/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;

public class QSpace {
    private DetectorProperties detProps;
    private double kmod;
    private Vector3d ki;

    public QSpace(DetectorProperties detectorProperties, DiffractionCrystalEnvironment diffractionCrystalEnvironment) {
        this.detProps = detectorProperties;
        this.setDiffractionCrystalEnvironment(diffractionCrystalEnvironment);
    }

    private void calculateInitalWavevector() {
        this.ki = new Vector3d(this.detProps.getBeamVector());
        this.ki.scale(this.kmod);
    }

    public void setDiffractionCrystalEnvironment(DiffractionCrystalEnvironment diffractionCrystalEnvironment) {
        this.kmod = Math.PI * 2 / diffractionCrystalEnvironment.getWavelength();
        this.calculateInitalWavevector();
    }

    public void setDetectorProperties(DetectorProperties detectorProperties) {
        this.detProps = detectorProperties;
        this.calculateInitalWavevector();
    }

    public DetectorProperties getDetectorProperties() {
        return this.detProps;
    }

    public Vector3d getInitialWavevector() {
        return this.ki;
    }

    public void qFromPixelPosition(double d, double d2, Vector3d vector3d) {
        this.detProps.pixelPosition(d, d2, vector3d);
        vector3d.normalize();
        vector3d.scale(this.kmod);
        vector3d.sub((Tuple3d)this.ki);
    }

    public void qFromPixelPosition(int n, int n2, Vector3d vector3d) {
        this.qFromPixelPosition((double)n, (double)n2, vector3d);
    }

    public Vector3d qFromPixelPosition(double d, double d2) {
        Vector3d vector3d = new Vector3d();
        this.qFromPixelPosition(d, d2, vector3d);
        return vector3d;
    }

    public Vector3d qFromPixelPosition(int n, int n2) {
        return this.qFromPixelPosition((double)n, (double)n2);
    }

    public double maxModQ() {
        double d = this.detProps.getMaxScatteringAngle();
        return 2.0 * this.kmod * Math.sin(0.5 * d);
    }

    public void pixelPosition(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, int[] nArray) {
        vector3d3.set((Tuple3d)vector3d);
        vector3d3.add((Tuple3d)this.ki);
        vector3d3.normalize();
        this.detProps.intersect(vector3d3, vector3d2);
        if (nArray == null) {
            this.detProps.pixelCoords(vector3d2, vector3d3);
        } else {
            this.detProps.pixelCoords(vector3d2, vector3d3, nArray);
        }
    }

    public void pixelPosition(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.pixelPosition(vector3d, vector3d2, vector3d3, null);
    }

    public void pixelPosition(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        this.pixelPosition(vector3d, vector3d3, vector3d2);
    }

    public int[] pixelPosition(Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(vector3d);
        vector3d2.add((Tuple3d)this.ki);
        vector3d2.normalize();
        return this.detProps.pixelCoords(this.detProps.intersect(vector3d2));
    }

    public double scatteringAngle(Vector3d vector3d) {
        return 2.0 * Math.asin(0.5 * vector3d.length() / this.kmod);
    }
}

