/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

public class DiffractionCrystalEnvironment {
    private double wavelength;
    private double phiStart;
    private double phiRange;
    private double exposureTime;

    public DiffractionCrystalEnvironment(double d) {
        this.wavelength = d;
        this.phiStart = Double.NaN;
        this.phiRange = Double.NaN;
        this.exposureTime = Double.NaN;
    }

    public DiffractionCrystalEnvironment(double d, double d2, double d3, double d4) {
        this.wavelength = d;
        this.phiStart = d2;
        this.phiRange = d3;
        this.exposureTime = d4;
    }

    public DiffractionCrystalEnvironment() {
    }

    public DiffractionCrystalEnvironment clone() {
        return new DiffractionCrystalEnvironment(this.wavelength, this.phiStart, this.phiRange, this.exposureTime);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.exposureTime);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.phiRange);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.phiStart);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.wavelength);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DiffractionCrystalEnvironment diffractionCrystalEnvironment = (DiffractionCrystalEnvironment)object;
        if (Double.doubleToLongBits(this.exposureTime) != Double.doubleToLongBits(diffractionCrystalEnvironment.exposureTime)) {
            return false;
        }
        if (Double.doubleToLongBits(this.phiRange) != Double.doubleToLongBits(diffractionCrystalEnvironment.phiRange)) {
            return false;
        }
        if (Double.doubleToLongBits(this.phiStart) != Double.doubleToLongBits(diffractionCrystalEnvironment.phiStart)) {
            return false;
        }
        return Double.doubleToLongBits(this.wavelength) == Double.doubleToLongBits(diffractionCrystalEnvironment.wavelength);
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public void setWavelengthFromEnergykeV(double d) {
        this.wavelength = 1.0 / (0.0806554465 * d);
    }

    public void setWavelength(double d) {
        this.wavelength = d;
    }

    public double getPhiStart() {
        return this.phiStart;
    }

    public void setPhiStart(double d) {
        this.phiStart = d;
    }

    public double getPhiRange() {
        return this.phiRange;
    }

    public void setPhiRange(double d) {
        this.phiRange = d;
    }

    public double getExposureTime() {
        return this.exposureTime;
    }

    public void setExposureTime(double d) {
        this.exposureTime = d;
    }
}

