/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;

public class ProjectToQSpacePlane
implements DatasetToDatasetFunction {
    private QSpace qspace;
    private Vector3d row;
    private Vector3d col;
    private double rdel;
    private double cdel;
    private int roff;
    private int coff;
    private int[] pshape;
    private AbstractDataset image;
    private AbstractDataset count;

    public ProjectToQSpacePlane(Vector3d vector3d, Vector3d vector3d2, double[] dArray, int[] nArray, int[] nArray2) {
        vector3d.normalize();
        this.row = vector3d2;
        this.row.normalize();
        this.col = new Vector3d();
        this.col.cross(vector3d, this.col);
        this.col.normalize();
        this.rdel = dArray[0];
        this.cdel = dArray[1];
        this.pshape = new int[2];
        this.pshape[0] = nArray[1] - nArray[0];
        this.pshape[1] = nArray2[1] - nArray2[0];
        this.roff = nArray[0];
        this.coff = nArray2[0];
    }

    public void createDataset(int n) {
        this.image = AbstractDataset.zeros(this.pshape, n);
        this.count = AbstractDataset.zeros(this.pshape, 2);
    }

    public void setQSpace(QSpace qSpace) {
        this.qspace = qSpace;
    }

    public void clearDataset() {
        this.image.fill(0);
        this.count.fill(0);
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDataset);
            int[] nArray = abstractDataset.getShape();
            if (nArray.length != 2) {
                return null;
            }
            int[] nArray2 = new int[2];
            int[] nArray3 = (int[])this.pshape.clone();
            int[] nArray4 = new int[2];
            this.qToPixel(this.qspace.qFromPixelPosition(0, 0), nArray2);
            this.adjustBoundingBox(nArray3, nArray4, nArray2);
            this.qToPixel(this.qspace.qFromPixelPosition(nArray[0], 0), nArray2);
            this.adjustBoundingBox(nArray3, nArray4, nArray2);
            this.qToPixel(this.qspace.qFromPixelPosition(0, nArray[1]), nArray2);
            this.adjustBoundingBox(nArray3, nArray4, nArray2);
            this.qToPixel(this.qspace.qFromPixelPosition(nArray[0], nArray[1]), nArray2);
            this.adjustBoundingBox(nArray3, nArray4, nArray2);
            nArray4[0] = nArray4[0] + 1;
            nArray4[1] = nArray4[1] + 1;
            Vector3d vector3d = new Vector3d();
            Vector3d vector3d2 = new Vector3d();
            Vector3d vector3d3 = new Vector3d();
            int n3 = 0;
            int n4 = nArray3[0];
            while (n4 < nArray4[0]) {
                vector3d.scale((double)(n4 + this.roff) * this.cdel, (Tuple3d)this.col);
                int n5 = nArray3[1];
                while (n5 < nArray4[1]) {
                    vector3d2.scaleAdd((double)(n5 + this.coff) * this.rdel, (Tuple3d)this.row, (Tuple3d)vector3d);
                    this.qspace.pixelPosition(vector3d2, vector3d3);
                    int n6 = (int)(this.count.getElementLongAbs(n3) + 1L);
                    double d = this.image.getElementDoubleAbs(n3);
                    double d2 = Maths.getBilinear(abstractDataset, vector3d3.y, vector3d3.x) - d;
                    this.image.setObjectAbs(n3, d + d2 / (double)n6);
                    this.count.setObjectAbs(n3, n6);
                    ++n3;
                    ++n5;
                }
                ++n4;
            }
            arrayList.add(this.image);
            arrayList.add(this.count);
            ++n2;
        }
        return arrayList;
    }

    private void qToPixel(Vector3d vector3d, int[] nArray) {
        nArray[0] = -1;
        nArray[1] = -1;
        int n = (int)Math.floor(vector3d.dot(this.row) / this.rdel) - this.roff;
        nArray[1] = n < 0 || n > this.pshape[1] ? -1 : n;
        int n2 = (int)Math.floor(vector3d.dot(this.col) / this.cdel) - this.coff;
        nArray[0] = n2 < 0 || n2 > this.pshape[0] ? -1 : n2;
    }

    private void adjustBoundingBox(int[] nArray, int[] nArray2, int[] nArray3) {
        if (nArray3[0] >= 0) {
            if (nArray3[0] < nArray[0]) {
                nArray[0] = nArray3[0];
            }
            if (nArray3[0] > nArray2[0]) {
                nArray2[0] = nArray3[0];
            }
        }
        if (nArray3[1] >= 0) {
            if (nArray3[1] < nArray[1]) {
                nArray[1] = nArray3[1];
            }
            if (nArray3[1] > nArray2[1]) {
                nArray2[1] = nArray3[1];
            }
        }
    }
}

