/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class Median
implements DatasetToDatasetFunction {
    private final int window;

    public Median(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Non-positive window parameter not allowed");
        }
        this.window = n / 2;
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDataset);
            int n3 = abstractDataset.getDtype();
            int n4 = abstractDataset.getElementsPerItem();
            int[] nArray = abstractDataset.getShape();
            if (nArray.length > 1) {
                throw new IllegalArgumentException("Only 1D input datasets are supported");
            }
            AbstractDataset abstractDataset2 = AbstractDataset.zeros(n4, nArray, n3);
            PositionIterator positionIterator = abstractDataset2.getPositionIterator(new int[0]);
            while (positionIterator.hasNext()) {
                int n5 = positionIterator.getPos()[0];
                int n6 = Math.max(n5 - this.window, 0);
                int n7 = Math.min(n5 + this.window, abstractDataset.getSize() - 1);
                AbstractDataset abstractDataset3 = abstractDataset.getSlice(new int[]{n6}, new int[]{n7}, new int[]{1});
                abstractDataset2.set(Stats.median(abstractDataset3), positionIterator.getPos());
            }
            arrayList.add(abstractDataset2);
            ++n2;
        }
        return arrayList;
    }
}

