/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class MapToRotatedCartesianAndIntegrate
implements DatasetToDatasetFunction {
    int ox;
    int oy;
    int h;
    int w;
    double phi;

    public MapToRotatedCartesianAndIntegrate(int n, int n2, int n3, int n4, double d) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = Math.toRadians(d);
    }

    public MapToRotatedCartesianAndIntegrate(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = bl ? Math.toRadians(d) : d;
    }

    public MapToRotatedCartesianAndIntegrate(RectangularROI rectangularROI) {
        int[] nArray = rectangularROI.getIntPoint();
        int[] nArray2 = rectangularROI.getIntLengths();
        this.ox = nArray[0];
        this.oy = nArray[1];
        this.w = nArray2[0];
        this.h = nArray2[1];
        this.phi = rectangularROI.getAngle();
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            if (iDataset.getRank() != 2) {
                return null;
            }
            double d = Math.cos(this.phi);
            double d2 = Math.sin(this.phi);
            int n3 = AbstractDataset.getBestFloatDType(iDataset.elementClass());
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{this.h}, n3);
            AbstractDataset abstractDataset2 = AbstractDataset.zeros(new int[]{this.w}, n3);
            int n4 = 0;
            while (n4 < this.h) {
                double d3 = 0.0;
                int n5 = 0;
                while (n5 < this.w) {
                    double d4 = (double)this.ox + (double)n5 * d - (double)n4 * d2;
                    double d5 = (double)this.oy + (double)n5 * d2 + (double)n4 * d;
                    double d6 = Maths.getBilinear(iDataset, d5, d4);
                    abstractDataset2.set(d6 + abstractDataset2.getDouble(n5), n5++);
                    d3 += d6;
                }
                abstractDataset.set(d3, n4++);
            }
            arrayList.add(abstractDataset);
            arrayList.add(abstractDataset2);
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(new int[]{this.h}, n3).fill(this.w);
            arrayList.add(abstractDataset3);
            AbstractDataset abstractDataset4 = AbstractDataset.zeros(new int[]{this.w}, n3).fill(this.h);
            arrayList.add(abstractDataset4);
            ++n2;
        }
        return arrayList;
    }
}

