/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;
import uk.ac.diamond.scisoft.analysis.roi.RectangularROI;

public class MapToRotatedCartesian
implements DatasetToDatasetFunction {
    int ox;
    int oy;
    int h;
    int w;
    double phi;

    public MapToRotatedCartesian(int n, int n2, int n3, int n4, double d) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = Math.toRadians(d);
    }

    public MapToRotatedCartesian(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = bl ? Math.toRadians(d) : d;
    }

    public MapToRotatedCartesian(RectangularROI rectangularROI) {
        int[] nArray = rectangularROI.getIntPoint();
        int[] nArray2 = rectangularROI.getIntLengths();
        this.ox = nArray[0];
        this.oy = nArray[1];
        this.w = nArray2[0];
        this.h = nArray2[1];
        this.phi = rectangularROI.getAngle();
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            if (iDataset.getRank() != 2) {
                return null;
            }
            int[] nArray = new int[]{this.h, this.w};
            double d = Math.cos(this.phi);
            double d2 = Math.sin(this.phi);
            AbstractDataset abstractDataset = AbstractDataset.zeros(nArray, AbstractDataset.getBestFloatDType(iDataset.elementClass()));
            AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset);
            int n3 = 0;
            while (n3 < this.h) {
                int n4 = 0;
                while (n4 < this.w) {
                    abstractDataset2.set(1.0, n3, n4);
                    double d3 = (double)this.ox + (double)n4 * d - (double)n3 * d2;
                    double d4 = (double)this.oy + (double)n4 * d2 + (double)n3 * d;
                    abstractDataset.set(Maths.getBilinear(iDataset, d4, d3), n3, n4++);
                }
                ++n3;
            }
            arrayList.add(abstractDataset);
            arrayList.add(abstractDataset2);
            ++n2;
        }
        return arrayList;
    }
}

