/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.MapToPolarAndIntegrate;

public class MapToPolarAndSimpleIntegrateTest
extends TestCase {
    int[] shape = new int[]{500, 500};
    AbstractDataset d = AbstractDataset.zeros(this.shape, 5);
    boolean interpolate = false;
    double racc = 0.01;

    public void setUp() {
        this.d.fill(1.0);
    }

    @Test
    public void testMapToPolarAndSimpleIntegrate() {
        int n = 250;
        int n2 = 250;
        double d = 50.0;
        double d2 = 200.0;
        double d3 = 0.0;
        double d4 = 45.0;
        MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(n, n2, d, d3, d2, d4, 1.0, true);
        AbstractDataset abstractDataset = AbstractDataset.ones(new int[]{500, 500}, 1);
        abstractDataset.setSlice((Object)0, new int[]{260, 310}, new int[]{270, 320}, new int[]{1, 1});
        mapToPolarAndIntegrate.setMask(abstractDataset);
        mapToPolarAndIntegrate.setClip(true);
        mapToPolarAndIntegrate.setInterpolate(this.interpolate);
        List<AbstractDataset> list = mapToPolarAndIntegrate.value(this.d);
        double d5 = 14626.215563702155;
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d5, (double)((Number)list.get(0).sum()).doubleValue(), (double)(d5 * this.racc));
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d5, (double)((Number)list.get(1).sum()).doubleValue(), (double)(d5 * this.racc));
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d5, (double)((Number)list.get(2).sum()).doubleValue(), (double)(d5 * this.racc));
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d5, (double)((Number)list.get(3).sum()).doubleValue(), (double)(d5 * this.racc));
    }

    @Test
    public void testMapToPolarAndSimpleIntegrateRadial() {
        double d;
        int n;
        int n2 = 250;
        int n3 = 250;
        double d2 = 50.0;
        double d3 = 200.0;
        double d4 = 0.0;
        double d5 = 45.0;
        MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(n2, n3, d2, d4, d3, d5, 1.0, true);
        int n4 = 0;
        while (n4 < this.shape[0]) {
            n = 0;
            while (n < this.shape[1]) {
                int n5 = n4 - n2;
                int n6 = n - n3;
                d = Math.sqrt(n5 * n5 + n6 * n6);
                this.d.set(d, n++, n4);
            }
            ++n4;
        }
        mapToPolarAndIntegrate.setMask(null);
        mapToPolarAndIntegrate.setClip(false);
        mapToPolarAndIntegrate.setInterpolate(this.interpolate);
        List<AbstractDataset> list = mapToPolarAndIntegrate.value(this.d);
        n = 0;
        while (n < list.get(1).getShape()[0]) {
            double d6 = d2 + (double)n;
            d = list.get(1).getDouble(n) / list.get(3).getDouble(n++);
            MapToPolarAndSimpleIntegrateTest.assertEquals((double)d6, (double)d, (double)(d6 * this.racc));
        }
    }

    @Test
    public void testMapToPolarAndSimpleIntegrateAzimuthal() {
        double d;
        int n;
        int n2 = 250;
        int n3 = 250;
        double d2 = 50.0;
        double d3 = 200.0;
        double d4 = 45.0;
        double d5 = 90.0;
        MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(n2, n3, d2, d4, d3, d5, 1.0, true);
        int n4 = 0;
        while (n4 < this.shape[0]) {
            int n5 = 0;
            while (n5 < this.shape[1]) {
                int n6 = n4 - n2;
                n = n5 - n3;
                d = Math.atan2(n, n6);
                this.d.set(Math.toDegrees(d), n5++, n4);
            }
            ++n4;
        }
        mapToPolarAndIntegrate.setMask(null);
        mapToPolarAndIntegrate.setClip(true);
        mapToPolarAndIntegrate.setInterpolate(this.interpolate);
        List<AbstractDataset> list = mapToPolarAndIntegrate.value(this.d);
        double d6 = Math.toDegrees(1.0 / d3);
        n = 0;
        while (n < list.get(0).getShape()[0]) {
            d = d4 + d6 * (double)n;
            double d7 = list.get(0).getDouble(n) / list.get(2).getDouble(n++);
            MapToPolarAndSimpleIntegrateTest.assertEquals((double)d, (double)d7, (double)(d * this.racc));
        }
    }

    @Test
    public void testMapToPolarAndSimpleIntegrate2() {
        MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(360.0, 360.0, 50.0, 0.0, 200.0, 45.0, 1.0, true);
        AbstractDataset abstractDataset = AbstractDataset.ones(new int[]{500, 500}, 1);
        abstractDataset.setSlice((Object)0, new int[]{370, 480}, new int[]{380, 490}, new int[]{1, 1});
        mapToPolarAndIntegrate.setMask(abstractDataset);
        mapToPolarAndIntegrate.setClip(true);
        mapToPolarAndIntegrate.setInterpolate(this.interpolate);
        List<AbstractDataset> list = mapToPolarAndIntegrate.value(this.d);
        double d = 8718.25229575319;
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d, (double)((Number)list.get(0).sum()).doubleValue(), (double)(d * this.racc));
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d, (double)((Number)list.get(1).sum()).doubleValue(), (double)(d * this.racc));
    }

    @Test
    public void testMapToPolarAndSimpleIntegrate3() {
        MapToPolarAndIntegrate mapToPolarAndIntegrate = new MapToPolarAndIntegrate(250.0, 250.0, 50.0, 22.5, 200.0, -22.5, 1.0, true);
        AbstractDataset abstractDataset = AbstractDataset.ones(new int[]{500, 500}, 1);
        abstractDataset.setSlice((Object)0, new int[]{245, 410}, new int[]{255, 420}, new int[]{1, 1});
        mapToPolarAndIntegrate.setMask(abstractDataset);
        mapToPolarAndIntegrate.setClip(true);
        mapToPolarAndIntegrate.setInterpolate(this.interpolate);
        List<AbstractDataset> list = mapToPolarAndIntegrate.value(this.d);
        double d = 14626.215563702155;
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d, (double)((Number)list.get(0).sum()).doubleValue(), (double)(d * this.racc));
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d, (double)((Number)list.get(1).sum()).doubleValue(), (double)(d * this.racc));
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d, (double)((Number)list.get(2).sum()).doubleValue(), (double)(d * this.racc));
        MapToPolarAndSimpleIntegrateTest.assertEquals((double)d, (double)((Number)list.get(3).sum()).doubleValue(), (double)(d * this.racc));
    }
}

