/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.util.MathUtils;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class MapToPolarAndIntegrate
implements DatasetToDatasetFunction {
    double cx;
    double cy;
    double srad;
    double sphi;
    double erad;
    double ephi;
    double dpp;
    boolean clip = true;
    boolean interpolate = true;
    AbstractDataset mask;

    public void setMask(AbstractDataset abstractDataset) {
        this.mask = abstractDataset;
    }

    public void setClip(boolean bl) {
        this.clip = bl;
    }

    public void setInterpolate(boolean bl) {
        this.interpolate = bl;
    }

    public MapToPolarAndIntegrate(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, 1.0, true);
    }

    public MapToPolarAndIntegrate(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        this.cx = d;
        this.cy = d2;
        this.srad = d3;
        this.erad = d5;
        this.dpp = d7;
        if (bl) {
            this.sphi = Math.toRadians(d4);
            this.ephi = Math.toRadians(d6);
        } else {
            this.sphi = d4;
            this.ephi = d6;
        }
        if (this.sphi > this.ephi) {
            double d8 = this.sphi;
            this.sphi = this.ephi;
            this.ephi = d8;
        }
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (this.interpolate) {
            return this.interpolate_value(iDatasetArray);
        }
        return this.simple_value(iDatasetArray);
    }

    public List<AbstractDataset> interpolate_value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            if (iDataset.getRank() != 2) {
                throw new IllegalArgumentException("operating on 2d arrays only");
            }
            double d = 1.0 / this.dpp;
            int n3 = (int)Math.ceil((this.erad - this.srad) / d);
            int n4 = (int)Math.ceil((this.ephi - this.sphi) * this.erad / d);
            double d2 = (this.ephi - this.sphi) / (double)n4;
            double d3 = d2 * this.erad;
            if (n3 == 0) {
                n3 = 1;
            }
            if (n4 == 0) {
                n4 = 1;
            }
            int n5 = AbstractDataset.getBestFloatDType(iDataset.elementClass());
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n3}, n5);
            AbstractDataset abstractDataset2 = AbstractDataset.zeros(new int[]{n4}, n5);
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(abstractDataset);
            AbstractDataset abstractDataset4 = AbstractDataset.zeros(abstractDataset2);
            int n6 = 0;
            while (n6 < n3) {
                double d4 = this.srad + (double)n6 * d;
                int n7 = (int)Math.ceil((this.ephi - this.sphi) * d4 / d3);
                double d5 = d3 / d4;
                if (Double.isInfinite(d5) || Double.isNaN(d5)) {
                    d5 = d2;
                }
                if (n7 == 0) {
                    n7 = 1;
                }
                double d6 = 0.0;
                double d7 = 1.0;
                double d8 = 0.0;
                double d9 = (double)n4 / (double)n7;
                int n8 = 0;
                while (n8 < n7) {
                    double d10 = this.sphi + (double)n8 * d5;
                    int n9 = (int)((double)n8 * d9);
                    int n10 = (int)((double)(n8 + 1) * d9);
                    double d11 = this.cx + d4 * Math.cos(d10);
                    if (d11 < 0.0 || d11 > (double)iDataset.getShape()[1] + 1.0) {
                        if (!this.clip) {
                            d8 += d4 * d * d5;
                            int n11 = n9;
                            while (n11 < n10) {
                                abstractDataset4.set(d4 * d * d2 + abstractDataset4.getDouble(n11), n11++);
                            }
                        }
                    } else {
                        double d12 = this.cy + d4 * Math.sin(d10);
                        if (d12 < 0.0 || d12 > (double)iDataset.getShape()[0] + 1.0) {
                            if (!this.clip) {
                                d8 += d4 * d * d5;
                                int n12 = n9;
                                while (n12 < n10) {
                                    abstractDataset4.set(d4 * d * d2 + abstractDataset4.getDouble(n12), n12++);
                                }
                            }
                        } else {
                            if (this.mask != null) {
                                d7 = Maths.getBilinear(this.mask, d12, d11);
                            }
                            double d13 = d3 * d * Maths.getBilinear(iDataset, this.mask, d12, d11);
                            d6 += d13;
                            d8 += d4 * d * d5 * d7;
                            int n13 = n9;
                            while (n13 < n10) {
                                abstractDataset2.set(d13 / d9 + abstractDataset2.getDouble(n13), n13);
                                abstractDataset4.set(d4 * d * d2 * d7 + abstractDataset4.getDouble(n13), n13++);
                            }
                        }
                    }
                    ++n8;
                }
                abstractDataset.set(d6, n6);
                abstractDataset3.set(d8, n6++);
            }
            arrayList.add(abstractDataset2);
            arrayList.add(abstractDataset);
            arrayList.add(abstractDataset4);
            arrayList.add(abstractDataset3);
            ++n2;
        }
        return arrayList;
    }

    public List<AbstractDataset> simple_value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            if (iDataset.getRank() != 2) {
                throw new IllegalArgumentException("operating on 2d arrays only");
            }
            int n3 = (int)(this.erad - this.srad + 1.0);
            int n4 = (int)(this.erad * (this.ephi - this.sphi) + 1.0);
            double d = (this.ephi - this.sphi) / (double)n4;
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n4];
            double[] dArray3 = new double[n3];
            double[] dArray4 = new double[n4];
            int n5 = (int)Math.max(0.0, this.cx - this.erad);
            int n6 = (int)Math.min((double)iDataset.getShape()[1], this.cx + this.erad);
            int n7 = (int)Math.max(0.0, this.cy - this.erad);
            int n8 = (int)Math.min((double)iDataset.getShape()[0], this.cy + this.erad);
            int n9 = n7;
            while (n9 < n8) {
                int n10 = n5;
                while (n10 < n6) {
                    double d2;
                    double d3;
                    double d4;
                    double d5 = Math.atan2((double)n9 - this.cy, (double)n10 - this.cx);
                    if ((d5 = MathUtils.normalizeAngle((double)d5, (double)(this.sphi + Math.PI))) >= this.sphi && d5 <= this.ephi && (d4 = Math.sqrt((d3 = (double)n10 - this.cx) * d3 + (d2 = (double)n9 - this.cy) * d2)) >= this.srad && d4 < this.erad) {
                        int n11 = (int)(d4 - this.srad);
                        if (this.mask == null || this.mask.getBoolean(n9, n10)) {
                            double d6 = (double)(n11 + 1) - (d4 - this.srad);
                            double d7 = iDataset.getDouble(n9, n10);
                            dArray[n11] = dArray[n11] + d6 * d7;
                            dArray3[n11] = dArray3[n11] + d6;
                            if (n11 < n3 - 1) {
                                dArray[n11 + 1] = dArray[n11 + 1] + (1.0 - d6) * d7;
                                dArray3[n11 + 1] = dArray3[n11 + 1] + (1.0 - d6);
                            }
                            double d8 = 1.0 / d4;
                            int n12 = Math.max(0, (int)((d5 - d8 / 2.0 - this.sphi) / d));
                            int n13 = Math.min(n4 - 1, (int)((d5 + d8 / 2.0 - this.sphi) / d));
                            int n14 = n12;
                            while (n14 <= n13) {
                                d6 = (double)(n13 - n12) + 1.0;
                                int n15 = n14;
                                dArray2[n15] = dArray2[n15] + d7 / d6;
                                int n16 = n14++;
                                dArray4[n16] = dArray4[n16] + 1.0 / d6;
                            }
                        }
                    }
                    ++n10;
                }
                ++n9;
            }
            arrayList.add(new DoubleDataset(dArray2, n4));
            arrayList.add(new DoubleDataset(dArray, n3));
            arrayList.add(new DoubleDataset(dArray4, n4));
            arrayList.add(new DoubleDataset(dArray3, n3));
            ++n2;
        }
        return arrayList;
    }
}

