/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.crystallography.MillerSpace;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;

public class MapToMillerSpace
implements DatasetToDatasetFunction {
    private double hmax;
    private double hdel;
    private int mlen;
    private MillerSpace mspace;
    private QSpace qspace;
    private AbstractDataset newmap;
    private int[] mshape;

    public MapToMillerSpace(MillerSpace millerSpace, QSpace qSpace, int n, double d) {
        this.mspace = millerSpace;
        this.qspace = qSpace;
        this.hdel = d;
        this.hmax = n;
        this.mlen = (int)((double)(2 * n) / d + 1.0);
        this.mshape = new int[3];
        this.mshape[1] = this.mshape[2] = this.mlen;
        this.mshape[0] = this.mshape[2];
    }

    public void createDataset(int n) {
        this.newmap = AbstractDataset.zeros(this.mshape, n);
    }

    public void clearDataset() {
        this.newmap.fill(0);
    }

    public void setDetectorOrientation(Matrix3d matrix3d) {
        this.qspace.getDetectorProperties().setOrientation(matrix3d);
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDataset);
            int[] nArray = abstractDataset.getShape();
            if (nArray.length != 2) {
                return null;
            }
            int[] nArray2 = new int[3];
            Vector3d vector3d = new Vector3d();
            Vector3d vector3d2 = new Vector3d();
            Vector3d vector3d3 = new Vector3d();
            Vector3d vector3d4 = new Vector3d();
            Vector3d vector3d5 = new Vector3d();
            int n3 = 0;
            while (n3 < nArray[0]) {
                int n4 = 0;
                while (n4 < nArray[1]) {
                    this.qspace.qFromPixelPosition(n4, n3, vector3d3);
                    this.mspace.h(vector3d3, null, vector3d4);
                    if (this.hToVoxel(vector3d4, nArray2)) {
                        this.mspace.q(vector3d4, vector3d3);
                        this.qspace.pixelPosition(vector3d3, vector3d, vector3d2);
                        double d = Maths.getBilinear(abstractDataset, vector3d2.y, vector3d2.x);
                        this.hFromVoxel(vector3d5, nArray2);
                        vector3d5.sub((Tuple3d)vector3d4, (Tuple3d)vector3d5);
                        this.spreadValue(vector3d5, nArray2, d);
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        arrayList.add(this.newmap);
        return arrayList;
    }

    private boolean hToVoxel(Vector3d vector3d, int[] nArray) {
        if (Math.abs(vector3d.x) > this.hmax || Math.abs(vector3d.y) > this.hmax || Math.abs(vector3d.z) > this.hmax) {
            return false;
        }
        nArray[0] = (int)Math.floor(vector3d.z / this.hdel + this.hmax);
        nArray[1] = (int)Math.floor(vector3d.y / this.hdel + this.hmax);
        nArray[2] = (int)Math.floor(vector3d.x / this.hdel + this.hmax);
        return true;
    }

    private void hFromVoxel(Vector3d vector3d, int[] nArray) {
        vector3d.x = ((double)nArray[0] - this.hmax) * this.hdel;
        vector3d.y = ((double)nArray[1] - this.hmax) * this.hdel;
        vector3d.z = ((double)nArray[2] - this.hmax) * this.hdel;
    }

    private void spreadValue(Vector3d vector3d, int[] nArray, double d) {
        int[] nArray2 = (int[])nArray.clone();
        double[] dArray = new double[8];
        double d2 = vector3d.x * vector3d.x;
        double d3 = vector3d.y * vector3d.y;
        double d4 = vector3d.z * vector3d.z;
        double d5 = this.hdel - vector3d.x;
        d5 *= d5;
        double d6 = this.hdel - vector3d.y;
        d6 *= d6;
        double d7 = this.hdel - vector3d.z;
        d7 *= d7;
        if (nArray2[0] == this.mlen) {
            if (nArray2[1] == this.mlen) {
                if (nArray2[2] == this.mlen) {
                    double d8 = this.newmap.getDouble(nArray2);
                    this.newmap.set(d8 + d, nArray2);
                } else {
                    dArray[0] = 1.0 / Math.sqrt(d4);
                    dArray[1] = 1.0 / Math.sqrt(d7);
                    double d9 = 1.0 / (dArray[0] + dArray[1]);
                    double d10 = this.newmap.getDouble(nArray2);
                    this.newmap.set(d10 + d9 * dArray[0] * d, nArray2);
                    nArray2[2] = nArray2[2] + 1;
                    d10 = this.newmap.getDouble(nArray2);
                    this.newmap.set(d10 + d9 * dArray[1] * d, nArray2);
                }
            } else if (nArray2[2] == this.mlen) {
                dArray[0] = 1.0 / Math.sqrt(d3);
                dArray[1] = 1.0 / Math.sqrt(d6);
                double d11 = 1.0 / (dArray[0] + dArray[1]);
                double d12 = this.newmap.getDouble(nArray2);
                this.newmap.set(d12 + d11 * dArray[0] * d, nArray2);
                nArray2[1] = nArray2[1] + 1;
                d12 = this.newmap.getDouble(nArray2);
                this.newmap.set(d12 + d11 * dArray[1] * d, nArray2);
            } else {
                dArray[0] = 1.0 / Math.sqrt(d3 + d4);
                dArray[1] = 1.0 / Math.sqrt(d6 + d4);
                dArray[2] = 1.0 / Math.sqrt(d3 + d7);
                dArray[3] = 1.0 / Math.sqrt(d6 + d7);
                double d13 = 1.0 / (dArray[0] + dArray[1] + dArray[2] + dArray[3]);
                double d14 = this.newmap.getDouble(nArray2);
                this.newmap.set(d14 + d13 * dArray[0] * d, nArray2);
                nArray2[1] = nArray2[1] + 1;
                d14 = this.newmap.getDouble(nArray2);
                this.newmap.set(d14 + d13 * dArray[1] * d, nArray2);
                nArray2[1] = nArray2[1] - 1;
                nArray2[2] = nArray2[2] + 1;
                d14 = this.newmap.getDouble(nArray2);
                this.newmap.set(d14 + d13 * dArray[2] * d, nArray2);
                nArray2[1] = nArray2[1] + 1;
                d14 = this.newmap.getDouble(nArray2);
                this.newmap.set(d14 + d13 * dArray[3] * d, nArray2);
            }
        } else if (nArray2[1] == this.mlen) {
            if (nArray2[2] == this.mlen) {
                dArray[0] = 1.0 / Math.sqrt(d2);
                dArray[1] = 1.0 / Math.sqrt(d5);
                double d15 = 1.0 / (dArray[0] + dArray[1]);
                double d16 = this.newmap.getDouble(nArray2);
                this.newmap.set(d16 + d15 * dArray[0] * d, nArray2);
                nArray2[0] = nArray2[0] + 1;
                d16 = this.newmap.getDouble(nArray2);
                this.newmap.set(d16 + d15 * dArray[1] * d, nArray2);
            } else {
                dArray[0] = 1.0 / Math.sqrt(d2 + d4);
                dArray[1] = 1.0 / Math.sqrt(d5 + d4);
                dArray[2] = 1.0 / Math.sqrt(d2 + d7);
                dArray[3] = 1.0 / Math.sqrt(d5 + d7);
                double d17 = 1.0 / (dArray[0] + dArray[1] + dArray[2] + dArray[3]);
                double d18 = this.newmap.getDouble(nArray2);
                this.newmap.set(d18 + d17 * dArray[0] * d, nArray2);
                nArray2[0] = nArray2[0] + 1;
                d18 = this.newmap.getDouble(nArray2);
                this.newmap.set(d18 + d17 * dArray[1] * d, nArray2);
                nArray2[0] = nArray2[0] - 1;
                nArray2[2] = nArray2[2] + 1;
                d18 = this.newmap.getDouble(nArray2);
                this.newmap.set(d18 + d17 * dArray[2] * d, nArray2);
                nArray2[0] = nArray2[0] + 1;
                d18 = this.newmap.getDouble(nArray2);
                this.newmap.set(d18 + d17 * dArray[3] * d, nArray2);
                nArray2[0] = nArray2[0] - 1;
            }
        } else if (nArray2[2] == this.mlen) {
            dArray[0] = 1.0 / Math.sqrt(d2 + d3);
            dArray[1] = 1.0 / Math.sqrt(d5 + d3);
            dArray[2] = 1.0 / Math.sqrt(d2 + d6);
            dArray[3] = 1.0 / Math.sqrt(d5 + d6);
            double d19 = 1.0 / (dArray[0] + dArray[1] + dArray[2] + dArray[3]);
            double d20 = this.newmap.getDouble(nArray2);
            this.newmap.set(d20 + d19 * dArray[0] * d, nArray2);
            nArray2[0] = nArray2[0] + 1;
            d20 = this.newmap.getDouble(nArray2);
            this.newmap.set(d20 + d19 * dArray[1] * d, nArray2);
            nArray2[0] = nArray2[0] - 1;
            nArray2[1] = nArray2[1] + 1;
            d20 = this.newmap.getDouble(nArray2);
            this.newmap.set(d20 + d19 * dArray[2] * d, nArray2);
            nArray2[0] = nArray2[0] + 1;
            d20 = this.newmap.getDouble(nArray2);
            this.newmap.set(d20 + d19 * dArray[3] * d, nArray2);
        } else {
            dArray[0] = 1.0 / Math.sqrt(d2 + d3 + d4);
            dArray[1] = 1.0 / Math.sqrt(d5 + d3 + d4);
            dArray[2] = 1.0 / Math.sqrt(d2 + d6 + d4);
            dArray[3] = 1.0 / Math.sqrt(d5 + d6 + d4);
            dArray[4] = 1.0 / Math.sqrt(d2 + d3 + d7);
            dArray[5] = 1.0 / Math.sqrt(d5 + d3 + d7);
            dArray[6] = 1.0 / Math.sqrt(d2 + d6 + d7);
            dArray[7] = 1.0 / Math.sqrt(d5 + d6 + d7);
            double d21 = 1.0 / (dArray[0] + dArray[1] + dArray[2] + dArray[3] + dArray[4] + dArray[5] + dArray[6] + dArray[7]);
            double d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[0] * d, nArray2);
            nArray2[0] = nArray2[0] + 1;
            d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[1] * d, nArray2);
            nArray2[0] = nArray2[0] - 1;
            nArray2[1] = nArray2[1] + 1;
            d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[2] * d, nArray2);
            nArray2[0] = nArray2[0] + 1;
            d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[3] * d, nArray2);
            nArray2[0] = nArray2[0] - 1;
            nArray2[1] = nArray2[1] - 1;
            nArray2[2] = nArray2[2] + 1;
            d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[4] * d, nArray2);
            nArray2[0] = nArray2[0] + 1;
            d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[5] * d, nArray2);
            nArray2[0] = nArray2[0] - 1;
            nArray2[1] = nArray2[1] + 1;
            d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[6] * d, nArray2);
            nArray2[0] = nArray2[0] + 1;
            d22 = this.newmap.getDouble(nArray2);
            this.newmap.set(d22 + d21 * dArray[7] * d, nArray2);
        }
    }
}

