/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class MandelbrotSet
implements DatasetToDatasetFunction {
    private int maxRecursion;

    public MandelbrotSet(int n) {
        this.maxRecursion = n;
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length < 2) {
            throw new IllegalArgumentException("Need two axes");
        }
        AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDatasetArray[0]);
        AbstractDataset abstractDataset2 = DatasetUtils.convertToAbstractDataset(iDatasetArray[1]);
        if (abstractDataset.getRank() != 1 || abstractDataset2.getRank() != 1) {
            throw new IllegalArgumentException("Need both axes to be 1d datasets");
        }
        IntegerDataset integerDataset = new IntegerDataset(abstractDataset2.getShape()[0], abstractDataset.getShape()[0]);
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IndexIterator indexIterator = abstractDataset2.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            double d = abstractDataset2.getElementDoubleAbs(indexIterator.index);
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator2.hasNext()) {
                double d2 = abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d3 = 0.0;
                double d4 = 0.0;
                int n2 = -1;
                do {
                    double d5 = d3 * d3 - d4 * d4 + d2;
                    d4 = 2.0 * d3 * d4 + d;
                    d3 = d5;
                } while (++n2 < this.maxRecursion && d3 * d3 + d4 * d4 <= 4.0);
                integerDataset.setAbs(n++, n2);
            }
        }
        arrayList.add(integerDataset);
        return arrayList;
    }
}

