/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class LineSample
implements DatasetToDatasetFunction {
    int sx;
    int sy;
    int ex;
    int ey;
    double step;

    public LineSample(int n, int n2, int n3, int n4, double d) {
        this.sx = n;
        this.sy = n2;
        this.ex = n3;
        this.ey = n4;
        this.step = d;
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            if (iDataset.getRank() != 2) {
                return null;
            }
            double d = Math.hypot(this.ex - this.sx, this.ey - this.sy);
            double d2 = Math.atan2(this.ey - this.sy, this.ex - this.sx);
            int n3 = (int)Math.floor(d / this.step) + 1;
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n3}, AbstractDataset.getBestFloatDType(iDataset.elementClass()));
            int n4 = 0;
            while (n4 < n3) {
                double d3 = this.step * (double)n4;
                double d4 = (double)this.sx + d3 * Math.cos(d2);
                double d5 = (double)this.sy + d3 * Math.sin(d2);
                abstractDataset.setObjectAbs(n4, Maths.getBilinear(iDataset, d5, d4));
                ++n4;
            }
            arrayList.add(abstractDataset);
            ++n2;
        }
        return arrayList;
    }
}

