/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Integrate2D;

public class Integrate2DTest
extends TestCase {
    private void check1DArray(AbstractDataset abstractDataset, double[] dArray) {
        Integrate2DTest.assertEquals((int)1, (int)abstractDataset.getRank());
        int n = abstractDataset.getSize();
        int n2 = abstractDataset.getElementsPerItem();
        Integrate2DTest.assertEquals((int)dArray.length, (int)(n2 * n));
        if (n2 == 1) {
            int n3 = 0;
            while (n3 < n) {
                Integrate2DTest.assertEquals((double)dArray[n3], (double)abstractDataset.getDouble(n3), (double)1.0E-8);
                ++n3;
            }
        } else {
            int n4 = 0;
            double[] dArray2 = new double[n2];
            int n5 = 0;
            while (n5 < n) {
                ((AbstractCompoundDataset)abstractDataset).getDoubleArray(dArray2, n5);
                int n6 = 0;
                while (n6 < n2) {
                    Integrate2DTest.assertEquals((double)dArray[n4++], (double)dArray2[n6], (double)1.0E-8);
                    ++n6;
                }
                ++n5;
            }
        }
    }

    @Test
    public void testSimple() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        AbstractDataset abstractDataset = new DoubleDataset(dArray, new int[0]).reshape(2, 3);
        Integrate2D integrate2D = new Integrate2D();
        List<AbstractDataset> list = integrate2D.value(abstractDataset);
        this.check1DArray(list.get(0), new double[]{3.0, 12.0});
        this.check1DArray(list.get(1), new double[]{3.0, 5.0, 7.0});
    }

    @Test
    public void testCompound() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        CompoundDoubleDataset compoundDoubleDataset = new CompoundDoubleDataset(2, dArray, 2, 3);
        Integrate2D integrate2D = new Integrate2D();
        List<AbstractDataset> list = integrate2D.value(compoundDoubleDataset);
        this.check1DArray(list.get(0), new double[]{6.0, 9.0, 24.0, 27.0});
        this.check1DArray(list.get(1), new double[]{6.0, 8.0, 10.0, 12.0, 14.0, 16.0});
    }
}

