/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import junit.framework.TestCase;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.Histogram;

public class HistogramTest
extends TestCase {
    DoubleDataset d = null;

    public void setUp() {
        this.d = (DoubleDataset)AbstractDataset.arange(1.0, 2048.0, 1.0, 6);
    }

    @Test
    public void testHistogram() {
        Histogram histogram = new Histogram(2048);
        AbstractDataset abstractDataset = histogram.value(this.d).get(0);
        HistogramTest.assertEquals((int)2048, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(1));
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(512));
    }

    @Test
    public void testHistogram2() {
        Histogram histogram = new Histogram(1024);
        AbstractDataset abstractDataset = histogram.value(this.d).get(0);
        HistogramTest.assertEquals((int)1024, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)2, (int)abstractDataset.getInt(1));
        HistogramTest.assertEquals((int)2, (int)abstractDataset.getInt(512));
    }

    @Test
    public void testHistogram3() {
        Histogram histogram = new Histogram(256);
        AbstractDataset abstractDataset = histogram.value(this.d).get(0);
        HistogramTest.assertEquals((int)256, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)8, (int)abstractDataset.getInt(1));
        HistogramTest.assertEquals((int)8, (int)abstractDataset.getInt(128));
    }

    @Test
    public void testHistogram4() {
        Histogram histogram = new Histogram(205);
        AbstractDataset abstractDataset = histogram.value(this.d).get(0);
        HistogramTest.assertEquals((int)205, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)10, (int)abstractDataset.getInt(1));
        HistogramTest.assertEquals((int)10, (int)abstractDataset.getInt(128));
    }

    @Test
    public void testHistogram5() {
        Histogram histogram = new Histogram(1024, 1.0, 1024.0);
        histogram.setIgnoreOutliers(false);
        AbstractDataset abstractDataset = histogram.value(this.d).get(0);
        HistogramTest.assertEquals((int)1024, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(1));
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(512));
        HistogramTest.assertEquals((int)1024, (int)abstractDataset.getInt(1023));
    }

    @Test
    public void testHistogram6() {
        Histogram histogram = new Histogram(1024, 2.0, 1024.0);
        histogram.setIgnoreOutliers(false);
        AbstractDataset abstractDataset = histogram.value(this.d).get(0);
        HistogramTest.assertEquals((int)1024, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)2, (int)abstractDataset.getInt(0));
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(512));
        HistogramTest.assertEquals((int)1024, (int)abstractDataset.getInt(1023));
    }

    @Test
    public void testHistogram7() {
        Histogram histogram = new Histogram(1024, 2.0, 1024.0, true);
        AbstractDataset abstractDataset = histogram.value(this.d).get(0);
        HistogramTest.assertEquals((int)1024, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(0));
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(512));
        HistogramTest.assertEquals((int)1, (int)abstractDataset.getInt(1023));
    }

    @Test
    public void testHistogram8() {
        Histogram histogram = new Histogram(50);
        AbstractDataset abstractDataset = histogram.value(DatasetUtils.linSpace(0.0, 100.0, 101, 3)).get(0);
        HistogramTest.assertEquals((int)50, (int)abstractDataset.getSize());
        HistogramTest.assertEquals((int)2, (int)abstractDataset.getInt(0));
        HistogramTest.assertEquals((int)2, (int)abstractDataset.getInt(25));
        HistogramTest.assertEquals((int)3, (int)abstractDataset.getInt(49));
    }

    @Test
    public void testHistogramSpeed() {
        long l = 0L;
        Histogram histogram = new Histogram(50);
        AbstractDataset abstractDataset = DatasetUtils.linSpace(0.0, 100.0, 500000, 6);
        AbstractDataset abstractDataset2 = null;
        abstractDataset2 = histogram.value(abstractDataset).get(0);
        l = -System.nanoTime();
        int n = 0;
        while (n < 4) {
            histogram = new Histogram(50);
            abstractDataset2 = histogram.value(abstractDataset).get(0);
            ++n;
        }
        System.out.printf("H = %s, %sms\n", abstractDataset2.sum().toString(), (double)(l += System.nanoTime()) * 1.0E-6);
    }
}

