/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Comparisons;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class Histogram
implements DatasetToDatasetFunction {
    private int nbins;
    private boolean ignoreOutliers = true;
    private Double min = null;
    private Double max = null;
    private DoubleDataset bins = null;
    private boolean useEqualSpanBins = true;

    public Histogram(int n) {
        this.nbins = n;
        this.ignoreOutliers = true;
    }

    public Histogram(int n, double d, double d2) {
        this(n);
        this.min = d;
        this.max = d2;
        if (this.min > this.max) {
            throw new IllegalArgumentException("Given lower bound was higher than upper bound");
        }
        this.bins = (DoubleDataset)DatasetUtils.linSpace(this.min, this.max, this.nbins + 1, 6);
    }

    public Histogram(int n, double d, double d2, boolean bl) {
        this(n, d, d2);
        this.ignoreOutliers = bl;
    }

    public Histogram(IDataset iDataset) {
        this(iDataset, true);
    }

    public Histogram(IDataset iDataset, boolean bl) {
        if (iDataset.getRank() != 1) {
            throw new IllegalArgumentException("Bin edges should be given as 1D dataset");
        }
        this.bins = (DoubleDataset)DatasetUtils.cast(DatasetUtils.convertToAbstractDataset(iDataset), 6);
        AbstractDataset abstractDataset = DatasetUtils.sort(this.bins, null);
        if (!Comparisons.allTrue(Comparisons.almostEqualTo(this.bins, abstractDataset, 1.0E-8, 1.0E-8))) {
            throw new IllegalArgumentException("Bin edges should be given in increasing order");
        }
        AbstractDataset abstractDataset2 = Maths.difference((AbstractDataset)this.bins, 2, 0);
        this.useEqualSpanBins = Comparisons.allTrue(Comparisons.almostEqualTo((Object)abstractDataset2, 0, 1.0E-8, 1.0E-8));
        this.nbins = iDataset.getSize() - 1;
        this.ignoreOutliers = bl;
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        if (this.useEqualSpanBins) {
            IDataset[] iDatasetArray2 = iDatasetArray;
            int n = iDatasetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDataset iDataset = iDatasetArray2[n2];
                if (this.bins == null) {
                    this.bins = (DoubleDataset)DatasetUtils.linSpace(iDataset.min().doubleValue(), iDataset.max().doubleValue(), this.nbins + 1, 6);
                }
                double[] dArray = this.bins.getData();
                double d = dArray[0];
                double d2 = dArray[this.nbins];
                double d3 = (d2 - d) / (double)this.nbins;
                IntegerDataset integerDataset = new IntegerDataset(this.nbins);
                int[] nArray = integerDataset.getData();
                if (d3 <= 0.0) {
                    nArray[0] = iDataset.getSize();
                    arrayList.add(integerDataset);
                } else {
                    AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDataset);
                    IndexIterator indexIterator = abstractDataset.getIterator();
                    while (indexIterator.hasNext()) {
                        double d4 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        if (d4 < d) {
                            if (this.ignoreOutliers) continue;
                            nArray[0] = nArray[0] + 1;
                            continue;
                        }
                        if (d4 >= d2) {
                            if (d4 > d2 && this.ignoreOutliers) continue;
                            int n3 = this.nbins - 1;
                            nArray[n3] = nArray[n3] + 1;
                            continue;
                        }
                        int n4 = (int)((d4 - d) / d3);
                        nArray[n4] = nArray[n4] + 1;
                    }
                    arrayList.add(integerDataset);
                    arrayList.add(this.bins);
                }
                ++n2;
            }
        } else {
            IDataset[] iDatasetArray3 = iDatasetArray;
            int n = iDatasetArray.length;
            int n5 = 0;
            while (n5 < n) {
                IDataset iDataset = iDatasetArray3[n5];
                if (this.bins == null) {
                    this.bins = (DoubleDataset)DatasetUtils.linSpace(iDataset.min().doubleValue(), iDataset.max().doubleValue(), this.nbins + 1, 6);
                }
                double[] dArray = this.bins.getData();
                double d = dArray[0];
                double d5 = dArray[this.nbins];
                IntegerDataset integerDataset = new IntegerDataset(this.nbins);
                int[] nArray = integerDataset.getData();
                if (d >= d5) {
                    nArray[0] = iDataset.getSize();
                    arrayList.add(integerDataset);
                } else {
                    AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDataset);
                    IndexIterator indexIterator = abstractDataset.getIterator();
                    while (indexIterator.hasNext()) {
                        double d6 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        if (d6 < d) {
                            if (this.ignoreOutliers) continue;
                            nArray[0] = nArray[0] + 1;
                            continue;
                        }
                        if (d6 >= d5) {
                            if (d6 > d5 && this.ignoreOutliers) continue;
                            int n6 = this.nbins - 1;
                            nArray[n6] = nArray[n6] + 1;
                            continue;
                        }
                        int n7 = Arrays.binarySearch(dArray, d6);
                        if (n7 >= 0) {
                            int n8 = n7;
                            nArray[n8] = nArray[n8] + 1;
                            continue;
                        }
                        int n9 = -n7 - 2;
                        nArray[n9] = nArray[n9] + 1;
                    }
                    arrayList.add(integerDataset);
                    arrayList.add(this.bins);
                }
                ++n5;
            }
        }
        return arrayList;
    }

    public void setMinMax(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.bins = (DoubleDataset)DatasetUtils.linSpace(d, d2, this.nbins + 1, 6);
    }

    public void setIgnoreOutliers(boolean bl) {
        this.ignoreOutliers = bl;
    }
}

