/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.BicubicInterpolator;

public class BicubicInterpolatorTest {
    @Test
    public void testBicubicInterpolate() {
        double[][] dArray = new double[4][4];
        dArray[0][0] = 0.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[0][3] = 0.0;
        dArray[1][0] = 0.0;
        dArray[1][1] = 1.0;
        dArray[1][2] = 1.0;
        dArray[1][3] = 0.0;
        dArray[2][0] = 0.0;
        dArray[2][1] = 1.0;
        dArray[2][2] = 1.0;
        dArray[2][3] = 0.0;
        dArray[3][0] = 0.0;
        dArray[3][1] = 0.0;
        dArray[3][2] = 0.0;
        dArray[3][3] = 0.0;
        BicubicInterpolator bicubicInterpolator = new BicubicInterpolator(new int[]{1, 2});
        bicubicInterpolator.calculateParameters(dArray);
        Assert.assertEquals((double)1.265, (double)bicubicInterpolator.bicubicInterpolate(0.5, 0.5), (double)0.001);
    }

    @Test
    public void testGenerateSurroundingPoints() {
        DoubleDataset doubleDataset = DoubleDataset.arange(0.0, 9.0, 1.0);
        doubleDataset = (DoubleDataset)doubleDataset.reshape(3, 3);
        BicubicInterpolator bicubicInterpolator = new BicubicInterpolator(new int[]{20, 20});
        double[][] dArray = bicubicInterpolator.generateSurroundingPoints(0, 0, doubleDataset);
        Assert.assertEquals((double)0.0, (double)dArray[0][0], (double)0.1);
        Assert.assertEquals((double)0.0, (double)dArray[1][1], (double)0.1);
        Assert.assertEquals((double)4.0, (double)dArray[2][2], (double)0.1);
        Assert.assertEquals((double)8.0, (double)dArray[3][3], (double)0.1);
        dArray = bicubicInterpolator.generateSurroundingPoints(1, 1, doubleDataset);
        Assert.assertEquals((double)0.0, (double)dArray[0][0], (double)0.1);
        Assert.assertEquals((double)4.0, (double)dArray[1][1], (double)0.1);
        Assert.assertEquals((double)8.0, (double)dArray[2][2], (double)0.1);
        Assert.assertEquals((double)8.0, (double)dArray[3][3], (double)0.1);
    }

    @Test
    public void testValue() {
        DoubleDataset doubleDataset = DoubleDataset.arange(0.0, 9.0, 1.0);
        doubleDataset = (DoubleDataset)doubleDataset.reshape(3, 3);
        BicubicInterpolator bicubicInterpolator = new BicubicInterpolator(new int[]{5, 5});
        List<AbstractDataset> list = bicubicInterpolator.value(doubleDataset);
        list.get(0).peakToPeak();
    }
}

