/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class BicubicInterpolator
implements DatasetToDatasetFunction {
    int[] shape;
    private double a00;
    private double a01;
    private double a02;
    private double a03;
    private double a10;
    private double a11;
    private double a12;
    private double a13;
    private double a20;
    private double a21;
    private double a22;
    private double a23;
    private double a30;
    private double a31;
    private double a32;
    private double a33;

    public BicubicInterpolator(int[] nArray) {
        this.shape = nArray;
    }

    protected void calculateParameters(double[][] dArray) {
        this.a00 = dArray[1][1];
        this.a01 = -0.5 * dArray[1][0] + 0.5 * dArray[1][2];
        this.a02 = dArray[1][0] - 2.5 * dArray[1][1] + 2.0 * dArray[1][2] - 0.5 * dArray[1][3];
        this.a03 = -0.5 * dArray[1][0] + 1.5 * dArray[1][1] - 1.5 * dArray[1][2] + 0.5 * dArray[1][3];
        this.a10 = -0.5 * dArray[0][1] + 0.5 * dArray[2][1];
        this.a11 = 0.25 * dArray[0][0] - 0.25 * dArray[0][2] - 0.25 * dArray[2][0] + 0.25 * dArray[2][2];
        this.a12 = -0.5 * dArray[0][0] + 1.25 * dArray[0][1] - dArray[0][2] + 0.25 * dArray[0][3] + 0.5 * dArray[2][0] - 1.25 * dArray[2][1] + dArray[2][2] - 0.25 * dArray[2][3];
        this.a13 = 0.25 * dArray[0][0] - 0.75 * dArray[0][1] + 0.75 * dArray[0][2] - 0.25 * dArray[0][3] - 0.25 * dArray[2][0] + 0.75 * dArray[2][1] - 0.75 * dArray[2][2] + 0.25 * dArray[2][3];
        this.a20 = dArray[0][1] - 2.5 * dArray[1][1] + 2.0 * dArray[2][1] - 0.5 * dArray[3][1];
        this.a21 = -0.5 * dArray[0][0] + 0.5 * dArray[0][2] + 1.25 * dArray[1][0] - 1.25 * dArray[1][2] - dArray[2][0] + dArray[2][2] + 0.25 * dArray[3][0] - 0.25 * dArray[3][2];
        this.a22 = dArray[0][0] - 2.5 * dArray[0][1] + 2.0 * dArray[0][2] - 0.5 * dArray[0][3] - 2.5 * dArray[1][0] + 6.25 * dArray[1][1] - 5.0 * dArray[1][2] + 1.25 * dArray[1][3] + 2.0 * dArray[2][0] - 5.0 * dArray[2][1] + 4.0 * dArray[2][2] - dArray[2][3] - 0.5 * dArray[3][0] + 1.25 * dArray[3][1] - dArray[3][2] + 0.25 * dArray[3][3];
        this.a23 = -0.5 * dArray[0][0] + 1.5 * dArray[0][1] - 1.5 * dArray[0][2] + 0.5 * dArray[0][3] + 1.25 * dArray[1][0] - 3.75 * dArray[1][1] + 3.75 * dArray[1][2] - 1.25 * dArray[1][3] - dArray[2][0] + 3.0 * dArray[2][1] - 3.0 * dArray[2][2] + dArray[2][3] + 0.25 * dArray[3][0] - 0.75 * dArray[3][1] + 0.75 * dArray[3][2] - 0.25 * dArray[3][3];
        this.a30 = -0.5 * dArray[0][1] + 1.5 * dArray[1][1] - 1.5 * dArray[2][1] + 0.5 * dArray[3][1];
        this.a31 = 0.25 * dArray[0][0] - 0.25 * dArray[0][2] - 0.75 * dArray[1][0] + 0.75 * dArray[1][2] + 0.75 * dArray[2][0] - 0.75 * dArray[2][2] - 0.25 * dArray[3][0] + 0.25 * dArray[3][2];
        this.a32 = -0.5 * dArray[0][0] + 1.25 * dArray[0][1] - dArray[0][2] + 0.25 * dArray[0][3] + 1.5 * dArray[1][0] - 3.75 * dArray[1][1] + 3.0 * dArray[1][2] - 0.75 * dArray[1][3] - 1.5 * dArray[2][0] + 3.75 * dArray[2][1] - 3.0 * dArray[2][2] + 0.75 * dArray[2][3] + 0.5 * dArray[3][0] - 1.25 * dArray[3][1] + dArray[3][2] - 0.25 * dArray[3][3];
        this.a33 = 0.25 * dArray[0][0] - 0.75 * dArray[0][1] + 0.75 * dArray[0][2] - 0.25 * dArray[0][3] - 0.75 * dArray[1][0] + 2.25 * dArray[1][1] - 2.25 * dArray[1][2] + 0.75 * dArray[1][3] + 0.75 * dArray[2][0] - 2.25 * dArray[2][1] + 2.25 * dArray[2][2] - 0.75 * dArray[2][3] - 0.25 * dArray[3][0] + 0.75 * dArray[3][1] - 0.75 * dArray[3][2] + 0.25 * dArray[3][3];
    }

    public double bicubicInterpolate(double d, double d2) {
        double d3 = d * d;
        double d4 = d3 * d;
        double d5 = d2 * d2;
        double d6 = d5 * d2;
        return this.a00 + this.a01 * d2 + this.a02 * d5 + this.a03 * d6 + this.a10 * d + this.a11 * d * d2 + this.a12 * d * d5 + this.a13 * d * d6 + this.a20 * d3 + this.a21 * d3 * d2 + this.a22 * d3 * d5 + this.a23 * d3 * d6 + this.a30 * d4 + this.a31 * d4 * d2 + this.a32 * d4 * d5 + this.a33 * d4 * d6;
    }

    protected double[][] generateSurroundingPoints(int n, int n2, IDataset iDataset) {
        double[][] dArray = new double[4][4];
        int n3 = 0;
        while (n3 < 4) {
            int n4 = 0;
            while (n4 < 4) {
                dArray[n3][n4] = this.getPoint(n + (n3 - 1), n2 + (n4 - 1), iDataset);
                ++n4;
            }
            ++n3;
        }
        return dArray;
    }

    private double getPoint(int n, int n2, IDataset iDataset) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= iDataset.getShape()[0]) {
            n = iDataset.getShape()[0] - 1;
        }
        if (n2 >= iDataset.getShape()[1]) {
            n2 = iDataset.getShape()[1] - 1;
        }
        return iDataset.getDouble(n, n2);
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            DoubleDataset doubleDataset = new DoubleDataset(this.shape);
            double d = ((double)iDataset.getShape()[0] - 1.0) / ((double)this.shape[0] - 1.0);
            double d2 = ((double)iDataset.getShape()[1] - 1.0) / ((double)this.shape[1] - 1.0);
            int n3 = 0;
            while (n3 < iDataset.getShape()[0] - 1) {
                int n4 = 0;
                while (n4 < iDataset.getShape()[1] - 1) {
                    this.calculateParameters(this.generateSurroundingPoints(n3, n4, iDataset));
                    double d3 = ((double)this.shape[0] - 1.0) / ((double)iDataset.getShape()[0] - 1.0);
                    double d4 = ((double)this.shape[1] - 1.0) / ((double)iDataset.getShape()[1] - 1.0);
                    int n5 = (int)((double)n3 * d3);
                    int n6 = (int)((double)(n3 + 1) * d3);
                    int n7 = (int)((double)n4 * d4);
                    int n8 = (int)((double)(n4 + 1) * d4);
                    int n9 = n5;
                    while (n9 <= n6) {
                        int n10 = n7;
                        while (n10 <= n8) {
                            double d5 = (double)n9 * d;
                            double d6 = (double)n10 * d2;
                            doubleDataset.setItem(this.bicubicInterpolate(d5 -= (double)n3, d6 -= (double)n4), n9, n10++);
                        }
                        ++n9;
                    }
                    ++n4;
                }
                ++n3;
            }
            arrayList.add(doubleDataset);
            ++n2;
        }
        return arrayList;
    }
}

