/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;

public class SliceTest {
    @Test
    public void testSlice() {
        Slice slice = new Slice();
        Assert.assertEquals((Object)":", (Object)slice.toString());
        slice = new Slice(12);
        Assert.assertEquals((Object)":12", (Object)slice.toString());
        slice = new Slice(1, 12);
        Assert.assertEquals((Object)"1:12", (Object)slice.toString());
        slice = new Slice(0, 12);
        Assert.assertEquals((Object)":12", (Object)slice.toString());
        slice = new Slice(null, 12);
        Assert.assertEquals((Object)":12", (Object)slice.toString());
        slice = new Slice(11, 12);
        Assert.assertEquals((Object)"11", (Object)slice.toString());
        slice = new Slice(1, 12, 3);
        Assert.assertEquals((Object)"1:12:3", (Object)slice.toString());
        slice = new Slice(11, 12, 3);
        Assert.assertEquals((Object)"11", (Object)slice.toString());
        slice = new Slice(0, 12, 3);
        Assert.assertEquals((Object)":12:3", (Object)slice.toString());
        slice = new Slice(1, 12).setLength(12);
        Assert.assertEquals((Object)"1:", (Object)slice.toString());
        slice = new Slice(1, null).setLength(12);
        Assert.assertEquals((Object)"1:", (Object)slice.toString());
        slice = new Slice(0, 12).setLength(12);
        Assert.assertEquals((Object)":", (Object)slice.toString());
        slice = new Slice(1, 12, 3).setLength(12);
        Assert.assertEquals((Object)"1::3", (Object)slice.toString());
        slice = new Slice(0, 12, 3).setLength(12);
        Assert.assertEquals((Object)"::3", (Object)slice.toString());
        slice = new Slice(null, null, 3).setLength(12);
        Assert.assertEquals((Object)"::3", (Object)slice.toString());
        slice = new Slice(11, 12);
        Assert.assertEquals((Object)"11", (Object)slice.toString());
        slice = new Slice(0, 1);
        Assert.assertEquals((Object)"0", (Object)slice.toString());
        slice = new Slice(1);
        Assert.assertEquals((Object)"0", (Object)slice.toString());
    }

    @Test
    public void testSliceSteps() {
        Slice slice = new Slice(null, null, 3).setLength(1);
        Assert.assertEquals((long)1L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(2);
        Assert.assertEquals((long)1L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(3);
        Assert.assertEquals((long)1L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(4);
        Assert.assertEquals((long)2L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(5);
        Assert.assertEquals((long)2L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(6);
        Assert.assertEquals((long)2L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(7);
        Assert.assertEquals((long)3L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(8);
        Assert.assertEquals((long)3L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 3).setLength(9);
        Assert.assertEquals((long)3L, (long)slice.getNumSteps());
        slice = new Slice().setLength(12);
        Assert.assertEquals((long)12L, (long)slice.getNumSteps());
        slice = new Slice(null, null, 2).setLength(12);
        Assert.assertEquals((long)6L, (long)slice.getNumSteps());
        slice = new Slice(1, null).setLength(12);
        Assert.assertEquals((long)11L, (long)slice.getNumSteps());
        slice = new Slice(1, null, 2).setLength(12);
        Assert.assertEquals((long)6L, (long)slice.getNumSteps());
        slice = new Slice(1, null, -2).setLength(12);
        Assert.assertEquals((long)1L, (long)slice.getNumSteps());
        slice = new Slice(null, null, -1).setLength(12);
        Assert.assertEquals((long)12L, (long)slice.getNumSteps());
        slice = new Slice(null, null, -2).setLength(12);
        Assert.assertEquals((long)6L, (long)slice.getNumSteps());
        try {
            slice = new Slice();
            slice.getNumSteps();
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        slice = new Slice(12);
        Assert.assertEquals((long)12L, (long)slice.getNumSteps());
        slice = new Slice(1, 12);
        Assert.assertEquals((long)11L, (long)slice.getNumSteps());
        slice = new Slice(12, 1);
        Assert.assertEquals((long)0L, (long)slice.getNumSteps());
        slice = new Slice(1, 12, 2);
        Assert.assertEquals((long)6L, (long)slice.getNumSteps());
        slice = new Slice(1, 12, 12);
        Assert.assertEquals((long)1L, (long)slice.getNumSteps());
        slice = new Slice(12, 1, -1);
        Assert.assertEquals((long)11L, (long)slice.getNumSteps());
        slice = new Slice(1, 12, -1);
        Assert.assertEquals((long)0L, (long)slice.getNumSteps());
        slice = new Slice(12, 1, -2);
        Assert.assertEquals((long)6L, (long)slice.getNumSteps());
        slice = new Slice(12, 1, -12);
        Assert.assertEquals((long)1L, (long)slice.getNumSteps());
        slice = new Slice(null, 11, 1);
        Assert.assertEquals((long)11L, (long)slice.getNumSteps());
        try {
            slice = new Slice(11, null, -1);
            Assert.assertEquals((long)10L, (long)slice.getNumSteps());
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        slice = new Slice(null, null, 15).setLength(4096);
        Assert.assertEquals((long)274L, (long)slice.getNumSteps());
    }

    @Test
    public void testGetter() {
        Slice slice = new Slice().setLength(12);
        Assert.assertEquals(null, (Object)slice.getStart());
        Assert.assertEquals(null, (Object)slice.getStop());
        Assert.assertEquals((long)1L, (long)slice.getStep());
        Assert.assertEquals((long)12L, (long)slice.getLength());
        slice = new Slice(10).setLength(12);
        Assert.assertEquals(null, (Object)slice.getStart());
        Assert.assertEquals((long)10L, (long)slice.getStop().intValue());
        Assert.assertEquals((long)1L, (long)slice.getStep());
        Assert.assertEquals((long)12L, (long)slice.getLength());
    }

    @Test
    public void testSetter() {
        Slice slice = new Slice().setLength(12);
        slice.setStart(1);
        Assert.assertEquals((long)1L, (long)slice.getStart().intValue());
        slice.setStop(10);
        Assert.assertEquals((long)10L, (long)slice.getStop().intValue());
        slice.setStep(2);
        Assert.assertEquals((long)2L, (long)slice.getStep());
        slice.setLength(11);
        Assert.assertEquals((long)11L, (long)slice.getLength());
        slice = new Slice().setLength(12);
        slice.setStart(3);
        slice.setStop(10);
        try {
            slice.setLength(9);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            slice.setStart(11);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        slice = new Slice().setLength(12);
        slice.setStart(3);
        slice.setStop(10);
        try {
            slice.setLength(9);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            slice.setStart(11);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            slice.setStop(0);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        slice = new Slice().setLength(12);
        slice.setStep(-2);
        slice.setStart(10);
        slice.setStop(3);
        try {
            slice.setLength(9);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            slice.setStart(2);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            slice.setStop(10);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            slice.setStep(0);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        slice = new Slice(10).setLength(12);
        Assert.assertEquals(null, (Object)slice.getStart());
        Assert.assertEquals((long)10L, (long)slice.getStop().intValue());
        Assert.assertEquals((long)1L, (long)slice.getStep());
        Assert.assertEquals((long)12L, (long)slice.getLength());
    }

    @Test
    public void testSliceEnd() {
        Slice slice = new Slice().setLength(12);
        Assert.assertEquals((long)11L, (long)slice.getEnd());
        slice = new Slice(null, null, 2).setLength(12);
        Assert.assertEquals((long)10L, (long)slice.getEnd());
        slice = new Slice(1, null).setLength(12);
        Assert.assertEquals((long)11L, (long)slice.getEnd());
        slice = new Slice(1, null, 2).setLength(12);
        Assert.assertEquals((long)11L, (long)slice.getEnd());
        slice = new Slice(1, null, -2).setLength(12);
        Assert.assertEquals((long)1L, (long)slice.getEnd());
        slice = new Slice(null, null, -1).setLength(12);
        Assert.assertEquals((long)0L, (long)slice.getEnd());
        slice = new Slice(null, null, -2).setLength(12);
        Assert.assertEquals((long)1L, (long)slice.getEnd());
        slice = new Slice(12);
        Assert.assertEquals((long)11L, (long)slice.getEnd());
        slice = new Slice(1, 12);
        Assert.assertEquals((long)11L, (long)slice.getEnd());
        try {
            slice = new Slice(12, 1);
            Assert.assertEquals((long)1L, (long)slice.getEnd());
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        slice = new Slice(1, 12, 2);
        Assert.assertEquals((long)11L, (long)slice.getEnd());
        slice = new Slice(1, 12, 12);
        Assert.assertEquals((long)1L, (long)slice.getEnd());
        slice = new Slice(12, 1, -1);
        Assert.assertEquals((long)2L, (long)slice.getEnd());
        slice = new Slice(12, 1, -2);
        Assert.assertEquals((long)2L, (long)slice.getEnd());
        slice = new Slice(12, 1, -12);
        Assert.assertEquals((long)12L, (long)slice.getEnd());
        slice = new Slice(null, 12, 2);
        Assert.assertEquals((long)10L, (long)slice.getEnd());
        try {
            slice = new Slice(null, 12, -2);
            Assert.assertEquals((long)10L, (long)slice.getEnd());
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        try {
            slice = new Slice(null, null, -2);
            Assert.assertEquals((long)10L, (long)slice.getEnd());
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
    }

    @Test
    public void testConverters() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[]{12};
        Slice.convertFromSlice(new Slice[1], nArray4, nArray, nArray2, nArray3);
        Assert.assertEquals((long)0L, (long)nArray[0]);
        Assert.assertEquals((long)12L, (long)nArray2[0]);
        Assert.assertEquals((long)1L, (long)nArray3[0]);
        Slice.convertFromSlice(new Slice[]{new Slice(1, 11, 2).setLength(12)}, nArray4, nArray, nArray2, nArray3);
        Assert.assertEquals((long)1L, (long)nArray[0]);
        Assert.assertEquals((long)11L, (long)nArray2[0]);
        Assert.assertEquals((long)2L, (long)nArray3[0]);
        Slice.convertFromSlice(new Slice[]{new Slice().setLength(12)}, nArray4, nArray, nArray2, nArray3);
        Assert.assertEquals((long)0L, (long)nArray[0]);
        Assert.assertEquals((long)12L, (long)nArray2[0]);
        Assert.assertEquals((long)1L, (long)nArray3[0]);
        Slice[] sliceArray = Slice.convertToSlice(nArray, nArray2, nArray3);
        Assert.assertEquals((long)1L, (long)sliceArray.length);
        Assert.assertEquals((long)0L, (long)sliceArray[0].getStart().intValue());
        Assert.assertEquals((long)12L, (long)sliceArray[0].getStop().intValue());
        Assert.assertEquals((long)1L, (long)sliceArray[0].getStep());
    }

    @Test
    public void testShifts() {
        Slice slice = new Slice().setLength(12);
        slice.setStop(2);
        Assert.assertEquals((long)2L, (long)slice.getNumSteps());
        Assert.assertFalse((boolean)slice.setPosition(5));
        Assert.assertEquals((long)5L, (long)slice.getStart().intValue());
        Assert.assertEquals((long)7L, (long)slice.getStop().intValue());
        slice.setStart(5);
        Assert.assertEquals((long)5L, (long)slice.getStart().intValue());
        Assert.assertTrue((boolean)slice.setPosition(11));
    }
}

