/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class SliceIteratorTest {
    @Test
    public void testIterations() {
        int n = 1024;
        int n2 = 6;
        this.testIterationsND(n, n2);
        n2 = 8;
        this.testIterationsND(n, n2);
    }

    private void testIterationsND(int n, int n2) {
        System.out.println("Size: " + n);
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[0], n2);
        this.testDataset(abstractDataset);
        this.testDatasetSteps(abstractDataset, new int[0]);
        this.testDatasetAxes(abstractDataset, new boolean[0]);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2);
        this.testDataset(abstractDataset);
        this.testDatasetSteps(abstractDataset, new int[]{2});
        this.testDatasetSteps(abstractDataset, new int[]{-3});
        this.testDatasetAxes(abstractDataset, new boolean[]{true});
        abstractDataset.setShape(16, n / 16);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetSteps(abstractDataset, new int[]{1, 2});
        this.testDatasetSteps(abstractDataset, new int[]{3, 1});
        this.testDatasetAxes(abstractDataset, new boolean[]{true, true});
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testDatasetAxes(abstractDataset, blArray);
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testDatasetAxes(abstractDataset, blArray2);
        abstractDataset.setShape(n / 32, 32);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetSteps(abstractDataset, new int[]{1, 2});
        this.testDatasetSteps(abstractDataset, new int[]{3, 1});
        this.testDatasetAxes(abstractDataset, new boolean[]{true, true});
        boolean[] blArray3 = new boolean[2];
        blArray3[0] = true;
        this.testDatasetAxes(abstractDataset, blArray3);
        boolean[] blArray4 = new boolean[2];
        blArray4[1] = true;
        this.testDatasetAxes(abstractDataset, blArray4);
        abstractDataset.setShape(16, 8, n / 128);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetSteps(abstractDataset, new int[]{1, 1, 3});
        this.testDatasetSteps(abstractDataset, new int[]{1, 2, 1});
        this.testDatasetSteps(abstractDataset, new int[]{3, 1, 1});
        this.testDatasetSteps(abstractDataset, new int[]{3, 1, 2});
        this.testDatasetSteps(abstractDataset, new int[]{3, -1, 2});
        this.testDatasetAxes(abstractDataset, new boolean[]{true, true, true});
        boolean[] blArray5 = new boolean[3];
        blArray5[0] = true;
        blArray5[1] = true;
        this.testDatasetAxes(abstractDataset, blArray5);
        boolean[] blArray6 = new boolean[3];
        blArray6[0] = true;
        blArray6[2] = true;
        this.testDatasetAxes(abstractDataset, blArray6);
        boolean[] blArray7 = new boolean[3];
        blArray7[0] = true;
        this.testDatasetAxes(abstractDataset, blArray7);
        boolean[] blArray8 = new boolean[3];
        blArray8[1] = true;
        blArray8[2] = true;
        this.testDatasetAxes(abstractDataset, blArray8);
        boolean[] blArray9 = new boolean[3];
        blArray9[1] = true;
        this.testDatasetAxes(abstractDataset, blArray9);
        boolean[] blArray10 = new boolean[3];
        blArray10[2] = true;
        this.testDatasetAxes(abstractDataset, blArray10);
        this.testDatasetAxes(abstractDataset, new boolean[3]);
        abstractDataset.setShape(n / 128, 16, 8);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetSteps(abstractDataset, new int[]{1, 1, 3});
        this.testDatasetSteps(abstractDataset, new int[]{1, 2, 1});
        this.testDatasetSteps(abstractDataset, new int[]{3, 1, 1});
        this.testDatasetSteps(abstractDataset, new int[]{3, 1, 2});
        this.testDatasetSteps(abstractDataset, new int[]{3, -1, 2});
        this.testDatasetAxes(abstractDataset, new boolean[]{true, true, true});
        boolean[] blArray11 = new boolean[3];
        blArray11[0] = true;
        blArray11[1] = true;
        this.testDatasetAxes(abstractDataset, blArray11);
        boolean[] blArray12 = new boolean[3];
        blArray12[0] = true;
        blArray12[2] = true;
        this.testDatasetAxes(abstractDataset, blArray12);
        boolean[] blArray13 = new boolean[3];
        blArray13[0] = true;
        this.testDatasetAxes(abstractDataset, blArray13);
        boolean[] blArray14 = new boolean[3];
        blArray14[1] = true;
        blArray14[2] = true;
        this.testDatasetAxes(abstractDataset, blArray14);
        boolean[] blArray15 = new boolean[3];
        blArray15[1] = true;
        this.testDatasetAxes(abstractDataset, blArray15);
        boolean[] blArray16 = new boolean[3];
        blArray16[2] = true;
        this.testDatasetAxes(abstractDataset, blArray16);
        this.testDatasetAxes(abstractDataset, new boolean[3]);
    }

    private void testDataset(AbstractDataset abstractDataset) {
        SliceIterator sliceIterator = (SliceIterator)abstractDataset.getSliceIterator(null, null, null);
        int[] nArray = sliceIterator.getPos();
        int n = 0;
        while (sliceIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)abstractDataset.getDouble(nArray), (double)(1.0E-5 * (double)n));
            ++n;
        }
    }

    private void testDatasetSteps(AbstractDataset abstractDataset, int[] nArray) {
        SliceIterator sliceIterator = (SliceIterator)abstractDataset.getSliceIterator(null, null, nArray);
        int[] nArray2 = sliceIterator.getPos();
        int[] nArray3 = abstractDataset.shape;
        int n = nArray3.length - 1;
        int[] nArray4 = new int[nArray3.length];
        int n2 = 0;
        while (n2 <= n) {
            if (nArray[n2] < 0) {
                nArray4[n2] = nArray3[n2] - 1;
            }
            ++n2;
        }
        block1: while (sliceIterator.hasNext()) {
            n2 = 0;
            while (n2 <= n) {
                Assert.assertEquals((String)("  step: " + Arrays.toString(nArray) + "; shape: " + Arrays.toString(nArray3) + "; dim " + n2), (double)nArray4[n2], (double)nArray2[n2], (double)(1.0E-5 * (double)nArray4[n2]));
                ++n2;
            }
            n2 = n;
            while (n2 >= 0) {
                if (nArray[n2] > 0) {
                    int n3 = n2;
                    nArray4[n3] = nArray4[n3] + nArray[n2];
                    if (nArray4[n2] < nArray3[n2]) continue block1;
                    nArray4[n2] = 0;
                } else {
                    int n4 = n2;
                    nArray4[n4] = nArray4[n4] + nArray[n2];
                    if (nArray4[n2] >= 0) continue block1;
                    nArray4[n2] = nArray3[n2] - 1;
                }
                --n2;
            }
        }
    }

    private void testDatasetAxes(AbstractDataset abstractDataset, boolean[] blArray) {
        SliceIterator sliceIterator = abstractDataset.getSliceIteratorFromAxes(null, blArray);
        int[] nArray = sliceIterator.getPos();
        int[] nArray2 = abstractDataset.shape;
        int n = nArray2.length - 1;
        int[] nArray3 = new int[nArray2.length];
        block0: while (sliceIterator.hasNext()) {
            int n2 = 0;
            while (n2 <= n) {
                Assert.assertEquals((String)("  axes: " + Arrays.toString(blArray) + "; shape: " + Arrays.toString(nArray2) + "; dim " + n2), (double)nArray3[n2], (double)nArray[n2], (double)(1.0E-5 * (double)nArray3[n2]));
                ++n2;
            }
            n2 = n;
            while (n2 >= 0) {
                if (blArray[n2]) {
                    int n3 = n2;
                    nArray3[n3] = nArray3[n3] + 1;
                    if (nArray3[n2] < nArray2[n2]) continue block0;
                    nArray3[n2] = 0;
                }
                --n2;
            }
        }
    }
}

