/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class SliceIterator
extends IndexIterator {
    final int[] shape;
    final int isize;
    final int endrank;
    final int[] gap;
    final int imax;
    final int[] start;
    final int[] stop;
    final int[] step;
    final int[] sshape;
    final int[] pos;
    final int istep;

    public SliceIterator(int[] nArray, int n, int[] nArray2) {
        this(nArray, n, null, null, nArray2, 1);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        this(nArray, n, nArray2, null, nArray3, 1);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int n2) {
        this(nArray, n, null, null, nArray2, n2);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2) {
        this(nArray, n, nArray2, null, nArray3, n2);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3, int[] nArray4) {
        this(nArray, n, nArray2, nArray3, nArray4, 1);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3, int[] nArray4, int n2) {
        this.isize = n2;
        int n3 = nArray.length;
        this.endrank = n3 - 1;
        this.shape = nArray;
        this.start = new int[n3];
        this.sshape = nArray4;
        if (nArray3 == null) {
            this.step = new int[n3];
            Arrays.fill(this.step, 1);
        } else {
            this.step = nArray3;
        }
        if (n3 == 0) {
            this.istep = n2;
            this.imax = n * n2;
            this.stop = new int[0];
            this.pos = new int[0];
            this.gap = null;
        } else {
            this.istep = this.step[this.endrank] * n2;
            this.imax = n * n2;
            this.stop = new int[n3];
            this.gap = new int[this.endrank + 1];
            this.pos = new int[n3];
            this.calcGap();
        }
        this.setStart(nArray2);
    }

    private void calcGap() {
        int n = this.isize;
        int n2 = this.endrank;
        while (n2 >= 0) {
            this.stop[n2] = this.start[n2] + this.sshape[n2] * this.step[n2];
            if (this.step[n2] < 0) {
                int n3 = n2;
                this.stop[n3] = this.stop[n3] + 1;
            }
            if (n2 > 0) {
                this.gap[n2] = (this.shape[n2] * this.step[n2 - 1] - this.sshape[n2] * this.step[n2]) * n;
                n *= this.shape[n2];
            }
            --n2;
        }
    }

    public void setStart(int ... nArray) {
        int n = this.shape.length;
        if (n == 0) {
            return;
        }
        if (nArray == null) {
            int n2 = 0;
            while (n2 < n) {
                this.start[n2] = 0;
                ++n2;
            }
        } else {
            if (nArray.length > n) {
                throw new IllegalArgumentException("Length of start array greater than rank");
            }
            int n3 = n - nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                this.start[n4] = 0;
                ++n4;
            }
            n4 = 0;
            while (n4 < nArray.length) {
                this.start[n4 + n3] = nArray[n4];
                ++n4;
            }
        }
        this.reset();
        this.calcGap();
    }

    @Override
    public void reset() {
        if (this.shape.length == 0) {
            this.index = -this.istep;
        } else {
            int n = 0;
            while (n < this.shape.length) {
                this.pos[n] = this.start[n];
                ++n;
            }
            int n2 = this.endrank;
            this.pos[n2] = this.pos[n2] - this.step[this.endrank];
            this.index = this.pos[0];
            n = 1;
            while (n <= this.endrank) {
                this.index = this.index * this.shape[n] + this.pos[n];
                ++n;
            }
            this.index *= this.isize;
        }
    }

    @Override
    public boolean hasNext() {
        int n = this.endrank;
        while (n >= 0) {
            int n2 = n;
            this.pos[n2] = this.pos[n2] + this.step[n];
            if (this.pos[n] >= this.stop[n] != this.step[n] > 0) break;
            this.pos[n] = this.start[n];
            this.index += this.gap[n];
            --n;
        }
        if (n == -1 && this.endrank >= 0) {
            this.index = this.imax;
            return false;
        }
        this.index += this.istep;
        return this.index < this.imax;
    }

    public int[] getStart() {
        return this.start;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    public int[] getStop() {
        return this.stop;
    }

    public int[] getStep() {
        return this.step;
    }

    public int[] getGap() {
        return this.gap;
    }

    public int[] getShape() {
        return this.shape;
    }

    public int[] getSliceShape() {
        return this.sshape;
    }
}

