/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

public class Slice {
    private Integer start;
    private Integer stop;
    private int step;
    private int length;

    public Slice() {
        this(null);
    }

    public Slice(Integer n) {
        this(null, n);
    }

    public Slice(Integer n, Integer n2) {
        this(n, n2, 1);
    }

    public Slice(Integer n, Integer n2, Integer n3) {
        this.start = n;
        this.stop = n2;
        this.step = n3 == null ? 1 : n3;
        this.length = -1;
    }

    public Slice clone() {
        Slice slice = new Slice(this.start, this.stop, this.step);
        slice.length = this.length;
        return slice;
    }

    public Slice setLength(int n) {
        if (this.stop != null && this.step > 0 && n < this.stop) {
            throw new IllegalArgumentException("Length must be greater than or equal to stop");
        }
        if (this.start != null && this.step < 0 && n < this.start) {
            throw new IllegalArgumentException("Length must be greater than or equal to start");
        }
        this.length = n;
        return this;
    }

    public boolean isSliceComplete() {
        if (this.start == null && this.stop == null && (this.step == 1 || this.step == -1)) {
            return true;
        }
        if (this.length > 0) {
            return this.getNumSteps() == this.length;
        }
        return true;
    }

    public int getLength() {
        return this.length;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getStop() {
        return this.stop;
    }

    public int getStep() {
        return this.step;
    }

    public void setStart(Integer n) {
        if (n != null && this.length > 0) {
            if (this.step > 0) {
                int n2;
                int n3 = n2 = this.stop == null ? this.length : this.stop;
                if (n >= n2) {
                    throw new IllegalArgumentException("Non-null start must be less than end");
                }
            } else {
                int n4;
                int n5 = n4 = this.stop == null ? -1 : this.stop;
                if (n < n4) {
                    throw new IllegalArgumentException("Non-null start must be greater than end for negative step");
                }
            }
        }
        this.start = n;
    }

    public void setStop(Integer n) {
        if (n != null && this.length > 0) {
            if (this.step > 0) {
                int n2;
                int n3 = n2 = this.start == null ? 0 : this.start;
                if (n < n2) {
                    throw new IllegalArgumentException("Non-null stop must be greater than or equal to beginning");
                }
            } else {
                int n4;
                int n5 = n4 = this.start == null ? this.length - 1 : this.start;
                if (n >= n4) {
                    throw new IllegalArgumentException("Non-null stop must be less than beginning for negative step");
                }
            }
            if (n > this.length) {
                n = this.length;
            }
        }
        this.stop = n;
    }

    public boolean setPosition(int n) {
        int n2;
        boolean bl = false;
        int n3 = this.getNumSteps();
        if (n3 > (n2 = this.getNumSteps(n, this.length))) {
            n3 = n2;
            bl = true;
        }
        this.start = n;
        this.stop = this.start + (n3 - 1) * this.step + 1;
        return bl;
    }

    public void setStep(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Step must not be zero");
        }
        this.step = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.start != null) {
            if (this.start != 0) {
                stringBuilder.append(this.start);
            }
            if (this.stop != null && this.start == this.stop - 1) {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(this.start);
                }
                return stringBuilder.toString();
            }
        } else if (this.stop != null && this.stop == 1) {
            return "0";
        }
        stringBuilder.append(':');
        if (this.stop != null && (this.length < 0 || this.length != this.stop)) {
            stringBuilder.append(this.stop);
        }
        if (this.step != 1) {
            stringBuilder.append(':');
            stringBuilder.append(this.step);
        }
        return stringBuilder.toString();
    }

    public int getNumSteps() {
        int n;
        if (this.length < 0) {
            int n2;
            if (this.stop == null) {
                throw new IllegalStateException("Slice is underspecified - stop is null and length is negative");
            }
            int n3 = this.start == null ? (this.step > 0 ? 0 : this.stop - 1) : (n2 = this.start.intValue());
            if (this.step > 0 && this.stop <= n2) {
                return 0;
            }
            if (this.step < 0 && this.stop > n2) {
                return 0;
            }
            return this.getNumSteps(n2, this.stop);
        }
        int n4 = this.start == null ? (this.step > 0 ? 0 : this.length - 1) : (n = this.start.intValue());
        int n5 = this.stop == null ? (this.step > 0 ? this.length : -1) : this.stop;
        return this.getNumSteps(n, n5);
    }

    public int getNumSteps(int n, int n2) {
        int n3 = this.step > 0 ? 1 : -1;
        return (n2 - n - n3) / this.step + 1;
    }

    public int getEnd() {
        int n = this.getNumSteps() - 1;
        if (n < 0) {
            throw new IllegalStateException("End is not defined");
        }
        if (this.length < 0) {
            if (this.start == null) {
                return this.step * n;
            }
            return this.start + this.step * n;
        }
        int n2 = this.start == null ? (this.step > 0 ? 0 : this.length - 1) : this.start;
        return n2 + this.step * n;
    }

    public static void convertFromSlice(Slice[] sliceArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = nArray.length;
        int n2 = sliceArray == null ? 0 : sliceArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n2 > n) break;
            Slice slice = sliceArray[n3];
            if (slice == null) {
                nArray2[n3] = 0;
                nArray3[n3] = nArray[n3];
                nArray4[n3] = 1;
            } else {
                int n4;
                if (slice.start == null) {
                    nArray2[n3] = slice.step > 0 ? 0 : nArray[n3] - 1;
                } else {
                    n4 = slice.start;
                    if (n4 < 0) {
                        n4 += nArray[n3];
                    }
                    if (n4 < 0 || n4 >= nArray[n3]) {
                        throw new IllegalArgumentException(String.format("Start is out of bounds: %d is not in [%d,%d)", n4, slice.start, nArray[n3]));
                    }
                    nArray2[n3] = n4;
                }
                if (slice.stop == null) {
                    nArray3[n3] = slice.step > 0 ? nArray[n3] : -1;
                } else {
                    n4 = slice.stop;
                    if (n4 < 0) {
                        n4 += nArray[n3];
                    }
                    if (n4 < 0 || n4 > nArray[n3]) {
                        throw new IllegalArgumentException(String.format("Stop is out of bounds: %d is not in [%d,%d)", n4, slice.stop, nArray[n3]));
                    }
                    nArray3[n3] = n4;
                }
                n4 = slice.step;
                if (n4 == 0) {
                    throw new IllegalArgumentException("Step cannot be zero");
                }
                if (n4 > 0) {
                    if (nArray2[n3] > nArray3[n3]) {
                        throw new IllegalArgumentException("Start must be less than stop for positive steps");
                    }
                } else if (nArray2[n3] < nArray3[n3]) {
                    throw new IllegalArgumentException("Start must be greater than stop for negative steps");
                }
                nArray4[n3] = n4;
            }
            ++n3;
        }
        while (n3 < n) {
            nArray2[n3] = 0;
            nArray3[n3] = nArray[n3];
            nArray4[n3] = 1;
            ++n3;
        }
    }

    public static Slice[] convertToSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        if (nArray2.length != n || nArray3.length != n) {
            throw new IllegalArgumentException("All arrays must be same length");
        }
        Slice[] sliceArray = new Slice[n];
        int n2 = 0;
        while (n2 < n) {
            sliceArray[n2] = new Slice(nArray[n2], nArray2[n2], nArray3[n2]);
            ++n2;
        }
        return sliceArray;
    }

    public static String createString(Slice ... sliceArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Slice[] sliceArray2 = sliceArray;
        int n = sliceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Slice slice = sliceArray2[n2];
            stringBuilder.append(slice != null ? slice.toString() : Character.valueOf(':'));
            stringBuilder.append(',');
            ++n2;
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

