/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Signal;

public class SignalTest {
    @Test
    public void testSimpleConvolveFilters() {
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{10, 10}, 600);
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(new int[]{3, 3}, 600);
        abstractDataset.iadd(2);
        abstractDataset2.set(1, 1, 1);
        AbstractDataset abstractDataset3 = Signal.convolve(abstractDataset, abstractDataset2, null);
        Assert.assertEquals((String)"Arrays are not equal area", (double)((Double)abstractDataset.sum()), (double)((Double)abstractDataset3.sum()), (double)0.1);
        abstractDataset2.set(0, 1, 1);
        abstractDataset3 = Signal.convolve(abstractDataset, abstractDataset2, null);
        Assert.assertEquals((String)"Array not zero size", (double)0.0, (double)((Double)abstractDataset3.sum()), (double)0.1);
        abstractDataset2.set(2, 1, 1);
        abstractDataset3 = Signal.convolve(abstractDataset, abstractDataset2, null);
        Assert.assertEquals((String)"convolved array not twice the size", (double)((Double)abstractDataset.sum() * 2.0), (double)((Double)abstractDataset3.sum()), (double)0.1);
    }

    @Test
    public void testConvolveFilters() {
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{10, 10}, 600);
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(new int[]{3, 3}, 600);
        abstractDataset.iadd(1);
        abstractDataset2.set(1, 1, 1);
        abstractDataset2.set(1, 0, 1);
        abstractDataset2.set(1, 2, 1);
        abstractDataset2.set(1, 1, 0);
        abstractDataset2.set(1, 1, 2);
        AbstractDataset abstractDataset3 = Signal.convolve(abstractDataset, abstractDataset2, null);
        Assert.assertEquals((String)"Element (0,0) is not correct", (double)0.0, (double)abstractDataset3.getDouble(0, 0), (double)0.1);
        Assert.assertEquals((String)"Element (1,1) is not correct", (double)3.0, (double)abstractDataset3.getDouble(1, 1), (double)0.1);
        Assert.assertEquals((String)"Element (2,2) is not correct", (double)5.0, (double)abstractDataset3.getDouble(2, 2), (double)0.1);
        Assert.assertEquals((String)"Element (3,3) is not correct", (double)5.0, (double)abstractDataset3.getDouble(3, 3), (double)0.1);
        Assert.assertEquals((String)"Element (6,6) is not correct", (double)5.0, (double)abstractDataset3.getDouble(6, 6), (double)0.1);
        Assert.assertEquals((String)"Element (9,9) is not correct", (double)5.0, (double)abstractDataset3.getDouble(9, 9), (double)0.1);
        Assert.assertEquals((String)"Element (10,10) is not correct", (double)3.0, (double)abstractDataset3.getDouble(10, 10), (double)0.1);
        Assert.assertEquals((String)"Element (11,11) is not correct", (double)0.0, (double)abstractDataset3.getDouble(11, 11), (double)0.1);
    }

    @Test
    public void testConvolve() {
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{10}, 600);
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(new int[]{10, 10}, 600);
        AbstractDataset abstractDataset3 = AbstractDataset.zeros(new int[]{10, 10, 10}, 600);
        try {
            Signal.convolve(abstractDataset, abstractDataset, null);
        }
        catch (Exception exception) {
            Assert.fail((String)"Should be able to convolve 2 1D arrays");
        }
        try {
            Signal.convolve(abstractDataset3, abstractDataset3, null);
        }
        catch (Exception exception) {
            Assert.fail((String)"Should be able to convolve 2 3D arrays");
        }
        try {
            Signal.convolve(abstractDataset, abstractDataset2, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)"convolving 2 differnt shaped arrays should raise an IllegalArgumentException");
        }
        try {
            Signal.convolve(abstractDataset, abstractDataset3, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)"convolving 2 differnt shaped arrays should raise an IllegalArgumentException");
        }
        try {
            Signal.convolve(abstractDataset2, abstractDataset3, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)"convolving 2 differnt shaped arrays should raise an IllegalArgumentException");
        }
        try {
            Signal.convolve(abstractDataset3, abstractDataset2, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)"convolving 2 differnt shaped arrays should raise an IllegalArgumentException");
        }
        try {
            Signal.convolve(abstractDataset3, abstractDataset, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Assert.fail((String)"convolving 2 differnt shaped arrays should raise an IllegalArgumentException");
        }
    }
}

