/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Random;

public class RandomTest {
    private static final String msg = "This test is statistical in nature and can fail. Try re-running.";

    @Test
    public void TestRand() {
        DoubleDataset doubleDataset = Random.rand(10000);
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)doubleDataset.mean()).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(0.5 / Math.sqrt(3.0)), (double)doubleDataset.stdDeviation().doubleValue(), (double)0.04);
    }

    @Test
    public void TestSeed() {
        Random.seed(103);
        DoubleDataset doubleDataset = Random.rand(100);
        Random.seed(103);
        DoubleDataset doubleDataset2 = Random.rand(100);
        int n = 0;
        while (n < 100) {
            Assert.assertEquals((double)doubleDataset.get(n), (double)doubleDataset2.get(n++), (double)1.0E-6);
        }
    }

    @Test
    public void TestRandn() {
        Random.seed(103);
        DoubleDataset doubleDataset = Random.randn(10000);
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)doubleDataset.mean()).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)1.0, (double)doubleDataset.stdDeviation().doubleValue(), (double)0.04);
    }

    @Test
    public void TestRandInt() {
        Random.seed(107);
        IntegerDataset integerDataset = Random.random_integers(13, 27, new int[]{10000});
        Assert.assertEquals((String)msg, (double)20.0, (double)((Number)integerDataset.mean()).doubleValue(), (double)0.07);
        Assert.assertEquals((String)msg, (double)Math.sqrt(18.666666666666668), (double)integerDataset.stdDeviation().doubleValue(), (double)0.07);
        Assert.assertEquals((String)msg, (double)13.0, (double)integerDataset.min().doubleValue(), (double)0.0);
        Assert.assertEquals((String)msg, (double)27.0, (double)integerDataset.max().doubleValue(), (double)0.0);
        integerDataset = Random.randint(2, 8, new int[]{10000});
        Assert.assertEquals((String)msg, (double)2.0, (double)integerDataset.min().doubleValue(), (double)0.0);
        Assert.assertEquals((String)msg, (double)7.0, (double)integerDataset.max().doubleValue(), (double)0.0);
    }

    @Test
    public void TestExp() {
        Random.seed(103);
        DoubleDataset doubleDataset = Random.exponential(2.3, 10000);
        Assert.assertEquals((String)msg, (double)2.3, (double)((Number)doubleDataset.mean()).doubleValue(), (double)0.11499999999999999);
        Assert.assertEquals((String)msg, (double)2.3, (double)doubleDataset.stdDeviation().doubleValue(), (double)0.11499999999999999);
    }

    @Test
    public void TestPoi() {
        Random.seed(103);
        IntegerDataset integerDataset = Random.poisson(2.3, 10000);
        Assert.assertEquals((String)msg, (double)2.3, (double)((Number)integerDataset.mean()).doubleValue(), (double)0.11499999999999999);
        Assert.assertEquals((String)msg, (double)Math.sqrt(2.3), (double)integerDataset.stdDeviation().doubleValue(), (double)0.11499999999999999);
    }
}

