/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class RGBDataset
extends CompoundShortDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final transient Logger logger = LoggerFactory.getLogger(RGBDataset.class);
    private static final int ISIZE = 3;
    private static final double Wr = 0.299;
    private static final double Wg = 0.587;
    private static final double Wb = 0.114;

    @Override
    public int getDtype() {
        return 203;
    }

    public RGBDataset() {
        super(3);
    }

    public RGBDataset(int ... nArray) {
        super(3, nArray);
    }

    public RGBDataset(RGBDataset rGBDataset) {
        super(rGBDataset);
    }

    public RGBDataset(RGBDataset rGBDataset, boolean bl) {
        super(rGBDataset, bl);
    }

    @Override
    public RGBDataset clone() {
        return new RGBDataset(this);
    }

    public RGBDataset(int[] nArray, int[] nArray2, int[] nArray3, int ... nArray4) {
        int n = nArray.length > nArray2.length ? nArray2.length : nArray.length;
        int n2 = n = n > nArray3.length ? nArray3.length : n;
        if (nArray4 == null || nArray4.length == 0) {
            nArray4 = new int[]{n};
        }
        this.isize = 3;
        this.size = RGBDataset.calcSize(nArray4);
        if (this.size != n) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray4.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.size) {
            this.data[n4++] = (short)nArray[n3];
            this.data[n4++] = (short)nArray2[n3];
            this.data[n4++] = (short)nArray3[n3];
            ++n3;
        }
    }

    public RGBDataset(short[] sArray, short[] sArray2, short[] sArray3, int ... nArray) {
        int n = sArray.length > sArray2.length ? sArray2.length : sArray.length;
        int n2 = n = n > sArray3.length ? sArray3.length : n;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{n};
        }
        this.isize = 3;
        this.size = RGBDataset.calcSize(nArray);
        if (this.size != n) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.size) {
            this.data[n4++] = sArray[n3];
            this.data[n4++] = sArray2[n3];
            this.data[n4++] = sArray3[n3];
            ++n3;
        }
    }

    public RGBDataset(byte[] byArray, byte[] byArray2, byte[] byArray3, int ... nArray) {
        int n = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        int n2 = n = n > byArray3.length ? byArray3.length : n;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{n};
        }
        this.isize = 3;
        this.size = RGBDataset.calcSize(nArray);
        if (this.size != n) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.size) {
            this.data[n4++] = (short)(0xFF & byArray[n3]);
            this.data[n4++] = (short)(0xFF & byArray2[n3]);
            this.data[n4++] = (short)(0xFF & byArray3[n3]);
            ++n3;
        }
    }

    public RGBDataset(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, AbstractDataset abstractDataset3) {
        super(3, abstractDataset.shape);
        abstractDataset.checkCompatibility(abstractDataset2);
        abstractDataset.checkCompatibility(abstractDataset3);
        if (abstractDataset.max().doubleValue() > 32767.0 || abstractDataset.min().doubleValue() < -32768.0 || abstractDataset2.max().doubleValue() > 32767.0 || abstractDataset2.min().doubleValue() < -32768.0 || abstractDataset3.max().doubleValue() > 32767.0 || abstractDataset3.min().doubleValue() < -32768.0) {
            logger.warn("Some values are out of range and will be ");
        }
        IndexIterator indexIterator = abstractDataset.getIterator();
        IndexIterator indexIterator2 = abstractDataset2.getIterator();
        IndexIterator indexIterator3 = abstractDataset3.getIterator();
        int n = 0;
        while (indexIterator.hasNext() && indexIterator2.hasNext() && indexIterator3.hasNext()) {
            this.data[n++] = (short)abstractDataset.getElementLongAbs(indexIterator.index);
            this.data[n++] = (short)abstractDataset2.getElementLongAbs(indexIterator.index);
            this.data[n++] = (short)abstractDataset3.getElementLongAbs(indexIterator.index);
        }
    }

    public RGBDataset(AbstractDataset abstractDataset) {
        super(3, abstractDataset.shape);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            short s = (short)abstractDataset.getElementLongAbs(indexIterator.index);
            this.data[n++] = s;
            this.data[n++] = s;
            this.data[n++] = s;
        }
    }

    public static RGBDataset createFromCompoundDataset(AbstractCompoundDataset abstractCompoundDataset) {
        if (abstractCompoundDataset instanceof RGBDataset) {
            return (RGBDataset)abstractCompoundDataset;
        }
        int n = abstractCompoundDataset.isize;
        if (n < 3) {
            return new RGBDataset((AbstractDataset)abstractCompoundDataset);
        }
        RGBDataset rGBDataset = new RGBDataset(abstractCompoundDataset.shape);
        IndexIterator indexIterator = abstractCompoundDataset.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            rGBDataset.data[n2++] = (short)abstractCompoundDataset.getElementLongAbs(indexIterator.index);
            rGBDataset.data[n2++] = (short)abstractCompoundDataset.getElementLongAbs(indexIterator.index + 1);
            rGBDataset.data[n2++] = (short)abstractCompoundDataset.getElementLongAbs(indexIterator.index + 2);
        }
        return rGBDataset;
    }

    @Override
    public RGBDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        RGBDataset rGBDataset = new RGBDataset(sliceIterator.getSliceShape());
        short[] sArray = rGBDataset.data;
        IndexIterator indexIterator = rGBDataset.getIterator();
        while (sliceIterator.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                sArray[indexIterator.index + n] = this.data[sliceIterator.index + n];
                ++n;
            }
        }
        return rGBDataset;
    }

    @Override
    public RGBDataset getView() {
        RGBDataset rGBDataset = new RGBDataset();
        rGBDataset.name = new String(this.name);
        rGBDataset.size = this.size;
        rGBDataset.dataSize = this.dataSize;
        rGBDataset.shape = (int[])this.shape.clone();
        if (this.dataShape != null) {
            rGBDataset.dataShape = (int[])this.dataShape.clone();
        }
        rGBDataset.data = this.data;
        rGBDataset.odata = this.data;
        rGBDataset.metadataStructure = this.metadataStructure;
        return rGBDataset;
    }

    public short getRed(int ... nArray) {
        int n = this.get1DIndex(nArray) * this.isize;
        return this.data[n];
    }

    public short getGreen(int ... nArray) {
        int n = this.get1DIndex(nArray) * this.isize;
        return this.data[n + 1];
    }

    public short getBlue(int ... nArray) {
        int n = this.get1DIndex(nArray) * this.isize;
        return this.data[n + 2];
    }

    public short getRedAbs(int n) {
        return this.data[n * this.isize];
    }

    public short getGreenAbs(int n) {
        return this.data[n * this.isize + 1];
    }

    public short getBlueAbs(int n) {
        return this.data[n * this.isize + 2];
    }

    public AbstractDataset createGreyDataset(int n) {
        return this.createGreyDataset(0.299, 0.587, 0.114, n);
    }

    public AbstractDataset createGreyDataset(double d, double d2, double d3, int n) {
        AbstractDataset abstractDataset = AbstractDataset.zeros(this.shape, n);
        IndexIterator indexIterator = this.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            abstractDataset.setObjectAbs(n2++, d * (double)this.data[indexIterator.index] + d2 * (double)this.data[indexIterator.index + 1] + d3 * (double)this.data[indexIterator.index + 2]);
        }
        return abstractDataset;
    }

    public AbstractDataset createRedDataset(int n) {
        return this.createColourChannelDataset(0, n, "red");
    }

    public AbstractDataset createGreenDataset(int n) {
        return this.createColourChannelDataset(1, n, "green");
    }

    public AbstractDataset createBlueDataset(int n) {
        return this.createColourChannelDataset(2, n, "blue");
    }

    private AbstractDataset createColourChannelDataset(int n, int n2, String string) {
        StringBuilder stringBuilder;
        AbstractDataset abstractDataset = AbstractDataset.zeros(this.shape, n2);
        StringBuilder stringBuilder2 = stringBuilder = this.name == null ? new StringBuilder() : new StringBuilder(this.name);
        if (stringBuilder.length() > 0) {
            stringBuilder.append('.');
        }
        stringBuilder.append(string);
        abstractDataset.setName(stringBuilder.toString());
        IndexIterator indexIterator = this.getIterator();
        int n3 = 0;
        while (indexIterator.hasNext()) {
            abstractDataset.setObjectAbs(n3++, this.data[indexIterator.index + n]);
        }
        return abstractDataset;
    }

    @Override
    public Number max() {
        short s = Short.MIN_VALUE;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < 3) {
                short s2 = this.data[indexIterator.index + n];
                if (s2 > s) {
                    s = s2;
                }
                ++n;
            }
        }
        return s;
    }

    @Override
    public Number min() {
        short s = Short.MAX_VALUE;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < 3) {
                short s2 = this.data[indexIterator.index + n];
                if (s2 < s) {
                    s = s2;
                }
                ++n;
            }
        }
        return s;
    }
}

