/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;

public class PositionIteratorTest {
    @Test
    public void testIterations() {
        int n = 1024;
        int n2 = 6;
        this.testIterationND(n, n2);
        n2 = 8;
        this.testIterationND(n, n2);
    }

    private void testIterationND(int n, int n2) {
        System.out.println("Size: " + n);
        AbstractDataset abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2);
        this.testDataset(abstractDataset);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, n / 16);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetAxes(abstractDataset, new int[1]);
        this.testDatasetAxes(abstractDataset, new int[]{1});
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 32, 32);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetAxes(abstractDataset, new int[1]);
        this.testDatasetAxes(abstractDataset, new int[]{1});
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, 8, n / 128);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetAxes(abstractDataset, new int[1]);
        this.testDatasetAxes(abstractDataset, new int[]{2});
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.testDatasetAxes(abstractDataset, nArray);
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        this.testDatasetAxes(abstractDataset, nArray2);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 128, 16, 8);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        this.testDatasetAxes(abstractDataset, new int[1]);
        this.testDatasetAxes(abstractDataset, new int[]{2});
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        this.testDatasetAxes(abstractDataset, nArray3);
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        this.testDatasetAxes(abstractDataset, nArray4);
    }

    private void testDataset(AbstractDataset abstractDataset) {
        PositionIterator positionIterator = abstractDataset.getPositionIterator(new int[0]);
        int[] nArray = positionIterator.getPos();
        int n = 0;
        while (positionIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)abstractDataset.getDouble(nArray), (double)(1.0E-5 * (double)n));
            ++n;
        }
    }

    private void testDatasetAxes(AbstractDataset abstractDataset, int[] nArray) {
        PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray);
        int[] nArray2 = positionIterator.getPos();
        int[] nArray3 = abstractDataset.shape;
        int n = nArray3.length - 1;
        int[] nArray4 = new int[nArray3.length];
        int[] nArray5 = new int[nArray3.length];
        Arrays.fill(nArray5, 1);
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray5[nArray[n2]] = 0;
            ++n2;
        }
        block1: while (positionIterator.hasNext()) {
            n2 = 0;
            while (n2 <= n) {
                Assert.assertEquals((String)("  Axes: " + Arrays.toString(nArray) + "; shape: " + Arrays.toString(nArray3) + "; dim " + n2), (double)nArray4[n2], (double)nArray2[n2], (double)(1.0E-5 * (double)nArray4[n2]));
                ++n2;
            }
            n2 = n;
            while (n2 >= 0) {
                if (nArray5[n2] > 0) {
                    int n3 = n2;
                    nArray4[n3] = nArray4[n3] + nArray5[n2];
                    if (nArray4[n2] < nArray3[n2]) continue block1;
                    nArray4[n2] = 0;
                }
                --n2;
            }
        }
    }
}

