/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class PositionIterator
extends IndexIterator {
    private final int[] shape;
    private final int endrank;
    private final boolean[] omit;
    private final int[] pos;
    private boolean once;

    public PositionIterator(int[] nArray) {
        this(nArray, -1);
    }

    public PositionIterator(int[] nArray, int n) {
        this(nArray, new int[]{n});
    }

    public PositionIterator(int[] nArray, int[] nArray2) {
        this.shape = nArray;
        this.endrank = nArray.length - 1;
        this.pos = new int[this.endrank + 1];
        this.omit = new boolean[this.endrank + 1];
        int[] nArray3 = nArray2;
        int n = nArray2.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray3[n2];
            if (n3 >= 0 && n3 <= this.endrank) {
                this.omit[n3] = true;
            } else if (n3 > this.endrank) {
                throw new IllegalArgumentException("Specified axis exceeds dataset rank");
            }
            ++n2;
        }
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (this.once) {
            this.once = false;
            return true;
        }
        int n = this.endrank;
        while (n >= 0) {
            if (!this.omit[n]) {
                int n2 = n;
                this.pos[n2] = this.pos[n2] + 1;
                if (this.pos[n] >= this.shape[n]) {
                    this.pos[n] = 0;
                } else {
                    return true;
                }
            }
            --n;
        }
        return false;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    public boolean[] getOmit() {
        return this.omit;
    }

    @Override
    public void reset() {
        int n = 0;
        while (n <= this.endrank) {
            if (!this.omit[n]) break;
            ++n;
        }
        if (n > this.endrank) {
            this.once = true;
            return;
        }
        if (this.omit[this.endrank]) {
            this.pos[this.endrank] = 0;
            int n2 = this.endrank - 1;
            while (n2 >= 0) {
                if (!this.omit[n2]) {
                    int n3 = n2;
                    this.pos[n3] = this.pos[n3] - 1;
                    break;
                }
                --n2;
            }
        } else {
            this.pos[this.endrank] = -1;
        }
    }
}

