/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class ObjectDatasetBase
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final transient Logger logger = LoggerFactory.getLogger(ObjectDatasetBase.class);
    protected Object[] data;

    @Override
    protected void setData() {
        this.data = (Object[])this.odata;
    }

    private static Object[] createArray(int n) {
        Object[] objectArray = null;
        try {
            objectArray = new Object[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)n);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return objectArray;
    }

    @Override
    public int getDtype() {
        return 10;
    }

    public ObjectDatasetBase() {
    }

    public ObjectDatasetBase(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = ObjectDatasetBase.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = ObjectDatasetBase.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = ObjectDatasetBase.createArray(this.size);
            this.odata = this.data;
        }
    }

    public ObjectDatasetBase(Object[] objectArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{objectArray.length};
        }
        this.size = ObjectDatasetBase.calcSize(nArray);
        if (this.size != objectArray.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(nArray), objectArray.length));
        }
        this.shape = (int[])nArray.clone();
        this.data = objectArray;
        this.odata = objectArray;
    }

    public ObjectDatasetBase(ObjectDatasetBase objectDatasetBase) {
        this(objectDatasetBase, false);
    }

    public ObjectDatasetBase(ObjectDatasetBase objectDatasetBase, boolean bl) {
        this.size = objectDatasetBase.size;
        if (bl) {
            this.shape = objectDatasetBase.shape;
            this.dataSize = objectDatasetBase.dataSize;
            this.dataShape = objectDatasetBase.dataShape;
            this.name = objectDatasetBase.name;
            this.metadataStructure = objectDatasetBase.metadataStructure;
            this.data = objectDatasetBase.data;
            this.odata = objectDatasetBase.data;
            return;
        }
        this.shape = (int[])objectDatasetBase.shape.clone();
        this.name = new String(objectDatasetBase.name);
        if (objectDatasetBase.metadataStructure != null) {
            this.metadataStructure = objectDatasetBase.metadataStructure.clone();
        }
        Object[] objectArray = objectDatasetBase.data;
        if (objectDatasetBase.isContiguous()) {
            this.data = (Object[])objectArray.clone();
            this.odata = this.data;
        } else {
            this.data = ObjectDatasetBase.createArray(this.size);
            this.odata = this.data;
            IndexIterator indexIterator = objectDatasetBase.getIterator();
            int n = 0;
            while (indexIterator.hasNext()) {
                this.data[n] = objectArray[indexIterator.index];
                ++n;
            }
        }
        this.errorValue = objectDatasetBase.errorValue;
        this.errorData = objectDatasetBase.errorData;
    }

    public ObjectDatasetBase(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.data = ObjectDatasetBase.createArray(this.size);
        this.odata = this.data;
        this.metadataStructure = abstractDataset.metadataStructure;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = abstractDataset.getObjectAbs(indexIterator.index);
            ++n;
        }
        this.errorValue = abstractDataset.errorValue;
        this.errorData = abstractDataset.errorData;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this.getRank() == 0) {
            return true;
        }
        ObjectDatasetBase objectDatasetBase = (ObjectDatasetBase)object;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index].equals(objectDatasetBase.data[indexIterator.index])) continue;
            return false;
        }
        return true;
    }

    public static ObjectDatasetBase createFromObject(Object object) {
        ObjectDatasetBase objectDatasetBase = new ObjectDatasetBase();
        objectDatasetBase.shape = ObjectDatasetBase.getShapeFromObject(object);
        objectDatasetBase.size = ObjectDatasetBase.calcSize(objectDatasetBase.shape);
        objectDatasetBase.data = ObjectDatasetBase.createArray(objectDatasetBase.size);
        objectDatasetBase.odata = objectDatasetBase.data;
        int[] nArray = new int[objectDatasetBase.shape.length];
        objectDatasetBase.fillData(object, 0, nArray);
        return objectDatasetBase;
    }

    public static ObjectDatasetBase ones(int ... nArray) {
        return new ObjectDatasetBase(nArray).fill(1);
    }

    @Override
    public ObjectDatasetBase fill(Object object) {
        Object object2 = object;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = object2;
        }
        return this;
    }

    public Object[] getData() {
        return this.data;
    }

    @Override
    public ObjectDatasetBase getView() {
        ObjectDatasetBase objectDatasetBase = new ObjectDatasetBase();
        objectDatasetBase.name = new String(this.name);
        objectDatasetBase.size = this.size;
        objectDatasetBase.dataSize = this.dataSize;
        objectDatasetBase.shape = (int[])this.shape.clone();
        if (this.dataShape != null) {
            objectDatasetBase.dataShape = (int[])this.dataShape.clone();
        }
        objectDatasetBase.data = this.data;
        objectDatasetBase.odata = this.data;
        objectDatasetBase.metadataStructure = this.metadataStructure;
        return objectDatasetBase;
    }

    public Object getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return false;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return 0.0;
    }

    @Override
    public long getElementLongAbs(int n) {
        return 0L;
    }

    @Override
    public Object getObjectAbs(int n) {
        return this.data[n];
    }

    @Override
    public String getStringAbs(int n) {
        return String.format("%s", this.data[n]);
    }

    public void setAbs(int n, Object object) {
        this.data[n] = object;
        this.setDirty();
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        Object[] objectArray = (Object[])object;
        this.data[n] = objectArray[n2];
    }

    @Override
    public void setObjectAbs(int n, Object object) {
        if (n < 0 || n > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(n, object);
    }

    public Object get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public double getDouble(int ... nArray) {
        return 0.0;
    }

    @Override
    public float getFloat(int ... nArray) {
        return 0.0f;
    }

    @Override
    public long getLong(int ... nArray) {
        return 0L;
    }

    @Override
    public int getInt(int ... nArray) {
        return 0;
    }

    @Override
    public short getShort(int ... nArray) {
        return 0;
    }

    @Override
    public byte getByte(int ... nArray) {
        return 0;
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return false;
    }

    @Override
    public String getString(int ... nArray) {
        return this.getStringAbs(this.get1DIndex(nArray));
    }

    public void setItem(Object object, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                int[] nArray2 = (int[])this.shape.clone();
                int n = 0;
                while (n < nArray.length) {
                    if (nArray[n] >= nArray2[n]) {
                        nArray2[n] = nArray[n] + 1;
                    }
                    ++n;
                }
                this.allocateArray(nArray2);
            }
            this.setAbs(this.get1DIndex(nArray), object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Dimensionalities of requested position, %d, and dataset, %d, are incompatible", nArray.length, this.shape.length));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(object, nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = ObjectDatasetBase.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = ObjectDatasetBase.calcSize(this.dataShape);
        Object[] objectArray = ObjectDatasetBase.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = ObjectDatasetBase.calcSize(nArray);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            objectArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = objectArray;
        this.odata = objectArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = ObjectDatasetBase.calcSize(nArray);
        Object[] objectArray = ObjectDatasetBase.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            objectArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = objectArray;
        this.odata = objectArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public ObjectDatasetBase getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.getSlice((SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3));
    }

    @Override
    public ObjectDatasetBase getSlice(SliceIterator sliceIterator) {
        ObjectDatasetBase objectDatasetBase = new ObjectDatasetBase(sliceIterator.getSliceShape());
        Object[] objectArray = objectDatasetBase.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            objectArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        objectDatasetBase.setName(String.valueOf(this.name) + ".slice");
        return objectDatasetBase;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        Object[] objectArray = ((ObjectDatasetBase)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            objectArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public ObjectDatasetBase setByBoolean(Object object, BooleanDataset booleanDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = abstractDataset.getObjectAbs(indexIterator.index);
            }
        } else {
            Object object2 = object;
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = object2;
            }
        }
        return this;
    }

    @Override
    public ObjectDatasetBase setByIndex(Object object, IntegerDataset integerDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = abstractDataset.getObjectAbs(indexIterator.index);
            }
        } else {
            Object object2 = object;
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = object2;
            }
        }
        return this;
    }

    @Override
    public ObjectDatasetBase setSlice(Object object, SliceIterator sliceIterator) {
        if (object instanceof IDataset) {
            IDataset iDataset = (IDataset)object;
            int[] nArray = iDataset.getShape();
            if (!ObjectDatasetBase.areShapesCompatible(sliceIterator.getSliceShape(), nArray)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(nArray), Arrays.toString(sliceIterator.getSliceShape())));
            }
            if (iDataset instanceof AbstractDataset) {
                AbstractDataset abstractDataset = (AbstractDataset)iDataset;
                IndexIterator indexIterator = abstractDataset.getIterator();
                while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                    this.data[sliceIterator.index] = abstractDataset.getObjectAbs(indexIterator.index);
                }
            } else {
                PositionIterator positionIterator = new PositionIterator(nArray);
                int[] nArray2 = ((IndexIterator)positionIterator).getPos();
                while (sliceIterator.hasNext() && ((IndexIterator)positionIterator).hasNext()) {
                    this.data[sliceIterator.index] = iDataset.getObject(nArray2);
                }
            }
        } else {
            try {
                Object object2 = object;
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = object2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (Object[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = ObjectDatasetBase.squeezeShape(var5_5.getSliceShape(), false);
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= ObjectDatasetBase.calcSize(var6_6)) ** GOTO lbl8
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl8:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl9:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        Object[] objectArray = (Object[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (objectArray.length < ObjectDatasetBase.calcSize(sliceIterator.getSliceShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = objectArray[n];
            ++n;
        }
        this.setDirty();
    }

    private List<Integer> findPositions(Object object) {
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != object) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(null);
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof List) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(null);
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        return false;
    }

    @Override
    public ObjectDatasetBase iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ObjectDatasetBase isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ObjectDatasetBase imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ObjectDatasetBase idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public ObjectDatasetBase ifloor() {
        return this;
    }

    @Override
    public ObjectDatasetBase iremainder(Object object) {
        return this;
    }

    @Override
    public ObjectDatasetBase ipower(Object object) {
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            }
        } else {
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
            }
        }
        return d;
    }
}

