/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;

public class Maths {
    private static StringBuilder bracketIfNecessary(AbstractDataset abstractDataset) {
        String string = abstractDataset.getName();
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string.contains("+") || string.contains("-") || string.contains("*") || string.contains("/") || string.contains("^") || string.contains("'")) {
            stringBuilder.insert(0, '(');
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    private static void addFunctionName(AbstractDataset abstractDataset, String string) {
        StringBuilder stringBuilder = new StringBuilder(abstractDataset.getName());
        stringBuilder.insert(0, '(');
        stringBuilder.insert(0, string);
        stringBuilder.append(')');
        abstractDataset.setName(stringBuilder.toString());
    }

    private static AbstractDataset broadcastClone(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        int n;
        int n2 = AbstractDataset.getBestDType(abstractDataset.getDtype(), abstractDataset2.getDtype());
        int n3 = abstractDataset.getElementsPerItem();
        return n3 > (n = abstractDataset2.getElementsPerItem()) ? abstractDataset.clone().cast(false, n2, n3) : abstractDataset.clone().cast(true, n2, n);
    }

    public static AbstractDataset add(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        AbstractDataset abstractDataset3 = Maths.broadcastClone(abstractDataset, abstractDataset2);
        abstractDataset3.iadd(abstractDataset2);
        abstractDataset3.setName(Maths.bracketIfNecessary(abstractDataset).append('+').append((CharSequence)Maths.bracketIfNecessary(abstractDataset2)).toString());
        return abstractDataset3;
    }

    public static AbstractDataset subtract(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        AbstractDataset abstractDataset3 = Maths.broadcastClone(abstractDataset, abstractDataset2);
        abstractDataset3.isubtract(abstractDataset2);
        abstractDataset3.setName(Maths.bracketIfNecessary(abstractDataset).append('-').append((CharSequence)Maths.bracketIfNecessary(abstractDataset2)).toString());
        return abstractDataset3;
    }

    public static AbstractDataset multiply(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        AbstractDataset abstractDataset3 = Maths.broadcastClone(abstractDataset, abstractDataset2);
        abstractDataset3.imultiply(abstractDataset2);
        abstractDataset3.setName(Maths.bracketIfNecessary(abstractDataset).append('*').append((CharSequence)Maths.bracketIfNecessary(abstractDataset2)).toString());
        return abstractDataset3;
    }

    public static AbstractDataset divide(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        AbstractDataset abstractDataset3 = Maths.broadcastClone(abstractDataset, abstractDataset2);
        abstractDataset3.idivide(abstractDataset2);
        abstractDataset3.setName(Maths.bracketIfNecessary(abstractDataset).append('/').append((CharSequence)Maths.bracketIfNecessary(abstractDataset2)).toString());
        return abstractDataset3;
    }

    public static AbstractDataset add(Collection<IDataset> collection, boolean bl) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection.size() == 1) {
            return (AbstractDataset)collection.iterator().next();
        }
        Iterator<IDataset> iterator = collection.iterator();
        AbstractDataset abstractDataset = bl ? ((AbstractDataset)iterator.next()).clone() : (AbstractDataset)iterator.next();
        while (iterator.hasNext()) {
            abstractDataset.iadd(iterator.next());
        }
        return abstractDataset;
    }

    public static AbstractDataset power(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        AbstractDataset abstractDataset3 = Maths.broadcastClone(abstractDataset, abstractDataset2);
        abstractDataset3.ipower(abstractDataset2);
        abstractDataset3.setName(Maths.bracketIfNecessary(abstractDataset).append('^').append((CharSequence)Maths.bracketIfNecessary(abstractDataset2)).toString());
        return abstractDataset3;
    }

    public static AbstractDataset remainder(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        AbstractDataset abstractDataset3 = Maths.broadcastClone(abstractDataset, abstractDataset2);
        abstractDataset3.iremainder(abstractDataset2);
        abstractDataset3.setName(Maths.bracketIfNecessary(abstractDataset).append('%').append((CharSequence)Maths.bracketIfNecessary(abstractDataset2)).toString());
        return abstractDataset3;
    }

    public static AbstractDataset add(Collection<IDataset> collection) {
        Iterator<IDataset> iterator = collection.iterator();
        AbstractDataset abstractDataset = ((AbstractDataset)iterator.next()).clone();
        while (iterator.hasNext()) {
            abstractDataset.iadd(iterator.next());
        }
        return abstractDataset;
    }

    public static AbstractDataset multiply(Collection<IDataset> collection, boolean bl) {
        if (collection.isEmpty()) {
            return null;
        }
        if (collection.size() == 1) {
            return (AbstractDataset)collection.iterator().next();
        }
        Iterator<IDataset> iterator = collection.iterator();
        AbstractDataset abstractDataset = bl ? ((AbstractDataset)iterator.next()).clone() : (AbstractDataset)iterator.next();
        while (iterator.hasNext()) {
            abstractDataset = abstractDataset.imultiply(iterator.next());
        }
        return abstractDataset;
    }

    public static AbstractDataset add(AbstractDataset abstractDataset, Object object) {
        if (object instanceof AbstractDataset) {
            return Maths.add(abstractDataset, (AbstractDataset)object);
        }
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = AbstractDataset.getBestDType(abstractDataset.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset, n);
        switch (n) {
            case 0: {
                boolean bl = AbstractDataset.toBoolean(object);
                boolean[] blArray = ((BooleanDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    boolean bl2 = blArray[n2++] = bl || abstractDataset.getElementBooleanAbs(indexIterator.index);
                }
                break;
            }
            case 1: {
                long l = AbstractDataset.toLong(object);
                byte[] byArray = ((ByteDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    byArray[n3++] = (byte)(abstractDataset.getElementLongAbs(indexIterator.index) + l);
                }
                break;
            }
            case 2: {
                long l = AbstractDataset.toLong(object);
                short[] sArray = ((ShortDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    sArray[n4++] = (short)(abstractDataset.getElementLongAbs(indexIterator.index) + l);
                }
                break;
            }
            case 3: {
                long l = AbstractDataset.toLong(object);
                int[] nArray = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    nArray[n5++] = (int)(abstractDataset.getElementLongAbs(indexIterator.index) + l);
                }
                break;
            }
            case 4: {
                long l = AbstractDataset.toLong(object);
                long[] lArray = ((LongDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    lArray[n6++] = abstractDataset.getElementLongAbs(indexIterator.index) + l;
                }
                break;
            }
            case 100: {
                long l = AbstractDataset.toLong(object);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byArray[n8++] = (byte)(abstractDataset.getElementLongAbs(indexIterator.index + n9) + l);
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                long l = AbstractDataset.toLong(object);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        sArray[n11++] = (short)(abstractDataset.getElementLongAbs(indexIterator.index + n12) + l);
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                long l = AbstractDataset.toLong(object);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        nArray[n14++] = (int)(abstractDataset.getElementLongAbs(indexIterator.index + n15) + l);
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                long l = AbstractDataset.toLong(object);
                int n16 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset2).getData();
                int n17 = 0;
                while (indexIterator.hasNext()) {
                    int n18 = 0;
                    while (n18 < n16) {
                        lArray[n17++] = abstractDataset.getElementLongAbs(indexIterator.index + n18) + l;
                        ++n18;
                    }
                }
                break;
            }
            case 5: {
                double d = AbstractDataset.toReal(object);
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n19 = 0;
                while (indexIterator.hasNext()) {
                    fArray[n19++] = (float)(abstractDataset.getElementDoubleAbs(indexIterator.index) + d);
                }
                break;
            }
            case 6: {
                double d = AbstractDataset.toReal(object);
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    dArray[n20++] = abstractDataset.getElementDoubleAbs(indexIterator.index) + d;
                }
                break;
            }
            case 500: {
                double d = AbstractDataset.toReal(object);
                int n21 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    int n23 = 0;
                    while (n23 < n21) {
                        fArray[n22++] = (float)(abstractDataset.getElementDoubleAbs(indexIterator.index + n23) + d);
                        ++n23;
                    }
                }
                break;
            }
            case 600: {
                double d = AbstractDataset.toReal(object);
                int n24 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        dArray[n25++] = abstractDataset.getElementDoubleAbs(indexIterator.index + n26) + d;
                        ++n26;
                    }
                }
                break;
            }
            case 7: {
                double d = AbstractDataset.toReal(object);
                double d2 = AbstractDataset.toImag(object);
                float[] fArray = ((ComplexFloatDataset)abstractDataset2).getData();
                int n27 = 0;
                while (indexIterator.hasNext()) {
                    fArray[n27++] = (float)(abstractDataset.getElementDoubleAbs(indexIterator.index) + d);
                    fArray[n27++] = (float)(abstractDataset.getElementDoubleAbs(indexIterator.index + 1) + d2);
                }
                break;
            }
            case 8: {
                double d = AbstractDataset.toReal(object);
                double d3 = AbstractDataset.toImag(object);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    dArray[n28++] = abstractDataset.getElementDoubleAbs(indexIterator.index) + d;
                    dArray[n28++] = abstractDataset.getElementDoubleAbs(indexIterator.index + 1) + d3;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("add does not support this dataset type");
            }
        }
        abstractDataset2.setName(Maths.bracketIfNecessary(abstractDataset).append('+').append(object).toString());
        return abstractDataset2;
    }

    public static AbstractDataset subtract(Object object, Object object2) {
        AbstractDataset abstractDataset = null;
        if (object instanceof AbstractDataset) {
            if (object2 instanceof AbstractDataset) {
                return Maths.subtract((AbstractDataset)object, (AbstractDataset)object2);
            }
            AbstractDataset abstractDataset2 = (AbstractDataset)object;
            int n = AbstractDataset.getBestDType(abstractDataset2.getDtype(), AbstractDataset.getDTypeFromClass(object2.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset2, n);
            IndexIterator indexIterator = abstractDataset2.getIterator();
            switch (n) {
                case 0: {
                    boolean bl = AbstractDataset.toBoolean(object2);
                    boolean[] blArray = ((BooleanDataset)abstractDataset).getData();
                    int n2 = 0;
                    while (indexIterator.hasNext()) {
                        blArray[n2++] = bl ^ abstractDataset2.getElementBooleanAbs(indexIterator.index);
                    }
                    break;
                }
                case 1: {
                    long l = AbstractDataset.toLong(object2);
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n3 = 0;
                    while (indexIterator.hasNext()) {
                        byArray[n3++] = (byte)(abstractDataset2.getElementLongAbs(indexIterator.index) - l);
                    }
                    break;
                }
                case 2: {
                    long l = AbstractDataset.toLong(object2);
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n4 = 0;
                    while (indexIterator.hasNext()) {
                        sArray[n4++] = (short)(abstractDataset2.getElementLongAbs(indexIterator.index) - l);
                    }
                    break;
                }
                case 3: {
                    long l = AbstractDataset.toLong(object2);
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n5 = 0;
                    while (indexIterator.hasNext()) {
                        nArray[n5++] = (int)(abstractDataset2.getElementLongAbs(indexIterator.index) - l);
                    }
                    break;
                }
                case 4: {
                    long l = AbstractDataset.toLong(object2);
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n6 = 0;
                    while (indexIterator.hasNext()) {
                        lArray[n6++] = abstractDataset2.getElementLongAbs(indexIterator.index) - l;
                    }
                    break;
                }
                case 100: {
                    long l = AbstractDataset.toLong(object2);
                    int n7 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n8 = 0;
                    while (indexIterator.hasNext()) {
                        int n9 = 0;
                        while (n9 < n7) {
                            byArray[n8++] = (byte)(abstractDataset2.getElementLongAbs(indexIterator.index + n9) - l);
                            ++n9;
                        }
                    }
                    break;
                }
                case 200: {
                    long l = AbstractDataset.toLong(object2);
                    int n10 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n11 = 0;
                    while (indexIterator.hasNext()) {
                        int n12 = 0;
                        while (n12 < n10) {
                            sArray[n11++] = (short)(abstractDataset2.getElementLongAbs(indexIterator.index + n12) - l);
                            ++n12;
                        }
                    }
                    break;
                }
                case 300: {
                    long l = AbstractDataset.toLong(object2);
                    int n13 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n14 = 0;
                    while (indexIterator.hasNext()) {
                        int n15 = 0;
                        while (n15 < n13) {
                            nArray[n14++] = (int)(abstractDataset2.getElementLongAbs(indexIterator.index + n15) - l);
                            ++n15;
                        }
                    }
                    break;
                }
                case 400: {
                    long l = AbstractDataset.toLong(object2);
                    int n16 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n17 = 0;
                    while (indexIterator.hasNext()) {
                        int n18 = 0;
                        while (n18 < n16) {
                            lArray[n17++] = abstractDataset2.getElementLongAbs(indexIterator.index + n18) - l;
                            ++n18;
                        }
                    }
                    break;
                }
                case 5: {
                    double d = AbstractDataset.toReal(object2);
                    float[] fArray = ((FloatDataset)abstractDataset).getData();
                    int n19 = 0;
                    while (indexIterator.hasNext()) {
                        fArray[n19++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index) - d);
                    }
                    break;
                }
                case 6: {
                    double d = AbstractDataset.toReal(object2);
                    double[] dArray = ((DoubleDataset)abstractDataset).getData();
                    int n20 = 0;
                    while (indexIterator.hasNext()) {
                        dArray[n20++] = abstractDataset2.getElementDoubleAbs(indexIterator.index) - d;
                    }
                    break;
                }
                case 500: {
                    double d = AbstractDataset.toReal(object2);
                    int n21 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n22 = 0;
                    while (indexIterator.hasNext()) {
                        int n23 = 0;
                        while (n23 < n21) {
                            fArray[n22++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index + n23) - d);
                            ++n23;
                        }
                    }
                    break;
                }
                case 600: {
                    double d = AbstractDataset.toReal(object2);
                    int n24 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n25 = 0;
                    while (indexIterator.hasNext()) {
                        int n26 = 0;
                        while (n26 < n24) {
                            dArray[n25++] = abstractDataset2.getElementDoubleAbs(indexIterator.index + n26) - d;
                            ++n26;
                        }
                    }
                    break;
                }
                case 7: {
                    double d = AbstractDataset.toReal(object2);
                    double d2 = AbstractDataset.toImag(object2);
                    float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                    int n27 = 0;
                    while (indexIterator.hasNext()) {
                        fArray[n27++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index) - d);
                        fArray[n27++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index + 1) - d2);
                    }
                    break;
                }
                case 8: {
                    double d = AbstractDataset.toReal(object2);
                    double d3 = AbstractDataset.toImag(object2);
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                    int n28 = 0;
                    while (indexIterator.hasNext()) {
                        dArray[n28++] = abstractDataset2.getElementDoubleAbs(indexIterator.index) - d;
                        dArray[n28++] = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1) - d3;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("subtract does not support this dataset type");
                }
            }
            abstractDataset.setName(Maths.bracketIfNecessary(abstractDataset2).append('-').append(object2).toString());
        } else {
            if (!(object2 instanceof AbstractDataset)) {
                throw new IllegalArgumentException("Both arguments are not datasets");
            }
            AbstractDataset abstractDataset3 = (AbstractDataset)object2;
            int n = AbstractDataset.getBestDType(abstractDataset3.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset3, n);
            IndexIterator indexIterator = abstractDataset3.getIterator();
            switch (n) {
                case 0: {
                    boolean bl = AbstractDataset.toBoolean(object);
                    boolean[] blArray = ((BooleanDataset)abstractDataset).getData();
                    int n29 = 0;
                    while (indexIterator.hasNext()) {
                        blArray[n29++] = bl ^ abstractDataset3.getElementBooleanAbs(indexIterator.index);
                    }
                    break;
                }
                case 1: {
                    long l = AbstractDataset.toLong(object);
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n30 = 0;
                    while (indexIterator.hasNext()) {
                        byArray[n30++] = (byte)(l - abstractDataset3.getElementLongAbs(indexIterator.index));
                    }
                    break;
                }
                case 2: {
                    long l = AbstractDataset.toLong(object);
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n31 = 0;
                    while (indexIterator.hasNext()) {
                        sArray[n31++] = (short)(l - abstractDataset3.getElementLongAbs(indexIterator.index));
                    }
                    break;
                }
                case 3: {
                    long l = AbstractDataset.toLong(object);
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n32 = 0;
                    while (indexIterator.hasNext()) {
                        nArray[n32++] = (int)(l - abstractDataset3.getElementLongAbs(indexIterator.index));
                    }
                    break;
                }
                case 4: {
                    long l = AbstractDataset.toLong(object);
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n33 = 0;
                    while (indexIterator.hasNext()) {
                        lArray[n33++] = l - abstractDataset3.getElementLongAbs(indexIterator.index);
                    }
                    break;
                }
                case 100: {
                    long l = AbstractDataset.toLong(object);
                    int n34 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n35 = 0;
                    while (indexIterator.hasNext()) {
                        int n36 = 0;
                        while (n36 < n34) {
                            byArray[n35++] = (byte)(l - abstractDataset3.getElementLongAbs(indexIterator.index + n36));
                            ++n36;
                        }
                    }
                    break;
                }
                case 200: {
                    long l = AbstractDataset.toLong(object);
                    int n37 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n38 = 0;
                    while (indexIterator.hasNext()) {
                        int n39 = 0;
                        while (n39 < n37) {
                            sArray[n38++] = (short)(l - abstractDataset3.getElementLongAbs(indexIterator.index + n39));
                            ++n39;
                        }
                    }
                    break;
                }
                case 300: {
                    long l = AbstractDataset.toLong(object);
                    int n40 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n41 = 0;
                    while (indexIterator.hasNext()) {
                        int n42 = 0;
                        while (n42 < n40) {
                            nArray[n41++] = (int)(l - abstractDataset3.getElementLongAbs(indexIterator.index + n42));
                            ++n42;
                        }
                    }
                    break;
                }
                case 400: {
                    long l = AbstractDataset.toLong(object);
                    int n43 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n44 = 0;
                    while (indexIterator.hasNext()) {
                        int n45 = 0;
                        while (n45 < n43) {
                            lArray[n44++] = l - abstractDataset3.getElementLongAbs(indexIterator.index + n45);
                            ++n45;
                        }
                    }
                    break;
                }
                case 5: {
                    double d = AbstractDataset.toReal(object);
                    float[] fArray = ((FloatDataset)abstractDataset).getData();
                    int n46 = 0;
                    while (indexIterator.hasNext()) {
                        fArray[n46++] = (float)(d - abstractDataset3.getElementDoubleAbs(indexIterator.index));
                    }
                    break;
                }
                case 6: {
                    double d = AbstractDataset.toReal(object);
                    double[] dArray = ((DoubleDataset)abstractDataset).getData();
                    int n47 = 0;
                    while (indexIterator.hasNext()) {
                        dArray[n47++] = d - abstractDataset3.getElementDoubleAbs(indexIterator.index);
                    }
                    break;
                }
                case 500: {
                    double d = AbstractDataset.toReal(object);
                    int n48 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n49 = 0;
                    while (indexIterator.hasNext()) {
                        int n50 = 0;
                        while (n50 < n48) {
                            fArray[n49++] = (float)(d - abstractDataset3.getElementDoubleAbs(indexIterator.index + n50));
                            ++n50;
                        }
                    }
                    break;
                }
                case 600: {
                    double d = AbstractDataset.toReal(object);
                    int n51 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n52 = 0;
                    while (indexIterator.hasNext()) {
                        int n53 = 0;
                        while (n53 < n51) {
                            dArray[n52++] = d - abstractDataset3.getElementDoubleAbs(indexIterator.index + n53);
                            ++n53;
                        }
                    }
                    break;
                }
                case 7: {
                    double d = AbstractDataset.toReal(object);
                    double d4 = AbstractDataset.toImag(object);
                    float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                    int n54 = 0;
                    while (indexIterator.hasNext()) {
                        fArray[n54++] = (float)(d - abstractDataset3.getElementDoubleAbs(indexIterator.index));
                        fArray[n54++] = (float)(d4 - abstractDataset3.getElementDoubleAbs(indexIterator.index + 1));
                    }
                    break;
                }
                case 8: {
                    double d = AbstractDataset.toReal(object);
                    double d5 = AbstractDataset.toImag(object);
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                    int n55 = 0;
                    while (indexIterator.hasNext()) {
                        dArray[n55++] = d - abstractDataset3.getElementDoubleAbs(indexIterator.index);
                        dArray[n55++] = d5 - abstractDataset3.getElementDoubleAbs(indexIterator.index + 1);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("subtract does not support this dataset type");
                }
            }
            abstractDataset.setName(object.toString() + '-' + Maths.bracketIfNecessary(abstractDataset3));
        }
        return abstractDataset;
    }

    public static AbstractDataset multiply(AbstractDataset abstractDataset, Object object) {
        if (object instanceof AbstractDataset) {
            return Maths.multiply(abstractDataset, (AbstractDataset)object);
        }
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = AbstractDataset.getBestDType(abstractDataset.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset, n);
        switch (n) {
            case 0: {
                boolean bl = AbstractDataset.toBoolean(object);
                boolean[] blArray = ((BooleanDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    boolean bl2 = blArray[n2++] = bl && abstractDataset.getElementBooleanAbs(indexIterator.index);
                }
                break;
            }
            case 1: {
                long l = AbstractDataset.toLong(object);
                byte[] byArray = ((ByteDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    byArray[n3++] = (byte)(abstractDataset.getElementLongAbs(indexIterator.index) * l);
                }
                break;
            }
            case 2: {
                long l = AbstractDataset.toLong(object);
                short[] sArray = ((ShortDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    sArray[n4++] = (short)(abstractDataset.getElementLongAbs(indexIterator.index) * l);
                }
                break;
            }
            case 3: {
                long l = AbstractDataset.toLong(object);
                int[] nArray = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    nArray[n5++] = (int)(abstractDataset.getElementLongAbs(indexIterator.index) * l);
                }
                break;
            }
            case 4: {
                long l = AbstractDataset.toLong(object);
                long[] lArray = ((LongDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    lArray[n6++] = abstractDataset.getElementLongAbs(indexIterator.index) * l;
                }
                break;
            }
            case 100: {
                long l = AbstractDataset.toLong(object);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byArray[n8++] = (byte)(abstractDataset.getElementLongAbs(indexIterator.index + n9) * l);
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                long l = AbstractDataset.toLong(object);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        sArray[n11++] = (short)(abstractDataset.getElementLongAbs(indexIterator.index + n12) * l);
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                long l = AbstractDataset.toLong(object);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        nArray[n14++] = (int)(abstractDataset.getElementLongAbs(indexIterator.index + n15) * l);
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                long l = AbstractDataset.toLong(object);
                int n16 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset2).getData();
                int n17 = 0;
                while (indexIterator.hasNext()) {
                    int n18 = 0;
                    while (n18 < n16) {
                        lArray[n17++] = abstractDataset.getElementLongAbs(indexIterator.index + n18) * l;
                        ++n18;
                    }
                }
                break;
            }
            case 5: {
                double d = AbstractDataset.toReal(object);
                double d2 = AbstractDataset.toImag(object);
                if (d2 == 0.0) {
                    float[] fArray = ((FloatDataset)abstractDataset2).getData();
                    int n19 = 0;
                    while (indexIterator.hasNext()) {
                        fArray[n19++] = (float)(abstractDataset.getElementDoubleAbs(indexIterator.index) * d);
                    }
                } else {
                    abstractDataset2 = new ComplexFloatDataset(abstractDataset.getShape());
                    float[] fArray = ((ComplexFloatDataset)abstractDataset2).getData();
                    int n20 = 0;
                    while (indexIterator.hasNext()) {
                        double d3 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        fArray[n20++] = (float)(d3 * d);
                        fArray[n20++] = (float)(d3 * d2);
                    }
                }
                break;
            }
            case 6: {
                double d = AbstractDataset.toReal(object);
                double d4 = AbstractDataset.toImag(object);
                if (d4 == 0.0) {
                    double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                    int n21 = 0;
                    while (indexIterator.hasNext()) {
                        dArray[n21++] = abstractDataset.getElementDoubleAbs(indexIterator.index) * d;
                    }
                } else {
                    abstractDataset2 = new ComplexDoubleDataset(abstractDataset.getShape());
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset2).getData();
                    int n22 = 0;
                    while (indexIterator.hasNext()) {
                        double d5 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        dArray[n22++] = d5 * d;
                        dArray[n22++] = d5 * d4;
                    }
                }
                break;
            }
            case 500: {
                double d = AbstractDataset.toReal(object);
                int n23 = abstractDataset2.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n24 = 0;
                while (indexIterator.hasNext()) {
                    int n25 = 0;
                    while (n25 < n23) {
                        fArray[n24++] = (float)(abstractDataset.getElementDoubleAbs(indexIterator.index + n25) * d);
                        ++n25;
                    }
                }
                break;
            }
            case 600: {
                double d = AbstractDataset.toReal(object);
                int n26 = abstractDataset2.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n27 = 0;
                while (indexIterator.hasNext()) {
                    int n28 = 0;
                    while (n28 < n26) {
                        dArray[n27++] = abstractDataset.getElementDoubleAbs(indexIterator.index + n28) * d;
                        ++n28;
                    }
                }
                break;
            }
            case 7: {
                double d = AbstractDataset.toReal(object);
                double d6 = AbstractDataset.toImag(object);
                float[] fArray = ((ComplexFloatDataset)abstractDataset2).getData();
                if (d6 == 0.0) {
                    int n29 = 0;
                    while (indexIterator.hasNext()) {
                        double d7 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        double d8 = abstractDataset.getElementDoubleAbs(indexIterator.index + 1);
                        fArray[n29++] = (float)(d7 * d);
                        fArray[n29++] = (float)(d8 * d);
                    }
                } else {
                    int n30 = 0;
                    while (indexIterator.hasNext()) {
                        double d9 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        double d10 = abstractDataset.getElementDoubleAbs(indexIterator.index + 1);
                        fArray[n30++] = (float)(d9 * d - d10 * d6);
                        fArray[n30++] = (float)(d9 * d6 + d10 * d);
                    }
                }
                break;
            }
            case 8: {
                double d = AbstractDataset.toReal(object);
                double d11 = AbstractDataset.toImag(object);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset2).getData();
                if (d11 == 0.0) {
                    int n31 = 0;
                    while (indexIterator.hasNext()) {
                        double d12 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        double d13 = abstractDataset.getElementDoubleAbs(indexIterator.index + 1);
                        dArray[n31++] = d12 * d;
                        dArray[n31++] = d13 * d;
                    }
                } else {
                    int n32 = 0;
                    while (indexIterator.hasNext()) {
                        double d14 = abstractDataset.getElementDoubleAbs(indexIterator.index);
                        double d15 = abstractDataset.getElementDoubleAbs(indexIterator.index + 1);
                        dArray[n32++] = d14 * d - d15 * d11;
                        dArray[n32++] = d14 * d11 + d15 * d;
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("multiply does not support this dataset type");
            }
        }
        abstractDataset2.setName(Maths.bracketIfNecessary(abstractDataset).append('*').append(object).toString());
        return abstractDataset2;
    }

    public static AbstractDataset divide(Object object, Object object2) {
        AbstractDataset abstractDataset = null;
        if (object instanceof AbstractDataset) {
            if (object2 instanceof AbstractDataset) {
                return Maths.divide((AbstractDataset)object, (AbstractDataset)object2);
            }
            AbstractDataset abstractDataset2 = (AbstractDataset)object;
            int n = AbstractDataset.getBestDType(abstractDataset2.getDtype(), AbstractDataset.getDTypeFromClass(object2.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset2, n);
            IndexIterator indexIterator = abstractDataset2.getIterator();
            switch (n) {
                case 0: {
                    boolean bl = AbstractDataset.toBoolean(object2);
                    boolean[] blArray = ((BooleanDataset)abstractDataset).getData();
                    int n2 = 0;
                    while (indexIterator.hasNext()) {
                        boolean bl2 = blArray[n2++] = bl && abstractDataset2.getElementBooleanAbs(indexIterator.index);
                    }
                    break;
                }
                case 1: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n3 = 0;
                    while (indexIterator.hasNext()) {
                        byArray[n3++] = (byte)(abstractDataset2.getElementLongAbs(indexIterator.index) / l);
                    }
                    break;
                }
                case 2: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n4 = 0;
                    while (indexIterator.hasNext()) {
                        sArray[n4++] = (short)(abstractDataset2.getElementLongAbs(indexIterator.index) / l);
                    }
                    break;
                }
                case 3: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n5 = 0;
                    while (indexIterator.hasNext()) {
                        nArray[n5++] = (int)(abstractDataset2.getElementLongAbs(indexIterator.index) / l);
                    }
                    break;
                }
                case 4: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n6 = 0;
                    while (indexIterator.hasNext()) {
                        lArray[n6++] = abstractDataset2.getElementLongAbs(indexIterator.index) / l;
                    }
                    break;
                }
                case 100: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n7 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n8 = 0;
                    while (indexIterator.hasNext()) {
                        int n9 = 0;
                        while (n9 < n7) {
                            byArray[n8++] = (byte)(abstractDataset2.getElementLongAbs(indexIterator.index + n9) / l);
                            ++n9;
                        }
                    }
                    break;
                }
                case 200: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n10 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n11 = 0;
                    while (indexIterator.hasNext()) {
                        int n12 = 0;
                        while (n12 < n10) {
                            sArray[n11++] = (short)(abstractDataset2.getElementLongAbs(indexIterator.index + n12) / l);
                            ++n12;
                        }
                    }
                    break;
                }
                case 300: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n13 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n14 = 0;
                    while (indexIterator.hasNext()) {
                        int n15 = 0;
                        while (n15 < n13) {
                            nArray[n14++] = (int)(abstractDataset2.getElementLongAbs(indexIterator.index + n15) / l);
                            ++n15;
                        }
                    }
                    break;
                }
                case 400: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n16 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n17 = 0;
                    while (indexIterator.hasNext()) {
                        int n18 = 0;
                        while (n18 < n16) {
                            lArray[n17++] = abstractDataset2.getElementLongAbs(indexIterator.index + n18) / l;
                            ++n18;
                        }
                    }
                    break;
                }
                case 5: {
                    double d = AbstractDataset.toReal(object2);
                    double d2 = AbstractDataset.toImag(object2);
                    if (d2 == 0.0) {
                        float[] fArray = ((FloatDataset)abstractDataset).getData();
                        int n19 = 0;
                        while (indexIterator.hasNext()) {
                            fArray[n19++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index) / d);
                        }
                    } else {
                        abstractDataset = new ComplexFloatDataset(abstractDataset2.getShape());
                        float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                        if (Math.abs(d) < Math.abs(d2)) {
                            double d3 = d / d2;
                            double d4 = d * d3 + d2;
                            int n20 = 0;
                            while (indexIterator.hasNext()) {
                                double d5 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                                double d6 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                                fArray[n20++] = (float)((d5 * d3 + d6) / d4);
                                fArray[n20++] = (float)((d6 * d3 - d5) / d4);
                            }
                        } else {
                            double d7 = d2 / d;
                            double d8 = d2 * d7 + d;
                            int n21 = 0;
                            while (indexIterator.hasNext()) {
                                double d9 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                                double d10 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                                fArray[n21++] = (float)((d10 * d7 + d9) / d8);
                                fArray[n21++] = (float)((d10 - d9 * d7) / d8);
                            }
                        }
                    }
                    break;
                }
                case 6: {
                    double d = AbstractDataset.toReal(object2);
                    double d11 = AbstractDataset.toImag(object2);
                    if (d11 == 0.0) {
                        abstractDataset = new DoubleDataset(abstractDataset2.getShape());
                        double[] dArray = ((DoubleDataset)abstractDataset).getData();
                        int n22 = 0;
                        while (indexIterator.hasNext()) {
                            dArray[n22++] = abstractDataset2.getElementDoubleAbs(indexIterator.index) / d;
                        }
                    } else {
                        abstractDataset = new ComplexDoubleDataset(abstractDataset2.getShape());
                        double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                        if (Math.abs(d) < Math.abs(d11)) {
                            double d12 = d / d11;
                            double d13 = d * d12 + d11;
                            int n23 = 0;
                            while (indexIterator.hasNext()) {
                                double d14 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                                double d15 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                                dArray[n23++] = (d14 * d12 + d15) / d13;
                                dArray[n23++] = (d15 * d12 - d14) / d13;
                            }
                        } else {
                            double d16 = d11 / d;
                            double d17 = d11 * d16 + d;
                            int n24 = 0;
                            while (indexIterator.hasNext()) {
                                double d18 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                                double d19 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                                dArray[n24++] = (d19 * d16 + d18) / d17;
                                dArray[n24++] = (d19 - d18 * d16) / d17;
                            }
                        }
                    }
                    break;
                }
                case 500: {
                    double d = AbstractDataset.toReal(object2);
                    int n25 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n26 = 0;
                    while (indexIterator.hasNext()) {
                        int n27 = 0;
                        while (n27 < n25) {
                            fArray[n26++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index + n27) / d);
                            ++n27;
                        }
                    }
                    break;
                }
                case 600: {
                    double d = AbstractDataset.toReal(object2);
                    int n28 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n29 = 0;
                    while (indexIterator.hasNext()) {
                        int n30 = 0;
                        while (n30 < n28) {
                            dArray[n29++] = abstractDataset2.getElementDoubleAbs(indexIterator.index + n30) / d;
                            ++n30;
                        }
                    }
                    break;
                }
                case 7: {
                    double d = AbstractDataset.toReal(object2);
                    double d20 = AbstractDataset.toImag(object2);
                    float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                    if (d20 == 0.0) {
                        int n31 = 0;
                        while (indexIterator.hasNext()) {
                            fArray[n31++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index) / d);
                            fArray[n31++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index + 1) / d);
                        }
                    } else if (Math.abs(d) < Math.abs(d20)) {
                        double d21 = d / d20;
                        double d22 = d * d21 + d20;
                        int n32 = 0;
                        while (indexIterator.hasNext()) {
                            double d23 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                            double d24 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                            fArray[n32++] = (float)((d23 * d21 + d24) / d22);
                            fArray[n32++] = (float)((d24 * d21 - d23) / d22);
                        }
                    } else {
                        double d25 = d20 / d;
                        double d26 = d20 * d25 + d;
                        int n33 = 0;
                        while (indexIterator.hasNext()) {
                            double d27 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                            double d28 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                            fArray[n33++] = (float)((d28 * d25 + d27) / d26);
                            fArray[n33++] = (float)((d28 - d27 * d25) / d26);
                        }
                    }
                    break;
                }
                case 8: {
                    double d = AbstractDataset.toReal(object2);
                    double d29 = AbstractDataset.toImag(object2);
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                    if (d29 == 0.0) {
                        int n34 = 0;
                        while (indexIterator.hasNext()) {
                            dArray[n34++] = abstractDataset2.getElementDoubleAbs(indexIterator.index) / d;
                            dArray[n34++] = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1) / d;
                        }
                    } else if (Math.abs(d) < Math.abs(d29)) {
                        double d30 = d / d29;
                        double d31 = d * d30 + d29;
                        int n35 = 0;
                        while (indexIterator.hasNext()) {
                            double d32 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                            double d33 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                            dArray[n35++] = (d32 * d30 + d33) / d31;
                            dArray[n35++] = (d33 * d30 - d32) / d31;
                        }
                    } else {
                        double d34 = d29 / d;
                        double d35 = d29 * d34 + d;
                        int n36 = 0;
                        while (indexIterator.hasNext()) {
                            double d36 = abstractDataset2.getElementDoubleAbs(indexIterator.index);
                            double d37 = abstractDataset2.getElementDoubleAbs(indexIterator.index + 1);
                            dArray[n36++] = (d37 * d34 + d36) / d35;
                            dArray[n36++] = (d37 - d36 * d34) / d35;
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("divide does not support this dataset type");
                }
            }
            abstractDataset.setName(Maths.bracketIfNecessary(abstractDataset2).append('/').append(object2).toString());
        } else {
            if (!(object2 instanceof AbstractDataset)) {
                throw new IllegalArgumentException("Both arguments are not datasets");
            }
            AbstractDataset abstractDataset3 = (AbstractDataset)object2;
            int n = AbstractDataset.getBestDType(abstractDataset3.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset3, n);
            IndexIterator indexIterator = abstractDataset3.getIterator();
            switch (n) {
                case 0: {
                    boolean bl = AbstractDataset.toBoolean(object);
                    boolean[] blArray = ((BooleanDataset)abstractDataset).getData();
                    int n37 = 0;
                    while (indexIterator.hasNext()) {
                        boolean bl3 = blArray[n37++] = bl && abstractDataset3.getElementBooleanAbs(indexIterator.index);
                    }
                    break;
                }
                case 1: {
                    long l = AbstractDataset.toLong(object);
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n38 = 0;
                    while (indexIterator.hasNext()) {
                        try {
                            byArray[n38++] = (byte)(l / abstractDataset3.getElementLongAbs(indexIterator.index));
                        }
                        catch (ArithmeticException arithmeticException) {
                            ++n38;
                        }
                    }
                    break;
                }
                case 2: {
                    long l = AbstractDataset.toLong(object);
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n39 = 0;
                    while (indexIterator.hasNext()) {
                        try {
                            sArray[n39++] = (short)(l / abstractDataset3.getElementLongAbs(indexIterator.index));
                        }
                        catch (ArithmeticException arithmeticException) {
                            ++n39;
                        }
                    }
                    break;
                }
                case 3: {
                    long l = AbstractDataset.toLong(object);
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n40 = 0;
                    while (indexIterator.hasNext()) {
                        try {
                            nArray[n40++] = (int)(l / abstractDataset3.getElementLongAbs(indexIterator.index));
                        }
                        catch (ArithmeticException arithmeticException) {
                            ++n40;
                        }
                    }
                    break;
                }
                case 4: {
                    long l = AbstractDataset.toLong(object);
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n41 = 0;
                    while (indexIterator.hasNext()) {
                        try {
                            lArray[n41++] = l / abstractDataset3.getElementLongAbs(indexIterator.index);
                        }
                        catch (ArithmeticException arithmeticException) {
                            ++n41;
                        }
                    }
                    break;
                }
                case 100: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n42 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n43 = 0;
                    while (indexIterator.hasNext()) {
                        int n44 = 0;
                        while (n44 < n42) {
                            try {
                                byArray[n43++] = (byte)(l / abstractDataset3.getElementLongAbs(indexIterator.index + n44));
                            }
                            catch (ArithmeticException arithmeticException) {
                                ++n43;
                            }
                            ++n44;
                        }
                    }
                    break;
                }
                case 200: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n45 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n46 = 0;
                    while (indexIterator.hasNext()) {
                        int n47 = 0;
                        while (n47 < n45) {
                            try {
                                sArray[n46++] = (short)(l / abstractDataset3.getElementLongAbs(indexIterator.index + n47));
                            }
                            catch (ArithmeticException arithmeticException) {
                                ++n46;
                            }
                            ++n47;
                        }
                    }
                    break;
                }
                case 300: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n48 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n49 = 0;
                    while (indexIterator.hasNext()) {
                        int n50 = 0;
                        while (n50 < n48) {
                            try {
                                nArray[n49++] = (int)(l / abstractDataset3.getElementLongAbs(indexIterator.index + n50));
                            }
                            catch (ArithmeticException arithmeticException) {
                                ++n49;
                            }
                            ++n50;
                        }
                    }
                    break;
                }
                case 400: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n51 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n52 = 0;
                    while (indexIterator.hasNext()) {
                        int n53 = 0;
                        while (n53 < n51) {
                            try {
                                lArray[n52++] = l / abstractDataset3.getElementLongAbs(indexIterator.index + n53);
                            }
                            catch (ArithmeticException arithmeticException) {
                                ++n52;
                            }
                            ++n53;
                        }
                    }
                    break;
                }
                case 5: {
                    double d = AbstractDataset.toReal(object);
                    double d38 = AbstractDataset.toImag(object);
                    if (d38 == 0.0) {
                        float[] fArray = ((FloatDataset)abstractDataset).getData();
                        int n54 = 0;
                        while (indexIterator.hasNext()) {
                            fArray[n54++] = (float)(d / abstractDataset3.getElementDoubleAbs(indexIterator.index));
                        }
                    } else {
                        abstractDataset = new ComplexFloatDataset(abstractDataset3.getShape());
                        float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                        int n55 = 0;
                        while (indexIterator.hasNext()) {
                            double d39 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                            fArray[n55++] = (float)(d / d39);
                            fArray[n55++] = (float)(d38 / d39);
                        }
                    }
                    break;
                }
                case 6: {
                    double d = AbstractDataset.toReal(object);
                    double d40 = AbstractDataset.toImag(object);
                    if (d40 == 0.0) {
                        double[] dArray = ((DoubleDataset)abstractDataset).getData();
                        int n56 = 0;
                        while (indexIterator.hasNext()) {
                            dArray[n56++] = d / abstractDataset3.getElementDoubleAbs(indexIterator.index);
                        }
                    } else {
                        abstractDataset = new ComplexDoubleDataset(abstractDataset3.getShape());
                        double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                        int n57 = 0;
                        while (indexIterator.hasNext()) {
                            double d41 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                            dArray[n57++] = d / d41;
                            dArray[n57++] = d40 / d41;
                        }
                    }
                    break;
                }
                case 7: {
                    double d = AbstractDataset.toReal(object);
                    double d42 = AbstractDataset.toImag(object);
                    float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                    if (d42 == 0.0) {
                        int n58 = 0;
                        while (indexIterator.hasNext()) {
                            double d43;
                            double d44;
                            double d45 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                            double d46 = abstractDataset3.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d45) < Math.abs(d46)) {
                                d44 = d45 / d46;
                                d43 = d45 * d44 + d46;
                                fArray[n58++] = (float)(d * d44 / d43);
                                fArray[n58++] = (float)(-d / d43);
                                continue;
                            }
                            d44 = d46 / d45;
                            d43 = d46 * d44 + d45;
                            fArray[n58++] = (float)(d / d43);
                            fArray[n58++] = (float)(-d * d44 / d43);
                        }
                    } else {
                        int n59 = 0;
                        while (indexIterator.hasNext()) {
                            double d47;
                            double d48;
                            double d49 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                            double d50 = abstractDataset3.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d49) < Math.abs(d50)) {
                                d48 = d49 / d50;
                                d47 = d49 * d48 + d50;
                                fArray[n59++] = (float)((d * d48 + d42) / d47);
                                fArray[n59++] = (float)((d42 * d48 - d) / d47);
                                continue;
                            }
                            d48 = d50 / d49;
                            d47 = d50 * d48 + d49;
                            fArray[n59++] = (float)((d42 * d48 + d) / d47);
                            fArray[n59++] = (float)((d42 - d * d48) / d47);
                        }
                    }
                    break;
                }
                case 8: {
                    double d = AbstractDataset.toReal(object);
                    double d51 = AbstractDataset.toImag(object);
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                    if (d51 == 0.0) {
                        int n60 = 0;
                        while (indexIterator.hasNext()) {
                            double d52;
                            double d53;
                            double d54 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                            double d55 = abstractDataset3.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d54) < Math.abs(d55)) {
                                d53 = d54 / d55;
                                d52 = d54 * d53 + d55;
                                dArray[n60++] = d * d53 / d52;
                                dArray[n60++] = -d / d52;
                                continue;
                            }
                            d53 = d55 / d54;
                            d52 = d55 * d53 + d54;
                            dArray[n60++] = d / d52;
                            dArray[n60++] = -d * d53 / d52;
                        }
                    } else {
                        int n61 = 0;
                        while (indexIterator.hasNext()) {
                            double d56;
                            double d57;
                            double d58 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                            double d59 = abstractDataset3.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d58) < Math.abs(d59)) {
                                d57 = d58 / d59;
                                d56 = d58 * d57 + d59;
                                dArray[n61++] = (d * d57 + d51) / d56;
                                dArray[n61++] = (d51 * d57 - d) / d56;
                                continue;
                            }
                            d57 = d59 / d58;
                            d56 = d59 * d57 + d58;
                            dArray[n61++] = (d51 * d57 + d) / d56;
                            dArray[n61++] = (d51 - d * d57) / d56;
                        }
                    }
                    break;
                }
                case 500: {
                    double d = AbstractDataset.toReal(object);
                    int n62 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n63 = 0;
                    while (indexIterator.hasNext()) {
                        int n64 = 0;
                        while (n64 < n62) {
                            fArray[n63++] = (float)(d / abstractDataset3.getElementDoubleAbs(indexIterator.index + n64));
                            ++n64;
                        }
                    }
                    break;
                }
                case 600: {
                    double d = AbstractDataset.toReal(object);
                    int n65 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n66 = 0;
                    while (indexIterator.hasNext()) {
                        int n67 = 0;
                        while (n67 < n65) {
                            dArray[n66++] = d / abstractDataset3.getElementDoubleAbs(indexIterator.index + n67);
                            ++n67;
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("divide does not support this dataset type");
                }
            }
            abstractDataset.setName(object.toString() + '/' + Maths.bracketIfNecessary(abstractDataset3));
        }
        return abstractDataset;
    }

    public static AbstractDataset dividez(Object object, Object object2) {
        AbstractDataset abstractDataset;
        block102: {
            block100: {
                block101: {
                    AbstractDataset abstractDataset2;
                    AbstractDataset abstractDataset3;
                    abstractDataset = null;
                    if (!(object instanceof AbstractDataset)) break block100;
                    if (!(object2 instanceof AbstractDataset)) break block101;
                    int n = ((AbstractDataset)object).getDtype();
                    int n2 = ((AbstractDataset)object2).getDtype();
                    if (n2 > n) {
                        abstractDataset3 = (AbstractDataset)object2;
                        abstractDataset2 = (AbstractDataset)object;
                    } else {
                        abstractDataset3 = (AbstractDataset)object;
                        abstractDataset2 = (AbstractDataset)object2;
                    }
                    abstractDataset3.checkCompatibility(abstractDataset2);
                    abstractDataset = AbstractDataset.zeros(abstractDataset3, n2);
                    IndexIterator indexIterator = abstractDataset3.getIterator();
                    IndexIterator indexIterator2 = abstractDataset2.getIterator();
                    switch (n2) {
                        case 0: {
                            boolean[] blArray = ((BooleanDataset)abstractDataset).getData();
                            int n3 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                boolean bl = blArray[n3++] = abstractDataset3.getElementBooleanAbs(indexIterator.index) && abstractDataset2.getElementBooleanAbs(indexIterator2.index);
                            }
                            break block102;
                        }
                        case 1: {
                            byte[] byArray = ((ByteDataset)abstractDataset).getData();
                            int n4 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                long l = abstractDataset2.getElementLongAbs(indexIterator2.index);
                                byte by = byArray[n4++] = l == 0L ? (byte)0 : (byte)(abstractDataset3.getElementLongAbs(indexIterator.index) / l);
                            }
                            break block102;
                        }
                        case 2: {
                            short[] sArray = ((ShortDataset)abstractDataset).getData();
                            int n5 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                long l = abstractDataset2.getElementLongAbs(indexIterator2.index);
                                short s = sArray[n5++] = l == 0L ? (short)0 : (short)(abstractDataset3.getElementLongAbs(indexIterator.index) / l);
                            }
                            break block102;
                        }
                        case 3: {
                            int[] nArray = ((IntegerDataset)abstractDataset).getData();
                            int n6 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                long l = abstractDataset2.getElementLongAbs(indexIterator2.index);
                                int n7 = nArray[n6++] = l == 0L ? 0 : (int)(abstractDataset3.getElementLongAbs(indexIterator.index) / l);
                            }
                            break block102;
                        }
                        case 4: {
                            long[] lArray = ((LongDataset)abstractDataset).getData();
                            int n8 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                long l = abstractDataset2.getElementLongAbs(indexIterator2.index);
                                long l2 = lArray[n8++] = l == 0L ? 0L : abstractDataset3.getElementLongAbs(indexIterator.index) / l;
                            }
                            break block102;
                        }
                        case 100: {
                            byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                            int n9 = abstractDataset.getElementsPerItem();
                            int n10 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                int n11 = 0;
                                while (n11 < n9) {
                                    long l = abstractDataset2.getElementLongAbs(indexIterator2.index + n11);
                                    byArray[n10++] = l == 0L ? (byte)0 : (byte)(abstractDataset3.getElementLongAbs(indexIterator.index + n11) / l);
                                    ++n11;
                                }
                            }
                            break block102;
                        }
                        case 200: {
                            short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                            int n12 = abstractDataset.getElementsPerItem();
                            int n13 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                int n14 = 0;
                                while (n14 < n12) {
                                    long l = abstractDataset2.getElementLongAbs(indexIterator2.index + n14);
                                    sArray[n13++] = l == 0L ? (short)0 : (short)(abstractDataset3.getElementLongAbs(indexIterator.index + n14) / l);
                                    ++n14;
                                }
                            }
                            break block102;
                        }
                        case 300: {
                            int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                            int n15 = abstractDataset.getElementsPerItem();
                            int n16 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                int n17 = 0;
                                while (n17 < n15) {
                                    long l = abstractDataset2.getElementLongAbs(indexIterator2.index + n17);
                                    nArray[n16++] = l == 0L ? 0 : (int)(abstractDataset3.getElementLongAbs(indexIterator.index + n17) / l);
                                    ++n17;
                                }
                            }
                            break block102;
                        }
                        case 400: {
                            long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                            int n18 = abstractDataset.getElementsPerItem();
                            int n19 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                int n20 = 0;
                                while (n20 < n18) {
                                    long l = abstractDataset2.getElementLongAbs(indexIterator2.index + n20);
                                    lArray[n19++] = l == 0L ? 0L : abstractDataset3.getElementLongAbs(indexIterator.index + n20) / l;
                                    ++n20;
                                }
                            }
                            break block102;
                        }
                        case 5: {
                            float[] fArray = ((FloatDataset)abstractDataset).getData();
                            int n21 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                double d = abstractDataset2.getElementDoubleAbs(indexIterator2.index);
                                float f = fArray[n21++] = d == 0.0 ? 0.0f : (float)(abstractDataset3.getElementDoubleAbs(indexIterator.index) / d);
                            }
                            break block102;
                        }
                        case 6: {
                            double[] dArray = ((DoubleDataset)abstractDataset).getData();
                            int n22 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                double d = abstractDataset2.getElementDoubleAbs(indexIterator2.index);
                                double d2 = dArray[n22++] = d == 0.0 ? 0.0 : abstractDataset3.getElementDoubleAbs(indexIterator.index) / d;
                            }
                            break block102;
                        }
                        case 500: {
                            float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                            int n23 = abstractDataset.getElementsPerItem();
                            int n24 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                int n25 = 0;
                                while (n25 < n23) {
                                    double d = abstractDataset2.getElementDoubleAbs(indexIterator2.index + n25);
                                    fArray[n24++] = d == 0.0 ? 0.0f : (float)(abstractDataset3.getElementDoubleAbs(indexIterator.index + n25) / d);
                                    ++n25;
                                }
                            }
                            break block102;
                        }
                        case 600: {
                            double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                            int n26 = abstractDataset.getElementsPerItem();
                            int n27 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                int n28 = 0;
                                while (n28 < n26) {
                                    double d = abstractDataset2.getElementDoubleAbs(indexIterator2.index + n28);
                                    dArray[n27++] = d == 0.0 ? 0.0 : abstractDataset3.getElementDoubleAbs(indexIterator.index + n28) / d;
                                    ++n28;
                                }
                            }
                            break block102;
                        }
                        case 7: {
                            float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                            int n29 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                double d;
                                double d3;
                                double d4 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                                double d5 = abstractDataset3.getElementDoubleAbs(indexIterator.index + 1);
                                double d6 = abstractDataset2.getElementDoubleAbs(indexIterator2.index);
                                double d7 = abstractDataset2.getElementDoubleAbs(indexIterator2.index + 1);
                                if (Math.abs(d6) < Math.abs(d7)) {
                                    d3 = d6 / d7;
                                    d = d6 * d3 + d7;
                                    fArray[n29++] = (float)((d4 * d3 + d5) / d);
                                    fArray[n29++] = (float)((d5 * d3 - d4) / d);
                                    continue;
                                }
                                d3 = d7 / d6;
                                d = d7 * d3 + d6;
                                fArray[n29++] = d == 0.0 ? 0.0f : (float)((d5 * d3 + d4) / d);
                                float f = fArray[n29++] = d == 0.0 ? 0.0f : (float)((d5 - d4 * d3) / d);
                            }
                            break block102;
                        }
                        case 8: {
                            double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                            int n30 = 0;
                            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                                double d;
                                double d8;
                                double d9 = abstractDataset3.getElementDoubleAbs(indexIterator.index);
                                double d10 = abstractDataset3.getElementDoubleAbs(indexIterator.index + 1);
                                double d11 = abstractDataset2.getElementDoubleAbs(indexIterator2.index);
                                double d12 = abstractDataset2.getElementDoubleAbs(indexIterator2.index + 1);
                                if (Math.abs(d11) < Math.abs(d12)) {
                                    d8 = d11 / d12;
                                    d = d11 * d8 + d12;
                                    dArray[n30++] = (d9 * d8 + d10) / d;
                                    dArray[n30++] = (d10 * d8 - d9) / d;
                                    continue;
                                }
                                d8 = d12 / d11;
                                d = d12 * d8 + d11;
                                dArray[n30++] = d == 0.0 ? 0.0 : (d10 * d8 + d9) / d;
                                double d13 = dArray[n30++] = d == 0.0 ? 0.0 : (d10 - d9 * d8) / d;
                            }
                            break block102;
                        }
                        default: {
                            throw new UnsupportedOperationException("dividez does not support this dataset type");
                        }
                    }
                }
                AbstractDataset abstractDataset4 = (AbstractDataset)object;
                int n = AbstractDataset.getBestDType(abstractDataset4.getDtype(), AbstractDataset.getDTypeFromClass(object2.getClass()));
                double d = AbstractDataset.toLong(object2);
                if (d == 0.0) {
                    abstractDataset = AbstractDataset.zeros(abstractDataset4, n);
                    abstractDataset.setName(Maths.bracketIfNecessary(abstractDataset4).append('/').append(object2).toString());
                } else {
                    abstractDataset = Maths.divide(object, object2);
                }
                break block102;
            }
            if (!(object2 instanceof AbstractDataset)) {
                throw new IllegalArgumentException("Both arguments are not datasets");
            }
            AbstractDataset abstractDataset5 = (AbstractDataset)object2;
            int n = AbstractDataset.getBestDType(abstractDataset5.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset5, n);
            double d = AbstractDataset.toReal(object);
            if (d == 0.0) {
                return abstractDataset;
            }
            IndexIterator indexIterator = abstractDataset5.getIterator();
            switch (n) {
                case 0: {
                    boolean bl = AbstractDataset.toBoolean(object);
                    boolean[] blArray = ((BooleanDataset)abstractDataset).getData();
                    int n31 = 0;
                    while (indexIterator.hasNext()) {
                        boolean bl2 = blArray[n31++] = bl && abstractDataset5.getElementBooleanAbs(indexIterator.index);
                    }
                    break;
                }
                case 1: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n32 = 0;
                    while (indexIterator.hasNext()) {
                        long l3 = abstractDataset5.getElementLongAbs(indexIterator.index);
                        byte by = byArray[n32++] = l3 == 0L ? (byte)0 : (byte)(l / l3);
                    }
                    break;
                }
                case 2: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n33 = 0;
                    while (indexIterator.hasNext()) {
                        long l4 = abstractDataset5.getElementLongAbs(indexIterator.index);
                        short s = sArray[n33++] = l4 == 0L ? (short)0 : (short)(l / l4);
                    }
                    break;
                }
                case 3: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n34 = 0;
                    while (indexIterator.hasNext()) {
                        long l5 = abstractDataset5.getElementLongAbs(indexIterator.index);
                        int n35 = nArray[n34++] = l5 == 0L ? 0 : (int)(l / l5);
                    }
                    break;
                }
                case 4: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n36 = 0;
                    while (indexIterator.hasNext()) {
                        long l6 = abstractDataset5.getElementLongAbs(indexIterator.index);
                        long l7 = lArray[n36++] = l6 == 0L ? 0L : l / l6;
                    }
                    break;
                }
                case 100: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n37 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n38 = 0;
                    while (indexIterator.hasNext()) {
                        int n39 = 0;
                        while (n39 < n37) {
                            long l8 = abstractDataset5.getElementLongAbs(indexIterator.index + n39);
                            byArray[n38++] = l8 == 0L ? (byte)0 : (byte)(l / l8);
                            ++n39;
                        }
                    }
                    break;
                }
                case 200: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n40 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n41 = 0;
                    while (indexIterator.hasNext()) {
                        int n42 = 0;
                        while (n42 < n40) {
                            long l9 = abstractDataset5.getElementLongAbs(indexIterator.index + n42);
                            sArray[n41++] = l9 == 0L ? (short)0 : (short)(l / l9);
                            ++n42;
                        }
                    }
                    break;
                }
                case 300: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n43 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n44 = 0;
                    while (indexIterator.hasNext()) {
                        int n45 = 0;
                        while (n45 < n43) {
                            long l10 = abstractDataset5.getElementLongAbs(indexIterator.index + n45);
                            nArray[n44++] = l10 == 0L ? 0 : (int)(l / l10);
                            ++n45;
                        }
                    }
                    break;
                }
                case 400: {
                    long l = AbstractDataset.toLong(object);
                    if (l == 0L) break;
                    int n46 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n47 = 0;
                    while (indexIterator.hasNext()) {
                        int n48 = 0;
                        while (n48 < n46) {
                            long l11 = abstractDataset5.getElementLongAbs(indexIterator.index + n48);
                            lArray[n47++] = l11 == 0L ? 0L : l / l11;
                            ++n48;
                        }
                    }
                    break;
                }
                case 5: {
                    double d14 = AbstractDataset.toImag(object);
                    if (d14 == 0.0) {
                        float[] fArray = ((FloatDataset)abstractDataset).getData();
                        int n49 = 0;
                        while (indexIterator.hasNext()) {
                            double d15 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            float f = fArray[n49++] = d15 == 0.0 ? 0.0f : (float)(d / d15);
                        }
                    } else {
                        abstractDataset = new ComplexFloatDataset(abstractDataset5.getShape());
                        float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                        int n50 = 0;
                        while (indexIterator.hasNext()) {
                            double d16 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            fArray[n50++] = d16 == 0.0 ? 0.0f : (float)(d / d16);
                            float f = fArray[n50++] = d16 == 0.0 ? 0.0f : (float)(d14 / d16);
                        }
                    }
                    break;
                }
                case 6: {
                    double d17 = AbstractDataset.toImag(object);
                    if (d17 == 0.0) {
                        double[] dArray = ((DoubleDataset)abstractDataset).getData();
                        int n51 = 0;
                        while (indexIterator.hasNext()) {
                            double d18 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            double d19 = dArray[n51++] = d18 == 0.0 ? 0.0 : d / d18;
                        }
                    } else {
                        abstractDataset = new ComplexDoubleDataset(abstractDataset5.getShape());
                        double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                        int n52 = 0;
                        while (indexIterator.hasNext()) {
                            double d20 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            dArray[n52++] = d20 == 0.0 ? 0.0 : d / d20;
                            double d21 = dArray[n52++] = d20 == 0.0 ? 0.0 : d17 / d20;
                        }
                    }
                    break;
                }
                case 500: {
                    int n53 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n54 = 0;
                    while (indexIterator.hasNext()) {
                        int n55 = 0;
                        while (n55 < n53) {
                            double d22 = abstractDataset5.getElementDoubleAbs(indexIterator.index + n55);
                            fArray[n54++] = d22 == 0.0 ? 0.0f : (float)(d / d22);
                            ++n55;
                        }
                    }
                    break;
                }
                case 600: {
                    int n56 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n57 = 0;
                    while (indexIterator.hasNext()) {
                        int n58 = 0;
                        while (n58 < n56) {
                            double d23 = abstractDataset5.getElementDoubleAbs(indexIterator.index + n58);
                            dArray[n57++] = d23 == 0.0 ? 0.0 : d / d23;
                            ++n58;
                        }
                    }
                    break;
                }
                case 7: {
                    double d24 = AbstractDataset.toImag(object);
                    float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                    if (d24 == 0.0) {
                        int n59 = 0;
                        while (indexIterator.hasNext()) {
                            double d25;
                            double d26;
                            double d27 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            double d28 = abstractDataset5.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d27) < Math.abs(d28)) {
                                d26 = d27 / d28;
                                d25 = d27 * d26 + d28;
                                fArray[n59++] = (float)(d * d26 / d25);
                                fArray[n59++] = (float)(-d / d25);
                                continue;
                            }
                            d26 = d28 / d27;
                            d25 = d28 * d26 + d27;
                            fArray[n59++] = d25 == 0.0 ? 0.0f : (float)(d / d25);
                            float f = fArray[n59++] = d25 == 0.0 ? 0.0f : (float)(-d * d26 / d25);
                        }
                    } else {
                        int n60 = 0;
                        while (indexIterator.hasNext()) {
                            double d29;
                            double d30;
                            double d31 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            double d32 = abstractDataset5.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d31) < Math.abs(d32)) {
                                d30 = d31 / d32;
                                d29 = d31 * d30 + d32;
                                fArray[n60++] = (float)((d * d30 + d24) / d29);
                                fArray[n60++] = (float)((d24 * d30 - d) / d29);
                                continue;
                            }
                            d30 = d32 / d31;
                            d29 = d32 * d30 + d31;
                            fArray[n60++] = d29 == 0.0 ? 0.0f : (float)((d24 * d30 + d) / d29);
                            float f = fArray[n60++] = d29 == 0.0 ? 0.0f : (float)((d24 - d * d30) / d29);
                        }
                    }
                    break;
                }
                case 8: {
                    double d33 = AbstractDataset.toImag(object);
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                    if (d33 == 0.0) {
                        int n61 = 0;
                        while (indexIterator.hasNext()) {
                            double d34;
                            double d35;
                            double d36 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            double d37 = abstractDataset5.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d36) < Math.abs(d37)) {
                                d35 = d36 / d37;
                                d34 = d36 * d35 + d37;
                                dArray[n61++] = d * d35 / d34;
                                dArray[n61++] = -d / d34;
                                continue;
                            }
                            d35 = d37 / d36;
                            d34 = d37 * d35 + d36;
                            dArray[n61++] = d34 == 0.0 ? 0.0 : d / d34;
                            double d38 = dArray[n61++] = d34 == 0.0 ? 0.0 : -d * d35 / d34;
                        }
                    } else {
                        int n62 = 0;
                        while (indexIterator.hasNext()) {
                            double d39;
                            double d40;
                            double d41 = abstractDataset5.getElementDoubleAbs(indexIterator.index);
                            double d42 = abstractDataset5.getElementDoubleAbs(indexIterator.index + 1);
                            if (Math.abs(d41) < Math.abs(d42)) {
                                d40 = d41 / d42;
                                d39 = d41 * d40 + d42;
                                dArray[n62++] = (d * d40 + d33) / d39;
                                dArray[n62++] = (d33 * d40 - d) / d39;
                                continue;
                            }
                            d40 = d42 / d41;
                            d39 = d42 * d40 + d41;
                            dArray[n62++] = d39 == 0.0 ? 0.0 : (d33 * d40 + d) / d39;
                            double d43 = dArray[n62++] = d39 == 0.0 ? 0.0 : (d33 - d * d40) / d39;
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("dividez does not support this dataset type");
                }
            }
            abstractDataset.setName(object.toString() + '/' + Maths.bracketIfNecessary(abstractDataset5));
        }
        return abstractDataset;
    }

    public static AbstractDataset power(Object object, Object object2) {
        AbstractDataset abstractDataset = null;
        if (object instanceof AbstractDataset) {
            if (object2 instanceof AbstractDataset) {
                return Maths.power((AbstractDataset)object, (AbstractDataset)object2);
            }
            AbstractDataset abstractDataset2 = (AbstractDataset)object;
            int n = AbstractDataset.getBestDType(abstractDataset2.getDtype(), AbstractDataset.getDTypeFromClass(object2.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset2, n);
            IndexIterator indexIterator = abstractDataset2.getIterator();
            double d = AbstractDataset.toReal(object2);
            switch (n) {
                case 1: {
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n2 = 0;
                    while (indexIterator.hasNext()) {
                        byArray[n2++] = (byte)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index), d);
                    }
                    break;
                }
                case 2: {
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n3 = 0;
                    while (indexIterator.hasNext()) {
                        sArray[n3++] = (short)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index), d);
                    }
                    break;
                }
                case 3: {
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n4 = 0;
                    while (indexIterator.hasNext()) {
                        nArray[n4++] = (int)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index), d);
                    }
                    break;
                }
                case 4: {
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n5 = 0;
                    while (indexIterator.hasNext()) {
                        lArray[n5++] = (long)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index), d);
                    }
                    break;
                }
                case 100: {
                    int n6 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n7 = 0;
                    while (indexIterator.hasNext()) {
                        int n8 = 0;
                        while (n8 < n6) {
                            byArray[n7++] = (byte)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index + n8), d);
                            ++n8;
                        }
                    }
                    break;
                }
                case 200: {
                    int n9 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n10 = 0;
                    while (indexIterator.hasNext()) {
                        int n11 = 0;
                        while (n11 < n9) {
                            sArray[n10++] = (short)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index + n11), d);
                            ++n11;
                        }
                    }
                    break;
                }
                case 300: {
                    int n12 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n13 = 0;
                    while (indexIterator.hasNext()) {
                        int n14 = 0;
                        while (n14 < n12) {
                            nArray[n13++] = (int)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index + n14), d);
                            ++n14;
                        }
                    }
                    break;
                }
                case 400: {
                    int n15 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n16 = 0;
                    while (indexIterator.hasNext()) {
                        int n17 = 0;
                        while (n17 < n15) {
                            lArray[n16++] = (long)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index + n17), d);
                            ++n17;
                        }
                    }
                    break;
                }
                case 5: {
                    double d2 = AbstractDataset.toImag(object2);
                    if (d2 == 0.0) {
                        float[] fArray = ((FloatDataset)abstractDataset).getData();
                        int n18 = 0;
                        while (indexIterator.hasNext()) {
                            fArray[n18++] = (float)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index), d);
                        }
                    } else {
                        abstractDataset = new ComplexFloatDataset(abstractDataset2.getShape());
                        float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                        Complex complex = new Complex(d, d2);
                        int n19 = 0;
                        while (indexIterator.hasNext()) {
                            Complex complex2 = new Complex(abstractDataset2.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator.index + 1)).pow(complex);
                            fArray[n19++] = (float)complex2.getReal();
                            fArray[n19++] = (float)complex2.getImaginary();
                        }
                    }
                    break;
                }
                case 6: {
                    double d3 = AbstractDataset.toImag(object2);
                    if (d3 == 0.0) {
                        abstractDataset = new DoubleDataset(abstractDataset2.getShape());
                        double[] dArray = ((DoubleDataset)abstractDataset).getData();
                        int n20 = 0;
                        while (indexIterator.hasNext()) {
                            dArray[n20++] = Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index), d);
                        }
                    } else {
                        abstractDataset = new ComplexDoubleDataset(abstractDataset2.getShape());
                        double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                        Complex complex = new Complex(d, d3);
                        int n21 = 0;
                        while (indexIterator.hasNext()) {
                            Complex complex3 = new Complex(abstractDataset2.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator.index + 1)).pow(complex);
                            dArray[n21++] = complex3.getReal();
                            dArray[n21++] = complex3.getImaginary();
                        }
                    }
                    break;
                }
                case 500: {
                    int n22 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n23 = 0;
                    while (indexIterator.hasNext()) {
                        int n24 = 0;
                        while (n24 < n22) {
                            fArray[n23++] = (float)Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index + n24), d);
                            ++n24;
                        }
                    }
                    break;
                }
                case 600: {
                    int n25 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n26 = 0;
                    while (indexIterator.hasNext()) {
                        int n27 = 0;
                        while (n27 < n25) {
                            dArray[n26++] = Math.pow(abstractDataset2.getElementDoubleAbs(indexIterator.index + n27), d);
                            ++n27;
                        }
                    }
                    break;
                }
                case 7: {
                    double d4 = AbstractDataset.toImag(object2);
                    float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                    Complex complex = new Complex(d, d4);
                    int n28 = 0;
                    while (indexIterator.hasNext()) {
                        Complex complex4 = new Complex(abstractDataset2.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator.index + 1)).pow(complex);
                        fArray[n28++] = (float)complex4.getReal();
                        fArray[n28++] = (float)complex4.getImaginary();
                    }
                    break;
                }
                case 8: {
                    double d5 = AbstractDataset.toImag(object2);
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                    Complex complex = new Complex(d, d5);
                    int n29 = 0;
                    while (indexIterator.hasNext()) {
                        Complex complex5 = new Complex(abstractDataset2.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator.index + 1)).pow(complex);
                        dArray[n29++] = complex5.getReal();
                        dArray[n29++] = complex5.getImaginary();
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("power does not support this dataset type");
                }
            }
            abstractDataset.setName(Maths.bracketIfNecessary(abstractDataset2).append("**").append(object2).toString());
        } else {
            if (!(object2 instanceof AbstractDataset)) {
                throw new IllegalArgumentException("Both arguments are not datasets");
            }
            AbstractDataset abstractDataset3 = (AbstractDataset)object2;
            int n = AbstractDataset.getBestDType(abstractDataset3.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset3, n);
            IndexIterator indexIterator = abstractDataset3.getIterator();
            double d = AbstractDataset.toReal(object);
            switch (n) {
                case 1: {
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n30 = 0;
                    while (indexIterator.hasNext()) {
                        byArray[n30++] = (byte)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index));
                    }
                    break;
                }
                case 2: {
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n31 = 0;
                    while (indexIterator.hasNext()) {
                        sArray[n31++] = (short)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index));
                    }
                    break;
                }
                case 3: {
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n32 = 0;
                    while (indexIterator.hasNext()) {
                        nArray[n32++] = (int)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index));
                    }
                    break;
                }
                case 4: {
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n33 = 0;
                    while (indexIterator.hasNext()) {
                        lArray[n33++] = (long)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index));
                    }
                    break;
                }
                case 100: {
                    int n34 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n35 = 0;
                    while (indexIterator.hasNext()) {
                        int n36 = 0;
                        while (n36 < n34) {
                            byArray[n35++] = (byte)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index + n36));
                            ++n36;
                        }
                    }
                    break;
                }
                case 200: {
                    int n37 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n38 = 0;
                    while (indexIterator.hasNext()) {
                        int n39 = 0;
                        while (n39 < n37) {
                            sArray[n38++] = (short)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index + n39));
                            ++n39;
                        }
                    }
                    break;
                }
                case 300: {
                    int n40 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n41 = 0;
                    while (indexIterator.hasNext()) {
                        int n42 = 0;
                        while (n42 < n40) {
                            nArray[n41++] = (int)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index + n42));
                            ++n42;
                        }
                    }
                    break;
                }
                case 400: {
                    int n43 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n44 = 0;
                    while (indexIterator.hasNext()) {
                        int n45 = 0;
                        while (n45 < n43) {
                            lArray[n44++] = (long)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index + n45));
                            ++n45;
                        }
                    }
                    break;
                }
                case 5: {
                    double d6 = AbstractDataset.toImag(object);
                    if (d6 == 0.0) {
                        float[] fArray = ((FloatDataset)abstractDataset).getData();
                        int n46 = 0;
                        while (indexIterator.hasNext()) {
                            fArray[n46++] = (float)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index));
                        }
                    } else {
                        abstractDataset = new ComplexFloatDataset(abstractDataset3.getShape());
                        float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                        Complex complex = new Complex(d, d6);
                        int n47 = 0;
                        while (indexIterator.hasNext()) {
                            Complex complex6 = complex.pow(new Complex(abstractDataset3.getElementDoubleAbs(indexIterator.index), abstractDataset3.getElementDoubleAbs(indexIterator.index + 1)));
                            fArray[n47++] = (float)complex6.getReal();
                            fArray[n47++] = (float)complex6.getImaginary();
                        }
                    }
                    break;
                }
                case 6: {
                    double d7 = AbstractDataset.toImag(object);
                    if (d7 == 0.0) {
                        double[] dArray = ((DoubleDataset)abstractDataset).getData();
                        int n48 = 0;
                        while (indexIterator.hasNext()) {
                            dArray[n48++] = Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index));
                        }
                    } else {
                        abstractDataset = new ComplexDoubleDataset(abstractDataset3.getShape());
                        double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                        Complex complex = new Complex(d, d7);
                        int n49 = 0;
                        while (indexIterator.hasNext()) {
                            Complex complex7 = complex.pow(new Complex(abstractDataset3.getElementDoubleAbs(indexIterator.index), abstractDataset3.getElementDoubleAbs(indexIterator.index + 1)));
                            dArray[n49++] = complex7.getReal();
                            dArray[n49++] = complex7.getImaginary();
                        }
                    }
                    break;
                }
                case 500: {
                    int n50 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n51 = 0;
                    while (indexIterator.hasNext()) {
                        int n52 = 0;
                        while (n52 < n50) {
                            fArray[n51++] = (float)Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index + n52));
                            ++n52;
                        }
                    }
                    break;
                }
                case 600: {
                    int n53 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n54 = 0;
                    while (indexIterator.hasNext()) {
                        int n55 = 0;
                        while (n55 < n53) {
                            dArray[n54++] = Math.pow(d, abstractDataset3.getElementDoubleAbs(indexIterator.index + n55));
                            ++n55;
                        }
                    }
                    break;
                }
                case 7: {
                    double d8 = AbstractDataset.toImag(object);
                    float[] fArray = ((ComplexFloatDataset)abstractDataset).getData();
                    Complex complex = new Complex(d, d8);
                    int n56 = 0;
                    while (indexIterator.hasNext()) {
                        Complex complex8 = complex.pow(new Complex(abstractDataset3.getElementDoubleAbs(indexIterator.index), abstractDataset3.getElementDoubleAbs(indexIterator.index + 1)));
                        fArray[n56++] = (float)complex8.getReal();
                        fArray[n56++] = (float)complex8.getImaginary();
                    }
                    break;
                }
                case 8: {
                    double d9 = AbstractDataset.toImag(object);
                    double[] dArray = ((ComplexDoubleDataset)abstractDataset).getData();
                    Complex complex = new Complex(d, d9);
                    int n57 = 0;
                    while (indexIterator.hasNext()) {
                        Complex complex9 = complex.pow(new Complex(abstractDataset3.getElementDoubleAbs(indexIterator.index), abstractDataset3.getElementDoubleAbs(indexIterator.index + 1)));
                        dArray[n57++] = complex9.getReal();
                        dArray[n57++] = complex9.getImaginary();
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("power does not support this dataset type");
                }
            }
            abstractDataset.setName(object.toString() + "**" + Maths.bracketIfNecessary(abstractDataset3));
        }
        return abstractDataset;
    }

    public static AbstractDataset remainder(Object object, Object object2) {
        AbstractDataset abstractDataset = null;
        if (object instanceof AbstractDataset) {
            if (object2 instanceof AbstractDataset) {
                return Maths.remainder((AbstractDataset)object, (AbstractDataset)object2);
            }
            AbstractDataset abstractDataset2 = (AbstractDataset)object;
            int n = AbstractDataset.getBestDType(abstractDataset2.getDtype(), AbstractDataset.getDTypeFromClass(object2.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset2, n);
            IndexIterator indexIterator = abstractDataset2.getIterator();
            switch (n) {
                case 1: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n2 = 0;
                    while (indexIterator.hasNext()) {
                        byArray[n2++] = (byte)(abstractDataset2.getElementLongAbs(indexIterator.index) % l);
                    }
                    break;
                }
                case 2: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n3 = 0;
                    while (indexIterator.hasNext()) {
                        sArray[n3++] = (short)(abstractDataset2.getElementLongAbs(indexIterator.index) % l);
                    }
                    break;
                }
                case 3: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n4 = 0;
                    while (indexIterator.hasNext()) {
                        nArray[n4++] = (int)(abstractDataset2.getElementLongAbs(indexIterator.index) % l);
                    }
                    break;
                }
                case 4: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n5 = 0;
                    while (indexIterator.hasNext()) {
                        lArray[n5++] = abstractDataset2.getElementLongAbs(indexIterator.index) % l;
                    }
                    break;
                }
                case 100: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n6 = abstractDataset.getElementsPerItem();
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n7 = 0;
                    while (indexIterator.hasNext()) {
                        int n8 = 0;
                        while (n8 < n6) {
                            byArray[n7++] = (byte)(abstractDataset2.getElementLongAbs(indexIterator.index + n8) % l);
                            ++n8;
                        }
                    }
                    break;
                }
                case 200: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n9 = abstractDataset.getElementsPerItem();
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n10 = 0;
                    while (indexIterator.hasNext()) {
                        int n11 = 0;
                        while (n11 < n9) {
                            sArray[n10++] = (short)(abstractDataset2.getElementLongAbs(indexIterator.index + n11) % l);
                            ++n11;
                        }
                    }
                    break;
                }
                case 300: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n12 = abstractDataset.getElementsPerItem();
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n13 = 0;
                    while (indexIterator.hasNext()) {
                        int n14 = 0;
                        while (n14 < n12) {
                            nArray[n13++] = (int)(abstractDataset2.getElementLongAbs(indexIterator.index + n14) % l);
                            ++n14;
                        }
                    }
                    break;
                }
                case 400: {
                    long l = AbstractDataset.toLong(object2);
                    if (l == 0L) break;
                    int n15 = abstractDataset.getElementsPerItem();
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n16 = 0;
                    while (indexIterator.hasNext()) {
                        int n17 = 0;
                        while (n17 < n15) {
                            lArray[n16++] = abstractDataset2.getElementLongAbs(indexIterator.index + n17) % l;
                            ++n17;
                        }
                    }
                    break;
                }
                case 5: {
                    double d = AbstractDataset.toReal(object2);
                    double d2 = AbstractDataset.toImag(object2);
                    if (d2 != 0.0) {
                        throw new IllegalArgumentException("remainder supports integer or real divisors only");
                    }
                    float[] fArray = ((FloatDataset)abstractDataset).getData();
                    int n18 = 0;
                    while (indexIterator.hasNext()) {
                        fArray[n18++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index) % d);
                    }
                    break;
                }
                case 6: {
                    double d = AbstractDataset.toReal(object2);
                    double d3 = AbstractDataset.toImag(object2);
                    if (d3 != 0.0) {
                        throw new IllegalArgumentException("remainder supports integer or real divisors only");
                    }
                    double[] dArray = ((DoubleDataset)abstractDataset).getData();
                    int n19 = 0;
                    while (indexIterator.hasNext()) {
                        dArray[n19++] = abstractDataset2.getElementDoubleAbs(indexIterator.index) % d;
                    }
                    break;
                }
                case 500: {
                    double d = AbstractDataset.toReal(object2);
                    int n20 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n21 = 0;
                    while (indexIterator.hasNext()) {
                        int n22 = 0;
                        while (n22 < n20) {
                            fArray[n21++] = (float)(abstractDataset2.getElementDoubleAbs(indexIterator.index + n22) % d);
                            ++n22;
                        }
                    }
                    break;
                }
                case 600: {
                    double d = AbstractDataset.toReal(object2);
                    int n23 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n24 = 0;
                    while (indexIterator.hasNext()) {
                        int n25 = 0;
                        while (n25 < n23) {
                            dArray[n24++] = abstractDataset2.getElementDoubleAbs(indexIterator.index + n25) % d;
                            ++n25;
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("remainder does not support this dataset type");
                }
            }
            abstractDataset.setName(Maths.bracketIfNecessary(abstractDataset2).append('%').append(object2).toString());
        } else {
            if (!(object2 instanceof AbstractDataset)) {
                throw new IllegalArgumentException("Both arguments are not datasets");
            }
            AbstractDataset abstractDataset3 = (AbstractDataset)object2;
            int n = AbstractDataset.getBestDType(abstractDataset3.getDtype(), AbstractDataset.getDTypeFromClass(object.getClass()));
            abstractDataset = AbstractDataset.zeros(abstractDataset3, n);
            IndexIterator indexIterator = abstractDataset3.getIterator();
            switch (n) {
                case 1: {
                    long l = AbstractDataset.toLong(object);
                    byte[] byArray = ((ByteDataset)abstractDataset).getData();
                    int n26 = 0;
                    while (indexIterator.hasNext()) {
                        byArray[n26++] = (byte)(l % abstractDataset3.getElementLongAbs(indexIterator.index));
                    }
                    break;
                }
                case 2: {
                    long l = AbstractDataset.toLong(object);
                    short[] sArray = ((ShortDataset)abstractDataset).getData();
                    int n27 = 0;
                    while (indexIterator.hasNext()) {
                        sArray[n27++] = (short)(l % abstractDataset3.getElementLongAbs(indexIterator.index));
                    }
                    break;
                }
                case 3: {
                    long l = AbstractDataset.toLong(object);
                    int[] nArray = ((IntegerDataset)abstractDataset).getData();
                    int n28 = 0;
                    while (indexIterator.hasNext()) {
                        nArray[n28++] = (int)(l % abstractDataset3.getElementLongAbs(indexIterator.index));
                    }
                    break;
                }
                case 4: {
                    long l = AbstractDataset.toLong(object);
                    long[] lArray = ((LongDataset)abstractDataset).getData();
                    int n29 = 0;
                    while (indexIterator.hasNext()) {
                        lArray[n29++] = l % abstractDataset3.getElementLongAbs(indexIterator.index);
                    }
                    break;
                }
                case 100: {
                    int n30 = abstractDataset.getElementsPerItem();
                    long l = AbstractDataset.toLong(object);
                    byte[] byArray = ((CompoundByteDataset)abstractDataset).getData();
                    int n31 = 0;
                    while (indexIterator.hasNext()) {
                        int n32 = 0;
                        while (n32 < n30) {
                            byArray[n31++] = (byte)(l % abstractDataset3.getElementLongAbs(indexIterator.index + n32));
                            ++n32;
                        }
                    }
                    break;
                }
                case 200: {
                    int n33 = abstractDataset.getElementsPerItem();
                    long l = AbstractDataset.toLong(object);
                    short[] sArray = ((CompoundShortDataset)abstractDataset).getData();
                    int n34 = 0;
                    while (indexIterator.hasNext()) {
                        int n35 = 0;
                        while (n35 < n33) {
                            sArray[n34++] = (short)(l % abstractDataset3.getElementLongAbs(indexIterator.index + n35));
                            ++n35;
                        }
                    }
                    break;
                }
                case 300: {
                    int n36 = abstractDataset.getElementsPerItem();
                    long l = AbstractDataset.toLong(object);
                    int[] nArray = ((CompoundIntegerDataset)abstractDataset).getData();
                    int n37 = 0;
                    while (indexIterator.hasNext()) {
                        int n38 = 0;
                        while (n38 < n36) {
                            nArray[n37++] = (int)(l % abstractDataset3.getElementLongAbs(indexIterator.index + n38));
                            ++n38;
                        }
                    }
                    break;
                }
                case 400: {
                    int n39 = abstractDataset.getElementsPerItem();
                    long l = AbstractDataset.toLong(object);
                    long[] lArray = ((CompoundLongDataset)abstractDataset).getData();
                    int n40 = 0;
                    while (indexIterator.hasNext()) {
                        int n41 = 0;
                        while (n41 < n39) {
                            lArray[n40++] = l % abstractDataset3.getElementLongAbs(indexIterator.index + n41);
                            ++n41;
                        }
                    }
                    break;
                }
                case 5: {
                    double d = AbstractDataset.toReal(object);
                    double d4 = AbstractDataset.toImag(object);
                    if (d4 != 0.0) {
                        throw new IllegalArgumentException("remainder supports integer or real numerators only");
                    }
                    float[] fArray = ((FloatDataset)abstractDataset).getData();
                    int n42 = 0;
                    while (indexIterator.hasNext()) {
                        fArray[n42++] = (float)(d % abstractDataset3.getElementDoubleAbs(indexIterator.index));
                    }
                    break;
                }
                case 6: {
                    double d = AbstractDataset.toReal(object);
                    double d5 = AbstractDataset.toImag(object);
                    if (d5 != 0.0) {
                        throw new IllegalArgumentException("remainder supports integer or real numerators only");
                    }
                    double[] dArray = ((DoubleDataset)abstractDataset).getData();
                    int n43 = 0;
                    while (indexIterator.hasNext()) {
                        dArray[n43++] = d % abstractDataset3.getElementDoubleAbs(indexIterator.index);
                    }
                    break;
                }
                case 500: {
                    double d = AbstractDataset.toReal(object);
                    int n44 = abstractDataset.getElementsPerItem();
                    float[] fArray = ((CompoundFloatDataset)abstractDataset).getData();
                    int n45 = 0;
                    while (indexIterator.hasNext()) {
                        int n46 = 0;
                        while (n46 < n44) {
                            fArray[n45++] = (float)(d % abstractDataset3.getElementDoubleAbs(indexIterator.index + n46));
                            ++n46;
                        }
                    }
                    break;
                }
                case 600: {
                    double d = AbstractDataset.toReal(object);
                    int n47 = abstractDataset.getElementsPerItem();
                    double[] dArray = ((CompoundDoubleDataset)abstractDataset).getData();
                    int n48 = 0;
                    while (indexIterator.hasNext()) {
                        int n49 = 0;
                        while (n49 < n47) {
                            dArray[n48++] = d % abstractDataset3.getElementDoubleAbs(indexIterator.index + n49);
                            ++n49;
                        }
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("remainder does not support this dataset type");
                }
            }
            abstractDataset.setName(object.toString() + '%' + Maths.bracketIfNecessary(abstractDataset3));
        }
        return abstractDataset;
    }

    public static AbstractDataset floorDivide(Object object, Object object2) {
        return Maths.divide(object, object2).ifloor();
    }

    public static AbstractDataset reciprocal(AbstractDataset abstractDataset) {
        return Maths.divide(1, (Object)abstractDataset);
    }

    public static AbstractDataset conjugate(AbstractDataset abstractDataset) {
        int n = abstractDataset.getDtype();
        IndexIterator indexIterator = abstractDataset.getIterator();
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(abstractDataset);
        switch (n) {
            case 7: {
                float[] fArray = ((ComplexFloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    fArray[n2++] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
                    fArray[n2++] = (float)(-abstractDataset.getElementDoubleAbs(indexIterator.index + 1));
                }
                abstractDataset2.setName(Maths.bracketIfNecessary(abstractDataset).append("^*").toString());
                break;
            }
            case 8: {
                double[] dArray = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    dArray[n3++] = abstractDataset.getElementDoubleAbs(indexIterator.index);
                    dArray[n3++] = -abstractDataset.getElementDoubleAbs(indexIterator.index + 1);
                }
                abstractDataset2.setName(Maths.bracketIfNecessary(abstractDataset).append("^*").toString());
                break;
            }
            default: {
                abstractDataset2 = abstractDataset;
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset hypot(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        int n = Math.max(abstractDataset.getElementsPerItem(), abstractDataset2.getElementsPerItem());
        if (n > 1) {
            throw new UnsupportedOperationException("hypot does not support multiple-element dataset");
        }
        int n2 = AbstractDataset.getBestDType(abstractDataset.getDtype(), abstractDataset2.getDtype());
        AbstractDataset abstractDataset3 = abstractDataset.clone().cast(n2);
        IndexIterator indexIterator = abstractDataset.getIterator();
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        switch (n2) {
            case 0: {
                boolean[] blArray = ((BooleanDataset)abstractDataset3).getData();
                int n3 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    boolean bl = blArray[n3++] = Math.hypot(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index)) != 0.0;
                }
                break;
            }
            case 1: {
                byte[] byArray = ((ByteDataset)abstractDataset3).getData();
                int n4 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    byArray[n4++] = (byte)Math.hypot(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 2: {
                short[] sArray = ((ShortDataset)abstractDataset3).getData();
                int n5 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    sArray[n5++] = (short)Math.hypot(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 3: {
                int[] nArray = ((IntegerDataset)abstractDataset3).getData();
                int n6 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    nArray[n6++] = (int)Math.hypot(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 4: {
                long[] lArray = ((LongDataset)abstractDataset3).getData();
                int n7 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    lArray[n7++] = (long)Math.hypot(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 5: {
                float[] fArray = ((FloatDataset)abstractDataset3).getData();
                int n8 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    fArray[n8++] = (float)Math.hypot(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 6: {
                double[] dArray = ((DoubleDataset)abstractDataset3).getData();
                int n9 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    dArray[n9++] = Math.hypot(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("hypot does not support multiple-element dataset");
            }
        }
        abstractDataset3.setName("hypot(" + abstractDataset.getName() + ", " + abstractDataset2.getName() + ")");
        return abstractDataset3;
    }

    public static AbstractDataset arctan2(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        abstractDataset.checkCompatibility(abstractDataset2);
        int n = Math.max(abstractDataset.getElementsPerItem(), abstractDataset2.getElementsPerItem());
        if (n > 1) {
            throw new UnsupportedOperationException("hypot does not support multiple-element dataset");
        }
        int n2 = AbstractDataset.getBestDType(abstractDataset.getDtype(), abstractDataset2.getDtype());
        AbstractDataset abstractDataset3 = abstractDataset.clone().cast(n2);
        IndexIterator indexIterator = abstractDataset.getIterator();
        IndexIterator indexIterator2 = abstractDataset2.getIterator();
        switch (n2) {
            case 0: {
                boolean[] blArray = ((BooleanDataset)abstractDataset3).getData();
                int n3 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    boolean bl = blArray[n3++] = Math.atan2(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index)) != 0.0;
                }
                break;
            }
            case 1: {
                byte[] byArray = ((ByteDataset)abstractDataset3).getData();
                int n4 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    byArray[n4++] = (byte)Math.atan2(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 2: {
                short[] sArray = ((ShortDataset)abstractDataset3).getData();
                int n5 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    sArray[n5++] = (short)Math.atan2(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 3: {
                int[] nArray = ((IntegerDataset)abstractDataset3).getData();
                int n6 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    nArray[n6++] = (int)Math.atan2(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 4: {
                long[] lArray = ((LongDataset)abstractDataset3).getData();
                int n7 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    lArray[n7++] = (long)Math.atan2(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 5: {
                float[] fArray = ((FloatDataset)abstractDataset3).getData();
                int n8 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    fArray[n8++] = (float)Math.atan2(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            case 6: {
                double[] dArray = ((DoubleDataset)abstractDataset3).getData();
                int n9 = 0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    dArray[n9++] = Math.atan2(abstractDataset.getElementDoubleAbs(indexIterator.index), abstractDataset2.getElementDoubleAbs(indexIterator2.index));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("atan2 does not support multiple-element dataset");
            }
        }
        abstractDataset3.setName("atan2(" + abstractDataset.getName() + ", " + abstractDataset2.getName() + ")");
        return abstractDataset3;
    }

    public static double getLinear(AbstractDataset abstractDataset, double d) {
        int[] nArray = abstractDataset.getShape();
        if (nArray.length != 1) {
            throw new IllegalArgumentException("Only 1d datasets allowed");
        }
        double d2 = 0.0;
        int n = (int)Math.floor(d);
        double d3 = d - (double)n;
        if (n < 0 || n >= nArray[0]) {
            return d2;
        }
        double d4 = abstractDataset.getElementDoubleAbs(n);
        if (d3 > 0.0) {
            if (n == nArray[0] - 1) {
                return d2;
            }
            double d5 = abstractDataset.getElementDoubleAbs(n + 1);
            d2 = (1.0 - d3) * d4 + d3 * d5;
        } else {
            d2 = d4;
        }
        return d2;
    }

    public static void getLinear(double[] dArray, AbstractCompoundDataset abstractCompoundDataset, double d) {
        int[] nArray = abstractCompoundDataset.getShape();
        if (nArray.length != 1) {
            throw new IllegalArgumentException("Only 1d datasets allowed");
        }
        int n = abstractCompoundDataset.isize;
        if (n != dArray.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int n2 = (int)Math.floor(d);
        double d2 = d - (double)n2;
        if (n2 < 0 || n2 >= nArray[0]) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        if (d2 > 0.0) {
            if (n2 == nArray[0] - 1) {
                Arrays.fill(dArray, 0.0);
                return;
            }
            double[] dArray2 = new double[n];
            abstractCompoundDataset.getDoubleArray(dArray2, n2);
            double[] dArray3 = new double[n];
            abstractCompoundDataset.getDoubleArray(dArray3, n2 + 1);
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = (1.0 - d2) * dArray2[n3] + d2 * dArray3[n3];
                ++n3;
            }
        } else {
            abstractCompoundDataset.getDoubleArray(dArray, n2);
        }
    }

    public static double getBilinear(IDataset iDataset, double d, double d2) {
        return Maths.getBilinear(iDataset, null, d, d2);
    }

    public static double getBilinear(IDataset iDataset, IDataset iDataset2, double d, double d2) {
        double d3;
        int[] nArray = iDataset.getShape();
        if (nArray.length != 2) {
            throw new IllegalArgumentException("Only 2d datasets allowed");
        }
        double d4 = 0.0;
        int n = (int)Math.floor(d);
        int n2 = (int)Math.floor(d2);
        double d5 = d - (double)n;
        double d6 = d2 - (double)n2;
        if (n < -1 || n >= nArray[0] || n2 < -1 || n2 >= nArray[1]) {
            return d4;
        }
        double d7 = n < 0 || n2 < 0 ? 0.0 : (d3 = iDataset.getDouble(n, n2) * (iDataset2 == null ? 1.0 : iDataset2.getDouble(n, n2)));
        if (d6 > 0.0) {
            if (n2 == nArray[1] - 1) {
                return d3;
            }
            if (d5 > 0.0) {
                if (n == nArray[0] - 1) {
                    return d3;
                }
                double d8 = n < 0 ? 0.0 : iDataset.getDouble(n, n2 + 1) * (iDataset2 == null ? 1.0 : iDataset2.getDouble(n, n2 + 1));
                double d9 = iDataset.getDouble(n + 1, n2 + 1) * (iDataset2 == null ? 1.0 : iDataset2.getDouble(n + 1, n2 + 1));
                double d10 = n2 < 0 ? 0.0 : iDataset.getDouble(n + 1, n2) * (iDataset2 == null ? 1.0 : iDataset2.getDouble(n + 1, n2));
                d4 = (1.0 - d6) * (1.0 - d5) * d3 + d6 * (1.0 - d5) * d8 + d6 * d5 * d9 + (1.0 - d6) * d5 * d10;
            } else {
                double d11 = n < 0 ? 0.0 : iDataset.getDouble(n, n2 + 1) * (iDataset2 == null ? 1.0 : iDataset2.getDouble(n, n2 + 1));
                d4 = (1.0 - d6) * d3 + d6 * d11;
            }
        } else if (d5 > 0.0) {
            if (n == nArray[0] - 1) {
                return d3;
            }
            double d12 = n2 < 0 ? 0.0 : iDataset.getDouble(n + 1, n2) * (iDataset2 == null ? 1.0 : iDataset2.getDouble(n + 1, n2));
            d4 = (1.0 - d5) * d3 + d5 * d12;
        } else {
            d4 = d3;
        }
        return d4;
    }

    public static void getBilinear(double[] dArray, AbstractCompoundDataset abstractCompoundDataset, double d, double d2) {
        int[] nArray = abstractCompoundDataset.getShape();
        if (nArray.length != 2) {
            throw new IllegalArgumentException("Only 2d datasets allowed");
        }
        int n = abstractCompoundDataset.isize;
        if (n != dArray.length) {
            throw new IllegalArgumentException("Output array length must match elements in item");
        }
        int n2 = (int)Math.floor(d);
        int n3 = (int)Math.floor(d2);
        double d3 = d - (double)n2;
        double d4 = d2 - (double)n3;
        if (n2 < -1 || n2 >= nArray[0] || n3 < -1 || n3 >= nArray[1]) {
            Arrays.fill(dArray, 0.0);
            return;
        }
        double[] dArray2 = new double[n];
        if (n2 >= 0 && n3 >= 0) {
            abstractCompoundDataset.getDoubleArray(dArray2, n2, n3);
        }
        if (d4 > 0.0) {
            if (n3 == nArray[1] - 1) {
                Arrays.fill(dArray, 0.0);
                return;
            }
            if (d3 > 0.0) {
                if (n2 == nArray[0] - 1) {
                    Arrays.fill(dArray, 0.0);
                    return;
                }
                double[] dArray3 = new double[n];
                double[] dArray4 = new double[n];
                double[] dArray5 = new double[n];
                if (n2 >= 0) {
                    abstractCompoundDataset.getDoubleArray(dArray3, n2, n3 + 1);
                }
                abstractCompoundDataset.getDoubleArray(dArray4, n2 + 1, n3 + 1);
                if (n3 >= 0) {
                    abstractCompoundDataset.getDoubleArray(dArray5, n2 + 1, n3);
                }
                int n4 = 0;
                while (n4 < n) {
                    dArray[n4] = (1.0 - d4) * (1.0 - d3) * dArray2[n4] + d4 * (1.0 - d3) * dArray3[n4] + d4 * d3 * dArray4[n4] + (1.0 - d4) * d3 * dArray5[n4];
                    ++n4;
                }
            } else {
                double[] dArray6 = new double[n];
                if (n2 >= 0) {
                    abstractCompoundDataset.getDoubleArray(dArray6, n2, n3 + 1);
                }
                int n5 = 0;
                while (n5 < n) {
                    dArray[n5] = (1.0 - d4) * dArray2[n5] + d4 * dArray6[n5];
                    ++n5;
                }
            }
        } else if (d3 > 0.0) {
            if (n2 == nArray[0] - 1) {
                Arrays.fill(dArray, 0.0);
                return;
            }
            double[] dArray7 = new double[n];
            if (n3 >= 0) {
                abstractCompoundDataset.getDoubleArray(dArray7, n2 + 1, n3);
            }
            int n6 = 0;
            while (n6 < n) {
                dArray[n6] = (1.0 - d3) * dArray2[n6] + d3 * dArray7[n6];
                ++n6;
            }
        } else {
            abstractCompoundDataset.getDoubleArray(dArray, n2, n3);
        }
    }

    public static AbstractDataset angle(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2 = null;
        int n = abstractDataset.getDtype();
        IndexIterator indexIterator = abstractDataset.getIterator();
        switch (n) {
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                float[] fArray2 = ((ComplexFloatDataset)abstractDataset).data;
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    fArray[n2++] = (float)Math.atan2(fArray2[indexIterator.index + 1], fArray2[indexIterator.index]);
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                double[] dArray2 = ((ComplexDoubleDataset)abstractDataset).data;
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    dArray[n3++] = Math.atan2(dArray2[indexIterator.index + 1], dArray2[indexIterator.index]);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("angle does not support this dataset type");
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset phaseAsComplexNumber(AbstractDataset abstractDataset, boolean bl) {
        AbstractDataset abstractDataset2 = null;
        int n = abstractDataset.getDtype();
        IndexIterator indexIterator = abstractDataset.getIterator();
        switch (n) {
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                float[] fArray = ((ComplexFloatDataset)abstractDataset2).getData();
                float[] fArray2 = ((ComplexFloatDataset)abstractDataset).data;
                if (bl) {
                    int n2 = 0;
                    while (indexIterator.hasNext()) {
                        double d = fArray2[indexIterator.index];
                        double d2 = fArray2[indexIterator.index + 1];
                        double d3 = Math.hypot(d, d2);
                        if (d3 == 0.0) {
                            fArray[n2++] = 0.0f;
                            fArray[n2++] = 0.0f;
                            continue;
                        }
                        fArray[n2++] = (float)(d / d3);
                        fArray[n2++] = (float)(d2 / d3);
                    }
                } else {
                    int n3 = 0;
                    while (indexIterator.hasNext()) {
                        double d = fArray2[indexIterator.index];
                        double d4 = fArray2[indexIterator.index + 1];
                        double d5 = Math.hypot(d, d4);
                        fArray[n3++] = (float)(d / d5);
                        fArray[n3++] = (float)(d4 / d5);
                    }
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset2).getData();
                double[] dArray2 = ((ComplexDoubleDataset)abstractDataset).data;
                if (bl) {
                    int n4 = 0;
                    while (indexIterator.hasNext()) {
                        double d = dArray2[indexIterator.index];
                        double d6 = dArray2[indexIterator.index + 1];
                        double d7 = Math.hypot(d, d6);
                        if (d7 == 0.0) {
                            dArray[n4++] = 0.0;
                            dArray[n4++] = 0.0;
                            continue;
                        }
                        dArray[n4++] = d / d7;
                        dArray[n4++] = d6 / d7;
                    }
                } else {
                    int n5 = 0;
                    while (indexIterator.hasNext()) {
                        double d = dArray2[indexIterator.index];
                        double d8 = dArray2[indexIterator.index + 1];
                        double d9 = Math.hypot(d, d8);
                        dArray[n5++] = d / d9;
                        dArray[n5++] = d8 / d9;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Dataset is not of complex type");
            }
        }
        return abstractDataset2;
    }

    private static int[] bincoeff(int n) {
        int n2;
        int[] nArray = new int[n + 1];
        int n3 = n / 2;
        nArray[0] = n2 = 1;
        int n4 = 1;
        while (n4 <= n3) {
            nArray[n4] = n2 = -(n2 * (n - n4 + 1)) / n4;
            ++n4;
        }
        if (n % 2 == 1) {
            n4 = n3 + 1;
            while (n4 <= n) {
                nArray[n4] = -nArray[n - n4];
                ++n4;
            }
        } else {
            n4 = n3 + 1;
            while (n4 <= n) {
                nArray[n4] = nArray[n - n4];
                ++n4;
            }
        }
        return nArray;
    }

    private static void difference(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        int n = abstractDataset.getDtype();
        int n2 = abstractDataset2.shape[0];
        switch (n) {
            case 1: {
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n3 = 0;
                while (n3 < n2) {
                    byArray2[n3] = (byte)(byArray[n3 + 1] - byArray[n3]);
                    ++n3;
                }
                break;
            }
            case 2: {
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n4 = 0;
                while (n4 < n2) {
                    sArray2[n4] = (short)(sArray[n4 + 1] - sArray[n4]);
                    ++n4;
                }
                break;
            }
            case 3: {
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (n5 < n2) {
                    nArray2[n5] = nArray[n5 + 1] - nArray[n5];
                    ++n5;
                }
                break;
            }
            case 4: {
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n6 = 0;
                while (n6 < n2) {
                    lArray2[n6] = lArray[n6 + 1] - lArray[n6];
                    ++n6;
                }
                break;
            }
            case 200: {
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                int n7 = abstractDataset.getElementsPerItem();
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n8 = 0;
                int n9 = n7;
                while (n8 < n2) {
                    sArray3[n8] = (short)(sArray[n9] - sArray[n8]);
                    ++n8;
                    ++n9;
                }
                break;
            }
            case 300: {
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int n10 = abstractDataset.getElementsPerItem();
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n11 = 0;
                int n12 = n10;
                while (n11 < n2) {
                    nArray3[n11] = nArray[n12] - nArray[n11];
                    ++n11;
                    ++n12;
                }
                break;
            }
            case 400: {
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                int n13 = abstractDataset.getElementsPerItem();
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n14 = 0;
                int n15 = n13;
                while (n14 < n2) {
                    lArray3[n14] = lArray[n15] - lArray[n14];
                    ++n14;
                    ++n15;
                }
                break;
            }
            case 5: {
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n16 = 0;
                while (n16 < n2) {
                    fArray2[n16] = fArray[n16 + 1] - fArray[n16];
                    ++n16;
                }
                break;
            }
            case 6: {
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n17 = 0;
                while (n17 < n2) {
                    dArray2[n17] = dArray[n17 + 1] - dArray[n17];
                    ++n17;
                }
                break;
            }
            case 7: {
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray3 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n18 = 0;
                while (n18 < n2) {
                    fArray3[n18] = fArray[n18 + 2] - fArray[n18];
                    ++n18;
                }
                break;
            }
            case 8: {
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n19 = 0;
                while (n19 < n2) {
                    dArray3[n19] = dArray[n19 + 2] - dArray[n19];
                    ++n19;
                }
                break;
            }
            case 500: {
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                int n20 = abstractDataset.getElementsPerItem();
                float[] fArray4 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n21 = 0;
                int n22 = n20;
                while (n21 < n2) {
                    fArray4[n21] = fArray[n22] - fArray[n21];
                    ++n21;
                    ++n22;
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                int n23 = abstractDataset.getElementsPerItem();
                double[] dArray4 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n24 = 0;
                int n25 = n23;
                while (n24 < n2) {
                    dArray4[n24] = dArray[n25] - dArray[n24];
                    ++n24;
                    ++n25;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support this dataset type");
            }
        }
    }

    private static void difference(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int n) {
        if (n == 1) {
            Maths.difference(abstractDataset, abstractDataset2);
            return;
        }
        int n2 = abstractDataset.getDtype();
        int n3 = abstractDataset2.shape[0];
        int[] nArray = Maths.bincoeff(n);
        int n4 = n + 1;
        switch (n2) {
            case 1: {
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = n5;
                    while (n7 < n4) {
                        n6 += byArray[n8] * nArray[n7];
                        ++n7;
                        ++n8;
                    }
                    byArray2[n5++] = (byte)n6;
                }
                break;
            }
            case 2: {
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n9 = 0;
                while (n9 < n3) {
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = n9;
                    while (n11 < n4) {
                        n10 += sArray[n12] * nArray[n11];
                        ++n11;
                        ++n12;
                    }
                    sArray2[n9++] = (short)n10;
                }
                break;
            }
            case 3: {
                int[] nArray2 = ((IntegerDataset)abstractDataset).data;
                int[] nArray3 = ((IntegerDataset)abstractDataset2).getData();
                int n13 = 0;
                while (n13 < n3) {
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = n13;
                    while (n15 < n4) {
                        n14 += nArray2[n16] * nArray[n15];
                        ++n15;
                        ++n16;
                    }
                    nArray3[n13++] = n14;
                }
                break;
            }
            case 4: {
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n17 = 0;
                while (n17 < n3) {
                    long l = 0L;
                    int n18 = 0;
                    int n19 = n17;
                    while (n18 < n4) {
                        l += lArray[n19] * (long)nArray[n18];
                        ++n18;
                        ++n19;
                    }
                    lArray2[n17++] = l;
                }
                break;
            }
            case 5: {
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (n20 < n3) {
                    float f = 0.0f;
                    int n21 = 0;
                    int n22 = n20;
                    while (n21 < n4) {
                        f += fArray[n22] * (float)nArray[n21];
                        ++n21;
                        ++n22;
                    }
                    fArray2[n20++] = f;
                }
                break;
            }
            case 6: {
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (n23 < n3) {
                    double d = 0.0;
                    int n24 = 0;
                    int n25 = n23;
                    while (n24 < n4) {
                        d += dArray[n25] * (double)nArray[n24];
                        ++n24;
                        ++n25;
                    }
                    dArray2[n23++] = d;
                }
                break;
            }
            case 7: {
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray3 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n26 = 0;
                while (n26 < n3) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    int n27 = 0;
                    int n28 = n26;
                    while (n27 < n4) {
                        f += fArray[n28] * (float)nArray[n27];
                        f2 += fArray[n28 + 1] * (float)nArray[n27];
                        ++n27;
                        n28 += 2;
                    }
                    fArray3[n26++] = f;
                    fArray3[n26++] = f2;
                }
                break;
            }
            case 8: {
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (n29 < n3) {
                    double d = 0.0;
                    double d2 = 0.0;
                    int n30 = 0;
                    int n31 = n29;
                    while (n30 < n4) {
                        d += dArray[n31] * (double)nArray[n30];
                        d2 += dArray[n31 + 1] * (double)nArray[n30];
                        ++n30;
                        n31 += 2;
                    }
                    dArray3[n29++] = d;
                    dArray3[n29++] = d2;
                }
                break;
            }
            case 500: {
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                int n32 = abstractDataset.getElementsPerItem();
                float[] fArray4 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n33 = 0;
                while (n33 < n3) {
                    int n34 = 0;
                    while (n34 < n32) {
                        float f = 0.0f;
                        int n35 = 0;
                        int n36 = n33 + n34;
                        while (n35 < n4) {
                            f += fArray[n36] * (float)nArray[n35];
                            ++n35;
                            n36 += n32;
                        }
                        fArray4[n33++] = f;
                        ++n34;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset);
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                int n37 = abstractDataset.getElementsPerItem();
                double[] dArray4 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n38 = 0;
                while (n38 < n3) {
                    int n39 = 0;
                    while (n39 < n37) {
                        double d = 0.0;
                        int n40 = 0;
                        int n41 = n38 + n39;
                        while (n40 < n4) {
                            d += dArray[n41] * (double)nArray[n40];
                            ++n40;
                            n41 += n37;
                        }
                        dArray4[n38++] = d;
                        ++n39;
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("difference does not support multiple-element dataset");
            }
        }
    }

    public static AbstractDataset difference(AbstractDataset abstractDataset, int n, int n2) {
        int n3 = abstractDataset.getDtype();
        int n4 = abstractDataset.getRank();
        int n5 = abstractDataset.getElementsPerItem();
        if (n2 < 0) {
            n2 += n4;
        }
        if (n2 < 0 || n2 >= n4) {
            throw new IllegalArgumentException("Axis is out of range");
        }
        int[] nArray = (int[])abstractDataset.shape.clone();
        if (nArray[n2] < n) {
            nArray[n2] = 0;
            return AbstractDataset.zeros(n5, nArray, n3);
        }
        int n6 = n2;
        nArray[n6] = nArray[n6] - n;
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(n5, nArray, n3);
        if (n4 == 1) {
            Maths.difference(abstractDataset, abstractDataset2);
        } else {
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(n5, new int[]{abstractDataset.shape[n2]}, n3);
            AbstractDataset abstractDataset4 = AbstractDataset.zeros(n5, new int[]{nArray[n2]}, n3);
            PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
            int[] nArray2 = positionIterator.getPos();
            boolean[] blArray = positionIterator.getOmit();
            while (positionIterator.hasNext()) {
                abstractDataset.copyItemsFromAxes(nArray2, blArray, abstractDataset3);
                Maths.difference(abstractDataset3, abstractDataset4, n);
                abstractDataset2.setItemsOnAxes(nArray2, blArray, abstractDataset4.getBuffer());
            }
        }
        return abstractDataset2;
    }

    private static double SelectedMean(AbstractDataset abstractDataset, int n, int n2) {
        double d = 0.0;
        int n3 = n;
        int n4 = abstractDataset.getSize();
        while (n3 <= n2) {
            int n5 = n3;
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 >= n4) {
                n5 = n4 - 1;
            }
            d += abstractDataset.getElementDoubleAbs(n5);
            ++n3;
        }
        return d /= (double)(n2 - n + 1);
    }

    private static void SelectedMeanArray(double[] dArray, AbstractDataset abstractDataset, int n, int n2) {
        int n3;
        int n4 = dArray.length;
        int n5 = 0;
        while (n5 < n4) {
            dArray[n5] = 0.0;
            ++n5;
        }
        n5 = n;
        int n6 = abstractDataset.getSize();
        while (n5 <= n2) {
            n3 = n5 * n4;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 >= n6) {
                n3 = n6 - n4;
            }
            int n7 = 0;
            while (n7 < n4) {
                int n8 = n7;
                dArray[n8] = dArray[n8] + abstractDataset.getElementDoubleAbs(n3 + n7);
                ++n7;
            }
            ++n5;
        }
        double d = 1.0 / ((double)(n2 - n) + 1.0);
        n3 = 0;
        while (n3 < n4) {
            int n9 = n3++;
            dArray[n9] = dArray[n9] * d;
        }
    }

    public static AbstractDataset derivative(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int n) {
        AbstractDataset abstractDataset3;
        if (abstractDataset.getRank() != 1 || abstractDataset2.getRank() != 1) {
            throw new IllegalArgumentException("Only one dimensional dataset supported");
        }
        if (abstractDataset2.getSize() > abstractDataset.getSize()) {
            throw new IllegalArgumentException("Length of x dataset should be greater than or equal to y's");
        }
        int n2 = abstractDataset2.getDtype();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 100: 
            case 200: {
                abstractDataset3 = AbstractDataset.zeros(abstractDataset2, 5);
                break;
            }
            case 3: 
            case 4: 
            case 300: 
            case 400: {
                abstractDataset3 = AbstractDataset.zeros(abstractDataset2, 6);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 500: 
            case 600: {
                abstractDataset3 = AbstractDataset.zeros(abstractDataset2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("derivative does not support multiple-element dataset");
            }
        }
        int n3 = abstractDataset2.getElementsPerItem();
        if (n3 == 1) {
            int n4 = 0;
            int n5 = abstractDataset.getSize();
            while (n4 < n5) {
                double d = Maths.SelectedMean(abstractDataset2, n4 - n, n4 - 1);
                double d2 = Maths.SelectedMean(abstractDataset2, n4 + 1, n4 + n);
                double d3 = Maths.SelectedMean(abstractDataset, n4 - n, n4 - 1);
                double d4 = Maths.SelectedMean(abstractDataset, n4 + 1, n4 + n);
                abstractDataset3.set((d2 - d) / (d4 - d3), n4++);
            }
        } else {
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            int n6 = 0;
            int n7 = abstractDataset.getSize();
            while (n6 < n7) {
                Maths.SelectedMeanArray(dArray, abstractDataset2, n6 - n, n6 - 1);
                Maths.SelectedMeanArray(dArray2, abstractDataset2, n6 + 1, n6 + n);
                double d = Maths.SelectedMean(abstractDataset, n6 - n, n6 - 1);
                d = 1.0 / (Maths.SelectedMean(abstractDataset, n6 + 1, n6 + n) - d);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = n8;
                    dArray2[n9] = dArray2[n9] - dArray[n8];
                    int n10 = n8++;
                    dArray2[n10] = dArray2[n10] * d;
                }
                abstractDataset3.set(dArray2, n6++);
            }
        }
        abstractDataset3.setName(String.valueOf(abstractDataset2.getName()) + "'");
        return abstractDataset3;
    }

    public static AbstractDataset sin(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.sin(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.sin(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.sin(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.sin(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.sin(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.sin(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.sin(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.sin(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.sin(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.sin(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.sin(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.sin(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(Math.sin(f) * Math.cosh(f4));
                    float f6 = (float)(Math.cos(f) * Math.sinh(f4));
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.sin(d) * Math.cosh(d4);
                    double d6 = Math.cos(d) * Math.sinh(d4);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("sin supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "sin");
        return abstractDataset2;
    }

    public static AbstractDataset cos(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.cos(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.cos(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.cos(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.cos(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.cos(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.cos(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.cos(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.cos(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.cos(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.cos(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.cos(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.cos(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(Math.cos(f) * Math.cosh(f4));
                    float f6 = (float)(-Math.sin(f) * Math.sinh(f4));
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.cos(d) * Math.cosh(d4);
                    double d6 = -Math.sin(d) * Math.sinh(d4);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("cos supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "cos");
        return abstractDataset2;
    }

    public static AbstractDataset tan(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.tan(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.tan(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.tan(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.tan(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.tan(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.tan(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.tan(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.tan(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.tan(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.tan(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.tan(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.tan(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(2.0 * (double)f);
                    float f6 = (float)(2.0 * (double)f4);
                    float f7 = (float)(1.0 / (Math.cos(f5) + Math.cosh(f6)));
                    float f8 = (float)((double)f7 * Math.sin(f5));
                    float f9 = (float)((double)f7 * Math.sinh(f6));
                    fArray4[n28++] = f8;
                    fArray4[n28++] = f9;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = 2.0 * d;
                    double d6 = 2.0 * d4;
                    double d7 = 1.0 / (Math.cos(d5) + Math.cosh(d6));
                    double d8 = d7 * Math.sin(d5);
                    double d9 = d7 * Math.sinh(d6);
                    dArray4[n29++] = d8;
                    dArray4[n29++] = d9;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("tan supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "tan");
        return abstractDataset2;
    }

    public static AbstractDataset arcsin(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.asin(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.asin(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.asin(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.asin(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.asin(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.asin(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.asin(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.asin(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.asin(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.asin(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.asin(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.asin(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)f, (double)f4).asin();
                    float f5 = (float)complex.getReal();
                    float f6 = (float)complex.getImaginary();
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(d, d4).asin();
                    double d5 = complex.getReal();
                    double d6 = complex.getImaginary();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("arcsin supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "arcsin");
        return abstractDataset2;
    }

    public static AbstractDataset arccos(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.acos(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.acos(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.acos(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.acos(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.acos(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.acos(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.acos(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.acos(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.acos(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.acos(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.acos(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.acos(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)f, (double)f4).acos();
                    float f5 = (float)complex.getReal();
                    float f6 = (float)complex.getImaginary();
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(d, d4).acos();
                    double d5 = complex.getReal();
                    double d6 = complex.getImaginary();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("arccos supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "arccos");
        return abstractDataset2;
    }

    public static AbstractDataset arctan(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.atan(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.atan(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.atan(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.atan(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.atan(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.atan(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.atan(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.atan(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.atan(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.atan(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.atan(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.atan(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)f, (double)f4).atan();
                    float f5 = (float)complex.getReal();
                    float f6 = (float)complex.getImaginary();
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(d, d4).atan();
                    double d5 = complex.getReal();
                    double d6 = complex.getImaginary();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("arctan supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "arctan");
        return abstractDataset2;
    }

    public static AbstractDataset sinh(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.sinh(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.sinh(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.sinh(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.sinh(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.sinh(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.sinh(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.sinh(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.sinh(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.sinh(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.sinh(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.sinh(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.sinh(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(Math.sinh(f) * Math.cos(f4));
                    float f6 = (float)(Math.cosh(f) * Math.sin(f4));
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.sinh(d) * Math.cos(d4);
                    double d6 = Math.cosh(d) * Math.sin(d4);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("sinh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "sinh");
        return abstractDataset2;
    }

    public static AbstractDataset cosh(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.cosh(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.cosh(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.cosh(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.cosh(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.cosh(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.cosh(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.cosh(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.cosh(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.cosh(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.cosh(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.cosh(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.cosh(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(Math.cosh(f) * Math.cos(f4));
                    float f6 = (float)(Math.sinh(f) * Math.sin(f4));
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.cosh(d) * Math.cos(d4);
                    double d6 = Math.sinh(d) * Math.sin(d4);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("cosh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "cosh");
        return abstractDataset2;
    }

    public static AbstractDataset tanh(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.tanh(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.tanh(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.tanh(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.tanh(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.tanh(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.tanh(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.tanh(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.tanh(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.tanh(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.tanh(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.tanh(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.tanh(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(2.0 * (double)f);
                    float f6 = (float)(2.0 * (double)f4);
                    float f7 = (float)(1.0 / (Math.cos(f5) + Math.cosh(f6)));
                    float f8 = (float)((double)f7 * Math.sinh(f5));
                    float f9 = (float)((double)f7 * Math.sin(f6));
                    fArray4[n28++] = f8;
                    fArray4[n28++] = f9;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = 2.0 * d;
                    double d6 = 2.0 * d4;
                    double d7 = 1.0 / (Math.cos(d5) + Math.cosh(d6));
                    double d8 = d7 * Math.sinh(d5);
                    double d9 = d7 * Math.sin(d6);
                    dArray4[n29++] = d8;
                    dArray4[n29++] = d9;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("tanh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "tanh");
        return abstractDataset2;
    }

    public static AbstractDataset arcsinh(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.log((double)by + Math.sqrt(by * by + 1));
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.log((double)s + Math.sqrt(s * s + 1));
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.log((double)n5 + Math.sqrt(n5 * n5 + 1));
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.log((double)l + Math.sqrt(l * l + 1L));
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.log((double)by + Math.sqrt(by * by + 1));
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.log((double)s + Math.sqrt(s * s + 1));
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.log((double)n16 + Math.sqrt(n16 * n16 + 1));
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.log((double)l + Math.sqrt(l * l + 1L));
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.log((double)f + Math.sqrt(f * f + 1.0f));
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.log(d + Math.sqrt(d * d + 1.0));
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.log((double)f + Math.sqrt(f * f + 1.0f));
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.log(d + Math.sqrt(d * d + 1.0));
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)(-f4), (double)f).asin();
                    float f5 = (float)complex.getImaginary();
                    float f6 = (float)(-complex.getReal());
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(-d4, d).asin();
                    double d5 = complex.getImaginary();
                    double d6 = -complex.getReal();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("arcsinh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "arcsinh");
        return abstractDataset2;
    }

    public static AbstractDataset arccosh(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.log((double)by + Math.sqrt(by * by - 1));
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.log((double)s + Math.sqrt(s * s - 1));
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.log((double)n5 + Math.sqrt(n5 * n5 - 1));
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.log((double)l + Math.sqrt(l * l - 1L));
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.log((double)by + Math.sqrt(by * by - 1));
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.log((double)s + Math.sqrt(s * s - 1));
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.log((double)n16 + Math.sqrt(n16 * n16 - 1));
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.log((double)l + Math.sqrt(l * l - 1L));
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.log((double)f + Math.sqrt(f * f - 1.0f));
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.log(d + Math.sqrt(d * d - 1.0));
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.log((double)f + Math.sqrt(f * f - 1.0f));
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.log(d + Math.sqrt(d * d - 1.0));
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)(-f4), (double)f).acos();
                    float f5 = (float)complex.getImaginary();
                    float f6 = (float)(-complex.getReal());
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(-d4, d).acos();
                    double d5 = complex.getImaginary();
                    double d6 = -complex.getReal();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("arccosh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "arccosh");
        return abstractDataset2;
    }

    public static AbstractDataset arctanh(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)(0.5 * Math.log((1 + by) / (1 - by)));
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)(0.5 * Math.log((1 + s) / (1 - s)));
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = 0.5 * Math.log((1 + n5) / (1 - n5));
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = 0.5 * Math.log((1L + l) / (1L - l));
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)(0.5 * Math.log((1 + by) / (1 - by)));
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)(0.5 * Math.log((1 + s) / (1 - s)));
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = 0.5 * Math.log((1 + n16) / (1 - n16));
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = 0.5 * Math.log((1L + l) / (1L - l));
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)(0.5 * Math.log((1.0f + f) / (1.0f - f)));
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = 0.5 * Math.log((1.0 + d) / (1.0 - d));
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)(0.5 * Math.log((1.0f + f) / (1.0f - f)));
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = 0.5 * Math.log((1.0 + d) / (1.0 - d));
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)(-f4), (double)f).atan();
                    float f5 = (float)complex.getImaginary();
                    float f6 = (float)(-complex.getReal());
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(-d4, d).atan();
                    double d5 = complex.getImaginary();
                    double d6 = -complex.getReal();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("arctanh supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "arctanh");
        return abstractDataset2;
    }

    public static AbstractDataset log(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.log(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.log(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.log(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.log(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.log(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.log(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.log(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.log(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.log(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.log(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.log(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.log(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.log(Math.hypot(f, f4));
                    float f6 = (float)Math.atan2(f4, f);
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.log(Math.hypot(d, d4));
                    double d6 = Math.atan2(d4, d);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("log supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "log");
        return abstractDataset2;
    }

    public static AbstractDataset log2(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)(Math.log(by) / Math.log(2.0));
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)(Math.log(s) / Math.log(2.0));
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.log(n5) / Math.log(2.0);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.log(l) / Math.log(2.0);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)(Math.log(by) / Math.log(2.0));
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)(Math.log(s) / Math.log(2.0));
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.log(n16) / Math.log(2.0);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.log(l) / Math.log(2.0);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)(Math.log(f) / Math.log(2.0));
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.log(d) / Math.log(2.0);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)(Math.log(f) / Math.log(2.0));
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.log(d) / Math.log(2.0);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(Math.log(Math.hypot(f, f4)) / Math.log(2.0));
                    float f6 = (float)Math.atan2(f4, f);
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.log(Math.hypot(d, d4)) / Math.log(2.0);
                    double d6 = Math.atan2(d4, d);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("log2 supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "log2");
        return abstractDataset2;
    }

    public static AbstractDataset log10(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.log10(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.log10(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.log10(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.log10(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.log10(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.log10(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.log10(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.log10(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.log10(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.log10(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.log10(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.log10(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.log10(Math.hypot(f, f4));
                    float f6 = (float)Math.atan2(f4, f);
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.log10(Math.hypot(d, d4));
                    double d6 = Math.atan2(d4, d);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("log10 supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "log10");
        return abstractDataset2;
    }

    public static AbstractDataset log1p(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.log1p(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.log1p(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.log1p(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.log1p(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.log1p(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.log1p(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.log1p(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.log1p(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.log1p(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.log1p(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.log1p(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.log1p(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)(0.5 * Math.log1p((double)(f * f) + 2.0 * (double)f + (double)(f4 * f4)));
                    float f6 = (float)Math.atan2(f4, f + 1.0f);
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = 0.5 * Math.log1p(d * d + 2.0 * d + d4 * d4);
                    double d6 = Math.atan2(d4, d + 1.0);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("log1p supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "log1p");
        return abstractDataset2;
    }

    public static AbstractDataset exp(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.exp(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.exp(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.exp(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.exp(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.exp(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.exp(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.exp(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.exp(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.exp(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.exp(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.exp(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.exp(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.exp(f);
                    float f6 = (float)((double)f5 * Math.cos(f4));
                    float f7 = (float)((double)f5 * Math.sin(f4));
                    fArray4[n28++] = f6;
                    fArray4[n28++] = f7;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.exp(d);
                    double d6 = d5 * Math.cos(d4);
                    double d7 = d5 * Math.sin(d4);
                    dArray4[n29++] = d6;
                    dArray4[n29++] = d7;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("exp supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "exp");
        return abstractDataset2;
    }

    public static AbstractDataset expm1(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.expm1(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.expm1(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.expm1(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.expm1(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.expm1(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.expm1(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.expm1(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.expm1(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.expm1(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.expm1(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.expm1(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.expm1(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.expm1(f);
                    float f6 = (float)((double)f5 * Math.cos(f4));
                    float f7 = (float)((double)f5 * Math.sin(f4));
                    fArray4[n28++] = f6;
                    fArray4[n28++] = f7;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.expm1(d);
                    double d6 = d5 * Math.cos(d4);
                    double d7 = d5 * Math.sin(d4);
                    dArray4[n29++] = d6;
                    dArray4[n29++] = d7;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("expm1 supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "expm1");
        return abstractDataset2;
    }

    public static AbstractDataset sqrt(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.sqrt(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.sqrt(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.sqrt(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.sqrt(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.sqrt(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.sqrt(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.sqrt(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.sqrt(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.sqrt(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.sqrt(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.sqrt(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.sqrt(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)f, (double)f4).sqrt();
                    float f5 = (float)complex.getReal();
                    float f6 = (float)complex.getImaginary();
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(d, d4).sqrt();
                    double d5 = complex.getReal();
                    double d6 = complex.getImaginary();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("sqrt supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "sqrt");
        return abstractDataset2;
    }

    public static AbstractDataset cbrt(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.cbrt(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.cbrt(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.cbrt(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.cbrt(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.cbrt(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.cbrt(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.cbrt(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.cbrt(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.cbrt(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.cbrt(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.cbrt(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.cbrt(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    Complex complex = new Complex((double)f, (double)f4).pow(new Complex(0.3333333333333333, 0.0));
                    float f5 = (float)complex.getReal();
                    float f6 = (float)complex.getImaginary();
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    Complex complex = new Complex(d, d4).pow(new Complex(0.3333333333333333, 0.0));
                    double d5 = complex.getReal();
                    double d6 = complex.getImaginary();
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("cbrt supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "cbrt");
        return abstractDataset2;
    }

    public static AbstractDataset square(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    byte by2 = (byte)(by * by);
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    short s2 = (short)(s * s);
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    long l2 = l * l;
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6 = nArray[indexIterator.index];
                    int n7 = n6 * n6;
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by = byArray[indexIterator.index + n10];
                        byte by3 = (byte)(by * by);
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s = sArray[indexIterator.index + n13];
                        short s3 = (short)(s * s);
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l = lArray[indexIterator.index + n16];
                        long l3 = l * l;
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20 = nArray[indexIterator.index + n19];
                        int n21 = n20 * n20;
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = f * f;
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = d * d;
                    dArray2[n23++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = f * f;
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d = dArray[indexIterator.index + n29];
                        double d3 = d * d;
                        dArray3[n28++] = d3;
                        ++n29;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n30 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = f * f - f4 * f4;
                    float f6 = (float)(2.0 * (double)f * (double)f4);
                    fArray4[n30++] = f5;
                    fArray4[n30++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n31 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = d * d - d4 * d4;
                    double d6 = 2.0 * d * d4;
                    dArray4[n31++] = d5;
                    dArray4[n31++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("square supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "square");
        return abstractDataset2;
    }

    public static AbstractDataset floor(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by;
                    byte by2 = by = byArray[indexIterator.index];
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s;
                    short s2 = s = sArray[indexIterator.index];
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l;
                    long l2 = l = lArray[indexIterator.index];
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6;
                    int n7 = n6 = nArray[indexIterator.index];
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by;
                        byte by3 = by = byArray[indexIterator.index + n10];
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s;
                        short s3 = s = sArray[indexIterator.index + n13];
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l;
                        long l3 = l = lArray[indexIterator.index + n16];
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20;
                        int n21 = n20 = nArray[indexIterator.index + n19];
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.floor(f);
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.floor(d);
                    dArray2[n23++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = (float)Math.floor(f);
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d = dArray[indexIterator.index + n29];
                        double d3 = Math.floor(d);
                        dArray3[n28++] = d3;
                        ++n29;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n30 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.floor(f);
                    float f6 = (float)Math.floor(f4);
                    fArray4[n30++] = f5;
                    fArray4[n30++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n31 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.floor(d);
                    double d6 = Math.floor(d4);
                    dArray4[n31++] = d5;
                    dArray4[n31++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("floor supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "floor");
        return abstractDataset2;
    }

    public static AbstractDataset ceil(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by;
                    byte by2 = by = byArray[indexIterator.index];
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s;
                    short s2 = s = sArray[indexIterator.index];
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l;
                    long l2 = l = lArray[indexIterator.index];
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6;
                    int n7 = n6 = nArray[indexIterator.index];
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by;
                        byte by3 = by = byArray[indexIterator.index + n10];
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s;
                        short s3 = s = sArray[indexIterator.index + n13];
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l;
                        long l3 = l = lArray[indexIterator.index + n16];
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20;
                        int n21 = n20 = nArray[indexIterator.index + n19];
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.ceil(f);
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.ceil(d);
                    dArray2[n23++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = (float)Math.ceil(f);
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d = dArray[indexIterator.index + n29];
                        double d3 = Math.ceil(d);
                        dArray3[n28++] = d3;
                        ++n29;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n30 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.ceil(f);
                    float f6 = (float)Math.ceil(f4);
                    fArray4[n30++] = f5;
                    fArray4[n30++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n31 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.ceil(d);
                    double d6 = Math.ceil(d4);
                    dArray4[n31++] = d5;
                    dArray4[n31++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("ceil supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "ceil");
        return abstractDataset2;
    }

    public static AbstractDataset rint(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by;
                    byte by2 = by = byArray[indexIterator.index];
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s;
                    short s2 = s = sArray[indexIterator.index];
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l;
                    long l2 = l = lArray[indexIterator.index];
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6;
                    int n7 = n6 = nArray[indexIterator.index];
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by;
                        byte by3 = by = byArray[indexIterator.index + n10];
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s;
                        short s3 = s = sArray[indexIterator.index + n13];
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l;
                        long l3 = l = lArray[indexIterator.index + n16];
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20;
                        int n21 = n20 = nArray[indexIterator.index + n19];
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.rint(f);
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.rint(d);
                    dArray2[n23++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = (float)Math.rint(f);
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d = dArray[indexIterator.index + n29];
                        double d3 = Math.rint(d);
                        dArray3[n28++] = d3;
                        ++n29;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n30 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.rint(f);
                    float f6 = (float)Math.rint(f4);
                    fArray4[n30++] = f5;
                    fArray4[n30++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n31 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.rint(d);
                    double d6 = Math.rint(d4);
                    dArray4[n31++] = d5;
                    dArray4[n31++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("rint supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "rint");
        return abstractDataset2;
    }

    public static AbstractDataset toDegrees(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.toDegrees(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.toDegrees(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.toDegrees(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.toDegrees(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.toDegrees(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.toDegrees(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.toDegrees(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.toDegrees(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.toDegrees(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.toDegrees(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.toDegrees(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.toDegrees(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.toDegrees(f);
                    float f6 = (float)Math.toDegrees(f4);
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.toDegrees(d);
                    double d6 = Math.toDegrees(d4);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("toDegrees supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "toDegrees");
        return abstractDataset2;
    }

    public static AbstractDataset toRadians(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    float f = (float)Math.toRadians(by);
                    fArray[n2++] = f;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                float[] fArray = ((FloatDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    float f = (float)Math.toRadians(s);
                    fArray[n3++] = f;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    int n5 = nArray[indexIterator.index];
                    double d = Math.toRadians(n5);
                    dArray[n4++] = d;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                long[] lArray = ((LongDataset)abstractDataset).data;
                double[] dArray = ((DoubleDataset)abstractDataset2).getData();
                int n6 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    double d = Math.toRadians(l);
                    dArray[n6++] = d;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n7 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n8 = 0;
                while (indexIterator.hasNext()) {
                    int n9 = 0;
                    while (n9 < n7) {
                        byte by = byArray[indexIterator.index + n9];
                        float f = (float)Math.toRadians(by);
                        fArray[n8++] = f;
                        ++n9;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n10 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                float[] fArray = ((CompoundFloatDataset)abstractDataset2).getData();
                int n11 = 0;
                while (indexIterator.hasNext()) {
                    int n12 = 0;
                    while (n12 < n10) {
                        short s = sArray[indexIterator.index + n12];
                        float f = (float)Math.toRadians(s);
                        fArray[n11++] = f;
                        ++n12;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n13 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n14 = 0;
                while (indexIterator.hasNext()) {
                    int n15 = 0;
                    while (n15 < n13) {
                        int n16 = nArray[indexIterator.index + n15];
                        double d = Math.toRadians(n16);
                        dArray[n14++] = d;
                        ++n15;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n17 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                double[] dArray = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        long l = lArray[indexIterator.index + n19];
                        double d = Math.toRadians(l);
                        dArray[n18++] = d;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n20 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = (float)Math.toRadians(f);
                    fArray2[n20++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n21 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.toRadians(d);
                    dArray2[n21++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n22 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    int n24 = 0;
                    while (n24 < n22) {
                        float f = fArray[indexIterator.index + n24];
                        float f3 = (float)Math.toRadians(f);
                        fArray3[n23++] = f3;
                        ++n24;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n25 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n26 = 0;
                while (indexIterator.hasNext()) {
                    int n27 = 0;
                    while (n27 < n25) {
                        double d = dArray[indexIterator.index + n27];
                        double d3 = Math.toRadians(d);
                        dArray3[n26++] = d3;
                        ++n27;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.toRadians(f);
                    float f6 = (float)Math.toRadians(f4);
                    fArray4[n28++] = f5;
                    fArray4[n28++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n29 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.toRadians(d);
                    double d6 = Math.toRadians(d4);
                    dArray4[n29++] = d5;
                    dArray4[n29++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("toRadians supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "toRadians");
        return abstractDataset2;
    }

    public static AbstractDataset signum(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    byte by2 = (byte)(by > 0 ? 1 : (by < 0 ? -1 : 0));
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    short s2 = (short)(s > 0 ? 1 : (s < 0 ? -1 : 0));
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    long l2 = l > 0L ? 1 : (l < 0L ? -1 : 0);
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6 = nArray[indexIterator.index];
                    int n7 = n6 > 0 ? 1 : (n6 < 0 ? -1 : 0);
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by = byArray[indexIterator.index + n10];
                        byte by3 = (byte)(by > 0 ? 1 : (by < 0 ? -1 : 0));
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s = sArray[indexIterator.index + n13];
                        short s3 = (short)(s > 0 ? 1 : (s < 0 ? -1 : 0));
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l = lArray[indexIterator.index + n16];
                        long l3 = l > 0L ? 1 : (l < 0L ? -1 : 0);
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20 = nArray[indexIterator.index + n19];
                        int n21 = n20 > 0 ? 1 : (n20 < 0 ? -1 : 0);
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = Math.signum(f);
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.signum(d);
                    dArray2[n23++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = Math.signum(f);
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d = dArray[indexIterator.index + n29];
                        double d3 = Math.signum(d);
                        dArray3[n28++] = d3;
                        ++n29;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n30 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = Math.signum(f);
                    float f6 = Math.signum(f4);
                    fArray4[n30++] = f5;
                    fArray4[n30++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n31 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.signum(d);
                    double d6 = Math.signum(d4);
                    dArray4[n31++] = d5;
                    dArray4[n31++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("signum supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "signum");
        return abstractDataset2;
    }

    public static AbstractDataset abs(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    byte by2 = (byte)Math.abs(by);
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    short s2 = (short)Math.abs(s);
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    long l2 = Math.abs(l);
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6 = nArray[indexIterator.index];
                    int n7 = Math.abs(n6);
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by = byArray[indexIterator.index + n10];
                        byte by3 = (byte)Math.abs(by);
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s = sArray[indexIterator.index + n13];
                        short s3 = (short)Math.abs(s);
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l = lArray[indexIterator.index + n16];
                        long l3 = Math.abs(l);
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20 = nArray[indexIterator.index + n19];
                        int n21 = Math.abs(n20);
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = Math.abs(f);
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = Math.abs(d);
                    dArray2[n23++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = Math.abs(f);
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d = dArray[indexIterator.index + n29];
                        double d3 = Math.abs(d);
                        dArray3[n28++] = d3;
                        ++n29;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((FloatDataset)abstractDataset2).getData();
                int n30 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = (float)Math.hypot(f, f4);
                    fArray4[n30++] = f5;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((DoubleDataset)abstractDataset2).getData();
                int n31 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = Math.hypot(d, d4);
                    dArray4[n31++] = d5;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("abs supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "abs");
        return abstractDataset2;
    }

    public static AbstractDataset negative(AbstractDataset abstractDataset) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    byte by2 = -by;
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    short s2 = -s;
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    long l2 = -l;
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6 = nArray[indexIterator.index];
                    int n7 = -n6;
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by = byArray[indexIterator.index + n10];
                        byte by3 = -by;
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s = sArray[indexIterator.index + n13];
                        short s3 = -s;
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l = lArray[indexIterator.index + n16];
                        long l3 = -l;
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20 = nArray[indexIterator.index + n19];
                        int n21 = -n20;
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = -f;
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d2 = -d;
                    dArray2[n23++] = d2;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = -f;
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d = dArray[indexIterator.index + n29];
                        double d3 = -d;
                        dArray3[n28++] = d3;
                        ++n29;
                    }
                }
                break;
            }
            case 7: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 7);
                float[] fArray = ((ComplexFloatDataset)abstractDataset).data;
                float[] fArray4 = ((ComplexFloatDataset)abstractDataset2).getData();
                int n30 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f4 = fArray[indexIterator.index + 1];
                    float f5 = -f;
                    float f6 = -f4;
                    fArray4[n30++] = f5;
                    fArray4[n30++] = f6;
                }
                break;
            }
            case 8: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 8);
                double[] dArray = ((ComplexDoubleDataset)abstractDataset).data;
                double[] dArray4 = ((ComplexDoubleDataset)abstractDataset2).getData();
                int n31 = 0;
                while (indexIterator.hasNext()) {
                    double d = dArray[indexIterator.index];
                    double d4 = dArray[indexIterator.index + 1];
                    double d5 = -d;
                    double d6 = -d4;
                    dArray4[n31++] = d5;
                    dArray4[n31++] = d6;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("negative supports integer, compound integer, real, compound real, complex datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "negative");
        return abstractDataset2;
    }

    public static AbstractDataset clip(AbstractDataset abstractDataset, Object object, Object object2) {
        AbstractDataset abstractDataset2;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = abstractDataset.getDtype();
        double d = AbstractDataset.toReal(object);
        double d2 = AbstractDataset.toReal(object2);
        switch (n) {
            case 1: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 1);
                byte[] byArray = ((ByteDataset)abstractDataset).data;
                byte[] byArray2 = ((ByteDataset)abstractDataset2).getData();
                int n2 = 0;
                while (indexIterator.hasNext()) {
                    byte by = byArray[indexIterator.index];
                    byte by2 = (double)by < d ? (byte)d : ((double)by > d2 ? (byte)d2 : by);
                    byArray2[n2++] = by2;
                }
                break;
            }
            case 2: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 2);
                short[] sArray = ((ShortDataset)abstractDataset).data;
                short[] sArray2 = ((ShortDataset)abstractDataset2).getData();
                int n3 = 0;
                while (indexIterator.hasNext()) {
                    short s = sArray[indexIterator.index];
                    short s2 = (double)s < d ? (short)d : ((double)s > d2 ? (short)d2 : s);
                    sArray2[n3++] = s2;
                }
                break;
            }
            case 4: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 4);
                long[] lArray = ((LongDataset)abstractDataset).data;
                long[] lArray2 = ((LongDataset)abstractDataset2).getData();
                int n4 = 0;
                while (indexIterator.hasNext()) {
                    long l = lArray[indexIterator.index];
                    long l2 = (double)l < d ? (long)d : ((double)l > d2 ? (long)d2 : l);
                    lArray2[n4++] = l2;
                }
                break;
            }
            case 3: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 3);
                int[] nArray = ((IntegerDataset)abstractDataset).data;
                int[] nArray2 = ((IntegerDataset)abstractDataset2).getData();
                int n5 = 0;
                while (indexIterator.hasNext()) {
                    int n6 = nArray[indexIterator.index];
                    int n7 = (double)n6 < d ? (int)d : ((double)n6 > d2 ? (int)d2 : n6);
                    nArray2[n5++] = n7;
                }
                break;
            }
            case 100: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 100);
                int n8 = abstractDataset.getElementsPerItem();
                byte[] byArray = ((CompoundByteDataset)abstractDataset).data;
                byte[] byArray3 = ((CompoundByteDataset)abstractDataset2).getData();
                int n9 = 0;
                while (indexIterator.hasNext()) {
                    int n10 = 0;
                    while (n10 < n8) {
                        byte by = byArray[indexIterator.index + n10];
                        byte by3 = (double)by < d ? (byte)d : ((double)by > d2 ? (byte)d2 : by);
                        byArray3[n9++] = by3;
                        ++n10;
                    }
                }
                break;
            }
            case 200: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 200);
                int n11 = abstractDataset.getElementsPerItem();
                short[] sArray = ((CompoundShortDataset)abstractDataset).data;
                short[] sArray3 = ((CompoundShortDataset)abstractDataset2).getData();
                int n12 = 0;
                while (indexIterator.hasNext()) {
                    int n13 = 0;
                    while (n13 < n11) {
                        short s = sArray[indexIterator.index + n13];
                        short s3 = (double)s < d ? (short)d : ((double)s > d2 ? (short)d2 : s);
                        sArray3[n12++] = s3;
                        ++n13;
                    }
                }
                break;
            }
            case 400: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 400);
                int n14 = abstractDataset.getElementsPerItem();
                long[] lArray = ((CompoundLongDataset)abstractDataset).data;
                long[] lArray3 = ((CompoundLongDataset)abstractDataset2).getData();
                int n15 = 0;
                while (indexIterator.hasNext()) {
                    int n16 = 0;
                    while (n16 < n14) {
                        long l = lArray[indexIterator.index + n16];
                        long l3 = (double)l < d ? (long)d : ((double)l > d2 ? (long)d2 : l);
                        lArray3[n15++] = l3;
                        ++n16;
                    }
                }
                break;
            }
            case 300: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 300);
                int n17 = abstractDataset.getElementsPerItem();
                int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
                int[] nArray3 = ((CompoundIntegerDataset)abstractDataset2).getData();
                int n18 = 0;
                while (indexIterator.hasNext()) {
                    int n19 = 0;
                    while (n19 < n17) {
                        int n20 = nArray[indexIterator.index + n19];
                        int n21 = (double)n20 < d ? (int)d : ((double)n20 > d2 ? (int)d2 : n20);
                        nArray3[n18++] = n21;
                        ++n19;
                    }
                }
                break;
            }
            case 5: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 5);
                float[] fArray = ((FloatDataset)abstractDataset).data;
                float[] fArray2 = ((FloatDataset)abstractDataset2).getData();
                int n22 = 0;
                while (indexIterator.hasNext()) {
                    float f = fArray[indexIterator.index];
                    float f2 = Double.isNaN(f) ? (float)((d + d2) / 2.0) : ((double)f < d ? (float)d : ((double)f > d2 ? (float)d2 : f));
                    fArray2[n22++] = f2;
                }
                break;
            }
            case 6: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 6);
                double[] dArray = ((DoubleDataset)abstractDataset).data;
                double[] dArray2 = ((DoubleDataset)abstractDataset2).getData();
                int n23 = 0;
                while (indexIterator.hasNext()) {
                    double d3 = dArray[indexIterator.index];
                    double d4 = Double.isNaN(d3) ? (d + d2) / 2.0 : (d3 < d ? d : (d3 > d2 ? d2 : d3));
                    dArray2[n23++] = d4;
                }
                break;
            }
            case 500: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 500);
                int n24 = abstractDataset.getElementsPerItem();
                float[] fArray = ((CompoundFloatDataset)abstractDataset).data;
                float[] fArray3 = ((CompoundFloatDataset)abstractDataset2).getData();
                int n25 = 0;
                while (indexIterator.hasNext()) {
                    int n26 = 0;
                    while (n26 < n24) {
                        float f = fArray[indexIterator.index + n26];
                        float f3 = Double.isNaN(f) ? (float)((d + d2) / 2.0) : ((double)f < d ? (float)d : ((double)f > d2 ? (float)d2 : f));
                        fArray3[n25++] = f3;
                        ++n26;
                    }
                }
                break;
            }
            case 600: {
                abstractDataset2 = AbstractDataset.zeros(abstractDataset, 600);
                int n27 = abstractDataset.getElementsPerItem();
                double[] dArray = ((CompoundDoubleDataset)abstractDataset).data;
                double[] dArray3 = ((CompoundDoubleDataset)abstractDataset2).getData();
                int n28 = 0;
                while (indexIterator.hasNext()) {
                    int n29 = 0;
                    while (n29 < n27) {
                        double d5 = dArray[indexIterator.index + n29];
                        double d6 = Double.isNaN(d5) ? (d + d2) / 2.0 : (d5 < d ? d : (d5 > d2 ? d2 : d5));
                        dArray3[n28++] = d6;
                        ++n29;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("clip supports integer, compound integer, real, compound real datasets only");
            }
        }
        abstractDataset2.setName(abstractDataset.getName());
        Maths.addFunctionName(abstractDataset2, "clip");
        return abstractDataset2;
    }
}

