/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LinearAlgebra;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.Random;

public class LinearAlgebraTest {
    private static boolean close(Number number, double d) {
        double d2 = number.doubleValue();
        return d2 == 0.0 ? Math.abs(d) < 1.0E-5 : Math.abs(d2 - d) < 1.0E-5 * d2;
    }

    @Test
    public void testTensorDot() {
        AbstractDataset abstractDataset = AbstractDataset.arange(60.0, 5).reshape(3, 4, 5);
        AbstractDataset abstractDataset2 = AbstractDataset.arange(24.0, 2).reshape(4, 3, 2);
        long l = -System.nanoTime();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        AbstractDataset abstractDataset3 = LinearAlgebra.tensorDotProduct(abstractDataset, abstractDataset2, nArray, nArray2);
        System.out.printf("Time taken %dus\n", (l += System.nanoTime()) / 1000L);
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{5, 2}, (int[])abstractDataset3.getShape());
        Assert.assertEquals((String)"Type", (long)5L, (long)abstractDataset3.getDtype());
        AbstractDataset abstractDataset4 = new DoubleDataset(new double[]{4400.0, 4730.0, 4532.0, 4874.0, 4664.0, 5018.0, 4796.0, 5162.0, 4928.0, 5306.0}, 5, 2);
        Assert.assertTrue((String)"Data does not match", (boolean)abstractDataset4.cast(abstractDataset3.getDtype()).equals(abstractDataset3));
        int n = 16;
        abstractDataset = AbstractDataset.arange(20 * n, 5).reshape(n, 4, 5);
        abstractDataset2 = AbstractDataset.arange(8 * n, 2).reshape(4, n, 2);
        l = -System.nanoTime();
        abstractDataset3 = LinearAlgebra.tensorDotProduct(abstractDataset, abstractDataset2, 0, 1);
        long l2 = -System.nanoTime();
        abstractDataset4 = LinearAlgebra.tensorDotProduct(abstractDataset, abstractDataset2, new int[1], new int[]{1});
        System.out.printf("Time taken %dus %dus\n", (l += System.nanoTime()) / 1000L, (l2 += System.nanoTime()) / 1000L);
        Assert.assertTrue((String)"Data does not match", (boolean)abstractDataset4.equals(abstractDataset3));
    }

    @Test
    public void testDot() {
        AbstractDataset abstractDataset = AbstractDataset.arange(10.0, 5);
        AbstractDataset abstractDataset2 = AbstractDataset.arange(-6.0, 4.0, 1.0, 2);
        long l = -System.nanoTime();
        AbstractDataset abstractDataset3 = LinearAlgebra.dotProduct(abstractDataset, abstractDataset2);
        long l2 = -System.nanoTime();
        AbstractDataset abstractDataset4 = Maths.multiply(abstractDataset, abstractDataset2);
        Number number = (Number)abstractDataset4.sum();
        System.out.printf("Time taken %dus %dus\n", (l += System.nanoTime()) / 1000L, (l2 += System.nanoTime()) / 1000L);
        Assert.assertTrue((String)"Data does not match", (boolean)number.equals(abstractDataset3.getObjectAbs(0)));
        Assert.assertTrue((String)"Data does not match", (boolean)number.equals(abstractDataset3.getObject(new int[0])));
    }

    @Test
    public void testRandomDot() {
        DoubleDataset doubleDataset = Random.randn(123.5, 23.4, 100);
        AbstractDataset abstractDataset = Maths.square(doubleDataset);
        AbstractDataset abstractDataset2 = LinearAlgebra.tensorDotProduct((AbstractDataset)doubleDataset, (AbstractDataset)doubleDataset, 0, 0);
        System.nanoTime();
        Number number = (Number)abstractDataset.sum();
        Assert.assertTrue((String)("Second moment does not match: " + number + " cf " + abstractDataset2.getObject(new int[0])), (boolean)LinearAlgebraTest.close(number, abstractDataset2.getDouble(new int[0])));
        abstractDataset2 = LinearAlgebra.dotProduct(abstractDataset, doubleDataset);
        AbstractDataset abstractDataset3 = Maths.multiply((AbstractDataset)doubleDataset, abstractDataset);
        number = (Number)abstractDataset3.sum();
        Assert.assertTrue((String)("Third moment does not match: " + number + " cf " + abstractDataset2.getObject(new int[0])), (boolean)LinearAlgebraTest.close(number, abstractDataset2.getDouble(new int[0])));
        abstractDataset2 = LinearAlgebra.dotProduct(abstractDataset, abstractDataset);
        abstractDataset3 = Maths.multiply(abstractDataset, abstractDataset);
        number = (Number)abstractDataset3.sum();
        Assert.assertTrue((String)("Fourth moment does not match: " + number + " cf " + abstractDataset2.getObject(new int[0])), (boolean)LinearAlgebraTest.close(number, abstractDataset2.getDouble(new int[0])));
    }
}

