/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class LinearAlgebra {
    private static final int CROSSOVERPOINT = 16;

    public static AbstractDataset tensorDotProduct(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int n, int n2) {
        int[] nArray = abstractDataset.shape;
        int[] nArray2 = abstractDataset2.shape;
        int n3 = nArray.length;
        int n4 = nArray2.length;
        int n5 = n;
        if (n5 < 0) {
            n5 += n3;
        }
        if (n5 < 0 || n5 >= n3) {
            throw new IllegalArgumentException("Summing axis outside valid rank of 1st dataset");
        }
        if (nArray[n5] < 16) {
            return LinearAlgebra.tensorDotProduct(abstractDataset, abstractDataset2, new int[]{n}, new int[]{n2});
        }
        int n6 = n2;
        if (n6 < 0) {
            n6 += n3;
        }
        if (n6 < 0 || n6 >= n3) {
            throw new IllegalArgumentException("Summing axis outside valid rank of 2nd dataset");
        }
        boolean[] blArray = new boolean[n3];
        boolean[] blArray2 = new boolean[n4];
        Arrays.fill(blArray, true);
        Arrays.fill(blArray2, true);
        blArray[n5] = false;
        blArray2[n6] = false;
        boolean[] blArray3 = new boolean[n3];
        boolean[] blArray4 = new boolean[n4];
        blArray3[n5] = true;
        blArray4[n6] = true;
        int n7 = n3 + n4 - 2;
        int[] nArray3 = new int[n7];
        int n8 = 0;
        int n9 = 0;
        while (n9 < n3) {
            if (blArray[n9]) {
                nArray3[n8++] = nArray[n9];
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < n4) {
            if (blArray2[n9]) {
                nArray3[n8++] = nArray2[n9];
            }
            ++n9;
        }
        n9 = AbstractDataset.getBestDType(abstractDataset.getDtype(), abstractDataset2.getDtype());
        AbstractDataset abstractDataset3 = AbstractDataset.zeros(nArray3, n9);
        SliceIterator sliceIterator = abstractDataset.getSliceIteratorFromAxes(null, blArray);
        int n10 = 0;
        int[] nArray4 = sliceIterator.getPos();
        while (sliceIterator.hasNext()) {
            SliceIterator sliceIterator2 = abstractDataset2.getSliceIteratorFromAxes(null, blArray2);
            int[] nArray5 = sliceIterator2.getPos();
            while (sliceIterator2.hasNext()) {
                SliceIterator sliceIterator3 = abstractDataset.getSliceIteratorFromAxes(nArray4, blArray3);
                SliceIterator sliceIterator4 = abstractDataset2.getSliceIteratorFromAxes(nArray5, blArray4);
                double d = 0.0;
                double d2 = 0.0;
                while (sliceIterator3.hasNext() && sliceIterator4.hasNext()) {
                    double d3 = abstractDataset.getElementDoubleAbs(sliceIterator3.index) * abstractDataset2.getElementDoubleAbs(sliceIterator4.index) - d2;
                    double d4 = d + d3;
                    d2 = d4 - d - d3;
                    d = d4;
                }
                abstractDataset3.setObjectAbs(n10++, d);
            }
        }
        return abstractDataset3;
    }

    public static AbstractDataset tensorDotProduct(AbstractDataset abstractDataset, AbstractDataset abstractDataset2, int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("Numbers of summing axes must be same");
        }
        int[] nArray3 = abstractDataset.shape;
        int[] nArray4 = abstractDataset2.shape;
        int n = nArray3.length;
        int n2 = nArray4.length;
        int[] nArray5 = new int[nArray.length];
        int[] nArray6 = new int[nArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            if (n4 < 0) {
                n4 += n;
            }
            if (n4 < 0 || n4 >= n) {
                throw new IllegalArgumentException("Summing axis outside valid rank of 1st dataset");
            }
            nArray5[n3] = n4;
            n4 = nArray2[n3];
            if (n4 < 0) {
                n4 += n2;
            }
            if (n4 < 0 || n4 >= n2) {
                throw new IllegalArgumentException("Summing axis outside valid rank of 2nd dataset");
            }
            nArray6[n3] = n4;
            if (nArray3[nArray5[n3]] != nArray4[n4]) {
                throw new IllegalArgumentException("Summing axes do not have matching lengths");
            }
            ++n3;
        }
        boolean[] blArray = new boolean[n];
        boolean[] blArray2 = new boolean[n2];
        Arrays.fill(blArray, true);
        Arrays.fill(blArray2, true);
        int n5 = 0;
        while (n5 < nArray5.length) {
            blArray[nArray5[n5]] = false;
            blArray2[nArray6[n5]] = false;
            ++n5;
        }
        n5 = n + n2 - 2 * nArray5.length;
        int[] nArray7 = new int[n5];
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            if (blArray[n7]) {
                nArray7[n6++] = nArray3[n7];
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n2) {
            if (blArray2[n7]) {
                nArray7[n6++] = nArray4[n7];
            }
            ++n7;
        }
        n7 = AbstractDataset.getBestDType(abstractDataset.getDtype(), abstractDataset2.getDtype());
        AbstractDataset abstractDataset3 = AbstractDataset.zeros(nArray7, n7);
        SliceIterator sliceIterator = abstractDataset.getSliceIteratorFromAxes(null, blArray);
        int n8 = 0;
        int[] nArray8 = sliceIterator.getPos();
        while (sliceIterator.hasNext()) {
            SliceIterator sliceIterator2 = abstractDataset2.getSliceIteratorFromAxes(null, blArray2);
            int[] nArray9 = sliceIterator2.getPos();
            while (sliceIterator2.hasNext()) {
                double d = 0.0;
                double d2 = 0.0;
                nArray8[nArray5[nArray5.length - 1]] = -1;
                nArray9[nArray6[nArray5.length - 1]] = -1;
                while (true) {
                    int n9 = nArray5.length - 1;
                    while (n9 >= 0) {
                        int n10 = nArray5[n9];
                        int n11 = nArray6[n9];
                        int n12 = n10;
                        nArray8[n12] = nArray8[n12] + 1;
                        int n13 = n11;
                        nArray9[n13] = nArray9[n13] + 1;
                        if (nArray8[n10] != nArray3[n10]) break;
                        nArray8[n10] = 0;
                        nArray9[n11] = 0;
                        --n9;
                    }
                    if (n9 == -1) break;
                    double d3 = abstractDataset.getDouble(nArray8) * abstractDataset2.getDouble(nArray9) - d2;
                    double d4 = d + d3;
                    d2 = d4 - d - d3;
                    d = d4;
                }
                abstractDataset3.setObjectAbs(n8++, d);
            }
        }
        return abstractDataset3;
    }

    public static AbstractDataset dotProduct(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        if (abstractDataset2.getRank() < 2) {
            return LinearAlgebra.tensorDotProduct(abstractDataset, abstractDataset2, -1, 0);
        }
        return LinearAlgebra.tensorDotProduct(abstractDataset, abstractDataset2, -1, -2);
    }
}

