/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.analysis.io.ScanFileHolderException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.io.ILazyLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.gda.monitor.IMonitor;

public class LazyDataset
implements ILazyDataset {
    private static final long serialVersionUID = -903717887381144620L;
    protected static final transient Logger logger = LoggerFactory.getLogger(LazyDataset.class);
    protected String name;
    protected int[] shape;
    protected int size;
    protected ILazyLoader loader;
    private int dtype;
    private IMetaData metadata = null;

    public LazyDataset(String string, int n, int[] nArray, ILazyLoader iLazyLoader) {
        this.name = string;
        this.shape = nArray;
        this.loader = iLazyLoader;
        this.dtype = n;
        try {
            this.size = AbstractDataset.calcSize(nArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.size = Integer.MAX_VALUE;
        }
    }

    @Override
    public LazyDataset clone() {
        return new LazyDataset(new String(this.name), this.dtype, (int[])this.shape.clone(), this.loader);
    }

    @Override
    public Class<?> elementClass() {
        return AbstractDataset.elementClass(this.dtype);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        LazyDataset lazyDataset = (LazyDataset)object;
        if (this.dtype != lazyDataset.dtype) {
            return false;
        }
        return Arrays.equals(this.shape, lazyDataset.shape);
    }

    public int hashCode() {
        int n = this.dtype;
        int n2 = this.shape.length;
        int n3 = 0;
        while (n3 < n2) {
            n = n * 17 + this.shape[n3];
            ++n3;
        }
        return n;
    }

    public int getDtype() {
        return this.dtype;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public void setShape(int ... nArray) {
        int n = AbstractDataset.calcSize(nArray);
        if (n != this.size) {
            throw new IllegalArgumentException("New shape (" + Arrays.toString(nArray) + ") is not compatible with old shape (" + Arrays.toString(this.shape) + ")");
        }
        this.shape = (int[])nArray.clone();
    }

    @Override
    public ILazyDataset squeeze() {
        return this.squeeze(false);
    }

    @Override
    public ILazyDataset squeeze(boolean bl) {
        this.shape = AbstractDataset.squeezeShape(this.shape, bl);
        return this;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && this.name.length() > 0) {
            stringBuilder.append("Lazy dataset '");
            stringBuilder.append(this.name);
            stringBuilder.append("' has shape [");
        } else {
            stringBuilder.append("Lazy dataset shape is [");
        }
        int n2 = n = this.shape == null ? 0 : this.shape.length;
        if (n > 0 && this.shape[0] > 0) {
            stringBuilder.append(this.shape[0]);
        }
        int n3 = 1;
        while (n3 < n) {
            stringBuilder.append(", " + this.shape[n3]);
            ++n3;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public AbstractDataset getSlice(Slice ... sliceArray) {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        Slice.convertFromSlice(sliceArray, this.shape, nArray, nArray2, nArray3);
        return this.getSlice(nArray, nArray2, nArray3);
    }

    @Override
    public AbstractDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.loader.isFileReadable()) {
            try {
                return this.loader.getDataset(null, this.shape, nArray, nArray2, nArray3);
            }
            catch (ScanFileHolderException scanFileHolderException) {
                logger.debug("Problem getting {}: {}", (Object)String.format("slice %s %s %s", Arrays.toString(nArray), Arrays.toString(nArray2), Arrays.toString(nArray3)), (Object)scanFileHolderException);
                return new DoubleDataset(1);
            }
        }
        return null;
    }

    @Override
    public AbstractDataset getSlice(IMonitor iMonitor, Slice ... sliceArray) throws ScanFileHolderException {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        Slice.convertFromSlice(sliceArray, this.shape, nArray, nArray2, nArray3);
        return this.getSlice(iMonitor, nArray, nArray2, nArray3);
    }

    @Override
    public AbstractDataset getSlice(IMonitor iMonitor, int[] nArray, int[] nArray2, int[] nArray3) throws ScanFileHolderException {
        if (this.loader.isFileReadable()) {
            return this.loader.getDataset(iMonitor, this.shape, nArray, nArray2, nArray3);
        }
        return null;
    }

    @Override
    public void setMetadata(IMetaData iMetaData) {
        this.metadata = iMetaData;
    }

    @Override
    public IMetaData getMetadata() {
        return this.metadata;
    }
}

