/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class IntegerDataset
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final transient Logger logger = LoggerFactory.getLogger(IntegerDataset.class);
    protected int[] data;

    @Override
    protected void setData() {
        this.data = (int[])this.odata;
    }

    private static int[] createArray(int n) {
        int[] nArray = null;
        try {
            nArray = new int[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)n);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return nArray;
    }

    @Override
    public int getDtype() {
        return 3;
    }

    public IntegerDataset() {
    }

    public IntegerDataset(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = IntegerDataset.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = IntegerDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = IntegerDataset.createArray(this.size);
            this.odata = this.data;
        }
    }

    public IntegerDataset(int[] nArray, int ... nArray2) {
        if (nArray2 == null || nArray2.length == 0) {
            nArray2 = new int[]{nArray.length};
        }
        this.size = IntegerDataset.calcSize(nArray2);
        if (this.size != nArray.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(nArray2), nArray.length));
        }
        this.shape = (int[])nArray2.clone();
        this.data = nArray;
        this.odata = nArray;
    }

    public IntegerDataset(IntegerDataset integerDataset) {
        this(integerDataset, false);
    }

    public IntegerDataset(IntegerDataset integerDataset, boolean bl) {
        this.size = integerDataset.size;
        if (bl) {
            this.shape = integerDataset.shape;
            this.dataSize = integerDataset.dataSize;
            this.dataShape = integerDataset.dataShape;
            this.name = integerDataset.name;
            this.metadataStructure = integerDataset.metadataStructure;
            this.data = integerDataset.data;
            this.odata = integerDataset.data;
            return;
        }
        this.shape = (int[])integerDataset.shape.clone();
        this.name = new String(integerDataset.name);
        if (integerDataset.metadataStructure != null) {
            this.metadataStructure = integerDataset.metadataStructure.clone();
        }
        int[] nArray = integerDataset.data;
        if (integerDataset.isContiguous()) {
            this.data = (int[])nArray.clone();
            this.odata = this.data;
        } else {
            this.data = IntegerDataset.createArray(this.size);
            this.odata = this.data;
            IndexIterator indexIterator = integerDataset.getIterator();
            int n = 0;
            while (indexIterator.hasNext()) {
                this.data[n] = nArray[indexIterator.index];
                ++n;
            }
        }
        this.errorValue = integerDataset.errorValue;
        this.errorData = integerDataset.errorData;
    }

    public IntegerDataset(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.data = IntegerDataset.createArray(this.size);
        this.odata = this.data;
        this.metadataStructure = abstractDataset.metadataStructure;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = (int)abstractDataset.getElementLongAbs(indexIterator.index);
            ++n;
        }
        this.errorValue = abstractDataset.errorValue;
        this.errorData = abstractDataset.errorData;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this.getRank() == 0) {
            return true;
        }
        IntegerDataset integerDataset = (IntegerDataset)object;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] == integerDataset.data[indexIterator.index]) continue;
            return false;
        }
        return true;
    }

    public static IntegerDataset createFromObject(Object object) {
        IntegerDataset integerDataset = new IntegerDataset();
        integerDataset.shape = IntegerDataset.getShapeFromObject(object);
        integerDataset.size = IntegerDataset.calcSize(integerDataset.shape);
        integerDataset.data = IntegerDataset.createArray(integerDataset.size);
        integerDataset.odata = integerDataset.data;
        int[] nArray = new int[integerDataset.shape.length];
        integerDataset.fillData(object, 0, nArray);
        return integerDataset;
    }

    public static IntegerDataset arange(double d) {
        return IntegerDataset.arange(0.0, d, 1.0);
    }

    public static IntegerDataset arange(double d, double d2, double d3) {
        int n = IntegerDataset.calcSteps(d, d2, d3);
        IntegerDataset integerDataset = new IntegerDataset(n);
        int n2 = 0;
        while (n2 < n) {
            integerDataset.data[n2] = (int)(d + (double)n2 * d3);
            ++n2;
        }
        return integerDataset;
    }

    public static IntegerDataset ones(int ... nArray) {
        return new IntegerDataset(nArray).fill(1);
    }

    @Override
    public IntegerDataset fill(Object object) {
        int n = (int)IntegerDataset.toLong(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = n;
        }
        return this;
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    public IntegerDataset getView() {
        IntegerDataset integerDataset = new IntegerDataset();
        integerDataset.name = new String(this.name);
        integerDataset.size = this.size;
        integerDataset.dataSize = this.dataSize;
        integerDataset.shape = (int[])this.shape.clone();
        if (this.dataShape != null) {
            integerDataset.dataShape = (int[])this.dataShape.clone();
        }
        integerDataset.data = this.data;
        integerDataset.odata = this.data;
        integerDataset.metadataStructure = this.metadataStructure;
        return integerDataset;
    }

    public int getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return this.data[n] != 0;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        return this.data[n];
    }

    @Override
    public String getStringAbs(int n) {
        return String.format("%d", this.data[n]);
    }

    public void setAbs(int n, int n2) {
        this.data[n] = n2;
        this.setDirty();
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        int[] nArray = (int[])object;
        this.data[n] = nArray[n2];
    }

    @Override
    public void setObjectAbs(int n, Object object) {
        if (n < 0 || n > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(n, (int)IntegerDataset.toLong(object));
    }

    public int get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return (short)this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0;
    }

    @Override
    public String getString(int ... nArray) {
        return this.getStringAbs(this.get1DIndex(nArray));
    }

    public void setItem(int n, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                int[] nArray2 = (int[])this.shape.clone();
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] >= nArray2[n2]) {
                        nArray2[n2] = nArray[n2] + 1;
                    }
                    ++n2;
                }
                this.allocateArray(nArray2);
            }
            this.setAbs(this.get1DIndex(nArray), n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Dimensionalities of requested position, %d, and dataset, %d, are incompatible", nArray.length, this.shape.length));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem((int)IntegerDataset.toLong(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = IntegerDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = IntegerDataset.calcSize(this.dataShape);
        int[] nArray2 = IntegerDataset.createArray(this.dataSize);
        int[] nArray3 = this.shape;
        this.shape = nArray;
        this.size = IntegerDataset.calcSize(nArray);
        Arrays.fill(nArray2, Integer.MIN_VALUE);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray3, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            nArray2[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = nArray2;
        this.odata = nArray2;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = IntegerDataset.calcSize(nArray);
        int[] nArray2 = IntegerDataset.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            nArray2[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = nArray2;
        this.odata = nArray2;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public IntegerDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.getSlice((SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3));
    }

    @Override
    public IntegerDataset getSlice(SliceIterator sliceIterator) {
        IntegerDataset integerDataset = new IntegerDataset(sliceIterator.getSliceShape());
        int[] nArray = integerDataset.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            nArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        integerDataset.setName(String.valueOf(this.name) + ".slice");
        return integerDataset;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        int[] nArray = ((IntegerDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            nArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public IntegerDataset setByBoolean(Object object, BooleanDataset booleanDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = (int)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            int n = (int)IntegerDataset.toLong(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = n;
            }
        }
        return this;
    }

    @Override
    public IntegerDataset setByIndex(Object object, IntegerDataset integerDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = (int)abstractDataset.getElementLongAbs(indexIterator.index);
            }
        } else {
            int n = (int)IntegerDataset.toLong(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = n;
            }
        }
        return this;
    }

    @Override
    public IntegerDataset setSlice(Object object, SliceIterator sliceIterator) {
        if (object instanceof IDataset) {
            IDataset iDataset = (IDataset)object;
            int[] nArray = iDataset.getShape();
            if (!IntegerDataset.areShapesCompatible(sliceIterator.getSliceShape(), nArray)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(nArray), Arrays.toString(sliceIterator.getSliceShape())));
            }
            if (iDataset instanceof AbstractDataset) {
                AbstractDataset abstractDataset = (AbstractDataset)iDataset;
                IndexIterator indexIterator = abstractDataset.getIterator();
                while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                    this.data[sliceIterator.index] = (int)abstractDataset.getElementLongAbs(indexIterator.index);
                }
            } else {
                PositionIterator positionIterator = new PositionIterator(nArray);
                int[] nArray2 = ((IndexIterator)positionIterator).getPos();
                while (sliceIterator.hasNext() && ((IndexIterator)positionIterator).hasNext()) {
                    this.data[sliceIterator.index] = iDataset.getInt(nArray2);
                }
            }
        } else {
            try {
                int n = (int)IntegerDataset.toLong(object);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = n;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (int[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = IntegerDataset.squeezeShape(var5_5.getSliceShape(), false);
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= IntegerDataset.calcSize(var6_6)) ** GOTO lbl8
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl8:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl9:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        int[] nArray2 = (int[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (nArray2.length < IntegerDataset.calcSize(sliceIterator.getSliceShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = nArray2[n];
            ++n;
        }
        this.setDirty();
    }

    private List<Integer> findPositions(int n) {
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != n) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(this.max().intValue());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof List) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(this.min().intValue());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        return false;
    }

    @Override
    public IntegerDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (int)((long)this.data[n] + abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = IntegerDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (int)((double)this.data[n] + d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public IntegerDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (int)((long)this.data[n] - abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = IntegerDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (int)((double)this.data[n] - d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public IntegerDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (int)((long)this.data[n] * abstractDataset.getElementLongAbs(indexIterator2.index));
            }
        } else {
            double d = IntegerDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (int)((double)this.data[n] * d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public IntegerDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = (int)((long)this.data[n] / abstractDataset.getElementLongAbs(indexIterator2.index));
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0;
                }
            }
        } else {
            double d = IntegerDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (int)((double)this.data[n] / d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public IntegerDataset ifloor() {
        return this;
    }

    @Override
    public IntegerDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                try {
                    int n = indexIterator.index;
                    this.data[n] = (int)((long)this.data[n] % abstractDataset.getElementLongAbs(indexIterator2.index));
                }
                catch (ArithmeticException arithmeticException) {
                    this.data[indexIterator.index] = 0;
                }
            }
        } else {
            double d = IntegerDataset.toReal(object);
            if (d == 0.0) {
                this.fill(0);
            } else {
                IndexIterator indexIterator = this.getIterator();
                while (indexIterator.hasNext()) {
                    int n = indexIterator.index;
                    this.data[n] = (int)((double)this.data[n] % d);
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public IntegerDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d = Math.pow(this.data[indexIterator.index], abstractDataset.getElementDoubleAbs(indexIterator2.index));
                this.data[indexIterator.index] = Double.isInfinite(d) || Double.isNaN(d) ? 0 : (int)d;
            }
        } else {
            double d = IntegerDataset.toReal(object);
            double d2 = IntegerDataset.toImag(object);
            IndexIterator indexIterator = this.getIterator();
            if (d2 == 0.0) {
                while (indexIterator.hasNext()) {
                    double d3 = Math.pow(this.data[indexIterator.index], d);
                    this.data[indexIterator.index] = Double.isInfinite(d3) || Double.isNaN(d3) ? 0 : (int)d3;
                }
            } else {
                Complex complex = new Complex(d, d2);
                while (indexIterator.hasNext()) {
                    Complex complex2 = new Complex((double)this.data[indexIterator.index], 0.0);
                    double d4 = complex2.pow(complex).getReal();
                    this.data[indexIterator.index] = Double.isInfinite(d4) || Double.isNaN(d4) ? 0 : (int)d4;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d4 = d3 * d3 - d2;
                double d5 = d + d4;
                d2 = d5 - d - d4;
                d = d5;
            }
        } else {
            double d6 = IntegerDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            double d7 = 0.0;
            while (indexIterator.hasNext()) {
                double d8 = (double)this.data[indexIterator.index] - d6;
                double d9 = d8 * d8 - d7;
                double d10 = d + d9;
                d7 = d10 - d - d9;
                d = d10;
            }
        }
        return d;
    }
}

