/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class IndexIteratorTest {
    @Test
    public void testIterations() {
        int n = 1024;
        int n2 = 6;
        this.testIterationsND(n, n2);
        n2 = 8;
        this.testIterationsND(n, n2);
    }

    private void testIterationsND(int n, int n2) {
        System.out.println("Size: " + n);
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[0], n2);
        this.testDataset(abstractDataset);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2);
        this.testDataset(abstractDataset);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, n / 16);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 32, 32);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, 8, n / 128);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 128, 16, 8);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testDataset(abstractDataset);
    }

    private void testDataset(AbstractDataset abstractDataset) {
        IndexIterator indexIterator = abstractDataset.getIterator();
        double[] dArray = (double[])abstractDataset.getBuffer();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)dArray[indexIterator.index], (double)(1.0E-5 * (double)n));
            ++n;
        }
        indexIterator.reset();
        n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)dArray[indexIterator.index], (double)(1.0E-5 * (double)n));
            ++n;
        }
        indexIterator = abstractDataset.getIterator(true);
        int[] nArray = indexIterator.getPos();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n2, (double)abstractDataset.getDouble(nArray), (double)(1.0E-5 * (double)n2));
            ++n2;
        }
        indexIterator.reset();
        n2 = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n2, (double)abstractDataset.getDouble(nArray), (double)(1.0E-5 * (double)n2));
            ++n2;
        }
    }

    private void testExpandedDataset(AbstractDataset abstractDataset, int n, int n2) {
        IndexIterator indexIterator = abstractDataset.getIterator(true);
        double[] dArray = (double[])abstractDataset.getBuffer();
        int[] nArray = indexIterator.getPos();
        int n3 = 0;
        while (indexIterator.hasNext()) {
            if (nArray[n] == n2) {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray)), (double)0.0, (double)dArray[indexIterator.index], (double)0.0);
                --n3;
            } else {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray)), (double)n3, (double)dArray[indexIterator.index], (double)(1.0E-5 * (double)n3));
            }
            ++n3;
        }
        indexIterator.reset();
        n3 = 0;
        while (indexIterator.hasNext()) {
            if (nArray[n] == n2) {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray)), (double)0.0, (double)dArray[indexIterator.index], (double)0.0);
                --n3;
            } else {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray)), (double)n3, (double)dArray[indexIterator.index], (double)(1.0E-5 * (double)n3));
            }
            ++n3;
        }
    }

    @Test
    public void testExpandedIterations() {
        int n = 1024;
        int n2 = 6;
        this.testExpandedIterationsND(n, n2);
        n2 = 8;
        this.testExpandedIterationsND(n, n2);
    }

    private void testExpandedIterationsND(int n, int n2) {
        int n3;
        int n4;
        System.out.println("Size: " + n);
        AbstractDataset abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2);
        abstractDataset.set(0, n);
        System.out.println(" New size: " + abstractDataset.getSize());
        this.testExpandedDataset(abstractDataset, 0, n);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, n / 16);
        int n5 = 0;
        int n6 = abstractDataset.getShape()[1];
        while (n5 < n6) {
            abstractDataset.set(0, 16, n5++);
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testExpandedDataset(abstractDataset, 0, 16);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 32, 32);
        n5 = 0;
        n6 = abstractDataset.getShape()[0];
        while (n5 < n6) {
            abstractDataset.set(0, n5++, 32);
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testExpandedDataset(abstractDataset, 1, 32);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, 8, n / 128);
        n5 = 0;
        n6 = abstractDataset.getShape()[1];
        while (n5 < n6) {
            n4 = 0;
            n3 = abstractDataset.getShape()[2];
            while (n4 < n3) {
                abstractDataset.set(0, 16, n5, n4++);
            }
            ++n5;
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testExpandedDataset(abstractDataset, 0, 16);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 128, 16, 8);
        n5 = 0;
        n6 = abstractDataset.getShape()[0];
        while (n5 < n6) {
            n4 = 0;
            n3 = abstractDataset.getShape()[1];
            while (n4 < n3) {
                abstractDataset.set(0, n5, n4++, 8);
            }
            ++n5;
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testExpandedDataset(abstractDataset, 2, 8);
    }

    private AbstractDataset oldSlice(AbstractDataset abstractDataset, SliceIterator sliceIterator) {
        int[] nArray = sliceIterator.getSliceShape();
        int n = nArray.length;
        int[] nArray2 = sliceIterator.getStart();
        int[] nArray3 = sliceIterator.getStep();
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(nArray, 6);
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray4[n2] = nArray2[n2];
            nArray5[n2] = 0;
            ++n2;
        }
        block1: do {
            abstractDataset2.set(abstractDataset.getDouble(nArray4), nArray5);
            n2 = n - 1;
            while (n2 >= 0) {
                int n3 = n2;
                nArray4[n3] = nArray4[n3] + nArray3[n2];
                int n4 = n2;
                nArray5[n4] = nArray5[n4] + 1;
                if (nArray5[n2] < nArray[n2]) continue block1;
                nArray4[n2] = nArray2[n2];
                nArray5[n2] = 0;
                --n2;
            }
        } while (n2 != -1);
        return abstractDataset2;
    }

    private void testSlicedDataset(AbstractDataset abstractDataset, int n, int n2, int n3, int n4) {
        long l;
        int n5 = abstractDataset.getRank();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        Arrays.fill(nArray, 1);
        while (n4 > n5) {
            n4 -= n5;
        }
        if (n4 < 0) {
            n4 += n5;
        }
        nArray[n4] = n3;
        while (n2 > n5) {
            n2 -= n5;
        }
        if (n2 < 0) {
            n2 += n5;
        }
        nArray2[n2] = n;
        int n6 = 7;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        AbstractDataset abstractDataset2 = null;
        SliceIterator sliceIterator = (SliceIterator)abstractDataset.getSliceIterator(nArray2, null, nArray);
        arrayList.clear();
        int n7 = 0;
        while (n7 < n6) {
            l = System.nanoTime();
            abstractDataset2 = this.oldSlice(abstractDataset, sliceIterator);
            arrayList.add(System.nanoTime() - l);
            ++n7;
        }
        Collections.sort(arrayList);
        double[] dArray = (double[])abstractDataset2.getBuffer();
        AbstractDataset abstractDataset3 = null;
        arrayList.clear();
        int n8 = 0;
        while (n8 < n6) {
            l = System.nanoTime();
            abstractDataset3 = abstractDataset.getSlice(nArray2, null, nArray);
            arrayList.add(System.nanoTime() - l);
            ++n8;
        }
        Collections.sort(arrayList);
        double[] dArray2 = (double[])abstractDataset3.getBuffer();
        IndexIterator indexIterator = abstractDataset3.getIterator();
        int n9 = 0;
        while (n9 < dArray.length && indexIterator.hasNext()) {
            Assert.assertEquals((double)dArray[n9], (double)dArray2[indexIterator.index], (double)(1.0E-5 * dArray[n9]));
            ++n9;
        }
    }

    @Test
    public void testSliceIteration() {
        int n = 60;
        int n2 = 6;
        this.testSliceIterationND(n, n2);
        n2 = 8;
        this.testSliceIterationND(n, n2);
    }

    private void testSliceIterationND(int n, int n2) {
        System.out.println(" Size: " + n);
        AbstractDataset abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2);
        this.testSlicedDataset(abstractDataset, 0, 0, 3, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, 62, 0);
        this.testSlicedDataset(abstractDataset, 23, 0, 3, 0);
        this.testSlicedDataset(abstractDataset, 23, 0, 62, 0);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 15, 15);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testSlicedDataset(abstractDataset, 0, 0, 3, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, 3, 1);
        this.testSlicedDataset(abstractDataset, 2, 0, 3, 0);
        this.testSlicedDataset(abstractDataset, 2, 0, 3, 1);
        this.testSlicedDataset(abstractDataset, 3, 1, 3, 0);
        this.testSlicedDataset(abstractDataset, 3, 1, 3, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, 4, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, 4, 1);
        this.testSlicedDataset(abstractDataset, 2, 0, 4, 0);
        this.testSlicedDataset(abstractDataset, 2, 0, 4, 1);
        this.testSlicedDataset(abstractDataset, 3, 1, 4, 0);
        this.testSlicedDataset(abstractDataset, 3, 1, 4, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, -1, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, -1, 1);
        this.testSlicedDataset(abstractDataset, 2, 0, -1, 0);
        this.testSlicedDataset(abstractDataset, 2, 0, -1, 1);
        this.testSlicedDataset(abstractDataset, 3, 1, -1, 0);
        this.testSlicedDataset(abstractDataset, 3, 1, -1, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, -2, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, -2, 1);
        this.testSlicedDataset(abstractDataset, 2, 0, -2, 0);
        this.testSlicedDataset(abstractDataset, 2, 0, -2, 1);
        this.testSlicedDataset(abstractDataset, 3, 1, -2, 0);
        this.testSlicedDataset(abstractDataset, 3, 1, -2, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, -3, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, -3, 1);
        this.testSlicedDataset(abstractDataset, 2, 0, -3, 0);
        this.testSlicedDataset(abstractDataset, 2, 0, -3, 1);
        this.testSlicedDataset(abstractDataset, 3, 1, -3, 0);
        this.testSlicedDataset(abstractDataset, 3, 1, -3, 1);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 10, 2, 5);
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testSlicedDataset(abstractDataset, 0, 0, 3, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, 3, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, 3, 2);
        this.testSlicedDataset(abstractDataset, 3, 0, 3, 0);
        this.testSlicedDataset(abstractDataset, 3, 0, 3, 1);
        this.testSlicedDataset(abstractDataset, 3, 0, 3, 2);
        this.testSlicedDataset(abstractDataset, 1, 1, 3, 0);
        this.testSlicedDataset(abstractDataset, 1, 1, 3, 1);
        this.testSlicedDataset(abstractDataset, 1, 1, 3, 2);
        this.testSlicedDataset(abstractDataset, 2, 2, 3, 0);
        this.testSlicedDataset(abstractDataset, 2, 2, 3, 1);
        this.testSlicedDataset(abstractDataset, 2, 2, 3, 2);
        this.testSlicedDataset(abstractDataset, 0, 0, 4, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, 4, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, 4, 2);
        this.testSlicedDataset(abstractDataset, 3, 0, 4, 0);
        this.testSlicedDataset(abstractDataset, 3, 0, 4, 1);
        this.testSlicedDataset(abstractDataset, 3, 0, 4, 2);
        this.testSlicedDataset(abstractDataset, 1, 1, 4, 0);
        this.testSlicedDataset(abstractDataset, 1, 1, 4, 1);
        this.testSlicedDataset(abstractDataset, 1, 1, 4, 2);
        this.testSlicedDataset(abstractDataset, 2, 2, 4, 0);
        this.testSlicedDataset(abstractDataset, 2, 2, 4, 1);
        this.testSlicedDataset(abstractDataset, 2, 2, 4, 2);
        this.testSlicedDataset(abstractDataset, 0, 0, -1, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, -1, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, -1, 2);
        this.testSlicedDataset(abstractDataset, 3, 0, -1, 0);
        this.testSlicedDataset(abstractDataset, 3, 0, -1, 1);
        this.testSlicedDataset(abstractDataset, 3, 0, -1, 2);
        this.testSlicedDataset(abstractDataset, 1, 1, -1, 0);
        this.testSlicedDataset(abstractDataset, 1, 1, -1, 1);
        this.testSlicedDataset(abstractDataset, 1, 1, -1, 2);
        this.testSlicedDataset(abstractDataset, 2, 2, -1, 0);
        this.testSlicedDataset(abstractDataset, 2, 2, -1, 1);
        this.testSlicedDataset(abstractDataset, 2, 2, -1, 2);
        this.testSlicedDataset(abstractDataset, 0, 0, -2, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, -2, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, -2, 2);
        this.testSlicedDataset(abstractDataset, 3, 0, -2, 0);
        this.testSlicedDataset(abstractDataset, 3, 0, -2, 1);
        this.testSlicedDataset(abstractDataset, 3, 0, -2, 2);
        this.testSlicedDataset(abstractDataset, 1, 1, -2, 0);
        this.testSlicedDataset(abstractDataset, 1, 1, -2, 1);
        this.testSlicedDataset(abstractDataset, 1, 1, -2, 2);
        this.testSlicedDataset(abstractDataset, 2, 2, -2, 0);
        this.testSlicedDataset(abstractDataset, 2, 2, -2, 1);
        this.testSlicedDataset(abstractDataset, 2, 2, -2, 2);
        this.testSlicedDataset(abstractDataset, 0, 0, -3, 0);
        this.testSlicedDataset(abstractDataset, 0, 0, -3, 1);
        this.testSlicedDataset(abstractDataset, 0, 0, -3, 2);
        this.testSlicedDataset(abstractDataset, 3, 0, -3, 0);
        this.testSlicedDataset(abstractDataset, 3, 0, -3, 1);
        this.testSlicedDataset(abstractDataset, 3, 0, -3, 2);
        this.testSlicedDataset(abstractDataset, 1, 1, -3, 0);
        this.testSlicedDataset(abstractDataset, 1, 1, -3, 1);
        this.testSlicedDataset(abstractDataset, 1, 1, -3, 2);
        this.testSlicedDataset(abstractDataset, 2, 2, -3, 0);
        this.testSlicedDataset(abstractDataset, 2, 2, -3, 1);
        this.testSlicedDataset(abstractDataset, 2, 2, -3, 2);
    }

    private int get1DIndex(int[] nArray, int[] nArray2) {
        int n = nArray2.length;
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < n) {
            n2 = n2 * nArray2[n3] + nArray[n3];
            ++n3;
        }
        return n2;
    }

    private int[] getNDPosition(int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = n;
        int n4 = n2 - 1;
        while (n4 > 0) {
            nArray2[n4] = n3 % nArray[n4];
            n3 /= nArray[n4];
            --n4;
        }
        nArray2[0] = n3;
        return nArray2;
    }

    private void testSlicedExpandedDataset(AbstractDataset abstractDataset, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = abstractDataset.getRank();
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n7];
        Arrays.fill(nArray2, 1);
        while (n6 > n7) {
            n6 -= n7;
        }
        if (n6 < 0) {
            n6 += n7;
        }
        nArray2[n6] = n5;
        while (n4 > n7) {
            n4 -= n7;
        }
        if (n4 < 0) {
            n4 += n7;
        }
        nArray3[n4] = n3;
        SliceIterator sliceIterator = (SliceIterator)abstractDataset.getSliceIterator((int[])nArray3.clone(), null, nArray2);
        int[] nArray4 = sliceIterator.getPos();
        int[] nArray5 = sliceIterator.getSliceShape();
        nArray5 = this.getSliceShape(nArray, nArray3, nArray2);
        double[] dArray = (double[])abstractDataset.getBuffer();
        int n8 = 0;
        while (sliceIterator.hasNext()) {
            if (nArray4[n] == n2) {
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray4)), (double)0.0, (double)dArray[sliceIterator.index], (double)0.0);
                --n8;
            } else {
                int[] nArray6 = this.getNDPosition(n8, nArray5);
                int n9 = n6;
                nArray6[n9] = nArray6[n9] * n5;
                if (nArray6[n6] >= nArray[n6]) {
                    nArray6[n6] = 0;
                    if (n6 > 0) {
                        int n10 = n6 - 1;
                        nArray6[n10] = nArray6[n10] + 1;
                    }
                }
                int n11 = n4;
                nArray6[n11] = nArray6[n11] + n3;
                int n12 = n4;
                int n13 = nArray6[n12] - nArray[n12];
                while (n13 >= 0 && n12 > 0) {
                    nArray6[n12] = n13;
                    if (n12 == n4) {
                        int n14 = n12;
                        nArray6[n14] = nArray6[n14] + n3;
                    }
                    if (n12 - 1 == n6) {
                        int n15 = n12 - 1;
                        nArray6[n15] = nArray6[n15] + n5;
                    } else {
                        int n16 = n12 - 1;
                        nArray6[n16] = nArray6[n16] + 1;
                    }
                    n13 = nArray6[--n12] - nArray[n12];
                }
                int n17 = this.get1DIndex(nArray6, nArray);
                Assert.assertEquals((String)("Position " + Arrays.toString(nArray4)), (double)n17, (double)dArray[sliceIterator.index], (double)(1.0E-5 * (double)n8));
            }
            ++n8;
        }
    }

    private int[] getSliceShape(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        int[] nArray4 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            if (nArray2[n2] < 0) {
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + nArray[n2];
            }
            if (nArray2[n2] < 0) {
                int n4 = nArray2[n2] = nArray3[n2] > 0 ? 0 : -1;
            }
            if (nArray2[n2] > nArray[n2]) {
                nArray2[n2] = nArray3[n2] > 0 ? nArray[n2] : nArray[n2] - 1;
            }
            int n5 = nArray3[n2] > 0 ? nArray[n2] : -1;
            nArray4[n2] = nArray3[n2] > 0 ? (n5 - nArray2[n2] - 1) / nArray3[n2] + 1 : (n5 - nArray2[n2] + 1) / nArray3[n2] + 1;
            ++n2;
        }
        return nArray4;
    }

    @Test
    public void testExpandedSliceIterations() {
        int n = 1024;
        int n2 = 6;
        this.testExpandedSliceIterationND(n, n2);
        n2 = 8;
        this.testExpandedSliceIterationND(n, n2);
    }

    private void testExpandedSliceIterationND(int n, int n2) {
        int n3;
        int n4;
        System.out.println("Size: " + n);
        AbstractDataset abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2);
        int[] nArray = (int[])abstractDataset.getShape().clone();
        abstractDataset.set(0, n);
        System.out.println(" New size: " + abstractDataset.getSize());
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, n, 0, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, n, 0, 0, n + 1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, n, 23, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, n, 23, 0, n + 1, 0);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, n / 16);
        nArray = (int[])abstractDataset.getShape().clone();
        int n5 = 0;
        int n6 = abstractDataset.getShape()[1];
        while (n5 < n6) {
            abstractDataset.set(0, 16, n5++);
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 1, -3, 1);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 32, 32);
        nArray = (int[])abstractDataset.getShape().clone();
        n5 = 0;
        n6 = abstractDataset.getShape()[0];
        while (n5 < n6) {
            abstractDataset.set(0, n5++, 32);
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 0, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 2, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 1, 32, 3, 1, -3, 1);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(16, 8, n / 128);
        nArray = (int[])abstractDataset.getShape().clone();
        n5 = 0;
        n6 = abstractDataset.getShape()[1];
        while (n5 < n6) {
            n4 = 0;
            n3 = abstractDataset.getShape()[2];
            while (n4 < n3) {
                abstractDataset.set(0, 16, n5, n4++);
            }
            ++n5;
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 0, 0, -3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 3, 0, -3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 1, 1, -3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 0, 16, 2, 2, -3, 2);
        abstractDataset = AbstractDataset.arange(0.0, n, 1.0, n2).reshape(n / 128, 16, 8);
        nArray = (int[])abstractDataset.getShape().clone();
        n5 = 0;
        n6 = abstractDataset.getShape()[0];
        while (n5 < n6) {
            n4 = 0;
            n3 = abstractDataset.getShape()[1];
            while (n4 < n3) {
                abstractDataset.set(0, n5, n4++, 8);
            }
            ++n5;
        }
        System.out.println(" New size: " + abstractDataset.getSize());
        System.out.println(" Shape: " + Arrays.toString(abstractDataset.getShape()));
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, 3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, 3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, 3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, 4, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, 4, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, 4, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -1, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -1, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -1, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -2, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -2, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -2, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 0, 0, -3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 3, 0, -3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 1, 1, -3, 2);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -3, 0);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -3, 1);
        this.testSlicedExpandedDataset(abstractDataset, nArray, 2, 8, 2, 2, -3, 2);
    }
}

