/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class FloatDatasetTest {
    @Test
    public void testConstructor() {
        float[] fArray = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f};
        FloatDataset floatDataset = new FloatDataset(fArray, new int[0]);
        IndexIterator indexIterator = floatDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)floatDataset.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n));
            ++n;
        }
        FloatDataset floatDataset2 = new FloatDataset(fArray, 3, 4);
        indexIterator = floatDataset2.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n2, (double)floatDataset2.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n2));
            ++n2;
        }
    }

    @Test
    public void testStats() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 5);
        Assert.assertEquals((double)11.0, (double)abstractDataset.max().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)abstractDataset.min().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)abstractDataset.mean()).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)abstractDataset.stdDeviation().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)abstractDataset.variance().doubleValue(), (double)1.0E-6);
    }
}

