/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class FloatDataset
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final transient Logger logger = LoggerFactory.getLogger(FloatDataset.class);
    protected float[] data;

    @Override
    protected void setData() {
        this.data = (float[])this.odata;
    }

    private static float[] createArray(int n) {
        float[] fArray = null;
        try {
            fArray = new float[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)n);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return fArray;
    }

    @Override
    public int getDtype() {
        return 5;
    }

    public FloatDataset() {
    }

    public FloatDataset(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = FloatDataset.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = FloatDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = FloatDataset.createArray(this.size);
            this.odata = this.data;
        }
    }

    public FloatDataset(float[] fArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{fArray.length};
        }
        this.size = FloatDataset.calcSize(nArray);
        if (this.size != fArray.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(nArray), fArray.length));
        }
        this.shape = (int[])nArray.clone();
        this.data = fArray;
        this.odata = fArray;
    }

    public FloatDataset(FloatDataset floatDataset) {
        this(floatDataset, false);
    }

    public FloatDataset(FloatDataset floatDataset, boolean bl) {
        this.size = floatDataset.size;
        if (bl) {
            this.shape = floatDataset.shape;
            this.dataSize = floatDataset.dataSize;
            this.dataShape = floatDataset.dataShape;
            this.name = floatDataset.name;
            this.metadataStructure = floatDataset.metadataStructure;
            this.data = floatDataset.data;
            this.odata = floatDataset.data;
            return;
        }
        this.shape = (int[])floatDataset.shape.clone();
        this.name = new String(floatDataset.name);
        if (floatDataset.metadataStructure != null) {
            this.metadataStructure = floatDataset.metadataStructure.clone();
        }
        float[] fArray = floatDataset.data;
        if (floatDataset.isContiguous()) {
            this.data = (float[])fArray.clone();
            this.odata = this.data;
        } else {
            this.data = FloatDataset.createArray(this.size);
            this.odata = this.data;
            IndexIterator indexIterator = floatDataset.getIterator();
            int n = 0;
            while (indexIterator.hasNext()) {
                this.data[n] = fArray[indexIterator.index];
                ++n;
            }
        }
        this.errorValue = floatDataset.errorValue;
        this.errorData = floatDataset.errorData;
    }

    public FloatDataset(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.data = FloatDataset.createArray(this.size);
        this.odata = this.data;
        this.metadataStructure = abstractDataset.metadataStructure;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            ++n;
        }
        this.errorValue = abstractDataset.errorValue;
        this.errorData = abstractDataset.errorData;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this.getRank() == 0) {
            return true;
        }
        FloatDataset floatDataset = (FloatDataset)object;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] == floatDataset.data[indexIterator.index]) continue;
            return false;
        }
        return true;
    }

    public static FloatDataset createFromObject(Object object) {
        FloatDataset floatDataset = new FloatDataset();
        floatDataset.shape = FloatDataset.getShapeFromObject(object);
        floatDataset.size = FloatDataset.calcSize(floatDataset.shape);
        floatDataset.data = FloatDataset.createArray(floatDataset.size);
        floatDataset.odata = floatDataset.data;
        int[] nArray = new int[floatDataset.shape.length];
        floatDataset.fillData(object, 0, nArray);
        return floatDataset;
    }

    public static FloatDataset arange(double d) {
        return FloatDataset.arange(0.0, d, 1.0);
    }

    public static FloatDataset arange(double d, double d2, double d3) {
        int n = FloatDataset.calcSteps(d, d2, d3);
        FloatDataset floatDataset = new FloatDataset(n);
        int n2 = 0;
        while (n2 < n) {
            floatDataset.data[n2] = (float)(d + (double)n2 * d3);
            ++n2;
        }
        return floatDataset;
    }

    public static FloatDataset ones(int ... nArray) {
        return new FloatDataset(nArray).fill(1);
    }

    @Override
    public FloatDataset fill(Object object) {
        float f = (float)FloatDataset.toReal(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = f;
        }
        return this;
    }

    public float[] getData() {
        return this.data;
    }

    @Override
    public FloatDataset getView() {
        FloatDataset floatDataset = new FloatDataset();
        floatDataset.name = new String(this.name);
        floatDataset.size = this.size;
        floatDataset.dataSize = this.dataSize;
        floatDataset.shape = (int[])this.shape.clone();
        if (this.dataShape != null) {
            floatDataset.dataShape = (int[])this.dataShape.clone();
        }
        floatDataset.data = this.data;
        floatDataset.odata = this.data;
        floatDataset.metadataStructure = this.metadataStructure;
        return floatDataset;
    }

    public float getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return this.data[n] != 0.0f;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return (long)this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        return Float.valueOf(this.data[n]);
    }

    @Override
    public String getStringAbs(int n) {
        return String.format("%.8g", Float.valueOf(this.data[n]));
    }

    public void setAbs(int n, float f) {
        this.data[n] = f;
        this.setDirty();
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        float[] fArray = (float[])object;
        this.data[n] = fArray[n2];
    }

    @Override
    public void setObjectAbs(int n, Object object) {
        if (n < 0 || n > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(n, (float)FloatDataset.toReal(object));
    }

    public float get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public Object getObject(int ... nArray) {
        return Float.valueOf(this.get(nArray));
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return (long)this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return (int)this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return (short)this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0.0f;
    }

    @Override
    public String getString(int ... nArray) {
        return this.getStringAbs(this.get1DIndex(nArray));
    }

    public void setItem(float f, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                int[] nArray2 = (int[])this.shape.clone();
                int n = 0;
                while (n < nArray.length) {
                    if (nArray[n] >= nArray2[n]) {
                        nArray2[n] = nArray[n] + 1;
                    }
                    ++n;
                }
                this.allocateArray(nArray2);
            }
            this.setAbs(this.get1DIndex(nArray), f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Dimensionalities of requested position, %d, and dataset, %d, are incompatible", nArray.length, this.shape.length));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem((float)FloatDataset.toReal(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = FloatDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = FloatDataset.calcSize(this.dataShape);
        float[] fArray = FloatDataset.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = FloatDataset.calcSize(nArray);
        Arrays.fill(fArray, Float.NaN);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            fArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = fArray;
        this.odata = fArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = FloatDataset.calcSize(nArray);
        float[] fArray = FloatDataset.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            fArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = fArray;
        this.odata = fArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public FloatDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.getSlice((SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3));
    }

    @Override
    public FloatDataset getSlice(SliceIterator sliceIterator) {
        FloatDataset floatDataset = new FloatDataset(sliceIterator.getSliceShape());
        float[] fArray = floatDataset.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            fArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        floatDataset.setName(String.valueOf(this.name) + ".slice");
        return floatDataset;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        float[] fArray = ((FloatDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            fArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public FloatDataset setByBoolean(Object object, BooleanDataset booleanDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            }
        } else {
            float f = (float)FloatDataset.toReal(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = f;
            }
        }
        return this;
    }

    @Override
    public FloatDataset setByIndex(Object object, IntegerDataset integerDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
            }
        } else {
            float f = (float)FloatDataset.toReal(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = f;
            }
        }
        return this;
    }

    @Override
    public FloatDataset setSlice(Object object, SliceIterator sliceIterator) {
        if (object instanceof IDataset) {
            IDataset iDataset = (IDataset)object;
            int[] nArray = iDataset.getShape();
            if (!FloatDataset.areShapesCompatible(sliceIterator.getSliceShape(), nArray)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(nArray), Arrays.toString(sliceIterator.getSliceShape())));
            }
            if (iDataset instanceof AbstractDataset) {
                AbstractDataset abstractDataset = (AbstractDataset)iDataset;
                IndexIterator indexIterator = abstractDataset.getIterator();
                while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                    this.data[sliceIterator.index] = (float)abstractDataset.getElementDoubleAbs(indexIterator.index);
                }
            } else {
                PositionIterator positionIterator = new PositionIterator(nArray);
                int[] nArray2 = ((IndexIterator)positionIterator).getPos();
                while (sliceIterator.hasNext() && ((IndexIterator)positionIterator).hasNext()) {
                    this.data[sliceIterator.index] = iDataset.getFloat(nArray2);
                }
            }
        } else {
            try {
                float f = (float)FloatDataset.toReal(object);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = f;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (float[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = FloatDataset.squeezeShape(var5_5.getSliceShape(), false);
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= FloatDataset.calcSize(var6_6)) ** GOTO lbl8
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl8:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl9:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        float[] fArray = (float[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (fArray.length < FloatDataset.calcSize(sliceIterator.getSliceShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = fArray[n];
            ++n;
        }
        this.setDirty();
    }

    private List<Integer> findPositions(float f) {
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != f) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(this.max().floatValue());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof List) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(this.min().floatValue());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Float.isNaN(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInfs() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Float.isInfinite(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            float f = this.data[indexIterator.index];
            if (!Float.isNaN(f) && !Float.isInfinite(f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FloatDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] + abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] + d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] - abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] - d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] * abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] * d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] / abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] / d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset ifloor() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = (float)Math.floor(this.data[indexIterator.index]);
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] % abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = (float)((double)this.data[n] % d);
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public FloatDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d = Math.pow(this.data[indexIterator.index], abstractDataset.getElementDoubleAbs(indexIterator2.index));
                this.data[indexIterator.index] = (float)d;
            }
        } else {
            double d = FloatDataset.toReal(object);
            double d2 = FloatDataset.toImag(object);
            IndexIterator indexIterator = this.getIterator();
            if (d2 == 0.0) {
                while (indexIterator.hasNext()) {
                    double d3 = Math.pow(this.data[indexIterator.index], d);
                    this.data[indexIterator.index] = (float)d3;
                }
            } else {
                Complex complex = new Complex(d, d2);
                while (indexIterator.hasNext()) {
                    Complex complex2 = new Complex((double)this.data[indexIterator.index], 0.0);
                    double d4 = complex2.pow(complex).getReal();
                    this.data[indexIterator.index] = (float)d4;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d4 = d3 * d3 - d2;
                double d5 = d + d4;
                d2 = d5 - d - d4;
                d = d5;
            }
        } else {
            double d6 = FloatDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            double d7 = 0.0;
            while (indexIterator.hasNext()) {
                double d8 = (double)this.data[indexIterator.index] - d6;
                double d9 = d8 * d8 - d7;
                double d10 = d + d9;
                d7 = d10 - d - d9;
                d = d10;
            }
        }
        return d;
    }
}

