/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;

public class DoubleDatasetTest {
    private static final int WARMUP = 3;
    private static final int REPEAT = 7;

    @Test
    public void testConstructor() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset doubleDataset = new DoubleDataset(dArray, new int[0]);
        IndexIterator indexIterator = doubleDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)doubleDataset.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n));
            ++n;
        }
        DoubleDataset doubleDataset2 = new DoubleDataset(dArray, 3, 4);
        indexIterator = doubleDataset2.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n2, (double)doubleDataset2.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n2));
            ++n2;
        }
    }

    @Test
    public void testCreators() {
        double d = 0.5;
        DoubleDataset doubleDataset = DoubleDataset.createFromObject(d);
        Assert.assertEquals((long)0L, (long)doubleDataset.getRank());
        Assert.assertEquals((long)1L, (long)doubleDataset.getSize());
        Assert.assertEquals((double)d, (double)doubleDataset.getElementDoubleAbs(0), (double)1.0E-14);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        DoubleDataset doubleDataset2 = DoubleDataset.createFromObject(dArray);
        Assert.assertEquals((long)1L, (long)doubleDataset2.getRank());
        Assert.assertEquals((long)6L, (long)doubleDataset2.getSize());
        Assert.assertEquals((long)6L, (long)doubleDataset2.getShape()[0]);
        IndexIterator indexIterator = doubleDataset2.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n, (double)doubleDataset2.getElementDoubleAbs(indexIterator.index), (double)(1.0E-15 * (double)n));
            ++n;
        }
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DoubleDataset doubleDataset3 = DoubleDataset.createFromObject(dArrayArray);
        Assert.assertEquals((long)2L, (long)doubleDataset3.getRank());
        Assert.assertEquals((long)6L, (long)doubleDataset3.getSize());
        Assert.assertEquals((long)2L, (long)doubleDataset3.getShape()[0]);
        Assert.assertEquals((long)3L, (long)doubleDataset3.getShape()[1]);
        indexIterator = doubleDataset3.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)n2, (double)doubleDataset3.getElementDoubleAbs(indexIterator.index), (double)(1.0E-15 * (double)n2));
            ++n2;
        }
        double[][] dArrayArray2 = new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}};
        DoubleDataset doubleDataset4 = DoubleDataset.createFromObject(dArrayArray2);
        Assert.assertEquals((long)2L, (long)doubleDataset4.getRank());
        Assert.assertEquals((long)8L, (long)doubleDataset4.getSize());
        Assert.assertEquals((long)2L, (long)doubleDataset4.getShape()[0]);
        Assert.assertEquals((long)4L, (long)doubleDataset4.getShape()[1]);
        indexIterator = doubleDataset4.getIterator();
        int n3 = 0;
        while (indexIterator.hasNext()) {
            if (n3 < 7) {
                Assert.assertEquals((double)n3, (double)doubleDataset4.getElementDoubleAbs(indexIterator.index), (double)(1.0E-15 * (double)n3));
            } else {
                Assert.assertEquals((double)0.0, (double)doubleDataset4.getElementDoubleAbs(indexIterator.index), (double)1.0E-15);
            }
            ++n3;
        }
        double[][] dArrayArray3 = new double[][]{{0.0, 1.0, 2.0}, {4.0, 5.0, 6.0, 7.0}};
        DoubleDataset doubleDataset5 = DoubleDataset.createFromObject(dArrayArray3);
        Assert.assertEquals((long)2L, (long)doubleDataset5.getRank());
        Assert.assertEquals((long)8L, (long)doubleDataset5.getSize());
        Assert.assertEquals((long)2L, (long)doubleDataset5.getShape()[0]);
        Assert.assertEquals((long)4L, (long)doubleDataset5.getShape()[1]);
        indexIterator = doubleDataset5.getIterator();
        int n4 = 0;
        while (indexIterator.hasNext()) {
            if (n4 != 3) {
                Assert.assertEquals((double)n4, (double)doubleDataset5.getElementDoubleAbs(indexIterator.index), (double)(1.0E-15 * (double)n4));
            } else {
                Assert.assertEquals((double)0.0, (double)doubleDataset5.getElementDoubleAbs(indexIterator.index), (double)1.0E-15);
            }
            ++n4;
        }
    }

    @Test
    public void testStats() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        Assert.assertEquals((double)11.0, (double)abstractDataset.max().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)abstractDataset.min().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)abstractDataset.mean()).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)abstractDataset.stdDeviation().doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)abstractDataset.variance().doubleValue(), (double)1.0E-6);
        abstractDataset.setShape(3, 1, 4);
        AbstractDataset abstractDataset2 = abstractDataset.sum(0);
        Assert.assertEquals((long)2L, (long)abstractDataset2.getRank());
        Assert.assertArrayEquals((int[])new int[]{1, 4}, (int[])abstractDataset2.getShape());
        Assert.assertEquals((double)12.0, (double)abstractDataset2.getDouble(0, 0), (double)1.0E-6);
        Assert.assertEquals((double)15.0, (double)abstractDataset2.getDouble(0, 1), (double)1.0E-6);
        Assert.assertEquals((double)18.0, (double)abstractDataset2.getDouble(0, 2), (double)1.0E-6);
        Assert.assertEquals((double)21.0, (double)abstractDataset2.getDouble(0, 3), (double)1.0E-6);
        abstractDataset2 = abstractDataset.sum(1);
        Assert.assertEquals((long)2L, (long)abstractDataset2.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])abstractDataset2.getShape());
        Assert.assertEquals((Object)abstractDataset.squeeze(), (Object)abstractDataset2);
        abstractDataset.setShape(3, 1, 4);
        abstractDataset2 = abstractDataset.sum(2);
        Assert.assertEquals((long)2L, (long)abstractDataset2.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 1}, (int[])abstractDataset2.getShape());
        Assert.assertEquals((double)6.0, (double)abstractDataset2.getDouble(0), (double)1.0E-6);
        Assert.assertEquals((double)22.0, (double)abstractDataset2.getDouble(1), (double)1.0E-6);
        Assert.assertEquals((double)38.0, (double)abstractDataset2.getDouble(2), (double)1.0E-6);
    }

    @Test
    public void testMaths() {
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset doubleDataset = new DoubleDataset(dArray, new int[0]);
        AbstractDataset abstractDataset = Maths.add((AbstractDataset)doubleDataset, doubleDataset);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)(2.0 * (double)n), (double)abstractDataset.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n));
            ++n;
        }
    }

    @Test
    @Ignore(value="This test is for benchmarking only")
    public void testExtending() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 100000;
        arrayList.clear();
        int n2 = 0;
        while (n2 < 7) {
            double d = this.timeList(100, n);
            arrayList.add(d);
            ++n2;
        }
        TimeStats timeStats = new TimeStats(arrayList);
        arrayList.clear();
        int n3 = 0;
        while (n3 < 7) {
            double d = this.timeDataset(100, n);
            arrayList.add(d);
            ++n3;
        }
        TimeStats timeStats2 = new TimeStats(arrayList);
        System.out.printf("Time taken by extend for %s: %s; %s (%.1f%%)\n", n, timeStats, timeStats2, 100.0 * (timeStats.getValue() - timeStats2.getValue()) / timeStats.getValue());
    }

    private double timeDataset(int n, int n2) {
        int n3 = 0;
        while (n3 < 3) {
            this.extendDataset(n2);
            ++n3;
        }
        long l = -System.nanoTime();
        int n4 = 0;
        while (n4 < n) {
            this.extendDataset(n2);
            ++n4;
        }
        return (double)(l += System.nanoTime()) / (double)n;
    }

    private void extendDataset(int n) {
        DoubleDataset doubleDataset = DoubleDataset.arange(100.0);
        int n2 = 0;
        while (n2 < n) {
            doubleDataset.setItem(n2, n2);
            ++n2;
        }
    }

    private double timeList(int n, int n2) {
        int n3 = 0;
        while (n3 < 3) {
            this.extendList(n2);
            ++n3;
        }
        long l = -System.nanoTime();
        int n4 = 0;
        while (n4 < n) {
            this.extendList(n2);
            ++n4;
        }
        return (double)(l += System.nanoTime()) / (double)n;
    }

    private void extendList(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(100);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(Double.valueOf(n2));
            ++n2;
        }
    }

    class TimeStats {
        double min;
        double max;
        double med;

        public TimeStats(List<Double> list) {
            Collections.sort(list);
            int n = list.size();
            this.min = list.get(0) * 1.0E-6;
            this.max = list.get(n - 1) * 1.0E-6;
            this.med = list.get(n / 2) * 1.0E-6;
        }

        public String toString() {
            return String.format("(%.2f, %.2f, %.2f ms)", this.min, this.max, this.med);
        }

        public double getValue() {
            return this.min;
        }
    }
}

