/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class DoubleDataset
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final transient Logger logger = LoggerFactory.getLogger(DoubleDataset.class);
    protected double[] data;

    @Override
    protected void setData() {
        this.data = (double[])this.odata;
    }

    private static double[] createArray(int n) {
        double[] dArray = null;
        try {
            dArray = new double[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)n);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return dArray;
    }

    @Override
    public int getDtype() {
        return 6;
    }

    public DoubleDataset() {
    }

    public DoubleDataset(int ... nArray) {
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = DoubleDataset.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = DoubleDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = DoubleDataset.createArray(this.size);
            this.odata = this.data;
        }
    }

    public DoubleDataset(double[] dArray, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{dArray.length};
        }
        this.size = DoubleDataset.calcSize(nArray);
        if (this.size != dArray.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(nArray), dArray.length));
        }
        this.shape = (int[])nArray.clone();
        this.data = dArray;
        this.odata = dArray;
    }

    public DoubleDataset(DoubleDataset doubleDataset) {
        this(doubleDataset, false);
    }

    public DoubleDataset(DoubleDataset doubleDataset, boolean bl) {
        this.size = doubleDataset.size;
        if (bl) {
            this.shape = doubleDataset.shape;
            this.dataSize = doubleDataset.dataSize;
            this.dataShape = doubleDataset.dataShape;
            this.name = doubleDataset.name;
            this.metadataStructure = doubleDataset.metadataStructure;
            this.data = doubleDataset.data;
            this.odata = doubleDataset.data;
            return;
        }
        this.shape = (int[])doubleDataset.shape.clone();
        this.name = new String(doubleDataset.name);
        if (doubleDataset.metadataStructure != null) {
            this.metadataStructure = doubleDataset.metadataStructure.clone();
        }
        double[] dArray = doubleDataset.data;
        if (doubleDataset.isContiguous()) {
            this.data = (double[])dArray.clone();
            this.odata = this.data;
        } else {
            this.data = DoubleDataset.createArray(this.size);
            this.odata = this.data;
            IndexIterator indexIterator = doubleDataset.getIterator();
            int n = 0;
            while (indexIterator.hasNext()) {
                this.data[n] = dArray[indexIterator.index];
                ++n;
            }
        }
        this.errorValue = doubleDataset.errorValue;
        this.errorData = doubleDataset.errorData;
    }

    public DoubleDataset(AbstractDataset abstractDataset) {
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.data = DoubleDataset.createArray(this.size);
        this.odata = this.data;
        this.metadataStructure = abstractDataset.metadataStructure;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = abstractDataset.getElementDoubleAbs(indexIterator.index);
            ++n;
        }
        this.errorValue = abstractDataset.errorValue;
        this.errorData = abstractDataset.errorData;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this.getRank() == 0) {
            return true;
        }
        DoubleDataset doubleDataset = (DoubleDataset)object;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] == doubleDataset.data[indexIterator.index]) continue;
            return false;
        }
        return true;
    }

    public static DoubleDataset createFromObject(Object object) {
        DoubleDataset doubleDataset = new DoubleDataset();
        doubleDataset.shape = DoubleDataset.getShapeFromObject(object);
        doubleDataset.size = DoubleDataset.calcSize(doubleDataset.shape);
        doubleDataset.data = DoubleDataset.createArray(doubleDataset.size);
        doubleDataset.odata = doubleDataset.data;
        int[] nArray = new int[doubleDataset.shape.length];
        doubleDataset.fillData(object, 0, nArray);
        return doubleDataset;
    }

    public static DoubleDataset arange(double d) {
        return DoubleDataset.arange(0.0, d, 1.0);
    }

    public static DoubleDataset arange(double d, double d2, double d3) {
        int n = DoubleDataset.calcSteps(d, d2, d3);
        DoubleDataset doubleDataset = new DoubleDataset(n);
        int n2 = 0;
        while (n2 < n) {
            doubleDataset.data[n2] = d + (double)n2 * d3;
            ++n2;
        }
        return doubleDataset;
    }

    public static DoubleDataset ones(int ... nArray) {
        return new DoubleDataset(nArray).fill(1);
    }

    @Override
    public DoubleDataset fill(Object object) {
        double d = DoubleDataset.toReal(object);
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = d;
        }
        return this;
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    public DoubleDataset getView() {
        DoubleDataset doubleDataset = new DoubleDataset();
        doubleDataset.name = new String(this.name);
        doubleDataset.size = this.size;
        doubleDataset.dataSize = this.dataSize;
        doubleDataset.shape = (int[])this.shape.clone();
        if (this.dataShape != null) {
            doubleDataset.dataShape = (int[])this.dataShape.clone();
        }
        doubleDataset.data = this.data;
        doubleDataset.odata = this.data;
        doubleDataset.metadataStructure = this.metadataStructure;
        return doubleDataset;
    }

    public double getAbs(int n) {
        return this.data[n];
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        return this.data[n] != 0.0;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return (long)this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        return this.data[n];
    }

    @Override
    public String getStringAbs(int n) {
        return String.format("%.8g", this.data[n]);
    }

    public void setAbs(int n, double d) {
        this.data[n] = d;
        this.setDirty();
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        double[] dArray = (double[])object;
        this.data[n] = dArray[n2];
    }

    @Override
    public void setObjectAbs(int n, Object object) {
        if (n < 0 || n > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(n, DoubleDataset.toReal(object));
    }

    public double get(int ... nArray) {
        return this.data[this.get1DIndex(nArray)];
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public double getDouble(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public float getFloat(int ... nArray) {
        return (float)this.get(nArray);
    }

    @Override
    public long getLong(int ... nArray) {
        return (long)this.get(nArray);
    }

    @Override
    public int getInt(int ... nArray) {
        return (int)this.get(nArray);
    }

    @Override
    public short getShort(int ... nArray) {
        return (short)this.get(nArray);
    }

    @Override
    public byte getByte(int ... nArray) {
        return (byte)this.get(nArray);
    }

    @Override
    public boolean getBoolean(int ... nArray) {
        return this.get(nArray) != 0.0;
    }

    @Override
    public String getString(int ... nArray) {
        return this.getStringAbs(this.get1DIndex(nArray));
    }

    public void setItem(double d, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                int[] nArray2 = (int[])this.shape.clone();
                int n = 0;
                while (n < nArray.length) {
                    if (nArray[n] >= nArray2[n]) {
                        nArray2[n] = nArray[n] + 1;
                    }
                    ++n;
                }
                this.allocateArray(nArray2);
            }
            this.setAbs(this.get1DIndex(nArray), d);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(String.format("Dimensionalities of requested position, %d, and dataset, %d, are incompatible", nArray.length, this.shape.length));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(DoubleDataset.toReal(object), nArray);
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = DoubleDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = DoubleDataset.calcSize(this.dataShape);
        double[] dArray = DoubleDataset.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = DoubleDataset.calcSize(nArray);
        Arrays.fill(dArray, Double.NaN);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            dArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        this.data = dArray;
        this.odata = dArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = DoubleDataset.calcSize(nArray);
        double[] dArray = DoubleDataset.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            dArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
        this.data = dArray;
        this.odata = dArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public DoubleDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.getSlice((SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3));
    }

    @Override
    public DoubleDataset getSlice(SliceIterator sliceIterator) {
        DoubleDataset doubleDataset = new DoubleDataset(sliceIterator.getSliceShape());
        double[] dArray = doubleDataset.data;
        int n = 0;
        while (sliceIterator.hasNext()) {
            dArray[n] = this.data[sliceIterator.index];
            ++n;
        }
        doubleDataset.setName(String.valueOf(this.name) + ".slice");
        return doubleDataset;
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        double[] dArray = ((DoubleDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            dArray[indexIterator2.index] = this.data[indexIterator.index];
        }
    }

    @Override
    public DoubleDataset setByBoolean(Object object, BooleanDataset booleanDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            int n = ((Number)booleanDataset.sum()).intValue();
            if (n != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext() && indexIterator.hasNext()) {
                this.data[booleanIterator.index] = abstractDataset.getElementDoubleAbs(indexIterator.index);
            }
        } else {
            double d = DoubleDataset.toReal(object);
            BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
            while (booleanIterator.hasNext()) {
                this.data[booleanIterator.index] = d;
            }
        }
        return this;
    }

    @Override
    public DoubleDataset setByIndex(Object object, IntegerDataset integerDataset) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            if (integerDataset.getSize() != abstractDataset.getSize()) {
                throw new IllegalArgumentException("Number of true items in index dataset does not match number of items in dataset");
            }
            IndexIterator indexIterator = abstractDataset.getIterator();
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext() && indexIterator.hasNext()) {
                this.data[integerIterator.index] = abstractDataset.getElementDoubleAbs(indexIterator.index);
            }
        } else {
            double d = DoubleDataset.toReal(object);
            IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size);
            while (integerIterator.hasNext()) {
                this.data[integerIterator.index] = d;
            }
        }
        return this;
    }

    @Override
    public DoubleDataset setSlice(Object object, SliceIterator sliceIterator) {
        if (object instanceof IDataset) {
            IDataset iDataset = (IDataset)object;
            int[] nArray = iDataset.getShape();
            if (!DoubleDataset.areShapesCompatible(sliceIterator.getSliceShape(), nArray)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(nArray), Arrays.toString(sliceIterator.getSliceShape())));
            }
            if (iDataset instanceof AbstractDataset) {
                AbstractDataset abstractDataset = (AbstractDataset)iDataset;
                IndexIterator indexIterator = abstractDataset.getIterator();
                while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                    this.data[sliceIterator.index] = abstractDataset.getElementDoubleAbs(indexIterator.index);
                }
            } else {
                PositionIterator positionIterator = new PositionIterator(nArray);
                int[] nArray2 = ((IndexIterator)positionIterator).getPos();
                while (sliceIterator.hasNext() && ((IndexIterator)positionIterator).hasNext()) {
                    this.data[sliceIterator.index] = iDataset.getDouble(nArray2);
                }
            }
        } else {
            try {
                double d = DoubleDataset.toReal(object);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = d;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (double[])var3_3.odata;
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = DoubleDataset.squeezeShape(var5_5.getSliceShape(), false);
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= DoubleDataset.calcSize(var6_6)) ** GOTO lbl8
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var4_4[var7_7.index] = this.data[var5_5.index];
lbl8:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl9:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        double[] dArray = (double[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (dArray.length < DoubleDataset.calcSize(sliceIterator.getSliceShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            this.data[sliceIterator.index] = dArray[n];
            ++n;
        }
        this.setDirty();
    }

    private List<Integer> findPositions(double d) {
        IndexIterator indexIterator = this.getIterator();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (indexIterator.hasNext()) {
            if (this.data[indexIterator.index] != d) continue;
            arrayList.add(indexIterator.index);
        }
        return arrayList;
    }

    @Override
    public int[] maxPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("maxpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(this.max().doubleValue());
            this.storedValues.put("maxpos", arrayList);
        } else if (v instanceof List) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public int[] minPos() {
        if (this.storedValues == null) {
            this.calculateMaxMin();
        }
        Object v = this.storedValues.get("minpos");
        ArrayList arrayList = null;
        if (v == null) {
            arrayList = this.findPositions(this.min().doubleValue());
            this.storedValues.put("minpos", arrayList);
        } else if (v instanceof ArrayList) {
            arrayList = (ArrayList)v;
        } else {
            throw new InternalError("Inconsistent internal state of stored values for statistics calculation");
        }
        return this.getNDPosition((Integer)arrayList.get(0));
    }

    @Override
    public boolean containsNans() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Double.isNaN(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInfs() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!Double.isInfinite(this.data[indexIterator.index])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            double d = this.data[indexIterator.index];
            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DoubleDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] + abstractDataset.getElementDoubleAbs(indexIterator2.index);
            }
        } else {
            double d = DoubleDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] + d;
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public DoubleDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
            }
        } else {
            double d = DoubleDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] - d;
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public DoubleDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] * abstractDataset.getElementDoubleAbs(indexIterator2.index);
            }
        } else {
            double d = DoubleDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] * d;
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public DoubleDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] / abstractDataset.getElementDoubleAbs(indexIterator2.index);
            }
        } else {
            double d = DoubleDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] / d;
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public DoubleDataset ifloor() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = Math.floor(this.data[indexIterator.index]);
        }
        this.setDirty();
        return this;
    }

    @Override
    public DoubleDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] % abstractDataset.getElementDoubleAbs(indexIterator2.index);
            }
        } else {
            double d = DoubleDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = indexIterator.index;
                this.data[n] = this.data[n] % d;
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public DoubleDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d;
                this.data[indexIterator.index] = d = Math.pow(this.data[indexIterator.index], abstractDataset.getElementDoubleAbs(indexIterator2.index));
            }
        } else {
            double d = DoubleDataset.toReal(object);
            double d2 = DoubleDataset.toImag(object);
            IndexIterator indexIterator = this.getIterator();
            if (d2 == 0.0) {
                while (indexIterator.hasNext()) {
                    double d3;
                    this.data[indexIterator.index] = d3 = Math.pow(this.data[indexIterator.index], d);
                }
            } else {
                Complex complex = new Complex(d, d2);
                while (indexIterator.hasNext()) {
                    double d4;
                    Complex complex2 = new Complex(this.data[indexIterator.index], 0.0);
                    this.data[indexIterator.index] = d4 = complex2.pow(complex).getReal();
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                double d3 = this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d4 = d3 * d3 - d2;
                double d5 = d + d4;
                d2 = d5 - d - d4;
                d = d5;
            }
        } else {
            double d6 = DoubleDataset.toReal(object);
            IndexIterator indexIterator = this.getIterator();
            double d7 = 0.0;
            while (indexIterator.hasNext()) {
                double d8 = this.data[indexIterator.index] - d6;
                double d9 = d8 * d8 - d7;
                double d10 = d + d9;
                d7 = d10 - d - d9;
                d = d10;
            }
        }
        return d;
    }
}

