/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DCT;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class DCTTest {
    private static double fabstol = 1.0E-4;
    private static double dabstol = 1.0E-8;

    @Test
    public void test1D() {
        this.testdct1d(5);
        this.testdct1d(6);
    }

    private void testdct1d(int n) {
        double d = 0.0;
        switch (n) {
            case 5: {
                d = fabstol;
                break;
            }
            case 6: {
                d = dabstol;
            }
        }
        double[] dArray = new double[]{19.05255888, -11.87866427, 0.0, -1.287746576, 0.0, -0.43698525, 0.0, -0.1974277508, 0.0, -0.09151733141, 0.0, -0.02710534351};
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, n);
        AbstractDataset abstractDataset2 = DCT.dct(abstractDataset);
        int n2 = 0;
        IndexIterator indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)dArray[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        AbstractDataset abstractDataset3 = DCT.idct(abstractDataset2);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        double[] dArray2 = new double[]{3.0, -2.230442497, 0.0, -0.1585126678, 11.0, -2.230442497, 0.0, -0.1585126678, 19.0, -2.230442497, 0.0, -0.1585126678};
        abstractDataset.setShape(3, 4);
        abstractDataset2 = DCT.dct(abstractDataset);
        Assert.assertEquals((String)"1D double: rank", (long)2L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"1D double: shape", (long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"1D double: shape", (long)4L, (long)abstractDataset2.getShape()[1]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)dArray2[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        abstractDataset3 = DCT.idct(abstractDataset2);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        double[] dArray3 = new double[]{6.92820323, 8.660254038, 10.39230485, 12.12435565, -5.656854249, -5.656854249, -5.656854249, -5.656854249, 0.0, 0.0, 0.0, 0.0};
        abstractDataset2 = DCT.dct(abstractDataset, abstractDataset.getShape()[0], 0);
        Assert.assertEquals((String)"1D double: rank", (long)2L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"1D double: shape", (long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"1D double: shape", (long)4L, (long)abstractDataset2.getShape()[1]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)dArray3[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        abstractDataset3 = DCT.idct(abstractDataset2, abstractDataset2.getShape()[0], 0);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        abstractDataset2 = DCT.dct(abstractDataset, abstractDataset.getShape()[1], 1);
        Assert.assertEquals((String)"1D double: rank", (long)2L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"1D double: shape", (long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"1D double: shape", (long)4L, (long)abstractDataset2.getShape()[1]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)dArray2[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        abstractDataset3 = DCT.idct(abstractDataset2, abstractDataset2.getShape()[1], 1);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        abstractDataset.setShape(12);
        double[] dArray4 = new double[]{17.04112672, -3.224819802, -11.03160238, 5.833684488, -3.946106358, 0.0, 1.712904806, -3.08892801, 2.610589007, -1.673755844, 0.0, 1.270424726, -2.121153097, 2.027744726, -1.258366124};
        abstractDataset2 = DCT.dct(abstractDataset, 15, -1);
        Assert.assertEquals((String)"1D double: shape", (long)15L, (long)abstractDataset2.getShape()[0]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)dArray4[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        abstractDataset3 = DCT.idct(abstractDataset2);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)(n2 < 12 ? n2 : 0), (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        double[] dArray5 = new double[]{5.366563146, 6.708203932, 8.049844719, 9.391485505, 1.486992138, 2.460241127, 3.433490117, 4.406739106, -5.841402287, -6.157630053, -6.473857819, -6.790085585, -2.40600382, -2.635756741, -2.865509661, -3.095262582, 3.012975162, 3.329202928, 3.645430694, 3.96165846};
        abstractDataset.setShape(3, 4);
        abstractDataset2 = DCT.dct(abstractDataset, 5, 0);
        Assert.assertEquals((String)"1D double: rank", (long)2L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"1D double: shape", (long)5L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"1D double: shape", (long)4L, (long)abstractDataset2.getShape()[1]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)dArray5[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        abstractDataset3 = DCT.idct(abstractDataset2, abstractDataset2.getShape()[0], 0);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"1D double: real", (double)(n2 < 12 ? n2 : 0), (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
    }

    public void test2D() {
        this.testdct2d(5);
        this.testdct2d(6);
    }

    private void testdct2d(int n) {
        double d = 0.0;
        switch (n) {
            case 5: {
                d = fabstol;
                break;
            }
            case 6: {
                d = dabstol;
            }
        }
        double[] dArray = new double[]{19.05255888, -3.863239729, 0.0, -0.2745519942, -11.3137085, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, n);
        abstractDataset.setShape(3, 4);
        AbstractDataset abstractDataset2 = DCT.dct2(abstractDataset, null, null);
        Assert.assertEquals((String)"2D double: rank", (long)2L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"2D double: shape", (long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"2D double: shape", (long)4L, (long)abstractDataset2.getShape()[1]);
        int n2 = 0;
        IndexIterator indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)dArray[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        AbstractDataset abstractDataset3 = DCT.idct2(abstractDataset2, null, null);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            ++n2;
        }
        double[] dArray2 = new double[]{190.0, -10.0, -10.0, -10.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, 590.0, -10.0, -10.0, -10.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, 990.0, -10.0, -10.0, -10.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0, -40.0, 0.0, 0.0, 0.0};
        double[] dArray3 = new double[]{0.0, 10.0, 0.0, -10.0, 55.05527682, 0.0, 0.0, 0.0, 12.99678785, 0.0, 0.0, 0.0, -12.99678785, 0.0, 0.0, 0.0, -55.05527682, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, -10.0, 55.05527682, 0.0, 0.0, 0.0, 12.99678785, 0.0, 0.0, 0.0, -12.99678785, 0.0, 0.0, 0.0, -55.05527682, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0, -10.0, 55.05527682, 0.0, 0.0, 0.0, 12.99678785, 0.0, 0.0, 0.0, -12.99678785, 0.0, 0.0, 0.0, -55.05527682, 0.0, 0.0, 0.0};
        abstractDataset = AbstractDataset.arange(60.0, 6);
        abstractDataset.setShape(3, 5, 4);
        abstractDataset2 = DCT.dct2(abstractDataset, null, null);
        Assert.assertEquals((String)"2D double: rank", (long)3L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"2D double: shape", (long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"2D double: shape", (long)5L, (long)abstractDataset2.getShape()[1]);
        Assert.assertEquals((String)"2D double: shape", (long)4L, (long)abstractDataset2.getShape()[2]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)dArray2[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"2D double: imag", (double)dArray3[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        abstractDataset3 = DCT.idct2(abstractDataset2, null, null);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"2D double: imag", (double)0.0, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        double[] dArray4 = new double[]{258.0, -6.0, -6.0, -6.0, 306.0, -6.0, -6.0, -6.0, 354.0, -6.0, -6.0, -6.0, 402.0, -6.0, -6.0, -6.0, 450.0, -6.0, -6.0, -6.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0};
        double[] dArray5 = new double[]{0.0, 6.0, 0.0, -6.0, 0.0, 6.0, 0.0, -6.0, 0.0, 6.0, 0.0, -6.0, 0.0, 6.0, 0.0, -6.0, 0.0, 6.0, 0.0, -6.0, 69.2820323, 0.0, 0.0, 0.0, 69.2820323, 0.0, 0.0, 0.0, 69.2820323, 0.0, 0.0, 0.0, 69.2820323, 0.0, 0.0, 0.0, 69.2820323, 0.0, 0.0, 0.0, -69.2820323, 0.0, 0.0, 0.0, -69.2820323, 0.0, 0.0, 0.0, -69.2820323, 0.0, 0.0, 0.0, -69.2820323, 0.0, 0.0, 0.0, -69.2820323, 0.0, 0.0, 0.0};
        int[] nArray = new int[2];
        nArray[1] = 2;
        abstractDataset2 = DCT.dct2(abstractDataset, null, nArray);
        Assert.assertEquals((String)"2D double: rank", (long)3L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"2D double: shape", (long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"2D double: shape", (long)5L, (long)abstractDataset2.getShape()[1]);
        Assert.assertEquals((String)"2D double: shape", (long)4L, (long)abstractDataset2.getShape()[2]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)dArray4[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"2D double: imag", (double)dArray5[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        abstractDataset3 = DCT.idct2(abstractDataset2, null, nArray2);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"2D double: imag", (double)0.0, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        double[] dArray6 = new double[]{258.0, -29.74922359, 50.74922359, 50.74922359, -29.74922359, 306.0, -33.45742753, 60.45742753, 60.45742753, -33.45742753, 354.0, -37.16563146, 70.16563146, 70.16563146, -37.16563146, 402.0, -40.87383539, 79.87383539, 79.87383539, -40.87383539, 450.0, -44.58203932, 89.58203932, 89.58203932, -44.58203932, 22.68164792, -58.93494429, -30.89772845, 38.73484154, 46.26097667, 45.09714981, -67.34974692, -30.49448701, 47.39886108, 51.21239379, 67.5126517, -75.76454956, -30.09124558, 56.06288063, 56.16381092, 89.92815358, -84.17935219, -29.68800414, 64.72690018, 61.11522804, 112.34365547, -92.59415483, -29.28476271, 73.39091972, 66.06664517, -162.69763239, 10.73835058, -34.93965408, -30.75499843, 15.20806734, -164.67346922, 8.83273803, -36.61134662, -29.88254868, 17.41896348, -166.64930605, 6.92712547, -38.28303915, -29.01009893, 19.62985961, -168.62514288, 5.02151291, -39.95473169, -28.13764918, 21.84075575, -170.60097971, 3.11590036, -41.62642423, -27.26519943, 24.05165188, 32.01598447, 16.77822603, 19.9471837, -7.68639203, -26.45392859, 43.57631941, 17.20881292, 23.10338477, -6.16633938, -28.67068545, 55.13665436, 17.6393998, 26.25958583, -4.64628674, -30.88744232, 66.6969893, 18.06998669, 29.4157869, -3.12623409, -33.10419918, 78.25732424, 18.50057357, 32.57198796, -1.60618144, -35.32095604, 32.01598447, -26.45392859, -7.68639203, 19.9471837, 16.77822603, 43.57631941, -28.67068545, -6.16633938, 23.10338477, 17.20881292, 55.13665436, -30.88744232, -4.64628674, 26.25958583, 17.6393998, 66.6969893, -33.10419918, -3.12623409, 29.4157869, 18.06998669, 78.25732424, -35.32095604, -1.60618144, 32.57198796, 18.50057357, -162.69763239, 15.20806734, -30.75499843, -34.93965408, 10.73835058, -164.67346922, 17.41896348, -29.88254868, -36.61134662, 8.83273803, -166.64930605, 19.62985961, -29.01009893, -38.28303915, 6.92712547, -168.62514288, 21.84075575, -28.13764918, -39.95473169, 5.02151291, -170.60097971, 24.05165188, -27.26519943, -41.62642423, 3.11590036, 22.68164792, 46.26097667, 38.73484154, -30.89772845, -58.93494429, 45.09714981, 51.21239379, 47.39886108, -30.49448701, -67.34974692, 67.5126517, 56.16381092, 56.06288063, -30.09124558, -75.76454956, 89.92815358, 61.11522804, 64.72690018, -29.68800414, -84.17935219, 112.34365547, 66.06664517, 73.39091972, -29.28476271, -92.59415483};
        double[] dArray7 = new double[]{0.0, -58.15320477, -39.88364044, 39.88364044, 58.15320477, 0.0, -69.56588297, -46.93706347, 46.93706347, 69.56588297, 0.0, -80.97856116, -53.9904865, 53.9904865, 80.97856116, 0.0, -92.39123936, -61.04390953, 61.04390953, 92.39123936, 0.0, -103.80391755, -68.09733255, 68.09733255, 103.80391755, -229.07554091, 19.5429154, -49.74637411, -41.23907274, 27.34934168, -257.18369123, 16.38478715, -58.72524229, -43.6301902, 34.850418, -285.29184154, 13.2266589, -67.70411047, -46.02130766, 42.35149431, -313.39999186, 10.06853065, -76.68297865, -48.41242513, 49.85257063, -341.50814217, 6.91040239, -85.66184683, -50.80354259, 57.35364694, -11.81909975, 41.23601821, 21.85683273, -26.1211078, -35.86868678, -20.47580652, 42.37456871, 20.39631894, -28.16230546, -35.66970253, -29.13251329, 43.51311921, 18.93580516, -30.20350312, -35.47071827, -37.78922006, 44.65166971, 17.47529137, -32.24470078, -35.27173402, -46.44592683, 45.79022021, 16.01477759, -34.28589844, -35.07274976, 92.47002453, -15.12636243, 13.35687952, 23.71577061, -1.43838964, 98.03718842, -18.30508246, 12.78411347, 26.54050176, 0.88015626, 103.60435231, -21.48380249, 12.21134742, 29.3652329, 3.19870217, 109.17151621, -24.66252253, 11.63858138, 32.18996405, 5.51724808, 114.7386801, -27.84124256, 11.06581533, 35.0146952, 7.83579398, -92.47002453, 1.43838964, -23.71577061, -13.35687952, 15.12636243, -98.03718842, -0.88015626, -26.54050176, -12.78411347, 18.30508246, -103.60435231, -3.19870217, -29.3652329, -12.21134742, 21.48380249, -109.17151621, -5.51724808, -32.18996405, -11.63858138, 24.66252253, -114.7386801, -7.83579398, -35.0146952, -11.06581533, 27.84124256, 11.81909975, 35.86868678, 26.1211078, -21.85683273, -41.23601821, 20.47580652, 35.66970253, 28.16230546, -20.39631894, -42.37456871, 29.13251329, 35.47071827, 30.20350312, -18.93580516, -43.51311921, 37.78922006, 35.27173402, 32.24470078, -17.47529137, -44.65166971, 46.44592683, 35.07274976, 34.28589844, -16.01477759, -45.79022021, 229.07554091, -27.34934168, 41.23907274, 49.74637411, -19.5429154, 257.18369123, -34.850418, 43.6301902, 58.72524229, -16.38478715, 285.29184154, -42.35149431, 46.02130766, 67.70411047, -13.2266589, 313.39999186, -49.85257063, 48.41242513, 76.68297865, -10.06853065, 341.50814217, -57.35364694, 50.80354259, 85.66184683, -6.91040239};
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        abstractDataset2 = DCT.dct2(abstractDataset, new int[]{7, 5}, nArray3);
        Assert.assertEquals((String)"2D double: rank", (long)3L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"2D double: shape", (long)7L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"2D double: shape", (long)5L, (long)abstractDataset2.getShape()[1]);
        Assert.assertEquals((String)"2D double: shape", (long)5L, (long)abstractDataset2.getShape()[2]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)dArray6[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"2D double: imag", (double)dArray7[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        abstractDataset3 = DCT.idct2(abstractDataset2, null, nArray4);
        n2 = 0;
        indexIterator = abstractDataset3.getSliceIterator(null, abstractDataset.getShape(), null);
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"2D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"2D double: imag", (double)0.0, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
    }

    public void test3D() {
        this.testdct3d(5);
        this.testdct3d(6);
    }

    private void testdct3d(int n) {
        double d = 0.0;
        switch (n) {
            case 5: {
                d = fabstol;
                break;
            }
            case 6: {
                d = dabstol;
            }
        }
        double[] dArray = new double[]{1770.0, -30.0, -30.0, -30.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -600.0, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -600.0, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 30.0, 0.0, -30.0, 165.16583, 0.0, 0.0, 0.0, 38.9903635, 0.0, 0.0, 0.0, -38.9903635, 0.0, 0.0, 0.0, -165.16583, 0.0, 0.0, 0.0, 346.410162, 0.0, 0.0, 0.0, -2.46139224E-14, 0.0, 0.0, 0.0, -1.23069612E-14, 0.0, 0.0, 0.0, -1.23069612E-14, 0.0, 0.0, 0.0, -2.46139224E-14, 0.0, 0.0, 0.0, -346.410162, 0.0, 0.0, 0.0, 2.46139224E-14, 0.0, 0.0, 0.0, 1.23069612E-14, 0.0, 0.0, 0.0, 1.23069612E-14, 0.0, 0.0, 0.0, 2.46139224E-14, 0.0, 0.0, 0.0};
        AbstractDataset abstractDataset = AbstractDataset.arange(60.0, 6);
        abstractDataset.setShape(3, 5, 4);
        AbstractDataset abstractDataset2 = DCT.dctn(abstractDataset, null, null);
        Assert.assertEquals((String)"3D double: rank", (long)3L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"3D double: shape", (long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"3D double: shape", (long)5L, (long)abstractDataset2.getShape()[1]);
        Assert.assertEquals((String)"3D double: shape", (long)4L, (long)abstractDataset2.getShape()[2]);
        int n2 = 0;
        IndexIterator indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)dArray[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)Math.max(d, d * Math.abs(dArray[n2])));
            Assert.assertEquals((String)"3D double: imag", (double)dArray2[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index + 1), (double)Math.max(d, d * Math.abs(dArray2[n2])));
            ++n2;
        }
        AbstractDataset abstractDataset3 = DCT.idctn(abstractDataset2, null, null);
        n2 = 0;
        indexIterator = abstractDataset3.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"3D double: imag", (double)0.0, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        double[] dArray3 = new double[]{1770.0, -30.0, -30.0, -30.0, -397.610007, 12.9463696, 2.40581321, -8.13474316, 402.178926, -3.49467377, -6.74093881, -9.98720385, 13.4310805, -3.75256086, -1.6648744, 0.422812064, 13.4310805, 0.422812064, -1.6648744, -3.75256086, 402.178926, -9.98720385, -6.74093881, -3.49467377, -397.610007, -8.13474316, 2.40581321, 12.9463696, -428.606798, 10.3884177, -5.0, -20.3884177, -379.912881, 6.33042245, 5.80771834, 5.28501422, -214.494858, 4.54046318, 0.541672942, -3.4571173, 76.3113708, -0.842307097, -1.34835211, -1.85439712, -152.148639, 1.99533447, 0.793393975, -0.408546521, 23.3685566, 0.128049348, -2.78865255, -5.70535444, 363.433731, -7.99659528, -5.0057806, -2.01496592, 18.6067977, -8.63271264, -5.0, -1.36728736, 157.797991, 1.17268879, -0.875391544, -2.92347187, 68.1599815, -1.79180035, -1.5165814, -1.24136246, -62.6772134, -0.574228318, -0.024680233, 0.524867852, 36.4769092, -0.383930498, -0.530277899, -0.6766253, -58.310317, -2.08770549, -0.730398201, 0.626909093, -246.004632, 0.21189082, 1.67732928, 3.14276774, 18.6067977, -1.36728736, -5.0, -8.63271264, -246.004632, 3.14276774, 1.67732928, 0.21189082, -58.310317, 0.626909093, -0.730398201, -2.08770549, 36.4769092, -0.6766253, -0.530277899, -0.383930498, -62.6772134, 0.524867852, -0.024680233, -0.574228318, 68.1599815, -1.24136246, -1.5165814, -1.79180035, 157.797991, -2.92347187, -0.875391544, 1.17268879, -428.606798, -20.3884177, -5.0, 10.3884177, 363.433731, -2.01496592, -5.0057806, -7.99659528, 23.3685566, -5.70535444, -2.78865255, 0.128049348, -152.148639, -0.408546521, 0.793393975, 1.99533447, 76.3113708, -1.85439712, -1.34835211, -0.842307097, -214.494858, -3.4571173, 0.541672942, 4.54046318, -379.912881, 5.28501422, 5.80771834, 6.33042245};
        double[] dArray4 = new double[]{0.0, 30.0, 0.0, -30.0, -563.538495, 8.13474316, 10.5405564, 12.9463696, -182.261009, 9.98720385, 3.24626504, -3.49467377, 190.79646, -0.422812064, -2.08768646, -3.75256086, -190.79646, 3.75256086, 2.08768646, 0.422812064, 182.261009, 3.49467377, -3.24626504, -9.98720385, 563.538495, -12.9463696, -10.5405564, -8.13474316, -1143.03074, 20.3884177, 15.3884177, 10.3884177, 383.125174, -5.28501422, 0.522704111, 6.33042245, -211.202422, 3.4571173, 3.99879024, 4.54046318, -38.4933445, 1.85439712, 0.50604501, -0.842307097, -1.38122374, 0.408546521, 1.2019405, 1.99533447, -307.050049, 5.70535444, 2.91670189, 0.128049348, 62.4901235, 2.01496592, -2.99081468, -7.99659528, 594.752652, 1.36728736, -3.63271264, -8.63271264, -75.4660992, 2.92347187, 2.04808033, 1.17268879, 133.711551, 1.24136246, -0.275218948, -1.79180035, 35.303569, -0.524867852, -0.549548085, -0.574228318, 10.1729052, 0.6766253, 0.146347401, -0.383930498, 134.648848, -0.626909093, -1.35730729, -2.08770549, -81.842476, -3.14276774, -1.46543846, 0.21189082, -594.752652, 8.63271264, 3.63271264, -1.36728736, 81.842476, -0.21189082, 1.46543846, 3.14276774, -134.648848, 2.08770549, 1.35730729, 0.626909093, -10.1729052, 0.383930498, -0.146347401, -0.6766253, -35.303569, 0.574228318, 0.549548085, 0.524867852, -133.711551, 1.79180035, 0.275218948, -1.24136246, 75.4660992, -1.17268879, -2.04808033, -2.92347187, 1143.03074, -10.3884177, -15.3884177, -20.3884177, -62.4901235, 7.99659528, 2.99081468, -2.01496592, 307.050049, -0.128049348, -2.91670189, -5.70535444, 1.38122374, -1.99533447, -1.2019405, -0.408546521, 38.4933445, 0.842307097, -0.50604501, -1.85439712, 211.202422, -4.54046318, -3.99879024, -3.4571173, -383.125174, -6.33042245, -0.522704111, 5.28501422};
        abstractDataset2 = DCT.dctn(abstractDataset, new int[]{5, 7, 4}, null);
        Assert.assertEquals((String)"3D double: rank", (long)3L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"3D double: shape", (long)5L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"3D double: shape", (long)7L, (long)abstractDataset2.getShape()[1]);
        Assert.assertEquals((String)"3D double: shape", (long)4L, (long)abstractDataset2.getShape()[2]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)dArray3[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)Math.max(d, d * Math.abs(dArray3[n2])));
            Assert.assertEquals((String)"3D double: imag", (double)dArray4[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index + 1), (double)Math.max(d, d * Math.abs(dArray4[n2])));
            ++n2;
        }
        abstractDataset3 = DCT.idctn(abstractDataset2, new int[]{5, 7, 4}, null);
        n2 = 0;
        indexIterator = abstractDataset3.getSliceIterator(null, abstractDataset.getShape(), null);
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"3D double: imag", (double)0.0, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        double[] dArray5 = new double[]{1770.0, -30.0, -30.0, -30.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -600.0, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -600.0, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -7.10542736E-15, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, 5370.0, -30.0, -30.0, -30.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -120.0, 0.0, 0.0, 0.0, -600.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -600.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, -1.42108547E-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray6 = new double[]{0.0, 30.0, 0.0, -30.0, 165.16583, 0.0, 0.0, 0.0, 38.9903635, 0.0, 0.0, 0.0, -38.9903635, 0.0, 0.0, 0.0, -165.16583, 0.0, 0.0, 0.0, 346.410162, 0.0, 0.0, 0.0, -2.46139224E-14, 0.0, 0.0, 0.0, -1.23069612E-14, 0.0, 0.0, 0.0, -1.23069612E-14, 0.0, 0.0, 0.0, -2.46139224E-14, 0.0, 0.0, 0.0, -346.410162, 0.0, 0.0, 0.0, 2.46139224E-14, 0.0, 0.0, 0.0, 1.23069612E-14, 0.0, 0.0, 0.0, 1.23069612E-14, 0.0, 0.0, 0.0, 2.46139224E-14, 0.0, 0.0, 0.0, 0.0, 30.0, 0.0, -30.0, 165.16583, 0.0, 0.0, 0.0, 38.9903635, 0.0, 0.0, 0.0, -38.9903635, 0.0, 0.0, 0.0, -165.16583, 0.0, 0.0, 0.0, 346.410162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2.46139224E-14, 0.0, 0.0, 0.0, -2.46139224E-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -346.410162, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.46139224E-14, 0.0, 0.0, 0.0, 2.46139224E-14, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        AbstractDataset abstractDataset4 = AbstractDataset.arange(120.0, 6).reshape(2, 3, 5, 4);
        abstractDataset2 = DCT.dctn(abstractDataset4, null, new int[]{-3, -2, -1});
        Assert.assertEquals((String)"3D double: rank", (long)4L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"3D double: shape", (long)2L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"3D double: shape", (long)3L, (long)abstractDataset2.getShape()[1]);
        Assert.assertEquals((String)"3D double: shape", (long)5L, (long)abstractDataset2.getShape()[2]);
        Assert.assertEquals((String)"3D double: shape", (long)4L, (long)abstractDataset2.getShape()[3]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)dArray5[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)Math.max(d, d * Math.abs(dArray5[n2])));
            Assert.assertEquals((String)"3D double: imag", (double)dArray6[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index + 1), (double)Math.max(d, d * Math.abs(dArray6[n2])));
            ++n2;
        }
        abstractDataset3 = DCT.idctn(abstractDataset2, null, new int[]{-3, -2, -1});
        n2 = 0;
        indexIterator = abstractDataset3.getSliceIterator(null, abstractDataset4.getShape(), null);
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"3D double: imag", (double)0.0, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
        double[] dArray7 = new double[]{1770.0, 172.13312, 207.690161, 205.176719, 205.176719, 207.690161, 172.13312, -397.610007, -358.329185, -4.79748793, -141.247772, 44.4232247, -92.4301844, 266.804419, 402.178926, -61.7943905, 61.2439002, 16.7052005, 76.6162641, 33.207095, 140.266197, 13.4310805, 104.224984, -12.5184243, 31.5852843, -30.0115138, 14.3711659, -106.318776, 13.4310805, -106.318776, 14.3711659, -30.0115138, 31.5852843, -12.5184243, 104.224984, 402.178926, 140.266197, 33.207095, 76.6162641, 16.7052005, 61.2439002, -61.7943905, -397.610007, 266.804419, -92.4301844, 44.4232247, -141.247772, -4.79748793, -358.329185, -428.606798, -693.50556, 27.4142091, -241.994097, 129.484637, -139.085855, 569.981567, -379.912881, 171.646762, -67.4363747, 15.4521636, -104.207111, -22.2917304, -247.607849, -214.494858, -143.086594, -10.1001376, -61.335126, 8.29184236, -43.0339103, 91.2365651, 76.3113708, -13.9390379, 11.7216126, 2.56664929, 15.0663639, 6.13733425, 28.6017573, -152.148639, -18.9252035, -17.4487117, -19.3235481, -17.8634488, -19.8712285, -16.5140205, 23.3685566, -170.893798, 22.8816003, -47.9478074, 50.8017601, -19.5603731, 167.60461, 363.433731, 72.5746238, 36.5978148, 53.820133, 31.6743453, 49.7354461, 1.89258728, 18.6067977, 321.219904, -39.145925, 94.4236378, -95.1296987, 39.2776781, -332.940498, 157.797991, -23.8036317, 25.7941764, 6.55172074, 31.9597493, 12.8639767, 60.386696, 68.1599815, 79.3684246, -0.47281416, 28.7836644, -13.368765, 16.1418362, -67.2944123, -62.6772134, 11.6646803, -10.4867628, -2.07941151, -13.616338, -5.20485123, -27.414798, 36.4769092, 9.20804026, 3.8449125, 5.80752649, 2.74348043, 4.79494927, -1.82518603, -58.310317, 65.7644825, -16.9982959, 14.0053527, -29.3655916, 1.76044452, -82.7337205, -246.004632, -72.2787057, -26.4412039, -42.0541748, -17.6496375, -33.5436664, 16.2698931, 18.6067977, -332.940498, 39.2776781, -95.1296987, 94.4236378, -39.145925, 321.219904, -246.004632, 16.2698931, -33.5436664, -17.6496375, -42.0541748, -26.4412039, -72.2787057, -58.310317, -82.7337205, 1.76044452, -29.3655916, 14.0053527, -16.9982959, 65.7644825, 36.4769092, -1.82518603, 4.79494927, 2.74348043, 5.80752649, 3.8449125, 9.20804026, -62.6772134, -27.414798, -5.20485123, -13.616338, -2.07941151, -10.4867628, 11.6646803, 68.1599815, -67.2944123, 16.1418362, -13.368765, 28.7836644, -0.47281416, 79.3684246, 157.797991, 60.386696, 12.8639767, 31.9597493, 6.55172074, 25.7941764, -23.8036317, -428.606798, 569.981567, -139.085855, 129.484637, -241.994097, 27.4142091, -693.50556, 363.433731, 1.89258728, 49.7354461, 31.6743453, 53.820133, 36.5978148, 72.5746238, 23.3685566, 167.60461, -19.5603731, 50.8017601, -47.9478074, 22.8816003, -170.893798, -152.148639, -16.5140205, -19.8712285, -17.8634488, -19.3235481, -17.4487117, -18.9252035, 76.3113708, 28.6017573, 6.13733425, 15.0663639, 2.56664929, 11.7216126, -13.9390379, -214.494858, 91.2365651, -43.0339103, 8.29184236, -61.335126, -10.1001376, -143.086594, -379.912881, -247.607849, -22.2917304, -104.207111, 15.4521636, -67.4363747, 171.646762, 5370.0, 622.13312, 657.690161, 655.176719, 655.176719, 657.690161, 622.13312, -686.307592, -1087.13431, 35.2562802, -375.596565, 206.597621, -204.658349, 923.435144, 1211.09158, -174.022555, 185.807765, 56.7589686, 238.79066, 110.871394, 454.722525, 213.216008, 266.39938, -2.62596053, 95.8265405, -44.3065381, 54.424934, -218.546941, 213.216008, -218.546941, 54.424934, -44.3065381, 95.8265405, -2.62596053, 266.39938, 1211.09158, 454.722525, 110.871394, 238.79066, 56.7589686, 185.807765, -174.022555, -686.307592, 923.435144, -204.658349, 206.597621, -375.596565, 35.2562802, -1087.13431, 171.393202, -1629.82151, 213.57428, -456.441079, 493.931619, -175.245926, 1656.29751, -1076.83908, 50.1792421, -150.776334, -81.4953648, -181.491133, -113.183321, -300.371879, -279.495611, -414.00936, 10.6605066, -144.675086, 75.3816136, -80.0447428, 345.909143, 238.113624, -26.9706771, 35.6023707, 13.2735253, 44.8100511, 22.7071394, 82.0839598, -247.355916, -109.816794, -20.6672608, -53.8322434, -7.15657276, -40.4544987, 50.5757508, 358.006862, -320.747599, 85.7805326, -60.9794466, 147.492976, 1.20027102, 401.117987, 964.127403, 344.215562, 90.0800172, 185.162287, 50.5056095, 146.426662, -119.574933, 618.606798, 634.959214, 9.61274195, 237.752801, -88.4588623, 140.519011, -496.679808, 262.844976, -145.271152, 53.7196022, -18.8405786, 83.613795, 11.2002973, 208.115962, 250.14975, 120.204341, 20.28783, 56.7090901, 4.20325139, 40.8786342, -62.6328862, -59.7155854, 48.150796, -14.0862854, 8.62746453, -23.582807, -0.864921584, -63.1605068, 100.110257, 7.54436086, 12.8562389, 11.0089874, 13.4503565, 11.6919598, 15.7468303, 29.3374671, 165.921733, -15.846994, 50.4914683, -43.9397613, 22.5210887, -160.979025, -447.284146, -1.13106387, -62.1869126, -39.6500885, -70.3736023, -48.1178361, -105.197627, 618.606798, -496.679808, 140.519011, -88.4588623, 237.752801, 9.61274195, 634.959214, -447.284146, -105.197627, -48.1178361, -70.3736023, -39.6500885, -62.1869126, -1.13106387, 29.3374671, -160.979025, 22.5210887, -43.9397613, 50.4914683, -15.846994, 165.921733, 100.110257, 15.7468303, 11.6919598, 13.4503565, 11.0089874, 12.8562389, 7.54436086, -59.7155854, -63.1605068, -0.864921584, -23.582807, 8.62746453, -14.0862854, 48.150796, 250.14975, -62.6328862, 40.8786342, 4.20325139, 56.7090901, 20.28783, 120.204341, 262.844976, 208.115962, 11.2002973, 83.613795, -18.8405786, 53.7196022, -145.271152, 171.393202, 1656.29751, -175.245926, 493.931619, -456.441079, 213.57428, -1629.82151, 964.127403, -119.574933, 146.426662, 50.5056095, 185.162287, 90.0800172, 344.215562, 358.006862, 401.117987, 1.20027102, 147.492976, -60.9794466, 85.7805326, -320.747599, -247.355916, 50.5757508, -40.4544987, -7.15657276, -53.8322434, -20.6672608, -109.816794, 238.113624, 82.0839598, 22.7071394, 44.8100511, 13.2735253, 35.6023707, -26.9706771, -279.495611, 345.909143, -80.0447428, 75.3816136, -144.675086, 10.6605066, -414.00936, -1076.83908, -300.371879, -113.183321, -181.491133, -81.4953648, -150.776334, 50.1792421};
        double[] dArray8 = new double[]{0.0, -980.570194, 134.70568, -290.256739, 290.256739, -134.70568, 980.570194, -563.538495, 165.469425, -91.8709377, -1.44361222, -128.146257, -39.4851363, -271.839432, -182.261009, -240.244372, 9.2214506, -86.9630894, 44.8763793, -51.852114, 205.308881, 190.79646, 12.4537182, 25.2770549, 19.9144238, 25.5476266, 20.534814, 28.4093539, -190.79646, -28.4093539, -20.534814, -25.5476266, -19.9144238, -25.2770549, -12.4537182, 182.261009, -205.308881, 51.852114, -44.8763793, 86.9630894, -9.2214506, 240.244372, 563.538495, 271.839432, 39.4851363, 128.146257, 1.44361222, 91.8709377, -165.469425, -1143.03074, 115.178226, -157.031248, -69.5884427, -199.679753, -114.815474, -350.547174, 383.125174, 258.980088, 19.8063681, 110.201607, -13.8602085, 76.4474444, -161.487221, -211.202422, 97.8194718, -38.0131825, 9.59459778, -58.1102914, -11.1725596, -137.526204, -38.4933445, -46.279763, 1.27629561, -17.0780768, 7.99699429, -10.4421725, 38.3134503, -1.38122374, 85.4175232, -9.53290865, 24.658854, -23.7162181, 10.274144, -81.8271247, -307.050049, -47.4460712, -33.0388458, -41.6729621, -31.9641522, -41.0869993, -19.7658213, 62.4901235, -197.994381, 33.035299, -52.8963824, 65.3140996, -20.1164325, 203.823613, 594.752652, 56.3378498, 78.5150677, 67.3449022, 77.4506201, 66.8891621, 80.4551458, -75.4660992, -92.8269788, 1.81301928, -33.4440288, 16.7721287, -18.8281014, 80.6668084, 133.711551, -21.6319281, 22.1159887, 5.2347636, 27.8982127, 11.063104, 54.1586228, 35.303569, 37.829839, 0.414748233, 13.9323088, -5.69528597, 7.91435844, -30.8034192, 10.1729052, -18.6639132, 4.03126199, -4.5941224, 7.29416757, -1.3557392, 21.686348, 134.648848, 46.2702163, 13.3930489, 24.9316712, 7.2761153, 19.0421719, -17.052451, -81.842476, 122.724317, -27.2756801, 28.2612178, -50.2921304, 5.49032042, -147.983454, -594.752652, -80.4551458, -66.8891621, -77.4506201, -67.3449022, -78.5150677, -56.3378498, 81.842476, 147.983454, -5.49032042, 50.2921304, -28.2612178, 27.2756801, -122.724317, -134.648848, 17.052451, -19.0421719, -7.2761153, -24.9316712, -13.3930489, -46.2702163, -10.1729052, -21.686348, 1.3557392, -7.29416757, 4.5941224, -4.03126199, 18.6639132, -35.303569, 30.8034192, -7.91435844, 5.69528597, -13.9323088, -0.414748233, -37.829839, -133.711551, -54.1586228, -11.063104, -27.8982127, -5.2347636, -22.1159887, 21.6319281, 75.4660992, -80.6668084, 18.8281014, -16.7721287, 33.4440288, -1.81301928, 92.8269788, 1143.03074, 350.547174, 114.815474, 199.679753, 69.5884427, 157.031248, -115.178226, -62.4901235, -203.823613, 20.1164325, -65.3140996, 52.8963824, -33.035299, 197.994381, 307.050049, 19.7658213, 41.0869993, 31.9641522, 41.6729621, 33.0388458, 47.4460712, 1.38122374, 81.8271247, -10.274144, 23.7162181, -24.658854, 9.53290865, -85.4175232, 38.4933445, -38.3134503, 10.4421725, -7.99699429, 17.0780768, -1.27629561, 46.279763, 211.202422, 137.526204, 11.1725596, 58.1102914, -9.59459778, 38.0131825, -97.8194718, -383.125174, 161.487221, -76.4474444, 13.8602085, -110.201607, -19.8063681, -258.980088, 0.0, -2952.14901, 351.414259, -854.538891, 854.538891, -351.414259, 2952.14901, -1828.40526, 165.469425, -267.357962, -114.300043, -331.506517, -180.214803, -588.056124, -571.812813, -731.948087, 9.2214506, -262.450114, 122.975452, -149.240065, 599.624645, 441.318836, -65.6453549, 68.6187706, 19.9144238, 88.1782204, 39.8236921, 169.139021, -441.318836, -169.139021, -39.8236921, -88.1782204, -19.9144238, -68.6187706, 65.6453549, 571.812813, -599.624645, 149.240065, -122.975452, 262.450114, -9.2214506, 731.948087, 1828.40526, 588.056124, 180.214803, 331.506517, 114.300043, 267.357962, -165.469425, -2989.64087, -444.244509, -351.739417, -394.461733, -336.458993, -381.759836, -252.77697, 320.400681, 632.818675, -29.9869397, 211.600772, -130.940497, 110.559629, -551.006931, -691.057251, 73.4359816, -101.907875, -40.19871, -128.280691, -67.2415741, -233.106421, -99.2187458, -142.483187, 3.42560274, -50.030453, 25.7680201, -27.7728299, 119.335524, -145.614083, 119.529708, -33.2931921, 21.5530152, -56.6685942, -2.02378742, -151.997524, -657.054276, -274.464876, -56.6452099, -137.876386, -23.2617853, -104.981692, 119.751927, 421.387885, -482.108528, 114.057372, -102.189917, 204.332075, -11.4140656, 577.6622, 1030.67817, -217.767931, 169.123854, 27.7885665, 225.988335, 85.2617553, 463.542305, -321.235739, -181.078298, -22.5846904, -80.6308279, 2.51651791, -55.8728016, 107.475718, 166.737825, -117.172303, 37.1994796, -19.1629461, 60.5524908, 4.23618159, 157.955566, 101.249339, 44.4510928, 8.83625012, 21.7113096, 3.01215581, 15.9792991, -20.9382305, -7.3887829, -55.7086133, 5.66657663, -16.7635452, 15.0731684, -7.38147587, 54.3406261, 297.525723, 18.6285716, 39.0287768, 31.552925, 41.3740803, 34.1256627, 51.3084125, 94.0101391, 254.93879, -17.4104913, 81.7923605, -59.8601193, 39.5882854, -236.234773, -1030.67817, -463.542305, -85.2617553, -225.988335, -27.7885665, -169.123854, 217.767931, -94.0101391, 236.234773, -39.5882854, 59.8601193, -81.7923605, 17.4104913, -254.93879, -297.525723, -51.3084125, -34.1256627, -41.3740803, -31.552925, -39.0287768, -18.6285716, 7.3887829, -54.3406261, 7.38147587, -15.0731684, 16.7635452, -5.66657663, 55.7086133, -101.249339, 20.9382305, -15.9792991, -3.01215581, -21.7113096, -8.83625012, -44.4510928, -166.737825, -157.955566, -4.23618159, -60.5524908, 19.1629461, -37.1994796, 117.172303, 321.235739, -107.475718, 55.8728016, -2.51651791, 80.6308279, 22.5846904, 181.078298, 2989.64087, 252.77697, 381.759836, 336.458993, 394.461733, 351.739417, 444.244509, -421.387885, -577.6622, 11.4140656, -204.332075, 102.189917, -114.057372, 482.108528, 657.054276, -119.751927, 104.981692, 23.2617853, 137.876386, 56.6452099, 274.464876, 145.614083, 151.997524, 2.02378742, 56.6685942, -21.5530152, 33.2931921, -119.529708, 99.2187458, -119.335524, 27.7728299, -25.7680201, 50.030453, -3.42560274, 142.483187, 691.057251, 233.106421, 67.2415741, 128.280691, 40.19871, 101.907875, -73.4359816, -320.400681, 551.006931, -110.559629, 130.940497, -211.600772, 29.9869397, -632.818675};
        abstractDataset2 = DCT.dctn(abstractDataset4, new int[]{5, 7, 7}, null);
        Assert.assertEquals((String)"3D double: rank", (long)4L, (long)abstractDataset2.getRank());
        Assert.assertEquals((String)"3D double: shape", (long)2L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((String)"3D double: shape", (long)5L, (long)abstractDataset2.getShape()[1]);
        Assert.assertEquals((String)"3D double: shape", (long)7L, (long)abstractDataset2.getShape()[2]);
        Assert.assertEquals((String)"3D double: shape", (long)7L, (long)abstractDataset2.getShape()[3]);
        n2 = 0;
        indexIterator = abstractDataset2.getIterator();
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)dArray7[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index), (double)Math.max(d, d * Math.abs(dArray7[n2])));
            Assert.assertEquals((String)"3D double: imag", (double)dArray8[n2], (double)abstractDataset2.getElementDoubleAbs(indexIterator.index + 1), (double)Math.max(d, d * Math.abs(dArray8[n2])));
            ++n2;
        }
        abstractDataset3 = DCT.idctn(abstractDataset2, null, new int[]{-3, -2, -1});
        n2 = 0;
        indexIterator = abstractDataset3.getSliceIterator(null, abstractDataset4.getShape(), null);
        while (indexIterator.hasNext()) {
            Assert.assertEquals((String)"3D double: real", (double)n2, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index), (double)d);
            Assert.assertEquals((String)"3D double: imag", (double)0.0, (double)abstractDataset3.getElementDoubleAbs(indexIterator.index + 1), (double)d);
            ++n2;
        }
    }

    @Test
    public void testShift() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        AbstractDataset abstractDataset2 = DCT.dctshift(abstractDataset, null);
        System.out.println(abstractDataset2);
        abstractDataset2 = DCT.idctshift(abstractDataset2, null);
        System.out.println(abstractDataset2);
        abstractDataset.setShape(3, 4);
        System.out.println(abstractDataset);
        abstractDataset2 = DCT.dctshift(abstractDataset, null);
        System.out.println(abstractDataset2);
        abstractDataset2 = DCT.idctshift(abstractDataset2, null);
        System.out.println(abstractDataset2);
    }
}

