/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_1D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_2D;
import edu.emory.mathcs.jtransforms.dct.FloatDCT_3D;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;

public class DCT {
    protected static final transient Logger logger = LoggerFactory.getLogger(DCT.class);

    public static AbstractDataset dct(AbstractDataset abstractDataset) {
        return DCT.dct(abstractDataset, abstractDataset.shape[abstractDataset.shape.length - 1], -1);
    }

    public static AbstractDataset dct(AbstractDataset abstractDataset, int n, int n2) {
        if (n <= 0) {
            logger.error("number of points should be greater than zero");
            throw new IllegalArgumentException("number of points should be greater than zero");
        }
        n2 = abstractDataset.checkAxis(n2);
        return DCT.dct1d(abstractDataset, n, n2);
    }

    public static AbstractDataset dct2(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n = abstractDataset.getRank();
        if (n < 2) {
            logger.error("dataset should be at least 2 dimensional");
            throw new IllegalArgumentException("dataset should be at least 2 dimensional");
        }
        if (nArray2 == null) {
            nArray2 = new int[]{n - 2, n - 1};
        } else if (nArray2.length != 2) {
            logger.error("axes should have two entries");
            throw new IllegalArgumentException("axes should have two entries");
        }
        if (nArray == null) {
            nArray = new int[2];
            int[] nArray3 = abstractDataset.getShape();
            nArray[0] = nArray3[nArray2[0]];
            nArray[1] = nArray3[nArray2[1]];
        } else if (nArray.length < 2) {
            logger.error("shape should not have more than 2 dimensions");
            throw new IllegalArgumentException("shape should not have more than 2 dimensions");
        }
        return DCT.dctn(abstractDataset, nArray, nArray2);
    }

    public static AbstractDataset dctn(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = abstractDataset.getShape();
        int n2 = nArray3.length;
        AbstractDataset abstractDataset2 = null;
        if (nArray == null) {
            if (nArray2 == null) {
                nArray = nArray3;
                nArray2 = new int[n2];
                n = 0;
                while (n < n2) {
                    nArray2[n] = n;
                    ++n;
                }
            } else {
                nArray = new int[nArray2.length];
                Arrays.sort(nArray2);
                n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
                    nArray[n] = nArray3[nArray2[n]];
                    ++n;
                }
            }
        } else {
            if (nArray.length > n2) {
                logger.error("shape of DCT should not have more dimensions than dataset");
                throw new IllegalArgumentException("shape of DCT should not have more dimensions than dataset");
            }
            if (nArray2 == null) {
                nArray2 = new int[nArray.length];
                n = 0;
                while (n < nArray.length) {
                    nArray2[n] = n2 - nArray.length + n;
                    ++n;
                }
            } else if (nArray.length != nArray2.length) {
                logger.error("shape of DCT should have same rank as axes");
                throw new IllegalArgumentException("shape of DCT should have same rank as axes");
            }
        }
        if (nArray.length > 3) {
            logger.error("DCT across more than 3 dimensions are not supported");
            throw new IllegalArgumentException("DCT across more than 3 dimensions are not supported");
        }
        n = 0;
        while (n < nArray2.length) {
            if (nArray[n] <= 0) {
                logger.error("dimensions should be greater than zero");
                throw new IllegalArgumentException("dimensions should be greater than zero");
            }
            nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
            ++n;
        }
        switch (nArray.length) {
            case 1: {
                abstractDataset2 = DCT.dct1d(abstractDataset, nArray[0], nArray2[0]);
                break;
            }
            case 2: {
                abstractDataset2 = DCT.dct2d(abstractDataset, nArray, nArray2);
                break;
            }
            case 3: {
                abstractDataset2 = DCT.dct3d(abstractDataset, nArray, nArray2);
            }
        }
        return abstractDataset2;
    }

    private static int[] newShape(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = (int[])nArray.clone();
        int n = 0;
        while (n < nArray2.length) {
            nArray4[nArray3[n]] = nArray2[n];
            ++n;
        }
        return nArray4;
    }

    private static AbstractDataset dct1d(AbstractDataset abstractDataset, int n, int n2) {
        AbstractDataset abstractDataset2 = null;
        AbstractDataset abstractDataset3 = null;
        switch (abstractDataset.getDtype()) {
            case 5: {
                FloatDCT_1D floatDCT_1D = new FloatDCT_1D(n);
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractDataset2 = new FloatDataset(nArray);
                abstractDataset3 = new FloatDataset(n);
                float[] fArray = (float[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray2 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray2, blArray, abstractDataset3);
                    floatDCT_1D.forward(fArray, true);
                    abstractDataset2.setItemsOnAxes(nArray2, blArray, fArray);
                }
                break;
            }
            case 6: {
                DoubleDCT_1D doubleDCT_1D = new DoubleDCT_1D(n);
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractDataset2 = new DoubleDataset(nArray);
                abstractDataset3 = new DoubleDataset(n);
                double[] dArray = (double[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractDataset3);
                    doubleDCT_1D.forward(dArray, true);
                    abstractDataset2.setItemsOnAxes(nArray3, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-float dataset not yet supported");
            }
        }
        return abstractDataset2;
    }

    private static AbstractDataset dct2d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractDataset abstractDataset2 = null;
        AbstractDataset abstractDataset3 = null;
        switch (abstractDataset.getDtype()) {
            case 5: {
                FloatDCT_2D floatDCT_2D = new FloatDCT_2D(nArray[0], nArray[1]);
                float[] fArray = null;
                abstractDataset2 = new FloatDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new FloatDataset(nArray);
                fArray = (float[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractDataset3);
                    floatDCT_2D.forward(fArray, true);
                    abstractDataset2.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 6: {
                DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(nArray[0], nArray[1]);
                double[] dArray = null;
                abstractDataset2 = new DoubleDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new DoubleDataset(nArray);
                dArray = (double[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractDataset3);
                    doubleDCT_2D.forward(dArray, true);
                    abstractDataset2.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-float dataset not yet supported");
            }
        }
        return abstractDataset2;
    }

    private static AbstractDataset dct3d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractDataset abstractDataset2 = null;
        AbstractDataset abstractDataset3 = null;
        switch (abstractDataset.getDtype()) {
            case 5: {
                FloatDCT_3D floatDCT_3D = new FloatDCT_3D(nArray[0], nArray[1], nArray[2]);
                float[] fArray = null;
                abstractDataset2 = new FloatDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new FloatDataset(nArray);
                fArray = (float[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractDataset3);
                    floatDCT_3D.forward(fArray, true);
                    abstractDataset2.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 6: {
                DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(nArray[0], nArray[1], nArray[2]);
                double[] dArray = null;
                abstractDataset2 = new DoubleDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new DoubleDataset(nArray);
                dArray = (double[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractDataset3);
                    doubleDCT_3D.forward(dArray, true);
                    abstractDataset2.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-float dataset not yet supported");
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset idct(AbstractDataset abstractDataset) {
        return DCT.idct(abstractDataset, abstractDataset.shape[abstractDataset.shape.length - 1], -1);
    }

    public static AbstractDataset idct(AbstractDataset abstractDataset, int n, int n2) {
        if (n <= 0) {
            logger.error("number of points should be greater than zero");
            throw new IllegalArgumentException("number of points should be greater than zero");
        }
        n2 = abstractDataset.checkAxis(n2);
        return DCT.idct1d(abstractDataset, n, n2);
    }

    public static AbstractDataset idct2(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n = abstractDataset.getRank();
        if (n < 2) {
            logger.error("dataset should be at least 2 dimensional");
            throw new IllegalArgumentException("dataset should be at least 2 dimensional");
        }
        if (nArray2 == null) {
            nArray2 = new int[]{n - 2, n - 1};
        } else if (nArray2.length != 2) {
            logger.error("axes should have two entries");
            throw new IllegalArgumentException("axes should have two entries");
        }
        if (nArray == null) {
            nArray = new int[2];
            int[] nArray3 = abstractDataset.getShape();
            nArray[0] = nArray3[nArray2[0]];
            nArray[1] = nArray3[nArray2[1]];
        } else if (nArray.length < 2) {
            logger.error("shape should not have more than 2 dimensions");
            throw new IllegalArgumentException("shape should not have more than 2 dimensions");
        }
        return DCT.idctn(abstractDataset, nArray, nArray2);
    }

    public static AbstractDataset idctn(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = abstractDataset.getShape();
        int n2 = nArray3.length;
        AbstractDataset abstractDataset2 = null;
        if (nArray == null) {
            if (nArray2 == null) {
                nArray = nArray3;
                nArray2 = new int[n2];
                n = 0;
                while (n < n2) {
                    nArray2[n] = n;
                    ++n;
                }
            } else {
                nArray = new int[nArray2.length];
                Arrays.sort(nArray2);
                n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
                    nArray[n] = nArray3[nArray2[n]];
                    ++n;
                }
            }
        } else {
            if (nArray.length > n2) {
                logger.error("shape of DCT should not have more dimensions than dataset");
                throw new IllegalArgumentException("shape of DCT should not have more dimensions than dataset");
            }
            if (nArray2 == null) {
                nArray2 = new int[nArray.length];
                n = 0;
                while (n < nArray.length) {
                    nArray2[n] = n2 - nArray.length + n;
                    ++n;
                }
            } else if (nArray.length != nArray2.length) {
                logger.error("shape of DCT should have same rank as axes");
                throw new IllegalArgumentException("shape of DCT should have same rank as axes");
            }
        }
        if (nArray.length > 3) {
            logger.error("DCT across more than 3 dimensions are not supported");
            throw new IllegalArgumentException("DCT across more than 3 dimensions are not supported");
        }
        n = 0;
        while (n < nArray2.length) {
            if (nArray[n] <= 0) {
                logger.error("dimensions should be greater than zero");
                throw new IllegalArgumentException("dimensions should be greater than zero");
            }
            nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
            ++n;
        }
        switch (nArray.length) {
            case 1: {
                abstractDataset2 = DCT.idct1d(abstractDataset, nArray[0], nArray2[0]);
                break;
            }
            case 2: {
                abstractDataset2 = DCT.idct2d(abstractDataset, nArray, nArray2);
                break;
            }
            case 3: {
                abstractDataset2 = DCT.idct3d(abstractDataset, nArray, nArray2);
            }
        }
        return abstractDataset2;
    }

    private static AbstractDataset idct1d(AbstractDataset abstractDataset, int n, int n2) {
        AbstractDataset abstractDataset2 = null;
        AbstractDataset abstractDataset3 = null;
        switch (abstractDataset.getDtype()) {
            case 5: {
                FloatDCT_1D floatDCT_1D = new FloatDCT_1D(n);
                float[] fArray = null;
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractDataset2 = new FloatDataset(nArray);
                abstractDataset3 = new FloatDataset(n);
                fArray = (float[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray2 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray2, blArray, abstractDataset3);
                    floatDCT_1D.inverse(fArray, true);
                    abstractDataset2.setItemsOnAxes(nArray2, blArray, fArray);
                }
                break;
            }
            case 6: {
                DoubleDCT_1D doubleDCT_1D = new DoubleDCT_1D(n);
                double[] dArray = null;
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractDataset2 = new DoubleDataset(nArray);
                abstractDataset3 = new DoubleDataset(n);
                dArray = (double[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractDataset3);
                    doubleDCT_1D.inverse(dArray, true);
                    abstractDataset2.setItemsOnAxes(nArray3, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-complex dataset not yet supported");
            }
        }
        return abstractDataset2;
    }

    private static AbstractDataset idct2d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractDataset abstractDataset2 = null;
        AbstractDataset abstractDataset3 = null;
        switch (abstractDataset.getDtype()) {
            case 5: {
                FloatDCT_2D floatDCT_2D = new FloatDCT_2D(nArray[0], nArray[1]);
                float[] fArray = null;
                abstractDataset2 = new FloatDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new FloatDataset(nArray);
                fArray = (float[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractDataset3);
                    floatDCT_2D.inverse(fArray, true);
                    abstractDataset2.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 6: {
                DoubleDCT_2D doubleDCT_2D = new DoubleDCT_2D(nArray[0], nArray[1]);
                double[] dArray = null;
                abstractDataset2 = new DoubleDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new DoubleDataset(nArray);
                dArray = (double[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractDataset3);
                    doubleDCT_2D.inverse(dArray, true);
                    abstractDataset2.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-complex dataset not yet supported");
            }
        }
        return abstractDataset2;
    }

    private static AbstractDataset idct3d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractDataset abstractDataset2 = null;
        AbstractDataset abstractDataset3 = null;
        switch (abstractDataset.getDtype()) {
            case 5: {
                FloatDCT_3D floatDCT_3D = new FloatDCT_3D(nArray[0], nArray[1], nArray[2]);
                float[] fArray = null;
                abstractDataset2 = new FloatDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new FloatDataset(nArray);
                fArray = (float[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractDataset3);
                    floatDCT_3D.inverse(fArray, true);
                    abstractDataset2.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 6: {
                DoubleDCT_3D doubleDCT_3D = new DoubleDCT_3D(nArray[0], nArray[1], nArray[2]);
                double[] dArray = null;
                abstractDataset2 = new DoubleDataset(DCT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractDataset3 = new DoubleDataset(nArray);
                dArray = (double[])abstractDataset3.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractDataset3);
                    doubleDCT_3D.inverse(dArray, true);
                    abstractDataset2.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-complex dataset not yet supported");
            }
        }
        return abstractDataset2;
    }

    public static AbstractDataset dctshift(AbstractDataset abstractDataset, int[] nArray) {
        int n;
        int n2;
        if (nArray == null) {
            n2 = abstractDataset.getRank();
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                nArray[n] = n;
                ++n;
            }
        } else {
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                nArray[n] = abstractDataset.checkAxis(nArray[n]);
                ++n;
            }
        }
        AbstractDataset abstractDataset2 = abstractDataset;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = abstractDataset.shape[n4];
            int n6 = (n5 + 1) / 2;
            logger.info("Shift {} by {}", (Object)n4, (Object)n6);
            int[] nArray2 = new int[n5];
            int n7 = 0;
            while (n7 < n5) {
                nArray2[n7] = n7 < n5 - n6 ? n6 + n7 : n7 - n5 + n6;
                ++n7;
            }
            abstractDataset2 = abstractDataset2.take(nArray2, n4);
            ++n3;
        }
        return abstractDataset2;
    }

    public static AbstractDataset idctshift(AbstractDataset abstractDataset, int[] nArray) {
        int n;
        int n2;
        if (nArray == null) {
            n2 = abstractDataset.getRank();
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                nArray[n] = n;
                ++n;
            }
        } else {
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                nArray[n] = abstractDataset.checkAxis(nArray[n]);
                ++n;
            }
        }
        AbstractDataset abstractDataset2 = abstractDataset;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = abstractDataset.shape[n4];
            int n6 = n5 - (n5 + 1) / 2;
            logger.info("Shift {} by {}", (Object)n4, (Object)n6);
            int[] nArray2 = new int[n5];
            int n7 = 0;
            while (n7 < n5) {
                nArray2[n7] = n7 < n5 - n6 ? n6 + n7 : n7 - n5 + n6;
                ++n7;
            }
            abstractDataset2 = abstractDataset2.take(nArray2, n4);
            ++n3;
        }
        return abstractDataset2;
    }
}

