/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class ContiguousIteratorWithPosition
extends IndexIterator {
    private final int[] shape;
    private final int endrank;
    private final int imax;
    private final int istep;
    private final int[] pos;

    public ContiguousIteratorWithPosition(int[] nArray, int n) {
        this(nArray, n, 1);
    }

    public ContiguousIteratorWithPosition(int[] nArray, int n, int n2) {
        this.shape = nArray;
        this.endrank = this.shape.length - 1;
        this.istep = n2;
        if (nArray.length == 0) {
            this.pos = new int[0];
        } else {
            this.pos = new int[this.endrank + 1];
            this.pos[this.endrank] = -1;
        }
        this.index = -n2;
        this.imax = n;
    }

    @Override
    public boolean hasNext() {
        int n = this.endrank;
        while (n >= 0) {
            int n2 = n;
            this.pos[n2] = this.pos[n2] + 1;
            if (this.pos[n] < this.shape[n]) break;
            this.pos[n] = 0;
            --n;
        }
        if (n == -1 && this.endrank >= 0) {
            this.index = this.imax;
            return false;
        }
        this.index += this.istep;
        return this.index < this.imax;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    @Override
    public void reset() {
        if (this.shape.length > 0) {
            Arrays.fill(this.pos, 0);
            this.pos[this.endrank] = -1;
        }
        this.index = -this.istep;
    }
}

