/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class CompoundIntegerDataset
extends AbstractCompoundDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final transient Logger compoundLogger = LoggerFactory.getLogger(CompoundIntegerDataset.class);
    protected int[] data;

    @Override
    protected void setData() {
        this.data = (int[])this.odata;
    }

    protected int[] createArray(int n) {
        int[] nArray = null;
        try {
            nArray = new int[this.isize * n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            compoundLogger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)n);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return nArray;
    }

    @Override
    public int getDtype() {
        return 300;
    }

    public CompoundIntegerDataset() {
    }

    public CompoundIntegerDataset(int n) {
        this.isize = n;
    }

    public CompoundIntegerDataset(int n, int[] nArray) {
        this.isize = n;
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = this.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = CompoundIntegerDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
    }

    public CompoundIntegerDataset(CompoundIntegerDataset compoundIntegerDataset) {
        this(compoundIntegerDataset, false);
    }

    public CompoundIntegerDataset(CompoundIntegerDataset compoundIntegerDataset, boolean bl) {
        this.isize = compoundIntegerDataset.isize;
        this.size = compoundIntegerDataset.size;
        if (bl) {
            this.shape = compoundIntegerDataset.shape;
            this.dataSize = compoundIntegerDataset.dataSize;
            this.dataShape = compoundIntegerDataset.dataShape;
            this.name = compoundIntegerDataset.name;
            this.metadataStructure = compoundIntegerDataset.metadataStructure;
            this.data = compoundIntegerDataset.data;
            this.odata = compoundIntegerDataset.data;
            return;
        }
        this.shape = (int[])compoundIntegerDataset.shape.clone();
        this.name = new String(compoundIntegerDataset.name);
        if (compoundIntegerDataset.metadataStructure != null) {
            this.metadataStructure = compoundIntegerDataset.metadataStructure.clone();
        }
        int[] nArray = compoundIntegerDataset.data;
        if (compoundIntegerDataset.isContiguous()) {
            this.data = (int[])nArray.clone();
            this.odata = this.data;
        } else {
            this.data = this.createArray(this.size);
            this.odata = this.data;
            IndexIterator indexIterator = compoundIntegerDataset.getIterator();
            IndexIterator indexIterator2 = this.getIterator();
            while (indexIterator2.hasNext() && indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    this.data[indexIterator2.index + n] = nArray[indexIterator.index + n];
                    ++n;
                }
            }
        }
        this.errorValue = compoundIntegerDataset.errorValue;
        this.errorData = compoundIntegerDataset.errorData;
        this.errorArray = compoundIntegerDataset.errorArray;
        this.errorCompoundData = compoundIntegerDataset.errorCompoundData;
    }

    public CompoundIntegerDataset(AbstractCompoundDataset abstractCompoundDataset) {
        this.isize = abstractCompoundDataset.isize;
        this.size = abstractCompoundDataset.size;
        this.shape = (int[])abstractCompoundDataset.shape.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractCompoundDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            int n2 = 0;
            while (n2 < this.isize) {
                this.data[n++] = (int)abstractCompoundDataset.getElementLongAbs(indexIterator.index + n2);
                ++n2;
            }
        }
        this.errorValue = abstractCompoundDataset.errorValue;
        this.errorData = abstractCompoundDataset.errorData;
        this.errorArray = abstractCompoundDataset.errorArray;
        this.errorCompoundData = abstractCompoundDataset.errorCompoundData;
        this.metadataStructure = abstractCompoundDataset.metadataStructure;
    }

    public CompoundIntegerDataset(int n, int[] nArray, int ... nArray2) {
        this.isize = n;
        if (nArray2 == null || nArray2.length == 0) {
            nArray2 = new int[]{nArray.length / this.isize};
        }
        this.size = CompoundIntegerDataset.calcSize(nArray2);
        if (this.size * this.isize != nArray.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(nArray2), nArray.length / this.isize));
        }
        this.shape = (int[])nArray2.clone();
        this.data = nArray;
        this.odata = nArray;
    }

    public CompoundIntegerDataset(AbstractDataset ... abstractDatasetArray) {
        if (abstractDatasetArray.length <= 1) {
            throw new IllegalArgumentException("Array of datasets must have length greater than one");
        }
        int n = 1;
        while (n < abstractDatasetArray.length) {
            abstractDatasetArray[0].checkCompatibility(abstractDatasetArray[n]);
            ++n;
        }
        this.isize = abstractDatasetArray.length;
        this.size = CompoundIntegerDataset.calcSize(abstractDatasetArray[0].shape);
        this.shape = (int[])abstractDatasetArray[0].shape.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        IndexIterator[] indexIteratorArray = new IndexIterator[this.isize];
        int n2 = 0;
        while (n2 < abstractDatasetArray.length) {
            indexIteratorArray[n2] = abstractDatasetArray[n2].getIterator();
            ++n2;
        }
        n2 = 0;
        while (indexIteratorArray[0].hasNext()) {
            this.data[n2++] = (int)abstractDatasetArray[0].getElementLongAbs(indexIteratorArray[0].index);
            int n3 = 1;
            while (n3 < abstractDatasetArray.length) {
                indexIteratorArray[n3].hasNext();
                this.data[n2++] = (int)abstractDatasetArray[n3].getElementLongAbs(indexIteratorArray[n3].index);
                ++n3;
            }
        }
    }

    public CompoundIntegerDataset(int n, boolean bl, AbstractDataset abstractDataset) {
        this.isize = n;
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.data = this.createArray(this.size);
        this.odata = this.data;
        int n2 = abstractDataset.getElementsPerItem();
        IndexIterator indexIterator = abstractDataset.getIterator();
        if (bl) {
            int n3 = 0;
            while (indexIterator.hasNext()) {
                int n4 = (int)abstractDataset.getElementLongAbs(indexIterator.index);
                int n5 = 0;
                while (n5 < this.isize) {
                    this.data[n3++] = n4;
                    ++n5;
                }
            }
        } else {
            int n6 = Math.min(this.isize, n2);
            int n7 = 0;
            while (indexIterator.hasNext()) {
                int n8 = 0;
                while (n8 < n6) {
                    this.data[n7 + n8] = (int)abstractDataset.getElementLongAbs(indexIterator.index + n8);
                    ++n8;
                }
                n7 += this.isize;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this.getRank() == 0) {
            return true;
        }
        CompoundIntegerDataset compoundIntegerDataset = (CompoundIntegerDataset)object;
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                if (this.data[indexIterator.index + n] != compoundIntegerDataset.data[indexIterator.index + n]) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public static CompoundIntegerDataset createFromObject(Object object) {
        IntegerDataset integerDataset = IntegerDataset.createFromObject(object);
        return (CompoundIntegerDataset)DatasetUtils.createCompoundDatasetFromLastAxis(integerDataset, true);
    }

    public static CompoundIntegerDataset arange(int n, double d) {
        return CompoundIntegerDataset.arange(n, 0.0, d, 1.0);
    }

    public static CompoundIntegerDataset arange(int n, double d, double d2, double d3) {
        int n2 = CompoundIntegerDataset.calcSteps(d, d2, d3);
        CompoundIntegerDataset compoundIntegerDataset = new CompoundIntegerDataset(n, new int[]{n2});
        int n3 = 0;
        while (n3 < n2) {
            compoundIntegerDataset.data[n3 * compoundIntegerDataset.isize] = (int)(d + (double)n3 * d3);
            ++n3;
        }
        return compoundIntegerDataset;
    }

    public static CompoundIntegerDataset ones(int n, int ... nArray) {
        return new CompoundIntegerDataset(n, nArray).fill(1);
    }

    @Override
    public CompoundIntegerDataset fill(Object object) {
        IndexIterator indexIterator = this.getIterator();
        int[] nArray = CompoundIntegerDataset.toIntegerArray(object, this.isize);
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                this.data[indexIterator.index + n] = nArray[n];
                ++n;
            }
        }
        return this;
    }

    public int[] getData() {
        return this.data;
    }

    @Override
    public CompoundIntegerDataset getView() {
        CompoundIntegerDataset compoundIntegerDataset = new CompoundIntegerDataset(this.isize);
        compoundIntegerDataset.name = new String(this.name);
        compoundIntegerDataset.size = this.size;
        compoundIntegerDataset.dataSize = this.dataSize;
        compoundIntegerDataset.shape = (int[])this.shape.clone();
        if (this.dataShape != null) {
            compoundIntegerDataset.dataShape = (int[])this.dataShape.clone();
        }
        compoundIntegerDataset.data = this.data;
        compoundIntegerDataset.odata = this.data;
        compoundIntegerDataset.metadataStructure = this.metadataStructure;
        return compoundIntegerDataset;
    }

    public int[] getAbs(int n) {
        int[] nArray = new int[this.isize];
        int n2 = 0;
        while (n2 < this.isize) {
            nArray[n2] = this.data[n + n2];
            ++n2;
        }
        return nArray;
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        int n2 = 0;
        while (n2 < this.isize) {
            if (this.data[n + n2] == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return this.data[n];
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        int[] nArray = (int[])object;
        int n3 = 0;
        while (n3 < this.isize) {
            this.data[n + n3] = nArray[n2 + n3];
            ++n3;
        }
    }

    public void setAbs(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < this.isize) {
            this.data[n + n2] = nArray[n2];
            ++n2;
        }
        this.setDirty();
    }

    public void setAbs(int n, int n2) {
        this.data[n] = n2;
        this.setDirty();
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.getIntegerArray(nArray);
    }

    public int[] getIntegerArray(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return (int[])this.getObjectAbs(n);
    }

    @Override
    public void getDoubleArray(double[] dArray, int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        int n2 = 0;
        while (n2 < this.isize) {
            dArray[n2] = this.data[n + n2];
            ++n2;
        }
    }

    @Override
    public String getString(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.getStringAbs(n);
    }

    @Override
    protected double getFirstValue(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        int[] nArray = new int[this.isize];
        int n2 = 0;
        while (n2 < this.isize) {
            nArray[n2] = this.data[n + n2];
            ++n2;
        }
        return nArray;
    }

    @Override
    public String getStringAbs(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(String.format("%d", this.data[n]));
        int n2 = 1;
        while (n2 < this.isize) {
            stringBuilder.append(' ');
            stringBuilder.append(String.format("%d", this.data[n + n2]));
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    public void setObjectAbs(int n, Object object) {
        int[] nArray = CompoundIntegerDataset.toIntegerArray(object, this.isize);
        this.setAbs(n, nArray);
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(CompoundIntegerDataset.toIntegerArray(object, this.isize), nArray);
    }

    public void setItem(int[] nArray, int ... nArray2) {
        try {
            if (!this.isPositionInShape(nArray2)) {
                int[] nArray3 = (int[])this.shape.clone();
                int n = 0;
                while (n < nArray2.length) {
                    if (nArray2[n] >= nArray3[n]) {
                        nArray3[n] = nArray2[n] + 1;
                    }
                    ++n;
                }
                this.allocateArray(nArray3);
            }
            if (nArray.length > this.isize) {
                throw new IllegalArgumentException("Array is larger than compound");
            }
            this.setAbs(this.isize * this.get1DIndex(nArray2), nArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Index out of bounds - need to make dataset extendible");
        }
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = CompoundIntegerDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = CompoundIntegerDataset.calcSize(this.dataShape);
        int[] nArray2 = this.createArray(this.dataSize);
        int[] nArray3 = this.shape;
        this.shape = nArray;
        this.size = CompoundIntegerDataset.calcSize(nArray);
        Arrays.fill(nArray2, Integer.MIN_VALUE);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray3, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                nArray2[indexIterator2.index + n] = this.data[indexIterator.index + n];
                ++n;
            }
        }
        this.data = nArray2;
        this.odata = nArray2;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = CompoundIntegerDataset.calcSize(nArray);
        int[] nArray2 = this.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            int n3 = 0;
            while (n3 < this.isize) {
                nArray2[n2++] = this.data[indexIterator.index + n3];
                ++n3;
            }
        }
        this.data = nArray2;
        this.odata = nArray2;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public IntegerDataset real() {
        IntegerDataset integerDataset = new IntegerDataset(this.shape);
        IndexIterator indexIterator = this.getIterator();
        IndexIterator indexIterator2 = integerDataset.getIterator();
        int[] nArray = integerDataset.data;
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            nArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        return integerDataset;
    }

    @Override
    public CompoundIntegerDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.getSlice((SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3));
    }

    @Override
    public CompoundIntegerDataset getSlice(SliceIterator sliceIterator) {
        CompoundIntegerDataset compoundIntegerDataset = new CompoundIntegerDataset(this.isize, sliceIterator.getSliceShape());
        int[] nArray = compoundIntegerDataset.data;
        IndexIterator indexIterator = compoundIntegerDataset.getIterator();
        while (sliceIterator.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                nArray[indexIterator.index + n] = this.data[sliceIterator.index + n];
                ++n;
            }
        }
        compoundIntegerDataset.setName(String.valueOf(this.name) + ".slice");
        return compoundIntegerDataset;
    }

    @Override
    public AbstractDataset getElements(int n) {
        IntegerDataset integerDataset = new IntegerDataset(this.shape);
        this.copyElements(integerDataset, n);
        return integerDataset;
    }

    @Override
    public void copyElements(AbstractDataset abstractDataset, int n) {
        if (n < 0) {
            n += this.isize;
        }
        if (n < 0 || n > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", n, this.isize));
        }
        if (this.elementClass() != abstractDataset.elementClass()) {
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator indexIterator = this.getIterator(n);
        int[] nArray = ((IntegerDataset)abstractDataset).data;
        int n2 = 0;
        while (indexIterator.hasNext()) {
            nArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
    }

    @Override
    public void setElements(AbstractDataset abstractDataset, int n) {
        if (n < 0) {
            n += this.isize;
        }
        if (n < 0 || n > this.isize) {
            throw new IllegalArgumentException(String.format("Invalid choice of element: %d/%d", n, this.isize));
        }
        if (this.elementClass() != abstractDataset.elementClass()) {
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator indexIterator = this.getIterator(n);
        int[] nArray = ((IntegerDataset)abstractDataset).data;
        if (abstractDataset.isContiguous()) {
            int n2 = 0;
            while (indexIterator.hasNext()) {
                this.data[indexIterator.index] = nArray[n2];
                ++n2;
            }
        } else {
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                this.data[indexIterator.index] = nArray[indexIterator2.index];
            }
        }
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        int[] nArray = ((CompoundIntegerDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                nArray[indexIterator2.index + n] = this.data[indexIterator.index + n];
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset setByBoolean(Object var1_1, BooleanDataset var2_2) {
        block10: {
            block9: {
                if (!(var1_1 instanceof AbstractDataset)) break block9;
                var3_3 = (AbstractDataset)var1_1;
                var4_5 = ((Number)var2_2.sum()).intValue();
                if (var4_5 != var3_3.getSize()) {
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                var5_7 = var3_3.getIterator();
                var6_9 = this.getBooleanIterator(var2_2);
                if (!(var3_3 instanceof AbstractCompoundDataset)) ** GOTO lbl24
                if (this.isize == var3_3.getElementsPerItem()) ** GOTO lbl16
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var7_10 = 0;
                    while (var7_10 < this.isize) {
                        this.data[var6_9.index + var7_10] = (int)var3_3.getElementLongAbs(var5_7.index + var7_10);
                        ++var7_10;
                    }
lbl16:
                    // 2 sources

                    ** while (var6_9.hasNext() && var5_7.hasNext())
                }
lbl17:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[var6_9.index] = (int)var3_3.getElementLongAbs(var5_7.index);
                    var7_11 = 1;
                    while (var7_11 < this.isize) {
                        this.data[var6_9.index + var7_11] = 0;
                        ++var7_11;
                    }
lbl24:
                    // 2 sources

                    ** while (var6_9.hasNext() && var5_7.hasNext())
                }
lbl25:
                // 1 sources

                break block10;
            }
            try {
                var3_4 = CompoundIntegerDataset.toIntegerArray(var1_1, this.isize);
                var4_6 = this.getBooleanIterator(var2_2);
                while (var4_6.hasNext()) {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        this.data[var4_6.index + var5_8] = var3_4[var5_8];
                        ++var5_8;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset setByIndex(Object var1_1, IntegerDataset var2_2) {
        block10: {
            block9: {
                if (!(var1_1 instanceof AbstractDataset)) break block9;
                var3_3 = (AbstractDataset)var1_1;
                if (var2_2.getSize() != var3_3.getSize()) {
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                var4_5 = var3_3.getIterator();
                var5_7 = new IntegerIterator(var2_2, this.size, this.isize);
                if (!(var3_3 instanceof AbstractCompoundDataset)) ** GOTO lbl23
                if (this.isize == var3_3.getElementsPerItem()) ** GOTO lbl15
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var6_9 = 0;
                    while (var6_9 < this.isize) {
                        this.data[var5_7.index + var6_9] = (int)var3_3.getElementLongAbs(var4_5.index + var6_9);
                        ++var6_9;
                    }
lbl15:
                    // 2 sources

                    ** while (var5_7.hasNext() && var4_5.hasNext())
                }
lbl16:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[var5_7.index] = (int)var3_3.getElementLongAbs(var4_5.index);
                    var6_10 = 1;
                    while (var6_10 < this.isize) {
                        this.data[var5_7.index + var6_10] = 0;
                        ++var6_10;
                    }
lbl23:
                    // 2 sources

                    ** while (var5_7.hasNext() && var4_5.hasNext())
                }
lbl24:
                // 1 sources

                break block10;
            }
            try {
                var3_4 = CompoundIntegerDataset.toIntegerArray(var1_1, this.isize);
                var4_6 = new IntegerIterator(var2_2, this.size, this.isize);
                while (var4_6.hasNext()) {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        this.data[var4_6.index + var5_8] = var3_4[var5_8];
                        ++var5_8;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundIntegerDataset setSlice(Object var1_1, SliceIterator var2_2) {
        block15: {
            block13: {
                block14: {
                    if (!(var1_1 instanceof IDataset)) break block13;
                    var3_3 = (IDataset)var1_1;
                    var4_5 = var3_3.getShape();
                    if (!CompoundIntegerDataset.areShapesCompatible(var2_2.getSliceShape(), var4_5)) {
                        throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", new Object[]{Arrays.toString(var4_5), Arrays.toString(var2_2.getSliceShape())}));
                    }
                    if (!(var3_3 instanceof AbstractDataset)) break block14;
                    var5_7 = (AbstractDataset)var3_3;
                    var6_9 = var5_7.getIterator();
                    if (!(var3_3 instanceof AbstractCompoundDataset)) ** GOTO lbl25
                    if (this.isize == var5_7.getElementsPerItem()) ** GOTO lbl17
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                    // 1 sources

                    {
                        var7_11 = 0;
                        while (var7_11 < this.isize) {
                            this.data[var2_2.index + var7_11] = (int)var5_7.getElementLongAbs(var6_9.index + var7_11);
                            ++var7_11;
                        }
lbl17:
                        // 2 sources

                        ** while (var2_2.hasNext() && var6_9.hasNext())
                    }
lbl18:
                    // 1 sources

                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        this.data[var2_2.index] = (int)var5_7.getElementLongAbs(var6_9.index);
                        var7_12 = 1;
                        while (var7_12 < this.isize) {
                            this.data[var2_2.index + var7_12] = 0;
                            ++var7_12;
                        }
lbl25:
                        // 2 sources

                        ** while (var2_2.hasNext() && var6_9.hasNext())
                    }
lbl26:
                    // 1 sources

                    break block15;
                }
                var5_8 = new PositionIterator(var4_5);
                var6_10 = var5_8.getPos();
                if (var3_3.getElementsPerItem() != 1) ** GOTO lbl46
                while (var2_2.hasNext() && var5_8.hasNext()) {
                    this.data[var2_2.index] = var3_3.getInt(var6_10);
                    var7_13 = 1;
                    while (var7_13 < this.isize) {
                        this.data[var2_2.index + var7_13] = 0;
                        ++var7_13;
                    }
                }
                break block15;
lbl-1000:
                // 1 sources

                {
                    var7_14 = CompoundIntegerDataset.toIntegerArray(var3_3.getObject(var6_10), this.isize);
                    var8_15 = 0;
                    while (var8_15 < this.isize) {
                        this.data[var2_2.index + var8_15] = var7_14[var8_15];
                        ++var8_15;
                    }
lbl46:
                    // 2 sources

                    ** while (var2_2.hasNext() && var5_8.hasNext())
                }
lbl47:
                // 1 sources

                break block15;
            }
            try {
                var3_4 = CompoundIntegerDataset.toIntegerArray(var1_1, this.isize);
                while (var2_2.hasNext()) {
                    var4_6 = 0;
                    while (var4_6 < this.isize) {
                        this.data[var2_2.index + var4_6] = var3_4[var4_6];
                        ++var4_6;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (int[])var3_3.odata;
        if (var3_3.getElementsPerItem() != this.isize) {
            throw new IllegalArgumentException(String.format("Destination dataset is incompatible as it has %d elements per item not %d", new Object[]{var3_3.getElementsPerItem(), this.isize}));
        }
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = CompoundIntegerDataset.squeezeShape(var5_5.getSliceShape(), false);
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= CompoundIntegerDataset.calcSize(var6_6)) ** GOTO lbl14
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var8_8 = 0;
            while (var8_8 < this.isize) {
                var4_4[var7_7.index + var8_8] = this.data[var5_5.index + var8_8];
                ++var8_8;
            }
lbl14:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl15:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        int[] nArray2 = (int[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (nArray2.length < CompoundIntegerDataset.calcSize(sliceIterator.getSliceShape())) {
            throw new IllegalArgumentException("source array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            int n2 = 0;
            while (n2 < this.isize) {
                this.data[sliceIterator.index + n2] = nArray2[this.isize * n + n2];
                ++n2;
            }
            ++n;
        }
        this.setDirty();
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundIntegerDataset iadd(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            int n = abstractDataset.getElementsPerItem();
            if (n == 1) {
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n2 = (int)abstractDataset.getElementLongAbs(indexIterator2.index);
                    int n3 = 0;
                    while (n3 < this.isize) {
                        int n4 = indexIterator.index + n3;
                        this.data[n4] = this.data[n4] + n2;
                        ++n3;
                    }
                }
            } else {
                if (n != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n5 = 0;
                    while (n5 < this.isize) {
                        int n6 = indexIterator.index + n5;
                        this.data[n6] = (int)((long)this.data[n6] + abstractDataset.getElementLongAbs(indexIterator2.index + n5));
                        ++n5;
                    }
                }
            }
        } else {
            int[] nArray = CompoundIntegerDataset.toIntegerArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    int n7 = indexIterator.index + n;
                    this.data[n7] = this.data[n7] + nArray[n];
                    ++n;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundIntegerDataset isubtract(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            int n = abstractDataset.getElementsPerItem();
            if (n == 1) {
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n2 = (int)abstractDataset.getElementLongAbs(indexIterator2.index);
                    int n3 = 0;
                    while (n3 < this.isize) {
                        int n4 = indexIterator.index + n3;
                        this.data[n4] = this.data[n4] - n2;
                        ++n3;
                    }
                }
            } else {
                if (n != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n5 = 0;
                    while (n5 < this.isize) {
                        int n6 = indexIterator.index + n5;
                        this.data[n6] = (int)((long)this.data[n6] - abstractDataset.getElementLongAbs(indexIterator2.index + n5));
                        ++n5;
                    }
                }
            }
        } else {
            int[] nArray = CompoundIntegerDataset.toIntegerArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    int n7 = indexIterator.index + n;
                    this.data[n7] = this.data[n7] - nArray[n];
                    ++n;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundIntegerDataset imultiply(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            int n = abstractDataset.getElementsPerItem();
            if (n == 1) {
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n2 = (int)abstractDataset.getElementLongAbs(indexIterator2.index);
                    int n3 = 0;
                    while (n3 < this.isize) {
                        int n4 = indexIterator.index + n3;
                        this.data[n4] = this.data[n4] * n2;
                        ++n3;
                    }
                }
            } else {
                if (n != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n5 = 0;
                    while (n5 < this.isize) {
                        int n6 = indexIterator.index + n5;
                        this.data[n6] = (int)((long)this.data[n6] * abstractDataset.getElementLongAbs(indexIterator2.index + n5));
                        ++n5;
                    }
                }
            }
        } else {
            int[] nArray = CompoundIntegerDataset.toIntegerArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    int n7 = indexIterator.index + n;
                    this.data[n7] = this.data[n7] * nArray[n];
                    ++n;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundIntegerDataset idivide(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            int n = abstractDataset.getElementsPerItem();
            if (n == 1) {
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n2;
                    int n3 = (int)abstractDataset.getElementLongAbs(indexIterator2.index);
                    if (n3 == 0) {
                        n2 = 0;
                        while (n2 < this.isize) {
                            this.data[indexIterator.index + n2] = 0;
                            ++n2;
                        }
                        continue;
                    }
                    n2 = 0;
                    while (n2 < this.isize) {
                        int n4 = indexIterator.index + n2;
                        this.data[n4] = this.data[n4] / n3;
                        ++n2;
                    }
                }
            } else {
                if (n != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n5 = 0;
                    while (n5 < this.isize) {
                        try {
                            int n6 = indexIterator.index + n5;
                            this.data[n6] = (int)((long)this.data[n6] / abstractDataset.getElementLongAbs(indexIterator2.index + n5));
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.data[indexIterator.index + n5] = 0;
                        }
                        ++n5;
                    }
                }
            }
        } else {
            double[] dArray = CompoundIntegerDataset.toDoubleArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    if (dArray[n] == 0.0) {
                        this.data[indexIterator.index + n] = 0;
                    } else {
                        int n7 = indexIterator.index + n;
                        this.data[n7] = (int)((double)this.data[n7] / dArray[n]);
                    }
                    ++n;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public CompoundIntegerDataset ifloor() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundIntegerDataset iremainder(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            int n = abstractDataset.getElementsPerItem();
            if (n == 1) {
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n2;
                    int n3 = (int)abstractDataset.getElementLongAbs(indexIterator2.index);
                    if (n3 == 0) {
                        n2 = 0;
                        while (n2 < this.isize) {
                            this.data[indexIterator.index + n2] = 0;
                            ++n2;
                        }
                        continue;
                    }
                    n2 = 0;
                    while (n2 < this.isize) {
                        int n4 = indexIterator.index + n2;
                        this.data[n4] = this.data[n4] % n3;
                        ++n2;
                    }
                }
            } else {
                if (n != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n5 = 0;
                    while (n5 < this.isize) {
                        try {
                            int n6 = indexIterator.index + n5;
                            this.data[n6] = (int)((long)this.data[n6] % abstractDataset.getElementLongAbs(indexIterator2.index + n5));
                        }
                        catch (ArithmeticException arithmeticException) {
                            this.data[indexIterator.index + n5] = 0;
                        }
                        ++n5;
                    }
                }
            }
        } else {
            double[] dArray = CompoundIntegerDataset.toDoubleArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    if (dArray[n] == 0.0) {
                        this.data[indexIterator.index + n] = 0;
                    } else {
                        int n7 = indexIterator.index + n;
                        this.data[n7] = (int)((double)this.data[n7] % dArray[n]);
                    }
                    ++n;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompoundIntegerDataset ipower(Object object) {
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            int n = abstractDataset.getElementsPerItem();
            if (n == 1) {
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n2 = (int)abstractDataset.getElementLongAbs(indexIterator2.index);
                    int n3 = 0;
                    while (n3 < this.isize) {
                        double d = Math.pow(this.data[indexIterator.index + n3], n2);
                        this.data[indexIterator.index + n3] = Double.isInfinite(d) || Double.isNaN(d) ? 0 : (int)d;
                        ++n3;
                    }
                }
            } else {
                if (n != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n4 = 0;
                    while (n4 < this.isize) {
                        double d = Math.pow(this.data[indexIterator.index + n4], abstractDataset.getElementDoubleAbs(indexIterator2.index + n4));
                        this.data[indexIterator.index + n4] = Double.isInfinite(d) || Double.isNaN(d) ? 0 : (int)d;
                        ++n4;
                    }
                }
            }
        } else {
            int[] nArray = CompoundIntegerDataset.toIntegerArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    double d = Math.pow(this.data[indexIterator.index + n], nArray[n]);
                    this.data[indexIterator.index + n] = Double.isInfinite(d) || Double.isNaN(d) ? 0 : (int)d;
                    ++n;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            int n = abstractDataset.getElementsPerItem();
            if (n == 1) {
                double d2 = 0.0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    double d3 = abstractDataset.getElementDoubleAbs(indexIterator2.index);
                    int n2 = 0;
                    while (n2 < this.isize) {
                        double d4 = (double)this.data[indexIterator.index + n2] - d3;
                        double d5 = d4 * d4 - d2;
                        double d6 = d + d5;
                        d2 = d6 - d - d5;
                        d = d6;
                        ++n2;
                    }
                }
                return d;
            } else {
                if (n != this.isize) throw new IllegalArgumentException("Argument does not have same number of elements per item or is not a non-compound dataset");
                double d7 = 0.0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n3 = 0;
                    while (n3 < this.isize) {
                        double d8 = (double)this.data[indexIterator.index + n3] - abstractDataset.getElementDoubleAbs(indexIterator2.index + n3);
                        double d9 = d8 * d8 - d7;
                        double d10 = d + d9;
                        d7 = d10 - d - d9;
                        d = d10;
                        ++n3;
                    }
                }
            }
            return d;
        } else {
            double[] dArray = CompoundIntegerDataset.toDoubleArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            double d11 = 0.0;
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    double d12 = (double)this.data[indexIterator.index + n] - dArray[n];
                    double d13 = d12 * d12 - d11;
                    double d14 = d + d13;
                    d11 = d14 - d - d13;
                    d = d14;
                    ++n;
                }
            }
        }
        return d;
    }
}

