/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;

public class ComplexFloatDatasetTest {
    @Test
    public void testConstructor() {
        float[] fArray = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f};
        ComplexFloatDataset complexFloatDataset = new ComplexFloatDataset(fArray, new int[0]);
        Assert.assertEquals((long)7L, (long)complexFloatDataset.getDtype());
        Assert.assertEquals((long)2L, (long)complexFloatDataset.getElementsPerItem());
        Assert.assertEquals((long)8L, (long)complexFloatDataset.getItemsize());
        IndexIterator indexIterator = complexFloatDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)(n * 2), (double)complexFloatDataset.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n));
            ++n;
        }
        ComplexFloatDataset complexFloatDataset2 = new ComplexFloatDataset(fArray, 3, 2);
        indexIterator = complexFloatDataset2.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((double)(n2 * 2), (double)complexFloatDataset2.getElementDoubleAbs(indexIterator.index), (double)(1.0E-5 * (double)n2));
            ++n2;
        }
        AbstractDataset abstractDataset = Maths.abs(complexFloatDataset);
        Assert.assertEquals((long)5L, (long)abstractDataset.getDtype());
        Assert.assertEquals((long)1L, (long)abstractDataset.getElementsPerItem());
        Assert.assertEquals((long)4L, (long)abstractDataset.getItemsize());
    }

    @Test
    public void testTake() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 7);
        System.out.println(abstractDataset);
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        AbstractDataset abstractDataset2 = abstractDataset.take(nArray, 0);
        System.out.println(abstractDataset2);
        abstractDataset.setShape(3, 4);
        System.out.println(abstractDataset);
        abstractDataset2 = abstractDataset.take(new int[1], 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[1], 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{3}, 1);
        System.out.println(abstractDataset2);
    }
}

