/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class ComplexDoubleDataset
extends CompoundDoubleDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final int ISIZE = 2;

    @Override
    public int getDtype() {
        return 8;
    }

    public ComplexDoubleDataset() {
        super(2);
    }

    public ComplexDoubleDataset(int ... nArray) {
        super(2, nArray);
    }

    public ComplexDoubleDataset(double[] dArray, int ... nArray) {
        super(2, dArray, nArray);
    }

    public ComplexDoubleDataset(ComplexDoubleDataset complexDoubleDataset) {
        super(complexDoubleDataset);
    }

    public ComplexDoubleDataset(ComplexDoubleDataset complexDoubleDataset, boolean bl) {
        super(complexDoubleDataset, bl);
    }

    public ComplexDoubleDataset(double[] dArray, double[] dArray2, int ... nArray) {
        int n;
        int n2 = n = dArray.length > dArray2.length ? dArray2.length : dArray.length;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{n};
        }
        this.isize = 2;
        this.size = ComplexDoubleDataset.calcSize(nArray);
        if (this.size * this.isize != n) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(nArray), n));
        }
        this.shape = (int[])nArray.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.size) {
            this.data[n4++] = dArray[n3];
            this.data[n4++] = dArray2[n3];
            ++n3;
        }
    }

    public ComplexDoubleDataset(AbstractDataset abstractDataset, AbstractDataset abstractDataset2) {
        super(2, abstractDataset.shape);
        abstractDataset.checkCompatibility(abstractDataset2);
        IndexIterator indexIterator = abstractDataset.getIterator();
        IndexIterator indexIterator2 = abstractDataset2.getIterator();
        int n = 0;
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            this.data[n++] = abstractDataset.getElementDoubleAbs(indexIterator.index);
            this.data[n++] = abstractDataset2.getElementDoubleAbs(indexIterator2.index);
        }
    }

    public ComplexDoubleDataset(AbstractDataset abstractDataset) {
        super(2, abstractDataset.shape);
        this.name = new String(abstractDataset.name);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            this.data[n] = abstractDataset.getElementDoubleAbs(indexIterator.index);
            n += this.isize;
        }
        this.metadataStructure = abstractDataset.metadataStructure;
    }

    public static ComplexDoubleDataset createFromObject(Object object) {
        ComplexDoubleDataset complexDoubleDataset = new ComplexDoubleDataset();
        complexDoubleDataset.shape = ComplexDoubleDataset.getShapeFromObject(object);
        complexDoubleDataset.size = ComplexDoubleDataset.calcSize(complexDoubleDataset.shape);
        complexDoubleDataset.data = complexDoubleDataset.createArray(complexDoubleDataset.size);
        complexDoubleDataset.odata = complexDoubleDataset.data;
        int[] nArray = new int[complexDoubleDataset.shape.length];
        complexDoubleDataset.fillData(object, 0, nArray);
        return complexDoubleDataset;
    }

    public static ComplexDoubleDataset arange(double d) {
        return ComplexDoubleDataset.arange(0.0, d, 1.0);
    }

    public static ComplexDoubleDataset arange(double d, double d2, double d3) {
        int n = ComplexDoubleDataset.calcSteps(d, d2, d3);
        ComplexDoubleDataset complexDoubleDataset = new ComplexDoubleDataset(new int[]{n});
        int n2 = 0;
        while (n2 < n) {
            complexDoubleDataset.data[n2 * 2] = d + (double)n2 * d3;
            ++n2;
        }
        return complexDoubleDataset;
    }

    public static ComplexDoubleDataset ones(int ... nArray) {
        return new ComplexDoubleDataset(nArray).fill(1);
    }

    @Override
    public ComplexDoubleDataset fill(Object object) {
        IndexIterator indexIterator = this.getIterator();
        double d = ComplexDoubleDataset.toReal(object);
        double d2 = ComplexDoubleDataset.toImag(object);
        while (indexIterator.hasNext()) {
            this.data[indexIterator.index] = d;
            this.data[indexIterator.index + 1] = d2;
        }
        return this;
    }

    @Override
    public ComplexDoubleDataset getView() {
        ComplexDoubleDataset complexDoubleDataset = new ComplexDoubleDataset();
        complexDoubleDataset.name = new String(this.name);
        complexDoubleDataset.size = this.size;
        complexDoubleDataset.dataSize = this.dataSize;
        complexDoubleDataset.shape = (int[])this.shape.clone();
        if (this.dataShape != null) {
            complexDoubleDataset.dataShape = (int[])this.dataShape.clone();
        }
        complexDoubleDataset.data = this.data;
        complexDoubleDataset.odata = this.data;
        complexDoubleDataset.metadataStructure = this.metadataStructure;
        return complexDoubleDataset;
    }

    public Complex getComplexAbs(int n) {
        return new Complex(this.data[n], this.data[n + 1]);
    }

    @Override
    public Object getObjectAbs(int n) {
        return new Complex(this.data[n], this.data[n + 1]);
    }

    @Override
    public String getStringAbs(int n) {
        double d = this.data[n + 1];
        return d >= 0.0 ? String.format("%.8g + %.8gj", this.data[n], d) : String.format("%.8g - %.8gj", this.data[n], -d);
    }

    public void setAbs(int n, Complex complex) {
        this.setAbs(n, complex.getReal(), complex.getImaginary());
    }

    @Override
    public void setObjectAbs(int n, Object object) {
        this.setAbs(n, ComplexDoubleDataset.toReal(object), ComplexDoubleDataset.toImag(object));
    }

    public void setAbs(int n, double d, double d2) {
        this.data[n] = d;
        this.data[n + 1] = d2;
        this.setDirty();
    }

    public Complex get(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        Complex complex = new Complex(this.data[n], this.data[n + 1]);
        return complex;
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.getComplex(nArray);
    }

    public double getReal(int ... nArray) {
        return this.getFirstValue(nArray);
    }

    public double getImag(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.data[n + 1];
    }

    public Complex getComplex(int ... nArray) {
        return this.get(nArray);
    }

    @Override
    public String getString(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.getStringAbs(n);
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(new double[]{ComplexDoubleDataset.toReal(object), ComplexDoubleDataset.toImag(object)}, nArray);
    }

    public void set(double d, double d2, int ... nArray) {
        this.setItem(new double[]{d, d2}, nArray);
    }

    public DoubleDataset imag() {
        DoubleDataset doubleDataset = new DoubleDataset(this.shape);
        IndexIterator indexIterator = this.getIterator();
        IndexIterator indexIterator2 = doubleDataset.getIterator();
        double[] dArray = doubleDataset.data;
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            dArray[indexIterator2.index] = this.data[indexIterator.index + 1];
        }
        return doubleDataset;
    }

    @Override
    public Number max() {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public Number min() {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public Object sum() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats-0");
        SummaryStatistics summaryStatistics2 = (SummaryStatistics)this.storedValues.get("stats-1");
        return new Complex(summaryStatistics.getSum(), summaryStatistics2.getSum());
    }

    @Override
    public Object mean() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        SummaryStatistics summaryStatistics = (SummaryStatistics)this.storedValues.get("stats-0");
        SummaryStatistics summaryStatistics2 = (SummaryStatistics)this.storedValues.get("stats-1");
        return new Complex(summaryStatistics.getMean(), summaryStatistics2.getMean());
    }

    @Override
    public int[] maxPos() {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public int[] minPos() {
        throw new UnsupportedOperationException("Cannot compare complex numbers");
    }

    @Override
    public ComplexDoubleDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.getSlice((SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3));
    }

    @Override
    public ComplexDoubleDataset getSlice(SliceIterator sliceIterator) {
        ComplexDoubleDataset complexDoubleDataset = new ComplexDoubleDataset(sliceIterator.getSliceShape());
        double[] dArray = complexDoubleDataset.data;
        IndexIterator indexIterator = complexDoubleDataset.getIterator();
        while (sliceIterator.hasNext() && indexIterator.hasNext()) {
            dArray[indexIterator.index] = this.data[sliceIterator.index];
            dArray[indexIterator.index + 1] = this.data[sliceIterator.index + 1];
        }
        return complexDoubleDataset;
    }

    @Override
    public ComplexDoubleDataset setSlice(Object object, SliceIterator sliceIterator) {
        if (object instanceof ComplexFloatDataset) {
            ComplexFloatDataset complexFloatDataset = (ComplexFloatDataset)object;
            if (!AbstractDataset.areShapesCompatible(sliceIterator.getSliceShape(), complexFloatDataset.shape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(complexFloatDataset.shape), Arrays.toString(sliceIterator.getSliceShape())));
            }
            IndexIterator indexIterator = complexFloatDataset.getIterator();
            float[] fArray = complexFloatDataset.data;
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = fArray[indexIterator.index];
                this.data[sliceIterator.index + 1] = fArray[indexIterator.index + 1];
            }
        } else if (object instanceof ComplexDoubleDataset) {
            ComplexDoubleDataset complexDoubleDataset = (ComplexDoubleDataset)object;
            if (!AbstractDataset.areShapesCompatible(sliceIterator.getSliceShape(), complexDoubleDataset.shape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(complexDoubleDataset.shape), Arrays.toString(sliceIterator.getSliceShape())));
            }
            IndexIterator indexIterator = complexDoubleDataset.getIterator();
            double[] dArray = complexDoubleDataset.data;
            while (sliceIterator.hasNext() && indexIterator.hasNext()) {
                this.data[sliceIterator.index] = dArray[indexIterator.index];
                this.data[sliceIterator.index + 1] = dArray[indexIterator.index + 1];
            }
        } else if (object instanceof IDataset) {
            super.setSlice(object, sliceIterator);
        } else {
            try {
                double d = ComplexDoubleDataset.toReal(object);
                double d2 = ComplexDoubleDataset.toImag(object);
                while (sliceIterator.hasNext()) {
                    this.data[sliceIterator.index] = d;
                    this.data[sliceIterator.index + 1] = d2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexDoubleDataset iadd(Object var1_1) {
        block9: {
            block10: {
                if (!(var1_1 instanceof AbstractDataset)) break block10;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_5 = var2_2.getIterator();
                switch (var2_2.getDtype()) {
                    case 7: 
                    case 8: {
                        while (var3_4.hasNext()) {
                            if (var4_5.hasNext()) {
                                v0 = var3_4.index;
                                this.data[v0] = this.data[v0] + var2_2.getElementDoubleAbs(var4_5.index);
                                v1 = var3_4.index + 1;
                                this.data[v1] = this.data[v1] + var2_2.getElementDoubleAbs(var4_5.index + 1);
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    default: {
                        while (var3_4.hasNext()) {
                            if (var4_5.hasNext()) {
                                v2 = var3_4.index;
                                this.data[v2] = this.data[v2] + var2_2.getElementDoubleAbs(var4_5.index);
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                }
            }
            var2_3 = ComplexDoubleDataset.toReal(var1_1);
            var4_6 = ComplexDoubleDataset.toImag(var1_1);
            var6_7 = this.getIterator();
            if (var4_6 != 0.0) ** GOTO lbl39
            while (var6_7.hasNext()) {
                v3 = var6_7.index;
                this.data[v3] = this.data[v3] + var2_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                v4 = var6_7.index;
                this.data[v4] = this.data[v4] + var2_3;
                v5 = var6_7.index + 1;
                this.data[v5] = this.data[v5] + var4_6;
lbl39:
                // 2 sources

                ** while (var6_7.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexDoubleDataset isubtract(Object var1_1) {
        block9: {
            block10: {
                if (!(var1_1 instanceof AbstractDataset)) break block10;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_5 = var2_2.getIterator();
                switch (var2_2.getDtype()) {
                    case 7: 
                    case 8: {
                        while (var3_4.hasNext()) {
                            if (var4_5.hasNext()) {
                                v0 = var3_4.index;
                                this.data[v0] = this.data[v0] - var2_2.getElementDoubleAbs(var4_5.index);
                                v1 = var3_4.index + 1;
                                this.data[v1] = this.data[v1] - var2_2.getElementDoubleAbs(var4_5.index + 1);
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    default: {
                        while (var3_4.hasNext()) {
                            if (var4_5.hasNext()) {
                                v2 = var3_4.index;
                                this.data[v2] = this.data[v2] - var2_2.getElementDoubleAbs(var4_5.index);
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                }
            }
            var2_3 = ComplexDoubleDataset.toReal(var1_1);
            var4_6 = ComplexDoubleDataset.toImag(var1_1);
            var6_7 = this.getIterator();
            if (var4_6 != 0.0) ** GOTO lbl39
            while (var6_7.hasNext()) {
                v3 = var6_7.index;
                this.data[v3] = this.data[v3] - var2_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                v4 = var6_7.index;
                this.data[v4] = this.data[v4] - var2_3;
                v5 = var6_7.index + 1;
                this.data[v5] = this.data[v5] - var4_6;
lbl39:
                // 2 sources

                ** while (var6_7.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexDoubleDataset imultiply(Object var1_1) {
        block9: {
            block10: {
                if (!(var1_1 instanceof AbstractDataset)) break block10;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_5 = var2_2.getIterator();
                switch (var2_2.getDtype()) {
                    case 7: 
                    case 8: {
                        while (var3_4.hasNext()) {
                            if (var4_5.hasNext()) {
                                var5_7 = this.data[var3_4.index];
                                var7_9 = var2_2.getElementDoubleAbs(var4_5.index);
                                var9_11 = this.data[var3_4.index + 1];
                                var11_13 = var2_2.getElementDoubleAbs(var4_5.index + 1);
                                this.data[var3_4.index] = var5_7 * var7_9 - var9_11 * var11_13;
                                this.data[var3_4.index + 1] = var5_7 * var11_13 + var9_11 * var7_9;
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                    default: {
                        while (var3_4.hasNext()) {
                            if (var4_5.hasNext()) {
                                var5_8 = var2_2.getElementDoubleAbs(var4_5.index);
                                v0 = var3_4.index;
                                this.data[v0] = this.data[v0] * var5_8;
                                v1 = var3_4.index + 1;
                                this.data[v1] = this.data[v1] * var5_8;
                                continue;
                            }
                            break block9;
                        }
                        break block9;
                    }
                }
            }
            var2_3 = ComplexDoubleDataset.toReal(var1_1);
            var4_6 = ComplexDoubleDataset.toImag(var1_1);
            var6_14 = this.getIterator();
            if (var4_6 != 0.0) ** GOTO lbl46
            while (var6_14.hasNext()) {
                v2 = var6_14.index;
                this.data[v2] = this.data[v2] * var2_3;
                v3 = var6_14.index + 1;
                this.data[v3] = this.data[v3] * var2_3;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                var7_10 = this.data[var6_14.index];
                var9_12 = this.data[var6_14.index + 1];
                this.data[var6_14.index] = var7_10 * var2_3 - var9_12 * var4_6;
                this.data[var6_14.index + 1] = var7_10 * var4_6 + var9_12 * var2_3;
lbl46:
                // 2 sources

                ** while (var6_14.hasNext())
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexDoubleDataset idivide(Object var1_1) {
        block12: {
            block15: {
                block14: {
                    block13: {
                        if (!(var1_1 instanceof AbstractDataset)) break block13;
                        var2_2 = (AbstractDataset)var1_1;
                        this.checkCompatibility(var2_2);
                        var3_4 = this.getIterator();
                        var4_5 = var2_2.getIterator();
                        block0 : switch (var2_2.getDtype()) {
                            case 7: 
                            case 8: {
                                while (var3_4.hasNext()) {
                                    if (!var4_5.hasNext()) break block0;
                                    var5_7 = this.data[var3_4.index];
                                    var7_9 = var2_2.getElementDoubleAbs(var4_5.index);
                                    var9_12 = this.data[var3_4.index + 1];
                                    var11_15 = var2_2.getElementDoubleAbs(var4_5.index + 1);
                                    if (Math.abs(var7_9) < Math.abs(var11_15)) {
                                        var13_18 = var7_9 / var11_15;
                                        var15_21 = var7_9 * var13_18 + var11_15;
                                        this.data[var3_4.index] = (var5_7 * var13_18 + var9_12) / var15_21;
                                        this.data[var3_4.index + 1] = (var9_12 * var13_18 - var5_7) / var15_21;
                                        continue;
                                    }
                                    var13_18 = var11_15 / var7_9;
                                    var15_21 = var11_15 * var13_18 + var7_9;
                                    if (var15_21 == 0.0) {
                                        this.data[var3_4.index] = NaN;
                                        this.data[var3_4.index + 1] = NaN;
                                        continue;
                                    }
                                    this.data[var3_4.index] = (var9_12 * var13_18 + var5_7) / var15_21;
                                    this.data[var3_4.index + 1] = (var9_12 - var5_7 * var13_18) / var15_21;
                                }
                                break block12;
                            }
                            default: {
                                while (var3_4.hasNext()) {
                                    if (!var4_5.hasNext()) break block0;
                                    var5_8 = var2_2.getElementDoubleAbs(var4_5.index);
                                    if (var5_8 == 0.0) {
                                        this.data[var3_4.index] = NaN;
                                        this.data[var3_4.index + 1] = NaN;
                                        continue;
                                    }
                                    v0 = var3_4.index;
                                    this.data[v0] = this.data[v0] / var5_8;
                                    v1 = var3_4.index + 1;
                                    this.data[v1] = this.data[v1] / var5_8;
                                }
                                break block12;
                            }
                        }
                        {
                            break block12;
                            break;
                        }
                    }
                    var2_3 = ComplexDoubleDataset.toReal(var1_1);
                    var4_6 = ComplexDoubleDataset.toImag(var1_1);
                    var6_22 = this.getIterator();
                    if (var4_6 != 0.0) break block14;
                    if (var2_3 != 0.0) ** GOTO lbl71
                    if (true) ** GOTO lbl65
                }
                if (!(Math.abs(var2_3) < Math.abs(var4_6))) break block15;
                var7_10 = var2_3 / var4_6;
                var9_13 = var2_3 * var7_10 + var4_6;
                if (true) ** GOTO lbl78
            }
            var7_11 = var4_6 / var2_3;
            var9_14 = var4_6 * var7_11 + var2_3;
            if (true) ** GOTO lbl85
            do {
                this.data[var6_22.index] = NaN;
                this.data[var6_22.index + 1] = NaN;
lbl65:
                // 2 sources

            } while (var6_22.hasNext());
            break block12;
lbl-1000:
            // 1 sources

            {
                v2 = var6_22.index;
                this.data[v2] = this.data[v2] / var2_3;
                v3 = var6_22.index + 1;
                this.data[v3] = this.data[v3] / var2_3;
lbl71:
                // 2 sources

                ** while (var6_22.hasNext())
            }
lbl72:
            // 1 sources

            break block12;
            do {
                var11_16 = this.data[var6_22.index];
                var13_19 = this.data[var6_22.index + 1];
                this.data[var6_22.index] = (var11_16 * var7_10 + var13_19) / var9_13;
                this.data[var6_22.index + 1] = (var13_19 * var7_10 - var11_16) / var9_13;
lbl78:
                // 2 sources

            } while (var6_22.hasNext());
            break block12;
            do {
                var11_17 = this.data[var6_22.index];
                var13_20 = this.data[var6_22.index + 1];
                this.data[var6_22.index] = (var13_20 * var7_11 + var11_17) / var9_14;
                this.data[var6_22.index + 1] = (var13_20 - var11_17 * var7_11) / var9_14;
lbl85:
                // 2 sources

            } while (var6_22.hasNext());
        }
        this.setDirty();
        return this;
    }

    @Override
    public ComplexDoubleDataset iremainder(Object object) {
        throw new UnsupportedOperationException("Unsupported method for class");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ComplexDoubleDataset ipower(Object object) {
        block8: {
            block9: {
                if (!(object instanceof AbstractDataset)) break block9;
                AbstractDataset abstractDataset = (AbstractDataset)object;
                this.checkCompatibility(abstractDataset);
                IndexIterator indexIterator = this.getIterator();
                IndexIterator indexIterator2 = abstractDataset.getIterator();
                switch (abstractDataset.getDtype()) {
                    case 7: 
                    case 8: {
                        while (indexIterator.hasNext()) {
                            if (indexIterator2.hasNext()) {
                                Complex complex = new Complex(abstractDataset.getElementDoubleAbs(indexIterator2.index), abstractDataset.getElementDoubleAbs(indexIterator2.index + 1));
                                Complex complex2 = new Complex(this.data[indexIterator.index], this.data[indexIterator.index + 1]).pow(complex);
                                this.data[indexIterator.index] = complex2.getReal();
                                this.data[indexIterator.index + 1] = complex2.getImaginary();
                                continue;
                            }
                            break block8;
                        }
                        break block8;
                    }
                    default: {
                        while (indexIterator.hasNext()) {
                            if (indexIterator2.hasNext()) {
                                Complex complex = new Complex(abstractDataset.getElementDoubleAbs(indexIterator2.index), 0.0);
                                Complex complex3 = new Complex(this.data[indexIterator.index], this.data[indexIterator.index + 1]).pow(complex);
                                this.data[indexIterator.index] = complex3.getReal();
                                this.data[indexIterator.index + 1] = complex3.getImaginary();
                                continue;
                            }
                            break block8;
                        }
                        break block8;
                    }
                }
            }
            Complex complex = new Complex(ComplexDoubleDataset.toReal(object), ComplexDoubleDataset.toImag(object));
            IndexIterator indexIterator = this.getIterator();
            while (indexIterator.hasNext()) {
                Complex complex4 = new Complex(this.data[indexIterator.index], this.data[indexIterator.index + 1]).pow(complex);
                this.data[indexIterator.index] = complex4.getReal();
                this.data[indexIterator.index + 1] = complex4.getImaginary();
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            double d2 = 0.0;
            switch (abstractDataset.getDtype()) {
                case 7: 
                case 8: {
                    while (indexIterator.hasNext()) {
                        if (!indexIterator2.hasNext()) {
                            return d;
                        }
                        double d3 = this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                        double d4 = d3 * d3 - d2;
                        double d5 = d + d4;
                        d2 = d5 - d - d4;
                        d = d5;
                        d3 = this.data[indexIterator.index + 1] - abstractDataset.getElementDoubleAbs(indexIterator2.index + 1);
                        d4 = d3 * d3 - d2;
                        d5 = d + d4;
                        d2 = d5 - d - d4;
                        d = d5;
                    }
                    return d;
                }
            }
            while (indexIterator.hasNext()) {
                if (!indexIterator2.hasNext()) {
                    return d;
                }
                double d6 = this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                double d7 = d6 * d6 - d2;
                double d8 = d + d7;
                d2 = d8 - d - d7;
                d = d8;
            }
            return d;
        }
        Complex complex = new Complex(ComplexDoubleDataset.toReal(object), ComplexDoubleDataset.toImag(object));
        IndexIterator indexIterator = this.getIterator();
        double d9 = 0.0;
        while (indexIterator.hasNext()) {
            double d10 = this.data[indexIterator.index] - complex.getReal();
            double d11 = d10 * d10 - d9;
            double d12 = d + d11;
            d9 = d12 - d - d11;
            d = d12;
            d10 = this.data[indexIterator.index + 1] - complex.getImaginary();
            d11 = d10 * d10 - d9;
            d12 = d + d11;
            d9 = d12 - d - d11;
            d = d12;
        }
        return d;
    }

    public static /* bridge */ /* synthetic */ CompoundDoubleDataset createFromObject(Object object) {
        return ComplexDoubleDataset.createFromObject(object);
    }
}

