/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CollectionStats;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.gda.util.number.DoubleUtils;

public class CollectionStatsTest {
    private static List<IDataset> SETS1D = new ArrayList<IDataset>(5);
    private static List<IDataset> SETS2D;

    static {
        SETS1D.add(new DoubleDataset(new double[]{1.0, 2.0, 1.0, 4.0, 5.0}, 5));
        SETS1D.add(new DoubleDataset(new double[]{500.0, 2.0, 1.0, 4.0, 5.0}, 5));
        SETS1D.add(new DoubleDataset(new double[]{1.0, 2.0, 1.0, 4.0, 5.0}, 5));
        SETS1D.add(new DoubleDataset(new double[]{1.0, 2.0, 3.0, 4.0, 500.0}, 5));
        SETS1D.add(new DoubleDataset(new double[]{1.0, 2.0, 300.0, 4.0, 5.0}, 5));
        SETS2D = new ArrayList<IDataset>(5);
        SETS2D.add(new DoubleDataset(new double[]{1.0, 2.0, 1.0, 4.0}, 2, 2));
        SETS2D.add(new DoubleDataset(new double[]{500.0, 2.0, 1.0, 4.0}, 2, 2));
        SETS2D.add(new DoubleDataset(new double[]{1.0, 2.0, 1.0, 4.0}, 2, 2));
        SETS2D.add(new DoubleDataset(new double[]{1.0, 2.0, 3.0, 500.0}, 2, 2));
        SETS2D.add(new DoubleDataset(new double[]{1.0, 2.0, 300.0, 4.0}, 2, 2));
    }

    @Test
    public void test2D() throws Exception {
        AbstractDataset abstractDataset = CollectionStats.median(SETS2D);
        if (abstractDataset.getDouble(0, 0) != 1.0) {
            throw new Exception("Median not calculated correctly!");
        }
        if (abstractDataset.getDouble(1, 1) != 4.0) {
            throw new Exception("Median not calculated correctly!");
        }
        if (abstractDataset.getShape()[0] != 2) {
            throw new Exception("Median shape not correct!");
        }
        if (abstractDataset.getShape()[1] != 2) {
            throw new Exception("Median shape not correct!");
        }
        AbstractDataset abstractDataset2 = CollectionStats.mean(SETS2D);
        if (!DoubleUtils.equalsWithinTolerance((Number)abstractDataset2.getDouble(0, 0), (Number)100.8, (Number)0.01)) {
            throw new Exception("Mean not calculated correctly!");
        }
        if (!DoubleUtils.equalsWithinTolerance((Number)abstractDataset2.getDouble(1, 1), (Number)103.2, (Number)0.01)) {
            throw new Exception("Mean not calculated correctly!");
        }
    }

    @Test
    public void test1D() throws Exception {
        AbstractDataset abstractDataset = CollectionStats.median(SETS1D);
        if (abstractDataset.getDouble(0) != 1.0) {
            throw new Exception("Median not calculated correctly!");
        }
        if (abstractDataset.getDouble(4) != 5.0) {
            throw new Exception("Median not calculated correctly!");
        }
        AbstractDataset abstractDataset2 = CollectionStats.mean(SETS1D);
        if (!DoubleUtils.equalsWithinTolerance((Number)abstractDataset2.getDouble(0), (Number)100.8, (Number)1.0E-4)) {
            throw new Exception("Mean not calculated correctly!");
        }
        if (!DoubleUtils.equalsWithinTolerance((Number)abstractDataset2.getDouble(4), (Number)104, (Number)1.0E-4)) {
            throw new Exception("Mean not calculated correctly!");
        }
    }

    @Test
    public void testLarge() throws Exception {
        long l = System.currentTimeMillis();
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>(10);
        File file = new File(String.valueOf(System.getProperty("GDALargeTestFilesLocation")) + "EDFLoaderTest/");
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].getName().startsWith("billeA")) {
                arrayList.add(LoaderFactory.getData(fileArray[n].getAbsolutePath(), null).getDataset(0));
            }
            ++n;
        }
        AbstractDataset abstractDataset = CollectionStats.median(arrayList);
        long l2 = System.currentTimeMillis();
        if (abstractDataset.getShape()[0] != 2048) {
            throw new Exception("Median has wrong size!");
        }
        if (abstractDataset.getShape()[1] != 2048) {
            throw new Exception("Median has wrong size!");
        }
        System.out.println("Did median of ten images 2048x2048 in " + (double)(l2 - l) / 1000.0 + "s");
        AbstractDataset abstractDataset2 = CollectionStats.median(arrayList);
        long l3 = System.currentTimeMillis();
        if (abstractDataset2.getShape()[0] != 2048) {
            throw new Exception("Mean has wrong size!");
        }
        if (abstractDataset2.getShape()[1] != 2048) {
            throw new Exception("Mean has wrong size!");
        }
        System.out.println("Did mean of ten images 2048x2048 in " + (double)(l3 - l2) / 1000.0 + "s");
    }
}

