/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;

public class CollectionStats {
    public static AbstractDataset mean(List<IDataset> list) throws Exception {
        return CollectionStats.process(list, new StatFunction(){

            @Override
            public double evaluate(IDataset iDataset) {
                return (Double)((AbstractDataset)iDataset).mean();
            }
        });
    }

    public static AbstractDataset median(List<IDataset> list) throws Exception {
        return CollectionStats.process(list, new StatFunction(){

            @Override
            public double evaluate(IDataset iDataset) {
                return (Double)Stats.median((AbstractDataset)iDataset);
            }
        });
    }

    private static AbstractDataset process(List<IDataset> list, StatFunction statFunction) throws Exception {
        CollectionStats.assertSize(list);
        double[] dArray = new double[list.get(0).getSize()];
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = new double[list.size()];
            int n2 = 0;
            while (n2 < dArray2.length) {
                dArray2[n2] = ((AbstractDataset)list.get(n2)).getElementDoubleAbs(n);
                ++n2;
            }
            DoubleDataset doubleDataset = new DoubleDataset(dArray2, dArray2.length);
            dArray[n] = statFunction.evaluate(doubleDataset);
            ++n;
        }
        return new DoubleDataset(dArray, list.get(0).getShape());
    }

    private static void assertSize(Collection<IDataset> collection) throws Exception {
        if (collection.size() < 2) {
            throw new Exception("You must take the median of at least two sets!");
        }
        Iterator<IDataset> iterator = collection.iterator();
        int[] nArray = iterator.next().getShape();
        while (iterator.hasNext()) {
            int[] nArray2 = iterator.next().getShape();
            if (Arrays.equals(nArray, nArray2)) continue;
            throw new Exception("All data sets should be the same shape!");
        }
    }

    private static interface StatFunction {
        public double evaluate(IDataset var1);
    }
}

