/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;

public class BooleanIteratorTest {
    AbstractDataset a;
    AbstractDataset b;

    @Before
    public void setUpClass() {
        this.a = new DoubleDataset(new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0}, new int[0]);
        this.b = new DoubleDataset(new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0}, new int[0]);
    }

    @Test
    public void testEqualTo() {
        AbstractDataset abstractDataset = this.a.clone().reshape(2, 3);
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[3] = true;
        blArray[5] = true;
        BooleanDataset booleanDataset = new BooleanDataset(blArray, new int[0]);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        BooleanIterator booleanIterator = abstractDataset.getBooleanIterator(booleanDataset);
        while (booleanIterator.hasNext()) {
            arrayList.add((int)abstractDataset.getElementLongAbs(booleanIterator.index));
        }
        this.checkDatasets((IntegerDataset)AbstractDataset.createFromList(arrayList), new IntegerDataset(new int[]{1, 5, -9}, null));
    }

    public void checkDatasets(IntegerDataset integerDataset, IntegerDataset integerDataset2) {
        IndexIterator indexIterator = integerDataset.getIterator(true);
        IndexIterator indexIterator2 = integerDataset2.getIterator();
        int n = integerDataset.getElementsPerItem();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(indexIterator.getPos()) + "; " + n2 + ": "), (long)integerDataset2.getAbs(indexIterator.index + n2), (long)integerDataset.getAbs(indexIterator2.index + n2));
                ++n2;
            }
        }
    }
}

