/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AggregateDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;

public class AggregateDatasetTest {
    ILazyDataset[] datasets;

    @Before
    public void init() {
        this.datasets = new ILazyDataset[]{AbstractDataset.zeros(new int[]{2, 3}, 3).fill(0), AbstractDataset.zeros(new int[]{2, 3}, 3).fill(1), AbstractDataset.zeros(new int[]{2, 3}, 3).fill(2), AbstractDataset.zeros(new int[]{2, 3}, 3).fill(3), AbstractDataset.zeros(new int[]{2, 3}, 3).fill(4)};
    }

    @Test
    public void testConstructorFailures() {
        try {
            new AggregateDataset(true, new ILazyDataset[0]);
        }
        catch (Exception exception) {
            try {
                new AggregateDataset(false, new ILazyDataset[0]);
            }
            catch (Exception exception2) {
                try {
                    new AggregateDataset(false, AbstractDataset.ones(new int[]{2, 3}, 0), AbstractDataset.ones(new int[]{3, 4}, 0));
                }
                catch (Exception exception3) {
                    try {
                        new AggregateDataset(true, AbstractDataset.ones(new int[]{2, 3}, 0), AbstractDataset.ones(new int[]{3, 3}, 0));
                    }
                    catch (Exception exception4) {
                        return;
                    }
                }
            }
        }
        Assert.fail((String)"No exceptions thrown!");
    }

    @Test
    public void testUnextendedShape() {
        AggregateDataset aggregateDataset = new AggregateDataset(false, this.datasets);
        Assert.assertEquals((String)"Incorrect rank", (long)this.datasets[0].getRank(), (long)aggregateDataset.getRank());
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2 * this.datasets.length, 3}, (int[])aggregateDataset.getShape());
        AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(new Slice[]{null, null}));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2 * this.datasets.length, 3}, (int[])abstractDataset.getShape());
        abstractDataset = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(null, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 2}, (int[])abstractDataset.getShape());
        int[] nArray = new int[2];
        nArray[0] = 1;
        abstractDataset = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(nArray, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2}, (int[])abstractDataset.getShape());
    }

    @Test
    public void testExtendedShape() {
        AggregateDataset aggregateDataset = new AggregateDataset(true, this.datasets);
        Assert.assertEquals((String)"Incorrect rank", (long)(this.datasets[0].getRank() + 1), (long)aggregateDataset.getRank());
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{this.datasets.length, 2, 3}, (int[])aggregateDataset.getShape());
        AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(new Slice[]{null, null, null}));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{this.datasets.length, 2, 3}, (int[])abstractDataset.getShape());
        abstractDataset = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(null, new int[]{2, 2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 2, 2}, (int[])abstractDataset.getShape());
        int[] nArray = new int[3];
        nArray[0] = 1;
        abstractDataset = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(nArray, new int[]{2, 2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2, 2}, (int[])abstractDataset.getShape());
    }

    @Test
    public void testRepeatedDataset() {
        AbstractDataset abstractDataset = AbstractDataset.arange(3.0, 6);
        Object[] objectArray = new AbstractDataset[5];
        Arrays.fill(objectArray, abstractDataset);
        AggregateDataset aggregateDataset = new AggregateDataset(true, (ILazyDataset[])objectArray);
        Assert.assertEquals((String)"Incorrect rank", (long)(abstractDataset.getRank() + 1), (long)aggregateDataset.getRank());
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{objectArray.length, 3}, (int[])aggregateDataset.getShape());
        int[] nArray = new int[2];
        nArray[0] = 1;
        AbstractDataset abstractDataset2 = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(nArray, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2}, (int[])abstractDataset2.getShape());
        Assert.assertArrayEquals((String)"Incorrect values", (double[])new double[]{0.0, 1.0}, (double[])((double[])abstractDataset2.getBuffer()), (double)1.0E-5);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        abstractDataset2 = DatasetUtils.convertToAbstractDataset(aggregateDataset.getSlice(nArray2, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 1}, (int[])abstractDataset2.getShape());
        Assert.assertArrayEquals((String)"Incorrect values", (double[])new double[]{1.0, 1.0}, (double[])((double[])abstractDataset2.getBuffer()), (double)1.0E-5);
    }
}

