/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.analysis.io.ScanFileHolderException;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.gda.monitor.IMonitor;

public class AggregateDataset
implements ILazyDataset {
    private ILazyDataset[] data = null;
    private int[] map = null;
    private int[] offset = null;
    private int[] shape;
    private int size;
    private String name;
    private int dtype = -1;

    public static int[][] calcShapes(boolean bl, ILazyDataset ... iLazyDatasetArray) {
        Object object;
        if (iLazyDatasetArray.length == 0) {
            throw new IllegalArgumentException("No datasets given");
        }
        int n = -1;
        Object[] objectArray = iLazyDatasetArray;
        int n2 = iLazyDatasetArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = objectArray[n3];
            if (object == null) {
                throw new IllegalArgumentException("Null dataset given");
            }
            int n4 = object.getRank();
            if (n4 > n) {
                n = n4;
            }
            ++n3;
        }
        if (bl) {
            ++n;
        }
        object = new int[iLazyDatasetArray.length][];
        n3 = 0;
        while (n3 < iLazyDatasetArray.length) {
            ILazyDataset iLazyDataset = iLazyDatasetArray[n3];
            objectArray = iLazyDataset.getShape();
            if (objectArray.length < n) {
                int[] nArray = new int[n];
                int n5 = n - objectArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    nArray[n6] = 1;
                    ++n6;
                }
                n6 = 0;
                while (n6 < objectArray.length) {
                    nArray[n6 + n5] = (int)objectArray[n6];
                    ++n6;
                }
                objectArray = nArray;
            }
            object[n3] = objectArray;
            ++n3;
        }
        return object;
    }

    public AggregateDataset(boolean bl, ILazyDataset ... iLazyDatasetArray) {
        int n;
        int n2;
        int[][] nArray = AggregateDataset.calcShapes(bl, iLazyDatasetArray);
        int[] nArray2 = nArray[0];
        int n3 = bl ? -1 : 0;
        int n4 = 1;
        while (n4 < nArray.length) {
            if (!AbstractDataset.areShapesCompatible(nArray2, nArray[n4], n3)) {
                throw new IllegalArgumentException("Dataset '" + iLazyDatasetArray[n4].getName() + "' has wrong shape");
            }
            ++n4;
        }
        n4 = nArray2.length;
        this.data = new ILazyDataset[iLazyDatasetArray.length];
        int n5 = 0;
        while (n5 < iLazyDatasetArray.length) {
            ILazyDataset iLazyDataset = iLazyDatasetArray[n5];
            int[] nArray3 = iLazyDataset.getShape();
            if (nArray3.length < n4) {
                iLazyDataset = iLazyDataset.clone();
                iLazyDataset.setShape(nArray[n5]);
            }
            this.data[n5] = iLazyDataset;
            ++n5;
        }
        this.shape = new int[n4];
        n5 = 1;
        while (n5 < this.shape.length) {
            this.shape[n5] = nArray2[n5];
            ++n5;
        }
        if (bl) {
            this.shape[0] = this.data.length;
        } else {
            n5 = 0;
            while (n5 < iLazyDatasetArray.length) {
                this.shape[0] = this.shape[0] + nArray[n5][0];
                ++n5;
            }
        }
        this.size = AbstractDataset.calcSize(this.shape);
        this.offset = new int[this.data.length];
        n5 = 0;
        int n6 = 0;
        while (n6 < this.data.length) {
            this.offset[n6] = n5;
            n5 += this.data[n6].getShape()[0];
            ++n6;
        }
        this.map = new int[this.shape[0]];
        n6 = 0;
        int n7 = 0;
        while (n7 < this.data.length) {
            n2 = this.data[n7].getShape()[0];
            n = 0;
            while (n < n2) {
                this.map[n6++] = n7;
                ++n;
            }
            ++n7;
        }
        ILazyDataset[] iLazyDatasetArray2 = this.data;
        n = this.data.length;
        n2 = 0;
        while (n2 < n) {
            ILazyDataset iLazyDataset = iLazyDatasetArray2[n2];
            this.dtype = iLazyDataset instanceof LazyDataset ? AbstractDataset.getBestDType(this.dtype, ((LazyDataset)iLazyDataset).getDtype()) : AbstractDataset.getBestDType(this.dtype, AbstractDataset.getDTypeFromClass(iLazyDataset.elementClass()));
            ++n2;
        }
        iLazyDatasetArray2 = this.data;
        n = this.data.length;
        n2 = 0;
        while (n2 < n) {
            ILazyDataset iLazyDataset = iLazyDatasetArray2[n2];
            String string = iLazyDataset.getName();
            if (string != null) {
                this.name = string;
                break;
            }
            ++n2;
        }
    }

    @Override
    public Class<?> elementClass() {
        return AbstractDataset.elementClass(this.getDtype());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int[] getShape() {
        return (int[])this.shape.clone();
    }

    @Override
    public void setShape(int ... nArray) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public ILazyDataset squeeze() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ILazyDataset squeeze(boolean bl) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public IDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        try {
            return this.getSlice(null, nArray, nArray2, nArray3);
        }
        catch (ScanFileHolderException scanFileHolderException) {
            return null;
        }
    }

    public int getDtype() {
        return this.dtype;
    }

    @Override
    public IDataset getSlice(IMonitor iMonitor, int[] nArray, int[] nArray2, int[] nArray3) throws ScanFileHolderException {
        AbstractDataset abstractDataset;
        int n;
        if (nArray == null) {
            nArray = new int[this.shape.length];
        }
        if (nArray2 == null) {
            nArray2 = (int[])this.shape.clone();
        }
        if (nArray3 == null) {
            nArray3 = new int[this.shape.length];
            Arrays.fill(nArray3, 1);
        }
        int n2 = nArray[0];
        int n3 = nArray2[0];
        int n4 = nArray3[0];
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        int n5 = n = n2;
        ILazyDataset iLazyDataset = this.data[this.map[n]];
        while (n5 < n3) {
            ILazyDataset iLazyDataset2 = this.data[this.map[n5]];
            if (iLazyDataset2 != iLazyDataset) {
                nArray[0] = n - this.offset[this.map[n]];
                nArray2[0] = n5 - this.offset[this.map[n]];
                abstractDataset = DatasetUtils.convertToAbstractDataset(iLazyDataset.getSlice(iMonitor, nArray, nArray2, nArray3));
                abstractDataset = abstractDataset.cast(this.dtype);
                arrayList.add(abstractDataset);
                iLazyDataset = iLazyDataset2;
                n = n5;
            }
            n5 += n4;
        }
        nArray[0] = n - this.offset[this.map[n]];
        nArray2[0] = n5 - this.offset[this.map[n]];
        arrayList.add(DatasetUtils.convertToAbstractDataset(iLazyDataset.getSlice(iMonitor, nArray, nArray2, nArray3)));
        abstractDataset = DatasetUtils.concatenate(arrayList.toArray(new AbstractDataset[0]), 0);
        abstractDataset.setName(this.name);
        return abstractDataset;
    }

    @Override
    public IDataset getSlice(Slice ... sliceArray) {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        Slice.convertFromSlice(sliceArray, this.shape, nArray, nArray2, nArray3);
        return this.getSlice(nArray, nArray2, nArray3);
    }

    @Override
    public IDataset getSlice(IMonitor iMonitor, Slice ... sliceArray) throws ScanFileHolderException {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        Slice.convertFromSlice(sliceArray, this.shape, nArray, nArray2, nArray3);
        return this.getSlice(iMonitor, nArray, nArray2, nArray3);
    }

    @Override
    public IMetaData getMetadata() throws Exception {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void setMetadata(IMetaData iMetaData) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public AggregateDataset clone() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && this.name.length() > 0) {
            stringBuilder.append("Aggregate dataset '");
            stringBuilder.append(this.name);
            stringBuilder.append("' has shape [");
        } else {
            stringBuilder.append("Aggregate dataset shape is [");
        }
        int n2 = n = this.shape == null ? 0 : this.shape.length;
        if (n > 0 && this.shape[0] > 0) {
            stringBuilder.append(this.shape[0]);
        }
        int n3 = 1;
        while (n3 < n) {
            stringBuilder.append(", " + this.shape[n3]);
            ++n3;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

