/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.HashSet;
import org.apache.commons.math.complex.Complex;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;

public class AbstractDatasetTest {
    @Test
    public void testCompatibleShapes() {
        Assert.assertTrue((String)"[] and []", (boolean)AbstractDataset.areShapesCompatible(new int[0], new int[0]));
        Assert.assertTrue((String)"[1] and []", (boolean)AbstractDataset.areShapesCompatible(new int[]{1}, new int[0]));
        Assert.assertFalse((String)"[2] and []", (boolean)AbstractDataset.areShapesCompatible(new int[]{2}, new int[0]));
        Assert.assertTrue((String)"[2] and [2]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2}, new int[]{2}));
        Assert.assertTrue((String)"[3] and [3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{3}, new int[]{3}));
        Assert.assertTrue((String)"[1,2] and [2]", (boolean)AbstractDataset.areShapesCompatible(new int[]{1, 2}, new int[]{2}));
        Assert.assertTrue((String)"[2] and [1,2]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2}, new int[]{1, 2}));
        Assert.assertFalse((String)"[10,10] and [10,10,10]", (boolean)AbstractDataset.areShapesCompatible(new int[]{10, 10}, new int[]{10, 10, 10}));
        Assert.assertFalse((String)"[10,10,10] and [10,10]", (boolean)AbstractDataset.areShapesCompatible(new int[]{10, 10, 10}, new int[]{10, 10}));
        Assert.assertTrue((String)"[2] and [2,1,1,1]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2}, new int[]{2, 1, 1, 1}));
        Assert.assertTrue((String)"[2,1] and [2,1,1,1]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1}, new int[]{2, 1, 1, 1}));
        Assert.assertFalse((String)"[2,1] and [3,1,1,2]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1}, new int[]{3, 1, 1, 2}));
        Assert.assertFalse((String)"[2,1] and [3,1,1,1]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1}, new int[]{3, 1, 1, 1}));
        Assert.assertTrue((String)"[1,2,1] and [2,1,1,1]", (boolean)AbstractDataset.areShapesCompatible(new int[]{1, 2, 1}, new int[]{2, 1, 1, 1}));
        Assert.assertTrue((String)"[1,2,1,3] and [2,1,1,1,3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{1, 2, 1, 3}, new int[]{2, 1, 1, 1, 3}));
        Assert.assertTrue((String)"[2,1,1] and [1,1,2]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1, 1}, new int[]{1, 1, 2}));
        Assert.assertFalse((String)"[2,1,1] and [1,1,3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1, 1}, new int[]{1, 1, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,1,1,3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1, 4}, new int[]{2, 1, 1, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,1,3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1, 4}, new int[]{2, 1, 3}));
        Assert.assertFalse((String)"[2,4] and [2,3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 4}, new int[]{2, 3}));
        Assert.assertTrue((String)"[2,1,4] and [2,1,4]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1, 4}, new int[]{2, 1, 4}));
        Assert.assertTrue((String)"[2,1,4] and [2,1,1,4]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1, 4}, new int[]{2, 1, 1, 4}));
        Assert.assertFalse((String)"[2,4] and [2,4,3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 4}, new int[]{2, 4, 3}));
        Assert.assertFalse((String)"[2,1,4] and [2,4,3]", (boolean)AbstractDataset.areShapesCompatible(new int[]{2, 1, 4}, new int[]{2, 4, 3}));
    }

    @Test
    public void testMax() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        System.out.println(abstractDataset.max());
    }

    @Test
    public void testMaxSpeed() {
        long l;
        AbstractDataset abstractDataset = AbstractDataset.arange(1000000.0, 6);
        int n = 0;
        while (n < 10) {
            abstractDataset.set(1, 0);
            l = -System.nanoTime();
            abstractDataset.max();
            l += System.nanoTime();
            ++n;
        }
        long l2 = 0L;
        n = 0;
        while (n < 200) {
            abstractDataset.set(1, 0);
            l = -System.nanoTime();
            abstractDataset.max();
            l2 += (l += System.nanoTime());
            ++n;
        }
        System.out.printf("Max double calculation took %g ms\n", (double)l2 * 1.0E-6 / 200.0);
        abstractDataset = AbstractDataset.arange(1000000.0, 2);
        l2 = 0L;
        n = 0;
        while (n < 200) {
            abstractDataset.set(1, 0);
            l = -System.nanoTime();
            abstractDataset.max();
            l2 += (l += System.nanoTime());
            ++n;
        }
        System.out.printf("Max short calculation took %g ms\n", (double)l2 * 1.0E-6 / 200.0);
    }

    @Test
    public void testSort() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        abstractDataset.set(12, 0);
        System.out.println(abstractDataset.sort(null));
    }

    @Test
    public void testTake() {
        AbstractDataset abstractDataset = AbstractDataset.arange(12.0, 6);
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 4;
        AbstractDataset abstractDataset2 = abstractDataset.take(nArray, 0);
        System.out.println(abstractDataset2);
        abstractDataset.setShape(3, 4);
        System.out.println(abstractDataset);
        abstractDataset2 = abstractDataset.take(new int[1], 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 0);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[1], 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{1}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{2}, 1);
        System.out.println(abstractDataset2);
        abstractDataset2 = abstractDataset.take(new int[]{3}, 1);
        System.out.println(abstractDataset2);
    }

    @Test
    public void testSqueeze() {
        AbstractDataset abstractDataset = AbstractDataset.arange(10.0, 6);
        abstractDataset.setShape(2, 1, 5);
        abstractDataset.squeeze();
        Assert.assertEquals((long)2L, (long)abstractDataset.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset.getShape()[0]);
        Assert.assertEquals((long)5L, (long)abstractDataset.getShape()[1]);
    }

    @Test
    public void testTile() {
        AbstractDataset abstractDataset = AbstractDataset.arange(3.0, 6);
        AbstractDataset abstractDataset2 = DatasetUtils.tile(abstractDataset, 2);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0};
        Assert.assertEquals((long)1L, (long)abstractDataset2.getShape().length);
        Assert.assertEquals((long)6L, (long)abstractDataset2.getShape()[0]);
        int n = 0;
        while (n < dArray.length) {
            Assert.assertEquals((double)dArray[n], (double)((DoubleDataset)abstractDataset2).getData()[n], (double)1.0E-6);
            ++n;
        }
        AbstractDataset abstractDataset3 = DatasetUtils.tile(abstractDataset, 1, 2);
        Assert.assertEquals((long)2L, (long)abstractDataset3.getShape().length);
        Assert.assertEquals((long)1L, (long)abstractDataset3.getShape()[0]);
        Assert.assertEquals((long)6L, (long)abstractDataset3.getShape()[1]);
        int n2 = 0;
        while (n2 < dArray.length) {
            Assert.assertEquals((double)dArray[n2], (double)((DoubleDataset)abstractDataset3).getData()[n2], (double)1.0E-6);
            ++n2;
        }
        AbstractDataset abstractDataset4 = DatasetUtils.tile(abstractDataset, 2, 1);
        Assert.assertEquals((long)2L, (long)abstractDataset4.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset4.getShape()[0]);
        Assert.assertEquals((long)3L, (long)abstractDataset4.getShape()[1]);
        int n3 = 0;
        while (n3 < dArray.length) {
            Assert.assertEquals((double)dArray[n3], (double)((DoubleDataset)abstractDataset4).getData()[n3], (double)1.0E-6);
            ++n3;
        }
        abstractDataset = AbstractDataset.arange(6.0, 6);
        abstractDataset.setShape(2, 3);
        AbstractDataset abstractDataset5 = DatasetUtils.tile(abstractDataset, 2);
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)abstractDataset5.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset5.getShape()[0]);
        Assert.assertEquals((long)6L, (long)abstractDataset5.getShape()[1]);
        int n4 = 0;
        while (n4 < dArray2.length) {
            Assert.assertEquals((double)dArray2[n4], (double)((DoubleDataset)abstractDataset5).getData()[n4], (double)1.0E-6);
            ++n4;
        }
        AbstractDataset abstractDataset6 = DatasetUtils.tile(abstractDataset, 1, 2);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)6L, (long)abstractDataset6.getShape()[1]);
        int n5 = 0;
        while (n5 < dArray2.length) {
            Assert.assertEquals((double)dArray2[n5], (double)((DoubleDataset)abstractDataset6).getData()[n5], (double)1.0E-6);
            ++n5;
        }
        AbstractDataset abstractDataset7 = DatasetUtils.tile(abstractDataset, 2, 1);
        double[] dArray3 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        Assert.assertEquals((long)2L, (long)abstractDataset7.getShape().length);
        Assert.assertEquals((long)4L, (long)abstractDataset7.getShape()[0]);
        Assert.assertEquals((long)3L, (long)abstractDataset7.getShape()[1]);
        int n6 = 0;
        while (n6 < dArray3.length) {
            Assert.assertEquals((double)dArray3[n6], (double)((DoubleDataset)abstractDataset7).getData()[n6], (double)1.0E-6);
            ++n6;
        }
    }

    @Test
    public void testTileSpeed() throws Exception {
        int[][] nArrayArray = new int[][]{{1024, 1}, {256, 4}, {64, 16}, {32, 32}, {16, 64}, {4, 256}, {1, 1024}};
        int[][] nArrayArray2 = new int[][]{{1024, 2048}, {2048, 2048}, {2048, 1024}};
        int n = 0;
        while (n < nArrayArray.length) {
            int n2 = 0;
            while (n2 < nArrayArray2.length) {
                int n3 = 0;
                while (n3 < 3) {
                    this.runTile(nArrayArray[n][0], nArrayArray[n][1], nArrayArray2[n2][0], nArrayArray2[n2][1]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    private void runTile(int n, int n2, int n3, int n4) throws Exception {
        int n5;
        AbstractDataset abstractDataset = AbstractDataset.arange(n * n2, 6).reshape(n, n2);
        System.out.printf("Tile %sx%d Block %dx%d: ", n3, n4, n, n2);
        int n6 = n3 / n;
        int n7 = n4 / n2;
        long l = System.currentTimeMillis();
        DoubleDataset doubleDataset = new DoubleDataset(n3, n4);
        double[] dArray = (double[])abstractDataset.getBuffer();
        double[] dArray2 = doubleDataset.getData();
        if (n2 == 1) {
            n5 = 0;
            while (n5 < dArray2.length) {
                dArray2[n5] = dArray[n5 / n4 % n];
                ++n5;
            }
        } else if (n == 1) {
            n5 = 0;
            while (n5 < dArray2.length) {
                dArray2[n5] = dArray[n5 % n2];
                ++n5;
            }
        } else {
            n5 = 0;
            while (n5 < dArray2.length) {
                dArray2[n5] = dArray[n5 / n4 % n * n2 + n5 % n2];
                ++n5;
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        System.out.printf("array = %d ms, ", l3);
        l = System.currentTimeMillis();
        AbstractDataset abstractDataset2 = DatasetUtils.tile(abstractDataset, n6, n7);
        l2 = System.currentTimeMillis();
        long l4 = l2 - l;
        System.out.printf("tile = %d ms\n", l4);
        Assert.assertEquals((long)n3, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((long)n4, (long)abstractDataset2.getShape()[1]);
        if (!abstractDataset2.equals(doubleDataset)) {
            throw new Exception("Datasets not equal!");
        }
        if (l4 > l3 * 20L) {
            throw new Exception("Creation of tile took more than 20x as long as array creation of same size! (It took " + l4 + ")");
        }
    }

    @Test
    public void testTranspose() {
        int n;
        int n2;
        AbstractDataset abstractDataset = AbstractDataset.arange(6.0, 6);
        abstractDataset.setShape(2, 3);
        AbstractDataset abstractDataset2 = DatasetUtils.transpose(abstractDataset, 1, 0);
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        Assert.assertEquals((long)2L, (long)abstractDataset2.getShape().length);
        Assert.assertEquals((long)3L, (long)abstractDataset2.getShape()[0]);
        Assert.assertEquals((long)2L, (long)abstractDataset2.getShape()[1]);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 3) {
                Assert.assertEquals((double)dArrayArray[n3][n4], (double)abstractDataset2.getDouble(n4, n3), (double)1.0E-6);
                ++n4;
            }
            ++n3;
        }
        abstractDataset = AbstractDataset.arange(24.0, 6);
        abstractDataset.setShape(2, 3, 4);
        double[][][] dArrayArray2 = new double[][][]{new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0, 7.0}, {8.0, 9.0, 10.0, 11.0}}, new double[][]{{12.0, 13.0, 14.0, 15.0}, {16.0, 17.0, 18.0, 19.0}, {20.0, 21.0, 22.0, 23.0}}};
        try {
            AbstractDataset abstractDataset3 = DatasetUtils.transpose(abstractDataset, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            AbstractDataset abstractDataset4 = DatasetUtils.transpose(abstractDataset, 0, -1, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            AbstractDataset abstractDataset5 = DatasetUtils.transpose(abstractDataset, 0, 1, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        AbstractDataset abstractDataset6 = DatasetUtils.transpose(abstractDataset, 0, 1, 2);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape()[1]);
        Assert.assertEquals((long)4L, (long)abstractDataset6.getShape()[2]);
        int n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)abstractDataset6.getDouble(n5, n2, n), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
        abstractDataset6 = DatasetUtils.transpose(abstractDataset, 1, 0, 2);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[1]);
        Assert.assertEquals((long)4L, (long)abstractDataset6.getShape()[2]);
        n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)abstractDataset6.getDouble(n2, n5, n), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
        abstractDataset6 = DatasetUtils.transpose(abstractDataset, 2, 0, 1);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape().length);
        Assert.assertEquals((long)4L, (long)abstractDataset6.getShape()[0]);
        Assert.assertEquals((long)2L, (long)abstractDataset6.getShape()[1]);
        Assert.assertEquals((long)3L, (long)abstractDataset6.getShape()[2]);
        n5 = 0;
        while (n5 < 2) {
            n2 = 0;
            while (n2 < 3) {
                n = 0;
                while (n < 4) {
                    Assert.assertEquals((double)dArrayArray2[n5][n2][n], (double)abstractDataset6.getDouble(n, n5, n2), (double)1.0E-6);
                    ++n;
                }
                ++n2;
            }
            ++n5;
        }
    }

    @Test
    public void testRepeat() {
        int n;
        AbstractDataset abstractDataset = AbstractDataset.arange(6.0, 6);
        abstractDataset.setShape(2, 3);
        double[] dArray = new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0};
        DoubleDataset doubleDataset = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2}, -1);
        Assert.assertEquals((long)1L, (long)doubleDataset.getShape().length);
        Assert.assertEquals((long)12L, (long)doubleDataset.getShape()[0]);
        int n2 = 0;
        while (n2 < 12) {
            Assert.assertEquals((double)dArray[n2], (double)doubleDataset.get(n2), (double)1.0E-6);
            ++n2;
        }
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 1.0, 1.0, 2.0, 2.0}, {3.0, 3.0, 4.0, 4.0, 5.0, 5.0}};
        DoubleDataset doubleDataset2 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2}, 1);
        Assert.assertEquals((long)2L, (long)doubleDataset2.getShape().length);
        Assert.assertEquals((long)2L, (long)doubleDataset2.getShape()[0]);
        Assert.assertEquals((long)6L, (long)doubleDataset2.getShape()[1]);
        int n3 = 0;
        while (n3 < 2) {
            int n4 = 0;
            while (n4 < 6) {
                Assert.assertEquals((double)dArrayArray[n3][n4], (double)doubleDataset2.get(n3, n4), (double)1.0E-6);
                ++n4;
            }
            ++n3;
        }
        double[][] dArrayArray2 = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}, {3.0, 4.0, 5.0}};
        DoubleDataset doubleDataset3 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2}, 0);
        Assert.assertEquals((long)2L, (long)doubleDataset3.getShape().length);
        Assert.assertEquals((long)4L, (long)doubleDataset3.getShape()[0]);
        Assert.assertEquals((long)3L, (long)doubleDataset3.getShape()[1]);
        int n5 = 0;
        while (n5 < 4) {
            int n6 = 0;
            while (n6 < 3) {
                Assert.assertEquals((double)dArrayArray2[n5][n6], (double)doubleDataset3.get(n5, n6), (double)1.0E-6);
                ++n6;
            }
            ++n5;
        }
        double[][] dArrayArray3 = new double[][]{{0.0, 1.0, 2.0}, {0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DoubleDataset doubleDataset4 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2, 1}, 0);
        Assert.assertEquals((long)2L, (long)doubleDataset4.getShape().length);
        Assert.assertEquals((long)3L, (long)doubleDataset4.getShape()[0]);
        Assert.assertEquals((long)3L, (long)doubleDataset4.getShape()[1]);
        int n7 = 0;
        while (n7 < 3) {
            int n8 = 0;
            while (n8 < 3) {
                Assert.assertEquals((double)dArrayArray3[n7][n8], (double)doubleDataset4.get(n7, n8), (double)1.0E-6);
                ++n8;
            }
            ++n7;
        }
        double[][] dArrayArray4 = new double[][]{{0.0, 1.0, 1.0, 2.0, 2.0, 2.0}, {3.0, 4.0, 4.0, 5.0, 5.0, 5.0}};
        DoubleDataset doubleDataset5 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{1, 2, 3}, 1);
        Assert.assertEquals((long)2L, (long)doubleDataset5.getShape().length);
        Assert.assertEquals((long)2L, (long)doubleDataset5.getShape()[0]);
        Assert.assertEquals((long)6L, (long)doubleDataset5.getShape()[1]);
        int n9 = 0;
        while (n9 < 2) {
            int n10 = 0;
            while (n10 < 6) {
                Assert.assertEquals((double)dArrayArray4[n9][n10], (double)doubleDataset5.get(n9, n10), (double)1.0E-6);
                ++n10;
            }
            ++n9;
        }
        double[] dArray2 = new double[]{0.0, 1.0, 2.0, 2.0, 5.0, 5.0, 5.0};
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[5] = 3;
        DoubleDataset doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, nArray, -1);
        Assert.assertEquals((long)1L, (long)doubleDataset6.getShape().length);
        Assert.assertEquals((long)7L, (long)doubleDataset6.getShape()[0]);
        int n11 = 0;
        while (n11 < 7) {
            Assert.assertEquals((double)dArray2[n11], (double)doubleDataset6.get(n11), (double)1.0E-6);
            ++n11;
        }
        AbstractDataset abstractDataset2 = AbstractDataset.arange(1024.0, 6);
        abstractDataset2.set(0, 1024);
        DoubleDataset doubleDataset7 = (DoubleDataset)DatasetUtils.repeat(abstractDataset2, new int[]{2}, -1);
        Assert.assertEquals((long)1L, (long)doubleDataset7.getShape().length);
        Assert.assertEquals((long)2050L, (long)doubleDataset7.getShape()[0]);
        int n12 = 0;
        while (n12 < 1024) {
            Assert.assertEquals((double)n12, (double)doubleDataset7.get(2 * n12), (double)1.0E-6);
            Assert.assertEquals((double)n12, (double)doubleDataset7.get(2 * n12 + 1), (double)1.0E-6);
            ++n12;
        }
        abstractDataset2 = AbstractDataset.arange(1024.0, 6);
        abstractDataset2.setShape(16, 64);
        abstractDataset2.set(0.0, 0, 64);
        doubleDataset7 = (DoubleDataset)DatasetUtils.repeat(abstractDataset2, new int[]{2}, 1);
        Assert.assertEquals((long)2L, (long)doubleDataset7.getShape().length);
        Assert.assertEquals((long)16L, (long)doubleDataset7.getShape()[0]);
        Assert.assertEquals((long)130L, (long)doubleDataset7.getShape()[1]);
        n12 = 0;
        while (n12 < 16) {
            n = 0;
            while (n < 64) {
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(n12, 2 * n), (double)1.0E-6);
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(n12, 2 * n + 1), (double)1.0E-6);
                ++n;
            }
            ++n12;
        }
        doubleDataset7 = (DoubleDataset)DatasetUtils.repeat(abstractDataset2, new int[]{2}, 0);
        Assert.assertEquals((long)2L, (long)doubleDataset7.getShape().length);
        Assert.assertEquals((long)32L, (long)doubleDataset7.getShape()[0]);
        Assert.assertEquals((long)65L, (long)doubleDataset7.getShape()[1]);
        n12 = 0;
        while (n12 < 16) {
            n = 0;
            while (n < 64) {
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(2 * n12, n), (double)1.0E-6);
                Assert.assertEquals((double)(n12 * 64 + n), (double)doubleDataset7.get(2 * n12 + 1, n), (double)1.0E-6);
                ++n;
            }
            ++n12;
        }
        try {
            doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[1], 3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{2, 1}, -1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
        try {
            doubleDataset6 = (DoubleDataset)DatasetUtils.repeat(abstractDataset, new int[]{-1}, -1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"wrong exception type passed from incorrect arguments being passed to the constructor");
        }
    }

    @Test
    public void testContents() {
        double[] dArray = new double[]{0.0, 2.0, -12.3};
        double[] dArray2 = new double[]{2.3, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        double[] dArray3 = new double[]{1.0E14, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        DoubleDataset doubleDataset = new DoubleDataset(dArray, new int[0]);
        Assert.assertEquals((Object)false, (Object)doubleDataset.containsNans());
        Assert.assertEquals((Object)false, (Object)doubleDataset.containsInfs());
        DoubleDataset doubleDataset2 = new DoubleDataset(dArray2, new int[0]);
        Assert.assertEquals((Object)true, (Object)doubleDataset2.containsNans());
        Assert.assertEquals((Object)true, (Object)doubleDataset2.containsInfs());
        Assert.assertEquals((Object)true, (Object)Double.isNaN(doubleDataset2.min().doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(doubleDataset2.min().doubleValue()));
        Assert.assertEquals((Object)true, (Object)Double.isNaN(doubleDataset2.max().doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(doubleDataset2.max().doubleValue()));
        AbstractDataset abstractDataset = doubleDataset2.cast(5);
        Assert.assertEquals((Object)true, (Object)abstractDataset.containsNans());
        Assert.assertEquals((Object)true, (Object)abstractDataset.containsInfs());
        Assert.assertEquals((Object)true, (Object)Double.isNaN(abstractDataset.min().doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(abstractDataset.min().doubleValue()));
        Assert.assertEquals((Object)true, (Object)Double.isNaN(abstractDataset.max().doubleValue()));
        Assert.assertEquals((Object)false, (Object)Double.isInfinite(abstractDataset.max().doubleValue()));
        DoubleDataset doubleDataset3 = new DoubleDataset(dArray3, new int[0]);
        Assert.assertEquals((Object)true, (Object)Double.isInfinite(doubleDataset3.min().doubleValue()));
        Assert.assertEquals((Object)true, (Object)Double.isInfinite(doubleDataset3.max().doubleValue()));
        doubleDataset = DoubleDataset.arange(1024.0);
        doubleDataset.set(3.0, 1024);
        Assert.assertEquals((Object)false, (Object)doubleDataset.containsNans());
        Assert.assertEquals((Object)false, (Object)doubleDataset.containsInfs());
    }

    @Test
    public void testAutoAllocation() {
        DoubleDataset doubleDataset = new DoubleDataset(1);
        int n = 0;
        while (n < 1000) {
            doubleDataset.set(n, n);
            ++n;
        }
        IndexIterator indexIterator = doubleDataset.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            if (n2 < 1000) {
                Assert.assertEquals((double)n2, (double)doubleDataset.get(indexIterator.index), (double)((double)n2 * 1.0E-5));
            }
            ++n2;
        }
        Assert.assertEquals((long)n2, (long)1000L);
    }

    @Test
    public void testView() {
        AbstractDataset abstractDataset = AbstractDataset.arange(20.0, 6);
        AbstractDataset abstractDataset2 = abstractDataset.getView();
        Assert.assertEquals((Object)true, (Object)abstractDataset.equals(abstractDataset2));
    }

    @Test
    public void testEquals() {
        AbstractDataset abstractDataset = AbstractDataset.arange(20.0, 6);
        AbstractDataset abstractDataset2 = AbstractDataset.arange(20.0, 6);
        AbstractDataset abstractDataset3 = abstractDataset.clone();
        AbstractDataset abstractDataset4 = Maths.add(abstractDataset, 0.5);
        AbstractDataset abstractDataset5 = AbstractDataset.arange(20.0, 5);
        Assert.assertTrue((boolean)abstractDataset.equals(abstractDataset2));
        Assert.assertFalse((abstractDataset == abstractDataset2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)abstractDataset.equals(abstractDataset3));
        Assert.assertFalse((abstractDataset == abstractDataset3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)abstractDataset.equals(abstractDataset4));
        Assert.assertFalse((boolean)abstractDataset.equals(abstractDataset5));
        HashSet<AbstractDataset> hashSet = new HashSet<AbstractDataset>();
        hashSet.add(abstractDataset);
        Assert.assertTrue((boolean)hashSet.contains(abstractDataset));
        Assert.assertTrue((boolean)hashSet.contains(abstractDataset2));
        Assert.assertTrue((boolean)hashSet.contains(abstractDataset3));
        Assert.assertFalse((boolean)hashSet.contains(abstractDataset4));
        Assert.assertFalse((boolean)hashSet.contains(abstractDataset5));
        hashSet.add(abstractDataset2);
        Assert.assertEquals((long)1L, (long)hashSet.size());
        hashSet.add(abstractDataset4);
        hashSet.add(abstractDataset5);
        Assert.assertEquals((long)3L, (long)hashSet.size());
        Assert.assertTrue((boolean)hashSet.contains(abstractDataset4));
        Assert.assertTrue((boolean)hashSet.contains(abstractDataset5));
        Assert.assertTrue((boolean)hashSet.contains(Maths.subtract((Object)abstractDataset4, 0.5)));
        Assert.assertFalse((boolean)hashSet.contains(Maths.subtract((Object)abstractDataset4, 0.5001)));
        Assert.assertTrue((boolean)hashSet.contains(abstractDataset5.cast(6)));
        Assert.assertTrue((boolean)hashSet.contains(abstractDataset2.cast(5)));
    }

    @Test
    public void testPrint() {
        AbstractDataset abstractDataset = AbstractDataset.arange(1000000.0, 3);
        System.out.println(abstractDataset);
        System.out.println(abstractDataset.reshape(1000, 1000));
        System.out.println(abstractDataset.reshape(100, 100, 100));
        AbstractDataset abstractDataset2 = AbstractDataset.arange(12.0, 3);
        System.out.println(abstractDataset2);
        System.out.println(abstractDataset2.reshape(1, 12));
        System.out.println(abstractDataset2.reshape(4, 1, 3));
    }

    @Test
    public void testSlicing() {
        AbstractDataset abstractDataset = AbstractDataset.arange(1000.0, 3);
        AbstractDataset abstractDataset2 = abstractDataset.getSlice(null, new int[]{10}, null);
        Assert.assertEquals((long)1L, (long)abstractDataset2.getShape().length);
        Assert.assertEquals((long)10L, (long)abstractDataset2.getShape()[0]);
        IndexIterator indexIterator = abstractDataset2.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((long)n, (long)abstractDataset2.getElementLongAbs(indexIterator.index));
            ++n;
        }
        AbstractDataset abstractDataset3 = abstractDataset.getSlice(new Slice(10));
        Assert.assertEquals((long)1L, (long)abstractDataset3.getShape().length);
        Assert.assertEquals((long)10L, (long)abstractDataset3.getShape()[0]);
        IndexIterator indexIterator2 = abstractDataset3.getIterator();
        n = 0;
        while (indexIterator2.hasNext()) {
            Assert.assertEquals((long)n, (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
            ++n;
        }
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        abstractDataset2 = abstractDataset.getSlice(new int[]{9}, null, new int[]{-1});
        Assert.assertEquals((long)1L, (long)abstractDataset2.getShape().length);
        Assert.assertEquals((long)10L, (long)abstractDataset2.getShape()[0]);
        indexIterator = abstractDataset2.getIterator();
        n = 9;
        while (indexIterator.hasNext()) {
            Assert.assertEquals((long)n, (long)abstractDataset2.getElementLongAbs(indexIterator.index));
            --n;
        }
        abstractDataset3 = abstractDataset.getSlice(new Slice(9, null, -1));
        Assert.assertEquals((long)1L, (long)abstractDataset3.getShape().length);
        Assert.assertEquals((long)10L, (long)abstractDataset3.getShape()[0]);
        indexIterator2 = abstractDataset3.getIterator();
        n = 9;
        while (indexIterator2.hasNext()) {
            Assert.assertEquals((long)n, (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
            --n;
        }
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        abstractDataset2 = abstractDataset.getSlice(new int[]{2}, new int[]{10}, null);
        abstractDataset3 = abstractDataset.getSlice(new Slice(2, 10));
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        abstractDataset2 = abstractDataset.getSlice(new int[]{2}, new int[]{10}, new int[]{3});
        abstractDataset3 = abstractDataset.getSlice(new Slice(2, 10, 3));
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        try {
            abstractDataset3 = abstractDataset.getSlice(new Slice(2000));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            abstractDataset3 = abstractDataset.getSlice(new Slice(12, 10, 3));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            abstractDataset3 = abstractDataset.getSlice(new Slice(2, 10, -3));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        abstractDataset.setShape(10, 10, 10);
        abstractDataset2 = abstractDataset.getSlice((int[])null, (int[])null, (int[])null);
        abstractDataset3 = abstractDataset.getSlice(new Slice[0]);
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        abstractDataset2 = abstractDataset.getSlice((int[])null, (int[])null, (int[])null);
        Slice[] sliceArray = null;
        abstractDataset3 = abstractDataset.getSlice(sliceArray);
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        abstractDataset2 = abstractDataset.getSlice(null, new int[]{8, 10, 10}, null);
        abstractDataset3 = abstractDataset.getSlice(new Slice(8));
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        abstractDataset2 = abstractDataset.getSlice(null, new int[]{8, 3, 10}, null);
        abstractDataset3 = abstractDataset.getSlice(new Slice(8), new Slice(3));
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
        abstractDataset2 = abstractDataset.getSlice(null, new int[]{8, 10, 3}, null);
        abstractDataset3 = abstractDataset.getSlice(new Slice(8), null, new Slice(3));
        indexIterator = abstractDataset2.getIterator();
        indexIterator2 = abstractDataset3.getIterator();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            Assert.assertEquals((long)abstractDataset2.getElementLongAbs(indexIterator.index), (long)abstractDataset3.getElementLongAbs(indexIterator2.index));
        }
    }

    @Test
    public void test1DErrors() {
        AbstractDataset abstractDataset = AbstractDataset.arange(100.0, 3);
        abstractDataset.setError(5);
        Assert.assertEquals((double)5.0, (double)abstractDataset.getErrorDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset.getErrorDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset.getErrorDouble(99), (double)0.001);
        AbstractDataset abstractDataset2 = abstractDataset.getError();
        try {
            AbstractDataset.checkCompatibility(abstractDataset, abstractDataset2);
        }
        catch (Exception exception) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)5.0, (double)abstractDataset2.getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset2.getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset2.getDouble(99), (double)0.001);
        abstractDataset.setError(Maths.multiply(abstractDataset2, 2));
        Assert.assertEquals((double)10.0, (double)abstractDataset.getErrorDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset.getErrorDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset.getErrorDouble(99), (double)0.001);
        AbstractDataset abstractDataset3 = abstractDataset.getError();
        try {
            AbstractDataset.checkCompatibility(abstractDataset, abstractDataset3);
        }
        catch (Exception exception) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)10.0, (double)abstractDataset3.getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset3.getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset3.getDouble(99), (double)0.001);
    }

    @Test
    public void test2DErrors() {
        AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{100, 100}, 3);
        abstractDataset.setError(5);
        Assert.assertEquals((double)5.0, (double)abstractDataset.getErrorDouble(0, 0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset.getErrorDouble(50, 50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset.getErrorDouble(99, 99), (double)0.001);
        AbstractDataset abstractDataset2 = abstractDataset.getError();
        try {
            AbstractDataset.checkCompatibility(abstractDataset, abstractDataset2);
        }
        catch (Exception exception) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)5.0, (double)abstractDataset2.getDouble(0, 0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset2.getDouble(50, 50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractDataset2.getDouble(99, 99), (double)0.001);
        abstractDataset.setError(Maths.multiply(abstractDataset2, 2));
        Assert.assertEquals((double)10.0, (double)abstractDataset.getErrorDouble(0, 0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset.getErrorDouble(50, 50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset.getErrorDouble(99, 99), (double)0.001);
        AbstractDataset abstractDataset3 = abstractDataset.getError();
        try {
            AbstractDataset.checkCompatibility(abstractDataset, abstractDataset3);
        }
        catch (Exception exception) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)10.0, (double)abstractDataset3.getDouble(0, 0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset3.getDouble(50, 50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractDataset3.getDouble(99, 99), (double)0.001);
    }

    @Test
    public void testInternalErrors() {
        AbstractDataset abstractDataset = AbstractDataset.arange(100.0, 3);
        abstractDataset.setError(5);
        Assert.assertEquals((double)25.0, (double)abstractDataset.errorValue.doubleValue(), (double)0.001);
        AbstractDataset abstractDataset2 = abstractDataset.getError();
        abstractDataset.setError(Maths.multiply(abstractDataset2, 2));
        Assert.assertEquals((double)100.0, (double)abstractDataset.errorData.getDouble(0), (double)0.001);
        Assert.assertEquals((double)100.0, (double)abstractDataset.errorData.getDouble(50), (double)0.001);
        Assert.assertEquals((double)100.0, (double)abstractDataset.errorData.getDouble(99), (double)0.001);
    }

    @Test
    public void testScalarDatasets() {
        AbstractDataset abstractDataset = DoubleDataset.ones(new int[0]);
        Assert.assertEquals((String)"Rank", (long)0L, (long)abstractDataset.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)abstractDataset.getShape().length);
        Assert.assertEquals((String)"Value", (Object)1.0, (Object)abstractDataset.getObject(new int[0]));
        Assert.assertEquals((String)"Value", (Object)true, (Object)abstractDataset.equals(new Double(1.0)));
        abstractDataset = AbstractDataset.zeros(new int[0], 2);
        Assert.assertEquals((String)"Rank", (long)0L, (long)abstractDataset.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)abstractDataset.getShape().length);
        Assert.assertEquals((String)"Value", (Object)0, (Object)abstractDataset.getObject(new int[0]));
        abstractDataset = AbstractDataset.array(new Complex(1.0, -0.5));
        Assert.assertEquals((String)"Rank", (long)0L, (long)abstractDataset.getRank());
        Assert.assertEquals((String)"Shape", (long)0L, (long)abstractDataset.getShape().length);
        Assert.assertEquals((String)"Value", (Object)new Complex(1.0, -0.5), (Object)abstractDataset.getObject(new int[0]));
    }

    @Test
    public void testConcatenate() {
        AbstractDataset abstractDataset = AbstractDataset.arange(6.0, 6).reshape(3, 2);
        AbstractDataset abstractDataset2 = AbstractDataset.arange(6.0, 8.0, 1.0, 6).reshape(1, 2);
        AbstractDataset abstractDataset3 = DatasetUtils.concatenate(new IDataset[]{abstractDataset, abstractDataset2}, 0);
        AbstractDataset abstractDataset4 = AbstractDataset.arange(8.0, 6).reshape(4, 2);
        Assert.assertEquals((String)"Rank", (long)2L, (long)abstractDataset3.getRank());
        Assert.assertTrue((String)"Dataset", (boolean)abstractDataset3.equals(abstractDataset4));
        abstractDataset.setShape(2, 3);
        abstractDataset2 = AbstractDataset.arange(6.0, 9.0, 1.0, 6).reshape(1, 3);
        abstractDataset3 = DatasetUtils.concatenate(new IDataset[]{abstractDataset, abstractDataset2}, 0);
        abstractDataset4 = AbstractDataset.arange(9.0, 6).reshape(3, 3);
        Assert.assertEquals((String)"Rank", (long)2L, (long)abstractDataset3.getRank());
        Assert.assertTrue((String)"Dataset", (boolean)abstractDataset3.equals(abstractDataset4));
        abstractDataset = AbstractDataset.arange(2.0, 6).reshape(1, 2);
        abstractDataset2 = AbstractDataset.arange(3.0, 5.0, 1.0, 6).reshape(1, 2);
        abstractDataset = DatasetUtils.concatenate(new IDataset[]{abstractDataset, abstractDataset2}, 0);
        abstractDataset2 = AbstractDataset.arange(2.0, 6.0, 3.0, 6).reshape(2, 1);
        abstractDataset3 = DatasetUtils.concatenate(new IDataset[]{abstractDataset, abstractDataset2}, 1);
        abstractDataset4 = AbstractDataset.arange(6.0, 6).reshape(2, 3);
        Assert.assertEquals((String)"Rank", (long)2L, (long)abstractDataset3.getRank());
        Assert.assertTrue((String)"Dataset", (boolean)abstractDataset3.equals(abstractDataset4));
    }
}

