/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.analysis.io.ScanFileHolderException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ContiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ContiguousIteratorWithPosition;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DiscontiguousIterator;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;
import uk.ac.diamond.scisoft.analysis.dataset.RGBDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Slice;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;
import uk.ac.diamond.scisoft.analysis.dataset.Stats;
import uk.ac.diamond.scisoft.analysis.dataset.StringDataset;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.gda.monitor.IMonitor;

public abstract class AbstractDataset
implements IDataset {
    protected static final long serialVersionUID = -6891075135217265625L;
    protected static final transient Logger abstractLogger = LoggerFactory.getLogger(AbstractDataset.class);
    public static final int BOOL = 0;
    public static final int INT8 = 1;
    public static final int INT16 = 2;
    public static final int INT32 = 3;
    public static final int INT = 3;
    public static final int INT64 = 4;
    public static final int FLOAT32 = 5;
    public static final int FLOAT64 = 6;
    public static final int FLOAT = 6;
    public static final int COMPLEX64 = 7;
    public static final int COMPLEX128 = 8;
    public static final int COMPLEX = 8;
    public static final int STRING = 9;
    public static final int OBJECT = 10;
    private static final int ARRAYMUL = 100;
    public static final int ARRAYINT8 = 100;
    public static final int ARRAYINT16 = 200;
    public static final int RGB = 203;
    public static final int ARRAYINT32 = 300;
    public static final int ARRAYINT64 = 400;
    public static final int ARRAYFLOAT32 = 500;
    public static final int ARRAYFLOAT64 = 600;
    private static final int MAX_STRING_LENGTH = 120;
    private static final int MAX_SUBBLOCKS = 6;
    private static final float ARRAY_ALLOCATION_EXTENSION = 0.5f;
    protected int[] shape;
    protected int size;
    protected int[] dataShape;
    protected int dataSize;
    protected Serializable odata = null;
    protected String name = "";
    protected transient HashMap<String, Object> storedValues = null;
    protected boolean extendible = true;
    private static final transient Map<Class<?>, Integer> dtypeMap = AbstractDataset.createDTypeMap();
    public static final int STRING_NORMAL = 0;
    public static final int STRING_SHAPE = 1;
    private int stringPolicy = 0;
    private static final String SEPARATOR = ",";
    private static final String SPACING = " ";
    private static final String ELLIPSES = "...";
    private static final String NEWLINE = "\n";
    protected Number errorValue = 0;
    protected AbstractDataset errorData = null;
    protected IMetaData metadataStructure = null;

    private static boolean isDTypeElemental(int n) {
        return n <= 8 || n == 203;
    }

    protected abstract void setData();

    public boolean isExtendible() {
        return this.extendible;
    }

    public void setExtendible(boolean bl) {
        this.extendible = bl;
    }

    public synchronized AbstractDataset synchronizedCopy() {
        return this.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            if (this.getRank() == 0) {
                return object.equals(this.getObject(new int[0]));
            }
            return false;
        }
        AbstractDataset abstractDataset = (AbstractDataset)object;
        if (this.getElementsPerItem() != abstractDataset.getElementsPerItem()) {
            return false;
        }
        return Arrays.equals(this.shape, abstractDataset.shape);
    }

    public int hashCode() {
        return (Integer)this.getMaxMin("hash");
    }

    @Override
    public AbstractDataset clone() {
        AbstractDataset abstractDataset = null;
        try {
            switch (this.getDtype()) {
                case 0: {
                    abstractDataset = new BooleanDataset((BooleanDataset)this);
                    break;
                }
                case 1: {
                    abstractDataset = new ByteDataset((ByteDataset)this);
                    break;
                }
                case 2: {
                    abstractDataset = new ShortDataset((ShortDataset)this);
                    break;
                }
                case 3: {
                    abstractDataset = new IntegerDataset((IntegerDataset)this);
                    break;
                }
                case 4: {
                    abstractDataset = new LongDataset((LongDataset)this);
                    break;
                }
                case 100: {
                    abstractDataset = new CompoundByteDataset((CompoundByteDataset)this);
                    break;
                }
                case 200: {
                    abstractDataset = new CompoundShortDataset((CompoundShortDataset)this);
                    break;
                }
                case 300: {
                    abstractDataset = new CompoundIntegerDataset((CompoundIntegerDataset)this);
                    break;
                }
                case 400: {
                    abstractDataset = new CompoundLongDataset((CompoundLongDataset)this);
                    break;
                }
                case 5: {
                    abstractDataset = new FloatDataset((FloatDataset)this);
                    break;
                }
                case 6: {
                    abstractDataset = new DoubleDataset((DoubleDataset)this);
                    break;
                }
                case 500: {
                    abstractDataset = new CompoundFloatDataset((CompoundFloatDataset)this);
                    break;
                }
                case 600: {
                    abstractDataset = new CompoundDoubleDataset((CompoundDoubleDataset)this);
                    break;
                }
                case 7: {
                    abstractDataset = new ComplexFloatDataset((ComplexFloatDataset)this);
                    break;
                }
                case 8: {
                    abstractDataset = new ComplexDoubleDataset((ComplexDoubleDataset)this);
                    break;
                }
                default: {
                    abstractLogger.error("Dataset of unknown type!");
                    break;
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new OutOfMemoryError("Not enough memory available to create dataset");
        }
        return abstractDataset;
    }

    public AbstractDataset cast(int n) {
        if (this.getDtype() == n) {
            return this;
        }
        return DatasetUtils.cast(this, n);
    }

    public AbstractDataset cast(boolean bl, int n, int n2) {
        if (this.getDtype() == n && this.getElementsPerItem() == n2) {
            return this;
        }
        return DatasetUtils.cast(this, bl, n, n2);
    }

    public abstract AbstractDataset getView();

    public IntegerDataset getIndices() {
        IntegerDataset integerDataset = DatasetUtils.indices(this.shape);
        if (this.getName() != null) {
            integerDataset.setName("Indices of " + this.getName());
        }
        return integerDataset;
    }

    public AbstractDataset transpose(int ... nArray) {
        return DatasetUtils.transpose(this, nArray);
    }

    public AbstractDataset swapaxes(int n, int n2) {
        return DatasetUtils.swapAxes(this, n, n2);
    }

    @Deprecated
    public AbstractDataset append(AbstractDataset abstractDataset, int n) {
        abstractLogger.warn("Use DatasetUtils.append");
        return DatasetUtils.append(this, abstractDataset, n);
    }

    public AbstractDataset flatten() {
        AbstractDataset abstractDataset = this.shape.length <= 1 || this.dataShape == null ? this.getView() : this.clone();
        abstractDataset.shape = new int[]{abstractDataset.size};
        return abstractDataset;
    }

    public static int calcSize(int[] nArray) {
        int n = 1;
        double d = 1.0;
        if (nArray.length == 1) {
            if (nArray[0] == 0) {
                return 0;
            }
            n *= nArray[0];
            d *= (double)nArray[0];
        } else {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] <= 0) {
                    throw new IllegalArgumentException("The " + n2 + "-th is " + nArray[n2] + " which is an illegal argument as it is zero or negative");
                }
                n *= nArray[n2];
                d *= (double)nArray[n2];
                ++n2;
            }
        }
        if (d > 2.147483647E9) {
            throw new IllegalArgumentException("Size of the dataset is too large to allocate");
        }
        return n;
    }

    public static int getBestDType(int n, int n2) {
        int n3;
        int n4 = n >= 100 ? n / 100 : n;
        int n5 = n2 >= 100 ? n2 / 100 : n2;
        int n6 = n3 = n4 > n5 ? n4 : n5;
        if (n >= 100 || n2 >= 100) {
            if (n3 >= 7) {
                throw new IllegalArgumentException("Complex type cannot be promoted to compound type");
            }
            n3 *= 100;
        }
        return n3;
    }

    public static int getLargestDType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return 3;
            }
            case 3: 
            case 4: {
                return 4;
            }
            case 5: 
            case 6: {
                return 6;
            }
            case 7: 
            case 8: {
                return 8;
            }
            case 100: 
            case 200: {
                return 300;
            }
            case 300: 
            case 400: {
                return 400;
            }
            case 500: 
            case 600: {
                return 600;
            }
        }
        throw new IllegalArgumentException("Unsupported dataset type");
    }

    public static int getBestFloatDType(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 100: 
            case 200: 
            case 500: {
                n2 = 5;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 300: 
            case 400: 
            case 600: {
                n2 = 6;
                break;
            }
            default: {
                n2 = n;
            }
        }
        return n2;
    }

    public static int getBestFloatDType(Class<? extends Object> clazz) {
        return AbstractDataset.getBestFloatDType(AbstractDataset.getDTypeFromClass(clazz));
    }

    private static Map<Class<?>, Integer> createDTypeMap() {
        HashMap hashMap = new HashMap();
        hashMap.put(Boolean.class, 0);
        hashMap.put(Byte.class, 1);
        hashMap.put(Short.class, 2);
        hashMap.put(Integer.class, 3);
        hashMap.put(Long.class, 4);
        hashMap.put(Float.class, 5);
        hashMap.put(Double.class, 6);
        hashMap.put(Complex.class, 8);
        hashMap.put(String.class, 9);
        hashMap.put(Object.class, 10);
        return hashMap;
    }

    public static int getDTypeFromClass(Class<? extends Object> clazz) {
        Integer n = dtypeMap.get(clazz);
        if (n == null) {
            throw new IllegalArgumentException("Class of object not supported");
        }
        return n;
    }

    public static int getDTypeFromObject(Object object) {
        int n = 0;
        if (object == null) {
            return n;
        }
        if (object instanceof List) {
            List list = (List)object;
            int n2 = list.size();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = AbstractDataset.getDTypeFromObject(list.get(n3));
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
        } else if (object.getClass().isArray()) {
            int n5 = Array.getLength(object);
            int n6 = 0;
            while (n6 < n5) {
                Object object2 = Array.get(object, n6);
                int n7 = AbstractDataset.getDTypeFromObject(object2);
                if (n7 > n) {
                    n = n7;
                }
                ++n6;
            }
        } else {
            n = AbstractDataset.getDTypeFromClass(object.getClass());
        }
        return n;
    }

    public static int getDType(ILazyDataset iLazyDataset) {
        if (iLazyDataset instanceof AbstractDataset) {
            return ((AbstractDataset)iLazyDataset).getDtype();
        }
        return AbstractDataset.getDTypeFromClass(iLazyDataset.elementClass());
    }

    protected static int[] getShapeFromObject(Object object) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        AbstractDataset.getShapeFromObj(arrayList, object, 0);
        if (object != null && arrayList.size() == 0) {
            return new int[0];
        }
        int n = arrayList.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = arrayList.get(n2);
            ++n2;
        }
        return nArray;
    }

    private static void getShapeFromObj(ArrayList<Integer> arrayList, Object object, int n) {
        if (object == null) {
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            int n2 = list.size();
            AbstractDataset.updateShape(arrayList, n, n2);
            int n3 = 0;
            while (n3 < n2) {
                Object e = list.get(n3);
                AbstractDataset.getShapeFromObj(arrayList, e, n + 1);
                ++n3;
            }
        } else if (object.getClass().isArray()) {
            int n4 = Array.getLength(object);
            AbstractDataset.updateShape(arrayList, n, n4);
            int n5 = 0;
            while (n5 < n4) {
                Object object2 = Array.get(object, n5);
                AbstractDataset.getShapeFromObj(arrayList, object2, n + 1);
                ++n5;
            }
        } else {
            return;
        }
    }

    private static void updateShape(ArrayList<Integer> arrayList, int n, int n2) {
        if (n >= arrayList.size()) {
            arrayList.add(n2);
        } else if (n2 > arrayList.get(n)) {
            arrayList.set(n, n2);
        }
    }

    public void fillData(Object object, int n, int[] nArray) {
        if (object == null) {
            int n2 = this.getDtype();
            if (n2 == 5) {
                this.set(Float.valueOf(Float.NaN), nArray);
            } else if (n2 == 6) {
                this.set(Double.NaN, nArray);
            }
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            int n3 = list.size();
            int n4 = 0;
            while (n4 < n3) {
                Object e = list.get(n4);
                this.fillData(e, n + 1, nArray);
                int n5 = n;
                nArray[n5] = nArray[n5] + 1;
                ++n4;
            }
            nArray[n] = 0;
        } else if (object.getClass().isArray()) {
            int n6 = Array.getLength(object);
            int n7 = 0;
            while (n7 < n6) {
                Object object2 = Array.get(object, n7);
                this.fillData(object2, n + 1, nArray);
                int n8 = n;
                nArray[n8] = nArray[n8] + 1;
                ++n7;
            }
            nArray[n] = 0;
        } else {
            this.set(object, nArray);
        }
    }

    protected static boolean toBoolean(Object object) {
        if (object instanceof Number) {
            return ((Number)object).longValue() != 0L;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Complex) {
            return ((Complex)object).getReal() != 0.0;
        }
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    protected static long toLong(Object object) {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                return 0L;
            }
            return ((Number)object).longValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Complex) {
            return (long)((Complex)object).getReal();
        }
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    protected static double toReal(Object object) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Complex) {
            return ((Complex)object).getReal();
        }
        throw new IllegalArgumentException("Argument is of unsupported class");
    }

    protected static double toImag(Object object) {
        if (object instanceof Number) {
            return 0.0;
        }
        if (object instanceof Boolean) {
            return 0.0;
        }
        if (object instanceof Complex) {
            return ((Complex)object).getImaginary();
        }
        throw new IllegalArgumentException("Argument is not a number");
    }

    protected void expandDataShape(int[] nArray) {
        int n = this.dataShape.length;
        int n2 = 0;
        while (n2 < n) {
            double d;
            if (this.dataShape[n2] > 0 && (d = (double)(nArray[n2] - this.dataShape[n2])) > 0.0) {
                if ((d /= (double)this.dataShape[n2]) < 0.1) {
                    d = 0.5;
                }
                int n3 = n2;
                this.dataShape[n3] = (int)((double)this.dataShape[n3] * (1.0 + d));
            }
            ++n2;
        }
    }

    private boolean isAllZeros(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IndexIterator getIterator(boolean bl) {
        if (this.shape.length <= 1 || this.dataShape == null || this.isAllZeros(this.dataShape)) {
            return bl ? new ContiguousIteratorWithPosition(this.shape, this.size) : new ContiguousIterator(this.size);
        }
        return new DiscontiguousIterator(this.shape, this.dataShape, this.dataSize);
    }

    public IndexIterator getIterator() {
        return this.getIterator(false);
    }

    public PositionIterator getPositionIterator(int ... nArray) {
        return new PositionIterator(this.shape, nArray);
    }

    public IndexIterator getSliceIterator(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4;
        int n = this.shape.length;
        if (nArray3 == null) {
            nArray4 = new int[n];
            Arrays.fill(nArray4, 1);
        } else {
            nArray4 = nArray3;
        }
        int[] nArray5 = nArray == null ? new int[n] : nArray;
        int[] nArray6 = nArray2 == null ? new int[n] : nArray2;
        int[] nArray7 = n > 1 || n > 0 && this.shape[0] > 0 ? this.checkSlice(nArray, nArray2, nArray5, nArray6, nArray4) : new int[n];
        if (n <= 1 || this.dataShape == null) {
            return new SliceIterator(this.shape, this.size, nArray5, nArray4, nArray7);
        }
        return new SliceIterator(this.dataShape, this.dataSize, nArray5, nArray4, nArray7);
    }

    protected SliceIterator getSliceIteratorFromAxes(int[] nArray, boolean[] blArray) {
        int[] nArray2;
        int n = this.shape.length;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        if (nArray == null) {
            nArray2 = new int[n];
        } else if (nArray.length == n) {
            nArray2 = (int[])nArray.clone();
        } else {
            throw new IllegalArgumentException("pos array length is not equal to rank of dataset");
        }
        if (blArray == null) {
            blArray = new boolean[n];
            Arrays.fill(blArray, true);
        } else if (blArray.length != n) {
            throw new IllegalArgumentException("axes array length is not equal to rank of dataset");
        }
        int n2 = 0;
        while (n2 < n) {
            if (blArray[n2]) {
                nArray2[n2] = 0;
                nArray3[n2] = this.shape[n2];
            } else {
                nArray3[n2] = nArray2[n2] + 1;
            }
            nArray4[n2] = 1;
            ++n2;
        }
        return (SliceIterator)this.getSliceIterator(nArray, nArray3, nArray4);
    }

    public abstract void copyItemsFromAxes(int[] var1, boolean[] var2, AbstractDataset var3);

    public abstract void setItemsOnAxes(int[] var1, boolean[] var2, Object var3);

    public static int[] checkSlice(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int n = nArray.length;
        if (nArray4.length != n || nArray5.length != n || nArray6.length != n) {
            throw new IllegalArgumentException("No of indexes does not match data dimensions: you passed it start=" + nArray4.length + ", stop=" + nArray5.length + ", step=" + nArray6.length + ", and it needs " + n);
        }
        int[] nArray7 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            if (nArray6[n2] == 0) {
                throw new IllegalArgumentException("The step array is not allowed any zero entries: " + n2 + "-th entry is zero");
            }
            if (nArray2 != null) {
                if (nArray2[n2] < 0) {
                    int n3 = n2;
                    nArray2[n3] = nArray2[n3] + nArray[n2];
                }
                if (nArray2[n2] < 0) {
                    int n4 = nArray2[n2] = nArray6[n2] > 0 ? 0 : -1;
                }
                if (nArray2[n2] > nArray[n2]) {
                    nArray2[n2] = nArray6[n2] > 0 ? nArray[n2] : nArray[n2] - 1;
                }
            } else {
                int n5 = nArray4[n2] = nArray6[n2] > 0 ? 0 : nArray[n2] - 1;
            }
            if (nArray3 != null) {
                if (nArray3[n2] < 0 && nArray6[n2] > 0) {
                    int n6 = n2;
                    nArray3[n6] = nArray3[n6] + nArray[n2];
                }
                if (nArray3[n2] < 0) {
                    nArray3[n2] = -1;
                }
                if (nArray3[n2] > nArray[n2]) {
                    nArray3[n2] = nArray[n2];
                }
            } else {
                int n7 = nArray5[n2] = nArray6[n2] > 0 ? nArray[n2] : -1;
            }
            if (nArray4[n2] == nArray5[n2]) {
                throw new IllegalArgumentException("Same indices in start and stop");
            }
            if (nArray6[n2] > 0 != nArray4[n2] < nArray5[n2]) {
                throw new IllegalArgumentException("Start=" + nArray4[n2] + " and stop=" + nArray5[n2] + " indices are incompatible with step=" + nArray6[n2]);
            }
            nArray7[n2] = nArray6[n2] > 0 ? (nArray5[n2] - nArray4[n2] - 1) / nArray6[n2] + 1 : (nArray5[n2] - nArray4[n2] + 1) / nArray6[n2] + 1;
            ++n2;
        }
        return nArray7;
    }

    protected int[] checkSlice(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        return AbstractDataset.checkSlice(this.shape, nArray, nArray2, nArray3, nArray4, nArray5);
    }

    public AbstractDataset setSlice(Object object, int[] nArray, int[] nArray2, int[] nArray3) {
        return this.setSlice(object, (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3));
    }

    public abstract AbstractDataset setSlice(Object var1, SliceIterator var2);

    public BooleanIterator getBooleanIterator(BooleanDataset booleanDataset) {
        return new BooleanIterator(this.getIterator(), booleanDataset);
    }

    public AbstractDataset getByBoolean(BooleanDataset booleanDataset) {
        this.checkCompatibility(booleanDataset);
        int n = ((Number)booleanDataset.sum()).intValue();
        int n2 = this.getElementsPerItem();
        AbstractDataset abstractDataset = AbstractDataset.zeros(n2, new int[]{n}, this.getDtype());
        BooleanIterator booleanIterator = this.getBooleanIterator(booleanDataset);
        int n3 = 0;
        while (booleanIterator.hasNext()) {
            abstractDataset.setObjectAbs(n3, this.getObjectAbs(booleanIterator.index));
            n3 += n2;
        }
        return abstractDataset;
    }

    public abstract AbstractDataset setByBoolean(Object var1, BooleanDataset var2);

    public AbstractDataset getByIndex(IntegerDataset integerDataset) {
        int n = this.getElementsPerItem();
        AbstractDataset abstractDataset = AbstractDataset.zeros(n, integerDataset.getShape(), this.getDtype());
        IntegerIterator integerIterator = new IntegerIterator(integerDataset, this.size, n);
        int n2 = 0;
        while (integerIterator.hasNext()) {
            abstractDataset.setObjectAbs(n2, this.getObjectAbs(integerIterator.index));
            n2 += n;
        }
        return abstractDataset;
    }

    public abstract AbstractDataset setByIndex(Object var1, IntegerDataset var2);

    public static Class<?> elementClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: 
            case 100: {
                return Byte.class;
            }
            case 2: 
            case 200: 
            case 203: {
                return Short.class;
            }
            case 3: 
            case 300: {
                return Integer.class;
            }
            case 4: 
            case 400: {
                return Long.class;
            }
            case 5: 
            case 500: {
                return Float.class;
            }
            case 6: 
            case 600: {
                return Double.class;
            }
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
        }
        return Object.class;
    }

    public abstract int getDtype();

    @Override
    public Class<?> elementClass() {
        return AbstractDataset.elementClass(this.getDtype());
    }

    @Override
    public int getElementsPerItem() {
        return AbstractDataset.getElementsPerItem(this.getDtype());
    }

    @Override
    public int getItemsize() {
        return AbstractDataset.getItemsize(this.getDtype(), this.getElementsPerItem());
    }

    public static int getElementsPerItem(int n) {
        switch (n) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                throw new UnsupportedOperationException("Multi-element type unsupported");
            }
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 1;
    }

    public static int getItemsize(int n) {
        return AbstractDataset.getItemsize(n, AbstractDataset.getElementsPerItem(n));
    }

    public static int getItemsize(int n, int n2) {
        int n3;
        switch (n) {
            case 0: {
                n3 = 1;
                break;
            }
            case 1: 
            case 100: {
                n3 = 1;
                break;
            }
            case 2: 
            case 200: 
            case 203: {
                n3 = 2;
                break;
            }
            case 3: 
            case 300: {
                n3 = 4;
                break;
            }
            case 4: 
            case 400: {
                n3 = 8;
                break;
            }
            case 5: 
            case 7: 
            case 500: {
                n3 = 4;
                break;
            }
            case 6: 
            case 8: 
            case 600: {
                n3 = 8;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3 * n2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getSize() {
        if (this.odata == null) {
            throw new NullPointerException("The data object inside the dataset has not been allocated, this suggests a failed or absent construction of the dataset");
        }
        return this.size;
    }

    public boolean isContiguous() {
        return this.shape.length <= 1 || this.dataShape == null;
    }

    @Override
    public int[] getShape() {
        if (this.shape == null) {
            abstractLogger.warn("Shape is null!!!");
            return new int[0];
        }
        return (int[])this.shape.clone();
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    public int getNbytes() {
        return this.getSize() * this.getItemsize();
    }

    @Override
    public void setShape(int ... nArray) {
        if (this.dataShape != null) {
            throw new UnsupportedOperationException("Cannot set a new shape to discontiguous dataset");
        }
        int n = AbstractDataset.calcSize(nArray);
        if (n != this.size) {
            throw new IllegalArgumentException("New shape (" + Arrays.toString(nArray) + ") is not compatible with old shape (" + Arrays.toString(this.shape) + ")");
        }
        this.shape = (int[])nArray.clone();
    }

    public Serializable getBuffer() {
        return this.odata;
    }

    protected int get1DIndex(int ... nArray) {
        int n = nArray.length;
        int n2 = this.shape.length;
        if (n == 0) {
            if (n2 == 0) {
                return 0;
            }
            if (n2 == 1 && this.shape[0] == 0) {
                return 0;
            }
            throw new IllegalArgumentException("One or more index parameters must be supplied");
        }
        if (n > n2) {
            throw new IllegalArgumentException("No of index parameters is different to the shape of data: " + n + " given " + n2 + " required");
        }
        int n3 = nArray[0];
        int n4 = this.shape[0];
        if (n3 < -n4 || n3 >= n4) {
            throw new ArrayIndexOutOfBoundsException("Index (" + n3 + ") out of range [-" + n4 + SEPARATOR + n4 + ") in dimension 0");
        }
        if (n3 < 0) {
            n3 += n4;
        }
        if (n2 == 1) {
            return n3;
        }
        int[] nArray2 = this.dataShape == null ? this.shape : this.dataShape;
        int n5 = 1;
        while (n5 < n) {
            int n6 = nArray[n5];
            int n7 = this.shape[n5];
            if (n6 < -n7 || n6 >= n7) {
                throw new ArrayIndexOutOfBoundsException("Index (" + n6 + ") out of range [-" + n7 + SEPARATOR + n7 + ") in dimension " + n5);
            }
            n3 = n3 * nArray2[n5] + n6;
            if (n6 < 0) {
                n3 += n7;
            }
            ++n5;
        }
        while (n5 < nArray2.length) {
            n3 *= nArray2[n5];
            ++n5;
        }
        return n3;
    }

    public int[] getNDPosition(int n) {
        if (n >= this.size && this.dataShape != null && n >= this.dataSize) {
            throw new IllegalArgumentException("Index provided " + n + "is larger then the size of the containing array " + this.dataSize);
        }
        if (this.shape.length == 1) {
            return new int[]{n};
        }
        int[] nArray = this.dataShape == null ? this.shape : this.dataShape;
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = n;
        --n2;
        while (n2 > 0) {
            nArray2[n2] = n3 % nArray[n2];
            n3 /= nArray[n2];
            --n2;
        }
        nArray2[0] = n3;
        return nArray2;
    }

    protected int to1DIndex(int n) {
        if (this.shape.length > 1 && this.dataShape != null) {
            return this.get1DIndex(this.getNDPosition(n));
        }
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " cf " + this.size);
        }
        return n;
    }

    public int checkAxis(int n) {
        int n2 = this.shape.length;
        if (n < 0) {
            n += n2;
        }
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Axis " + n + " given is out of range [0, " + n2 + ")");
        }
        return n;
    }

    public String toString() {
        int n = this.shape == null ? 0 : this.shape.length;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.stringPolicy == 1) {
            if (this.name != null && this.name.length() > 0) {
                stringBuilder.append("Dataset '");
                stringBuilder.append(this.name);
                stringBuilder.append("' has shape [");
            } else {
                stringBuilder.append("Dataset shape is [");
            }
            if (n > 0 && this.shape[0] > 0) {
                stringBuilder.append(this.shape[0]);
            }
            int n2 = 1;
            while (n2 < n) {
                stringBuilder.append(", " + this.shape[n2]);
                ++n2;
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (this.size == 0) {
            return stringBuilder.toString();
        }
        if (n > 0) {
            int[] nArray = new int[n];
            StringBuilder stringBuilder2 = new StringBuilder();
            this.printBlocks(stringBuilder, stringBuilder2, 0, nArray);
        } else {
            stringBuilder.append(this.getString(new int[0]));
        }
        return stringBuilder.toString();
    }

    private StringBuilder makeLine(int n, int ... nArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray2 = n >= nArray.length ? Arrays.copyOf(nArray, n + 1) : nArray;
        nArray2[n] = 0;
        stringBuilder.append('[');
        stringBuilder.append(this.getString(nArray2));
        int n3 = this.shape[n];
        int n4 = n3 - 40;
        if (n4 > 0) {
            n2 = (n3 - n4) / 2;
            int n5 = 1;
            while (n5 < n2) {
                stringBuilder.append(", ");
                nArray2[n] = n5++;
                stringBuilder.append(this.getString(nArray2));
            }
            n5 = n2 = (n3 + n4) / 2;
            while (n5 < n3) {
                stringBuilder.append(", ");
                nArray2[n] = n5++;
                stringBuilder.append(this.getString(nArray2));
            }
        } else {
            n2 = 1;
            while (n2 < n3) {
                stringBuilder.append(", ");
                nArray2[n] = n2++;
                stringBuilder.append(this.getString(nArray2));
            }
        }
        stringBuilder.append(']');
        n4 = stringBuilder.length() - 120 - ELLIPSES.length() - 1;
        if (n4 > 0) {
            n2 = stringBuilder.substring(0, (stringBuilder.length() - n4) / 2).lastIndexOf(SEPARATOR) + 2;
            StringBuilder stringBuilder2 = new StringBuilder(stringBuilder.subSequence(0, n2));
            stringBuilder2.append("...,");
            n2 = stringBuilder.substring((stringBuilder.length() + n4) / 2).indexOf(SEPARATOR) + (stringBuilder.length() + n4) / 2 + 1;
            stringBuilder2.append(stringBuilder.subSequence(n2, stringBuilder.length()));
            return stringBuilder2;
        }
        return stringBuilder;
    }

    private void printBlocks(StringBuilder stringBuilder, StringBuilder stringBuilder2, int n, int[] nArray) {
        int n2;
        String string;
        if (stringBuilder.length() > 0 && !(string = stringBuilder.substring(stringBuilder.length() - 1)).equals("[")) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        if (n != (n2 = this.getRank() - 1)) {
            stringBuilder.append('[');
            int n3 = this.shape[n];
            nArray[n] = 0;
            StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2);
            stringBuilder3.append(SPACING);
            this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
            if (n3 < 2) {
                stringBuilder.append(']');
                return;
            }
            stringBuilder.append(",\n");
            int n4 = n + 1;
            while (n4 < n2) {
                stringBuilder.append(NEWLINE);
                ++n4;
            }
            if (n3 < 6) {
                n4 = 1;
                while (n4 < n3 - 1) {
                    nArray[n] = n4;
                    this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
                    if (n2 <= n + 1) {
                        stringBuilder.append(",\n");
                    } else {
                        stringBuilder.append(",\n\n");
                    }
                    ++n4;
                }
            } else {
                n4 = n3 - 6;
                int n5 = (n3 - n4) / 2;
                int n6 = 1;
                while (n6 < n5) {
                    nArray[n] = n6;
                    this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
                    if (n2 <= n + 1) {
                        stringBuilder.append(",\n");
                    } else {
                        stringBuilder.append(",\n\n");
                    }
                    ++n6;
                }
                stringBuilder.append((CharSequence)stringBuilder3);
                stringBuilder.append("...,\n");
                n6 = n5 = (n3 + n4) / 2;
                while (n6 < n3 - 1) {
                    nArray[n] = n6;
                    this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
                    if (n2 <= n + 1) {
                        stringBuilder.append(",\n");
                    } else {
                        stringBuilder.append(",\n\n");
                    }
                    ++n6;
                }
            }
            nArray[n] = n3 - 1;
            this.printBlocks(stringBuilder, stringBuilder3, n + 1, nArray);
            stringBuilder.append(']');
        } else {
            stringBuilder.append((CharSequence)this.makeLine(n2, nArray));
        }
    }

    public void setDirty() {
        this.storedValues = null;
    }

    protected boolean isPositionInShape(int ... nArray) {
        int n = nArray.length;
        if (n > this.shape.length) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.shape[n2];
            if (nArray[n2] < 0) {
                int n4 = n2;
                nArray[n4] = nArray[n4] + n3;
            }
            if (nArray[n2] < 0) {
                throw new ArrayIndexOutOfBoundsException("Index (" + nArray[n2] + ") out of range [-" + n3 + SEPARATOR + n3 + ") in dimension " + n2);
            }
            if (nArray[n2] >= n3) {
                if (this.extendible) {
                    return false;
                }
                throw new ArrayIndexOutOfBoundsException("Index (" + nArray[n2] + ") out of range [-" + n3 + SEPARATOR + n3 + ") in dimension " + n2);
            }
            ++n2;
        }
        return true;
    }

    protected boolean isShapeInDataShape(int[] nArray) {
        int n = 0;
        while (n < this.dataShape.length) {
            if (nArray[n] >= this.dataShape[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public AbstractDataset squeeze() {
        return this.squeeze(false);
    }

    @Override
    public AbstractDataset squeeze(boolean bl) {
        this.shape = AbstractDataset.squeezeShape(this.shape, bl);
        return this;
    }

    public static int[] squeezeShape(int[] nArray, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = nArray.length;
        if (bl) {
            n = n3 - 1;
            while (n >= 0) {
                if (nArray[n] == 1) {
                    ++n2;
                    --n;
                    continue;
                }
                break;
            }
        } else {
            n = 0;
            while (n < n3) {
                if (nArray[n] == 1) {
                    ++n2;
                }
                ++n;
            }
        }
        if (n2 == 0) {
            return nArray;
        }
        int[] nArray2 = new int[n3 - n2];
        if (n2 == n3) {
            return nArray2;
        }
        if (bl) {
            n3 = nArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
        } else {
            int n5 = 0;
            int n6 = 0;
            while (n6 < n3) {
                if (nArray[n6] > 1) {
                    nArray2[n5++] = nArray[n6];
                    if (n5 >= nArray2.length) break;
                }
                ++n6;
            }
        }
        return nArray2;
    }

    protected static boolean areShapesCompatible(int[] nArray, int[] nArray2) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray3 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n = nArray3[n3];
            if (n > 1) {
                arrayList.add(n);
            }
            ++n3;
        }
        n = arrayList.size();
        n3 = 0;
        int[] nArray4 = nArray2;
        int n4 = nArray2.length;
        int n5 = 0;
        while (n5 < n4) {
            n2 = nArray4[n5];
            if (n2 != 1 && (n3 >= n || n2 != (Integer)arrayList.get(n3++))) {
                return false;
            }
            ++n5;
        }
        return n3 == n;
    }

    public static boolean areShapesCompatible(int[] nArray, int[] nArray2, int n) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n && nArray[n3] != nArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isCompatibleWith(ILazyDataset iLazyDataset) {
        return AbstractDataset.areShapesCompatible(this.shape, iLazyDataset.getShape());
    }

    public void checkCompatibility(ILazyDataset iLazyDataset) throws IllegalArgumentException {
        AbstractDataset.checkCompatibility(this, iLazyDataset);
    }

    public static void checkCompatibility(ILazyDataset iLazyDataset, ILazyDataset iLazyDataset2) throws IllegalArgumentException {
        if (!AbstractDataset.areShapesCompatible(iLazyDataset.getShape(), iLazyDataset2.getShape())) {
            throw new IllegalArgumentException("Shapes do not match");
        }
    }

    public AbstractDataset reshape(int ... nArray) {
        AbstractDataset abstractDataset = this.getView();
        abstractDataset.setShape(nArray);
        return abstractDataset;
    }

    public abstract void resize(int ... var1);

    public static AbstractDataset array(Object object) {
        int n = AbstractDataset.getDTypeFromObject(object);
        return AbstractDataset.array(object, n);
    }

    public static AbstractDataset array(Object object, boolean bl) {
        AbstractDataset abstractDataset = AbstractDataset.array(object);
        if (bl) {
            switch (abstractDataset.getDtype()) {
                case 3: {
                    abstractDataset = new LongDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 32);
                    break;
                }
                case 2: {
                    abstractDataset = new IntegerDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 16);
                    break;
                }
                case 1: {
                    abstractDataset = new ShortDataset(abstractDataset);
                    DatasetUtils.unwrapUnsigned(abstractDataset, 8);
                }
            }
        }
        return abstractDataset;
    }

    public static AbstractDataset array(Object object, int n) {
        switch (n) {
            case 0: {
                return BooleanDataset.createFromObject(object);
            }
            case 1: {
                return ByteDataset.createFromObject(object);
            }
            case 2: {
                return ShortDataset.createFromObject(object);
            }
            case 3: {
                return IntegerDataset.createFromObject(object);
            }
            case 4: {
                return LongDataset.createFromObject(object);
            }
            case 100: {
                return CompoundByteDataset.createFromObject(object);
            }
            case 200: {
                return CompoundShortDataset.createFromObject(object);
            }
            case 300: {
                return CompoundIntegerDataset.createFromObject(object);
            }
            case 400: {
                return CompoundLongDataset.createFromObject(object);
            }
            case 5: {
                return FloatDataset.createFromObject(object);
            }
            case 6: {
                return DoubleDataset.createFromObject(object);
            }
            case 500: {
                return CompoundFloatDataset.createFromObject(object);
            }
            case 600: {
                return CompoundDoubleDataset.createFromObject(object);
            }
            case 7: {
                return ComplexFloatDataset.createFromObject(object);
            }
            case 8: {
                return ComplexDoubleDataset.createFromObject(object);
            }
            case 9: {
                return StringDataset.createFromObject(object);
            }
        }
        return null;
    }

    public static AbstractDataset createFromList(List<?> list) {
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("No list or zero-length list given");
        }
        Object obj = list.get(0);
        if (obj instanceof Number || obj instanceof Complex) {
            int n = AbstractDataset.getDTypeFromClass(obj.getClass());
            int n2 = list.size();
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n2}, n);
            int n3 = 0;
            for (Object obj2 : list) {
                abstractDataset.setObjectAbs(n3++, obj2);
            }
            return abstractDataset;
        }
        throw new IllegalArgumentException("Class of list element not supported");
    }

    public static AbstractDataset zeros(int[] nArray, int n) {
        switch (n) {
            case 0: {
                return new BooleanDataset(nArray);
            }
            case 1: 
            case 100: {
                return new ByteDataset(nArray);
            }
            case 2: 
            case 200: {
                return new ShortDataset(nArray);
            }
            case 203: {
                return new RGBDataset(nArray);
            }
            case 3: 
            case 300: {
                return new IntegerDataset(nArray);
            }
            case 4: 
            case 400: {
                return new LongDataset(nArray);
            }
            case 5: 
            case 500: {
                return new FloatDataset(nArray);
            }
            case 6: 
            case 600: {
                return new DoubleDataset(nArray);
            }
            case 7: {
                return new ComplexFloatDataset(nArray);
            }
            case 8: {
                return new ComplexDoubleDataset(nArray);
            }
        }
        throw new IllegalArgumentException("dtype not known or unsupported");
    }

    public static AbstractDataset zeros(int n, int[] nArray, int n2) {
        if (n == 1) {
            return AbstractDataset.zeros(nArray, n2);
        }
        switch (n2) {
            case 1: 
            case 100: {
                return new CompoundByteDataset(n, nArray);
            }
            case 2: 
            case 200: {
                return new CompoundShortDataset(n, nArray);
            }
            case 203: {
                if (n != 3) {
                    throw new IllegalArgumentException("Number of elements not compatible with RGB type");
                }
                return new RGBDataset(nArray);
            }
            case 3: 
            case 300: {
                return new CompoundIntegerDataset(n, nArray);
            }
            case 4: 
            case 400: {
                return new CompoundLongDataset(n, nArray);
            }
            case 5: 
            case 500: {
                return new CompoundFloatDataset(n, nArray);
            }
            case 6: 
            case 600: {
                return new CompoundDoubleDataset(n, nArray);
            }
            case 7: {
                if (n != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return new ComplexFloatDataset(nArray);
            }
            case 8: {
                if (n != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return new ComplexDoubleDataset(nArray);
            }
        }
        throw new IllegalArgumentException("dtype not a known compound type");
    }

    public static AbstractDataset zeros(AbstractDataset abstractDataset) {
        return AbstractDataset.zeros(abstractDataset, abstractDataset.getDtype());
    }

    public static AbstractDataset zeros(AbstractDataset abstractDataset, int n) {
        int[] nArray = abstractDataset.shape;
        int n2 = AbstractDataset.isDTypeElemental(n) ? 1 : abstractDataset.getElementsPerItem();
        return AbstractDataset.zeros(n2, nArray, n);
    }

    public static AbstractDataset ones(AbstractDataset abstractDataset) {
        return AbstractDataset.ones(abstractDataset, abstractDataset.getDtype());
    }

    public static AbstractDataset ones(AbstractDataset abstractDataset, int n) {
        int[] nArray = abstractDataset.shape;
        int n2 = AbstractDataset.isDTypeElemental(n) ? 1 : abstractDataset.getElementsPerItem();
        return AbstractDataset.ones(n2, nArray, n);
    }

    public static AbstractDataset ones(int[] nArray, int n) {
        switch (n) {
            case 0: {
                return BooleanDataset.ones(nArray);
            }
            case 1: {
                return ByteDataset.ones(nArray);
            }
            case 2: {
                return ShortDataset.ones(nArray);
            }
            case 203: {
                return new RGBDataset(nArray).fill(1);
            }
            case 3: {
                return IntegerDataset.ones(nArray);
            }
            case 4: {
                return LongDataset.ones(nArray);
            }
            case 5: {
                return FloatDataset.ones(nArray);
            }
            case 6: {
                return DoubleDataset.ones(nArray);
            }
            case 7: {
                return ComplexFloatDataset.ones(nArray);
            }
            case 8: {
                return ComplexDoubleDataset.ones(nArray);
            }
        }
        throw new IllegalArgumentException("dtype not known");
    }

    public static AbstractDataset ones(int n, int[] nArray, int n2) {
        if (n == 1) {
            return AbstractDataset.ones(nArray, n2);
        }
        switch (n2) {
            case 1: 
            case 100: {
                return CompoundByteDataset.ones(n, nArray);
            }
            case 2: 
            case 200: {
                return CompoundShortDataset.ones(n, nArray);
            }
            case 203: {
                if (n != 3) {
                    throw new IllegalArgumentException("Number of elements not compatible with RGB type");
                }
                return new RGBDataset(nArray).fill(1);
            }
            case 3: 
            case 300: {
                return CompoundIntegerDataset.ones(n, nArray);
            }
            case 4: 
            case 400: {
                return CompoundLongDataset.ones(n, nArray);
            }
            case 5: 
            case 500: {
                return CompoundFloatDataset.ones(n, nArray);
            }
            case 6: 
            case 600: {
                return CompoundDoubleDataset.ones(n, nArray);
            }
            case 7: {
                if (n != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return ComplexFloatDataset.ones(nArray);
            }
            case 8: {
                if (n != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return ComplexDoubleDataset.ones(nArray);
            }
        }
        throw new IllegalArgumentException("dtype not a known compound type");
    }

    public static AbstractDataset arange(double d, int n) {
        return AbstractDataset.arange(0.0, d, 1.0, n);
    }

    public static int calcSteps(double d, double d2, double d3) {
        if (d3 > 0.0) {
            return (int)Math.ceil((d2 - d) / d3);
        }
        return (int)Math.ceil((d2 - d) / d3);
    }

    public static AbstractDataset arange(double d, double d2, double d3, int n) {
        if (d3 > 0.0 != d <= d2) {
            return null;
        }
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                return ByteDataset.arange(d, d2, d3);
            }
            case 2: {
                return ShortDataset.arange(d, d2, d3);
            }
            case 3: {
                return IntegerDataset.arange(d, d2, d3);
            }
            case 4: {
                return LongDataset.arange(d, d2, d3);
            }
            case 5: {
                return FloatDataset.arange(d, d2, d3);
            }
            case 6: {
                return DoubleDataset.arange(d, d2, d3);
            }
            case 7: {
                return ComplexFloatDataset.arange(d, d2, d3);
            }
            case 8: {
                return ComplexDoubleDataset.arange(d, d2, d3);
            }
        }
        throw new IllegalArgumentException("dtype not known");
    }

    public boolean isComplex() {
        int n = this.getDtype();
        return n == 7 || n == 8;
    }

    public AbstractDataset real() {
        return this;
    }

    public abstract AbstractDataset fill(Object var1);

    public abstract boolean getElementBooleanAbs(int var1);

    public abstract double getElementDoubleAbs(int var1);

    public abstract long getElementLongAbs(int var1);

    public abstract Object getObjectAbs(int var1);

    public abstract String getStringAbs(int var1);

    public abstract void setObjectAbs(int var1, Object var2);

    public AbstractDataset sort(Integer n) {
        int n2 = this.getDtype();
        if (n2 == 0 || n2 == 7 || n2 == 8 || this.getElementsPerItem() != 1) {
            throw new UnsupportedOperationException("Cannot sort dataset");
        }
        if (n == null) {
            if (this.dataShape != null) {
                AbstractDataset abstractDataset = this.clone();
                this.odata = abstractDataset.odata;
                this.setData();
                this.dataShape = null;
            }
            switch (n2) {
                case 1: {
                    Arrays.sort((byte[])this.odata);
                    break;
                }
                case 2: {
                    Arrays.sort((short[])this.odata);
                    break;
                }
                case 3: {
                    Arrays.sort((int[])this.odata);
                    break;
                }
                case 4: {
                    Arrays.sort((long[])this.odata);
                    break;
                }
                case 5: {
                    Arrays.sort((float[])this.odata);
                    break;
                }
                case 6: {
                    Arrays.sort((double[])this.odata);
                }
            }
        } else {
            n = this.checkAxis(n);
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{this.shape[n]}, n2);
            Serializable serializable = abstractDataset.getBuffer();
            PositionIterator positionIterator = this.getPositionIterator(n);
            int[] nArray = positionIterator.getPos();
            boolean[] blArray = positionIterator.getOmit();
            while (positionIterator.hasNext()) {
                this.copyItemsFromAxes(nArray, blArray, abstractDataset);
                switch (n2) {
                    case 1: {
                        Arrays.sort((byte[])serializable);
                        break;
                    }
                    case 2: {
                        Arrays.sort((short[])serializable);
                        break;
                    }
                    case 3: {
                        Arrays.sort((int[])serializable);
                        break;
                    }
                    case 4: {
                        Arrays.sort((long[])serializable);
                        break;
                    }
                    case 5: {
                        Arrays.sort((float[])serializable);
                        break;
                    }
                    case 6: {
                        Arrays.sort((double[])serializable);
                    }
                }
                this.setItemsOnAxes(nArray, blArray, abstractDataset.getBuffer());
            }
        }
        return this;
    }

    @Override
    public abstract AbstractDataset getSlice(int[] var1, int[] var2, int[] var3);

    public abstract AbstractDataset getSlice(SliceIterator var1);

    @Override
    public AbstractDataset getSlice(Slice ... sliceArray) {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        Slice.convertFromSlice(sliceArray, this.shape, nArray, nArray2, nArray3);
        AbstractDataset abstractDataset = this.getSlice(nArray, nArray2, nArray3);
        if (Arrays.equals(this.shape, abstractDataset.shape)) {
            abstractDataset.setName(this.name);
        } else {
            abstractDataset.setName(String.valueOf(this.name) + '[' + Slice.createString(sliceArray) + ']');
        }
        return abstractDataset;
    }

    @Override
    public AbstractDataset getSlice(IMonitor iMonitor, Slice ... sliceArray) throws ScanFileHolderException {
        return this.getSlice(sliceArray);
    }

    @Override
    public AbstractDataset getSlice(IMonitor iMonitor, int[] nArray, int[] nArray2, int[] nArray3) throws ScanFileHolderException {
        return this.getSlice(nArray, nArray2, nArray3);
    }

    public void setSlice(Object object, Slice ... sliceArray) {
        int n = this.shape.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        Slice.convertFromSlice(sliceArray, this.shape, nArray, nArray2, nArray3);
        this.setSlice(object, nArray, nArray2, nArray3);
    }

    public abstract void fillDataset(AbstractDataset var1, IndexIterator var2);

    public boolean all() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (this.getElementBooleanAbs(indexIterator.index)) continue;
            return false;
        }
        return true;
    }

    public BooleanDataset all(int n) {
        int n2 = this.getRank();
        int[] nArray = this.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        BooleanDataset booleanDataset = new BooleanDataset(nArray2);
        IndexIterator indexIterator = booleanDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n4 = 0;
            while (n4 < n) {
                nArray4[n4] = nArray3[n4];
                ++n4;
            }
            nArray4[n4++] = 0;
            while (n4 < n2) {
                nArray4[n4] = nArray3[n4 - 1];
                ++n4;
            }
            boolean bl = true;
            int n5 = 0;
            while (n5 < n3) {
                nArray4[n] = n5++;
                if (this.getDouble(nArray4) != 0.0) continue;
                bl = false;
                break;
            }
            booleanDataset.set(bl, nArray3);
        }
        return booleanDataset;
    }

    public boolean any() {
        IndexIterator indexIterator = this.getIterator();
        while (indexIterator.hasNext()) {
            if (!this.getElementBooleanAbs(indexIterator.index)) continue;
            return true;
        }
        return false;
    }

    public BooleanDataset any(int n) {
        int n2 = this.getRank();
        int[] nArray = this.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = AbstractDataset.squeezeShape(nArray, false);
        BooleanDataset booleanDataset = new BooleanDataset(nArray2);
        IndexIterator indexIterator = booleanDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = nArray;
        while (indexIterator.hasNext()) {
            int n4 = 0;
            while (n4 < n) {
                nArray4[n4] = nArray3[n4];
                ++n4;
            }
            nArray4[n4++] = 0;
            while (n4 < n2) {
                nArray4[n4] = nArray3[n4 - 1];
                ++n4;
            }
            boolean bl = false;
            int n5 = 0;
            while (n5 < n3) {
                nArray4[n] = n5++;
                if (this.getDouble(nArray4) == 0.0) continue;
                bl = true;
                break;
            }
            booleanDataset.set(bl, nArray3);
        }
        return booleanDataset;
    }

    public abstract AbstractDataset iadd(Object var1);

    public abstract AbstractDataset isubtract(Object var1);

    public abstract AbstractDataset imultiply(Object var1);

    public abstract AbstractDataset idivide(Object var1);

    public AbstractDataset ifloorDivide(Object object) {
        return this.idivide(object).ifloor();
    }

    public abstract AbstractDataset iremainder(Object var1);

    public abstract AbstractDataset ifloor();

    public abstract AbstractDataset ipower(Object var1);

    public abstract double residual(Object var1);

    protected Object getStoredValue(String string) {
        if (this.storedValues == null) {
            return null;
        }
        return this.storedValues.get(string);
    }

    public void setStoredValue(String string, Object object) {
        if (this.storedValues == null) {
            this.storedValues = new HashMap();
        }
        this.storedValues.put(string, object);
    }

    protected void calculateSummaryStats() {
        IndexIterator indexIterator = this.getIterator();
        SummaryStatistics summaryStatistics = new SummaryStatistics();
        while (indexIterator.hasNext()) {
            double d = this.getElementDoubleAbs(indexIterator.index);
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            summaryStatistics.addValue(d);
        }
        this.setStoredValue("stats", summaryStatistics);
    }

    protected void calculateSummaryStats(int n) {
        int n2 = this.getRank();
        int[] nArray = this.getShape();
        int n3 = nArray[n];
        nArray[n] = 1;
        int[] nArray2 = new int[n2 - 1];
        int n4 = 0;
        while (n4 < n) {
            nArray2[n4] = nArray[n4];
            ++n4;
        }
        n4 = n + 1;
        while (n4 < n2) {
            nArray2[n4 - 1] = nArray[n4];
            ++n4;
        }
        n4 = this.getDtype();
        IntegerDataset integerDataset = new IntegerDataset(nArray2);
        AbstractDataset abstractDataset = AbstractDataset.zeros(nArray2, n4);
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(nArray2, n4);
        IntegerDataset integerDataset2 = new IntegerDataset(nArray2);
        IntegerDataset integerDataset3 = new IntegerDataset(nArray2);
        AbstractDataset abstractDataset3 = AbstractDataset.zeros(nArray2, AbstractDataset.getLargestDType(n4));
        DoubleDataset doubleDataset = new DoubleDataset(nArray2);
        DoubleDataset doubleDataset2 = new DoubleDataset(nArray2);
        IndexIterator indexIterator = abstractDataset.getIterator(true);
        int[] nArray3 = indexIterator.getPos();
        int[] nArray4 = (int[])nArray.clone();
        while (indexIterator.hasNext()) {
            int n5 = 0;
            while (n5 < n) {
                nArray4[n5] = nArray3[n5];
                ++n5;
            }
            nArray4[n5++] = 0;
            while (n5 < n2) {
                nArray4[n5] = nArray3[n5 - 1];
                ++n5;
            }
            SummaryStatistics summaryStatistics = new SummaryStatistics();
            int n6 = 0;
            while (n6 < n3) {
                nArray4[n] = n6;
                double d = this.getDouble(nArray4);
                if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                    summaryStatistics.addValue(d);
                }
                ++n6;
            }
            integerDataset.setAbs(indexIterator.index, (int)summaryStatistics.getN());
            double d = summaryStatistics.getMax();
            abstractDataset.setObjectAbs(indexIterator.index, d);
            int n7 = 0;
            while (n7 < n3) {
                nArray4[n] = n7++;
                double d2 = this.getDouble(nArray4);
                if (d2 != d) continue;
                integerDataset2.setAbs(indexIterator.index, n7);
                break;
            }
            double d3 = summaryStatistics.getMin();
            abstractDataset2.setObjectAbs(indexIterator.index, d);
            int n8 = 0;
            while (n8 < n3) {
                nArray4[n] = n8++;
                double d4 = this.getDouble(nArray4);
                if (d4 != d3) continue;
                integerDataset3.setAbs(indexIterator.index, n8);
                break;
            }
            abstractDataset3.setObjectAbs(indexIterator.index, summaryStatistics.getSum());
            doubleDataset.setAbs(indexIterator.index, summaryStatistics.getMean());
            doubleDataset2.setAbs(indexIterator.index, summaryStatistics.getVariance());
        }
        this.setStoredValue("count-" + n, integerDataset);
        this.storedValues.put("max-" + n, abstractDataset);
        this.storedValues.put("min-" + n, abstractDataset2);
        this.storedValues.put("sum-" + n, abstractDataset3);
        this.storedValues.put("mean-" + n, doubleDataset);
        this.storedValues.put("var-" + n, doubleDataset2);
        this.storedValues.put("maxIndex-" + n, integerDataset2);
        this.storedValues.put("minIndex-" + n, integerDataset3);
    }

    protected void calculateMaxMin() {
        IndexIterator indexIterator = this.getIterator();
        double d = Double.NEGATIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = 0.0;
        boolean bl = false;
        while (indexIterator.hasNext()) {
            if (bl) {
                d3 = d3 * 19.0 % 2.147483647E9;
                continue;
            }
            double d4 = this.getElementDoubleAbs(indexIterator.index);
            if (Double.isInfinite(d4) || Double.isNaN(d4)) {
                d3 = d3 * 19.0 % 2.147483647E9;
                if (Double.isNaN(d4)) {
                    d = Double.NaN;
                    d2 = Double.NaN;
                    bl = true;
                    continue;
                }
            } else {
                d3 = (d3 * 19.0 + d4) % 2.147483647E9;
            }
            if (d4 > d) {
                d = d4;
            }
            if (!(d4 < d2)) continue;
            d2 = d4;
        }
        int n = (int)d3 * 19 + this.getDtype() * 17 + this.getElementsPerItem();
        int n2 = this.shape.length;
        int n3 = 0;
        while (n3 < n2) {
            n = n * 17 + this.shape[n3];
            ++n3;
        }
        this.setStoredValue("max", this.fromDoubleToNumber(d));
        this.storedValues.put("min", this.fromDoubleToNumber(d2));
        this.storedValues.put("hash", n);
    }

    private Number fromDoubleToNumber(double d) {
        switch (this.getDtype()) {
            case 0: 
            case 3: {
                return (int)d;
            }
            case 1: {
                return (byte)d;
            }
            case 2: {
                return (short)d;
            }
            case 4: {
                return (long)d;
            }
            case 5: {
                return Float.valueOf((float)d);
            }
            case 6: {
                return d;
            }
        }
        return null;
    }

    private Number fromDoubleToBiggestNumber(double d) {
        switch (this.getDtype()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return (int)d;
            }
            case 4: {
                return (long)d;
            }
            case 5: {
                return Float.valueOf((float)d);
            }
            case 6: {
                return d;
            }
        }
        return null;
    }

    private SummaryStatistics getStatistics() {
        SummaryStatistics summaryStatistics = (SummaryStatistics)this.getStoredValue("stats");
        if (summaryStatistics == null) {
            this.calculateSummaryStats();
            summaryStatistics = (SummaryStatistics)this.getStoredValue("stats");
        }
        return summaryStatistics;
    }

    private Object getMaxMin(String string) {
        Object object = this.getStoredValue(string);
        if (object == null) {
            this.calculateMaxMin();
            object = this.getStoredValue(string);
        }
        return object;
    }

    private Object getStatistics(int n, String string) {
        n = this.checkAxis(n);
        Object object = this.getStoredValue(string);
        if (object == null) {
            this.calculateSummaryStats(n);
            object = this.getStoredValue(string);
        }
        return object;
    }

    @Override
    public Number max() {
        return (Number)this.getMaxMin("max");
    }

    public AbstractDataset max(int n) {
        return (AbstractDataset)this.getStatistics(n, "max-" + n);
    }

    @Override
    public Number min() {
        return (Number)this.getMaxMin("min");
    }

    public AbstractDataset min(int n) {
        return (AbstractDataset)this.getStatistics(n, "min-" + n);
    }

    public int argMax() {
        return this.get1DIndex(this.maxPos());
    }

    public IntegerDataset argMax(int n) {
        return (IntegerDataset)this.getStatistics(n, "maxIndex-" + n);
    }

    public int argMin() {
        return this.get1DIndex(this.minPos());
    }

    public IntegerDataset argMin(int n) {
        return (IntegerDataset)this.getStatistics(n, "minIndex-" + n);
    }

    public abstract boolean containsInfs();

    public abstract boolean containsNans();

    public abstract boolean containsInvalidNumbers();

    public Number peakToPeak() {
        return this.fromDoubleToNumber(this.max().doubleValue() - this.min().doubleValue());
    }

    public AbstractDataset peakToPeak(int n) {
        return Maths.subtract(this.max(n), this.min(n));
    }

    public Object sum() {
        return this.fromDoubleToBiggestNumber(this.getStatistics().getSum());
    }

    public AbstractDataset sum(int n) {
        return (AbstractDataset)this.getStatistics(n, "sum-" + n);
    }

    public Object product() {
        return Stats.product(this);
    }

    public AbstractDataset product(int n) {
        return Stats.product(this, n);
    }

    public Object mean() {
        return this.getStatistics().getMean();
    }

    public AbstractDataset mean(int n) {
        return (AbstractDataset)this.getStatistics(n, "mean-" + n);
    }

    public Number variance() {
        return this.variance(false);
    }

    public Number variance(boolean bl) {
        SummaryStatistics summaryStatistics = this.getStatistics();
        if (bl) {
            StorelessUnivariateStatistic storelessUnivariateStatistic = summaryStatistics.getVarianceImpl();
            summaryStatistics.setVarianceImpl((StorelessUnivariateStatistic)new Variance(false));
            Double d = summaryStatistics.getVariance();
            summaryStatistics.setVarianceImpl(storelessUnivariateStatistic);
            return d;
        }
        return summaryStatistics.getVariance();
    }

    public AbstractDataset variance(int n) {
        return (AbstractDataset)this.getStatistics(n, "var-" + n);
    }

    public Number stdDeviation() {
        return Math.sqrt(this.variance().doubleValue());
    }

    public Number stdDeviation(boolean bl) {
        return Math.sqrt(this.variance(bl).doubleValue());
    }

    public AbstractDataset stdDeviation(int n) {
        AbstractDataset abstractDataset = (AbstractDataset)this.getStatistics(n, "var-" + n);
        return Maths.sqrt(abstractDataset);
    }

    public Number rootMeanSquare() {
        SummaryStatistics summaryStatistics = this.getStatistics();
        double d = summaryStatistics.getMean();
        return Math.sqrt(summaryStatistics.getVariance() + d * d);
    }

    public AbstractDataset rootMeanSquare(int n) {
        AbstractDataset abstractDataset = (AbstractDataset)this.getStatistics(n, "var-" + n);
        AbstractDataset abstractDataset2 = (AbstractDataset)this.getStatistics(n, "mean-" + n);
        AbstractDataset abstractDataset3 = Maths.power((Object)abstractDataset2, 2);
        return Maths.sqrt(abstractDataset3.iadd(abstractDataset));
    }

    public AbstractDataset put(int[] nArray, Object[] objectArray) {
        return DatasetUtils.put(this, nArray, objectArray);
    }

    public AbstractDataset take(int[] nArray, Integer n) {
        return DatasetUtils.take(this, nArray, n);
    }

    protected abstract void setItemDirect(int var1, int var2, Object var3);

    public int getStringPolicy() {
        return this.stringPolicy;
    }

    public void setStringPolicy(int n) {
        this.stringPolicy = n;
    }

    public void setError(Number number) {
        this.errorData = null;
        if (number instanceof Integer) {
            this.errorValue = number.intValue() * number.intValue();
            return;
        }
        if (number instanceof Float) {
            this.errorValue = Float.valueOf(number.floatValue() * number.floatValue());
            return;
        }
        if (number instanceof Long) {
            this.errorValue = number.longValue() * number.longValue();
            return;
        }
        if (number instanceof Short) {
            this.errorValue = number.intValue() * number.intValue();
            return;
        }
        if (number instanceof Byte) {
            this.errorValue = number.intValue() * number.intValue();
            return;
        }
        this.errorValue = number.doubleValue() * number.doubleValue();
    }

    public void setError(AbstractDataset abstractDataset) {
        if (!this.isCompatibleWith(abstractDataset)) {
            throw new IllegalArgumentException("Error array dataset is incompatible with this dataset");
        }
        this.errorData = Maths.square(abstractDataset);
        this.errorValue = null;
    }

    public AbstractDataset getError() {
        if (this.errorData == null) {
            DoubleDataset doubleDataset = new DoubleDataset(this.shape);
            doubleDataset.fill(this.errorValue.doubleValue());
            return Maths.sqrt(doubleDataset);
        }
        return Maths.sqrt(this.errorData);
    }

    public double getErrorDouble(int ... nArray) {
        if (this.errorData == null) {
            return Math.sqrt(this.errorValue.doubleValue());
        }
        return Math.sqrt(this.errorData.getDouble(nArray));
    }

    public float getErrorFloat(int ... nArray) {
        if (this.errorData == null) {
            return this.errorValue.floatValue();
        }
        return (float)Math.sqrt(this.errorData.getFloat(nArray));
    }

    @Override
    public void setMetadata(IMetaData iMetaData) {
        this.metadataStructure = iMetaData;
    }

    @Override
    public IMetaData getMetadata() {
        return this.metadataStructure;
    }
}

