/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.Random;

public class AbstractCompoundDatasetTest {
    long[] ldata;
    int[] idata;
    short[] sdata;
    byte[] bdata;
    double[] ddata;
    float[] fdata;

    public AbstractCompoundDatasetTest() {
        long[] lArray = new long[6];
        lArray[1] = 1L;
        lArray[2] = 2L;
        lArray[3] = 3L;
        lArray[4] = 4L;
        lArray[5] = 5L;
        this.ldata = lArray;
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        this.idata = nArray;
        short[] sArray = new short[6];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        sArray[4] = 4;
        sArray[5] = 5;
        this.sdata = sArray;
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        this.bdata = byArray;
        this.ddata = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        this.fdata = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
    }

    @Test
    public void testToDoubleArray() {
        double[] dArray = AbstractCompoundDataset.toDoubleArray(this.ddata, this.idata.length);
        int n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)dArray[n], (double)1.0E-10);
            ++n;
        }
        dArray = AbstractCompoundDataset.toDoubleArray(this.fdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)dArray[n], (double)1.0E-10);
            ++n;
        }
        dArray = AbstractCompoundDataset.toDoubleArray(this.ldata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)dArray[n], (double)1.0E-10);
            ++n;
        }
        dArray = AbstractCompoundDataset.toDoubleArray(this.idata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)dArray[n], (double)1.0E-10);
            ++n;
        }
        dArray = AbstractCompoundDataset.toDoubleArray(this.sdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)dArray[n], (double)1.0E-10);
            ++n;
        }
        dArray = AbstractCompoundDataset.toDoubleArray(this.bdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)dArray[n], (double)1.0E-10);
            ++n;
        }
    }

    @Test
    public void testToFloatArray() {
        float[] fArray = AbstractCompoundDataset.toFloatArray(this.ddata, this.idata.length);
        int n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)fArray[n], (double)1.0E-10);
            ++n;
        }
        fArray = AbstractCompoundDataset.toFloatArray(this.fdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)fArray[n], (double)1.0E-10);
            ++n;
        }
        fArray = AbstractCompoundDataset.toFloatArray(this.ldata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)fArray[n], (double)1.0E-10);
            ++n;
        }
        fArray = AbstractCompoundDataset.toFloatArray(this.idata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)fArray[n], (double)1.0E-10);
            ++n;
        }
        fArray = AbstractCompoundDataset.toFloatArray(this.sdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)fArray[n], (double)1.0E-10);
            ++n;
        }
        fArray = AbstractCompoundDataset.toFloatArray(this.bdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)fArray[n], (double)1.0E-10);
            ++n;
        }
    }

    @Test
    public void testToLongArray() {
        long[] lArray = AbstractCompoundDataset.toLongArray(this.ddata, this.idata.length);
        int n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)lArray[n], (double)1.0E-10);
            ++n;
        }
        lArray = AbstractCompoundDataset.toLongArray(this.fdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)lArray[n], (double)1.0E-10);
            ++n;
        }
        lArray = AbstractCompoundDataset.toLongArray(this.ldata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)lArray[n], (double)1.0E-10);
            ++n;
        }
        lArray = AbstractCompoundDataset.toLongArray(this.idata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)lArray[n], (double)1.0E-10);
            ++n;
        }
        lArray = AbstractCompoundDataset.toLongArray(this.sdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)lArray[n], (double)1.0E-10);
            ++n;
        }
        lArray = AbstractCompoundDataset.toLongArray(this.bdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)lArray[n], (double)1.0E-10);
            ++n;
        }
    }

    @Test
    public void testToIntegerArray() {
        int[] nArray = AbstractCompoundDataset.toIntegerArray(this.ddata, this.idata.length);
        int n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)nArray[n], (double)1.0E-10);
            ++n;
        }
        nArray = AbstractCompoundDataset.toIntegerArray(this.fdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)nArray[n], (double)1.0E-10);
            ++n;
        }
        nArray = AbstractCompoundDataset.toIntegerArray(this.ldata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)nArray[n], (double)1.0E-10);
            ++n;
        }
        nArray = AbstractCompoundDataset.toIntegerArray(this.idata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)nArray[n], (double)1.0E-10);
            ++n;
        }
        nArray = AbstractCompoundDataset.toIntegerArray(this.sdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)nArray[n], (double)1.0E-10);
            ++n;
        }
        nArray = AbstractCompoundDataset.toIntegerArray(this.bdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)nArray[n], (double)1.0E-10);
            ++n;
        }
    }

    @Test
    public void testToShortArray() {
        short[] sArray = AbstractCompoundDataset.toShortArray(this.ddata, this.idata.length);
        int n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)sArray[n], (double)1.0E-10);
            ++n;
        }
        sArray = AbstractCompoundDataset.toShortArray(this.fdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)sArray[n], (double)1.0E-10);
            ++n;
        }
        sArray = AbstractCompoundDataset.toShortArray(this.ldata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)sArray[n], (double)1.0E-10);
            ++n;
        }
        sArray = AbstractCompoundDataset.toShortArray(this.idata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)sArray[n], (double)1.0E-10);
            ++n;
        }
        sArray = AbstractCompoundDataset.toShortArray(this.sdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)sArray[n], (double)1.0E-10);
            ++n;
        }
        sArray = AbstractCompoundDataset.toShortArray(this.bdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)sArray[n], (double)1.0E-10);
            ++n;
        }
    }

    @Test
    public void testToByteArray() {
        byte[] byArray = AbstractCompoundDataset.toByteArray(this.ddata, this.idata.length);
        int n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)byArray[n], (double)1.0E-10);
            ++n;
        }
        byArray = AbstractCompoundDataset.toByteArray(this.fdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)byArray[n], (double)1.0E-10);
            ++n;
        }
        byArray = AbstractCompoundDataset.toByteArray(this.ldata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)byArray[n], (double)1.0E-10);
            ++n;
        }
        byArray = AbstractCompoundDataset.toByteArray(this.idata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)byArray[n], (double)1.0E-10);
            ++n;
        }
        byArray = AbstractCompoundDataset.toByteArray(this.sdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)byArray[n], (double)1.0E-10);
            ++n;
        }
        byArray = AbstractCompoundDataset.toByteArray(this.bdata, this.idata.length);
        n = 0;
        while (n < this.idata.length) {
            Assert.assertEquals((double)this.ddata[n], (double)byArray[n], (double)1.0E-10);
            ++n;
        }
    }

    @Test
    public void testSum() {
        IntegerDataset integerDataset = Random.randint(0, 255, new int[]{5, 2});
        AbstractCompoundDataset abstractCompoundDataset = DatasetUtils.createCompoundDatasetFromLastAxis(integerDataset, true);
        AbstractDataset abstractDataset = DatasetUtils.createDatasetFromCompoundDataset(abstractCompoundDataset, true);
        double[] dArray = (double[])abstractCompoundDataset.sum();
        double d = ((Number)integerDataset.sum()).doubleValue();
        double d2 = ((Number)abstractDataset.sum()).doubleValue();
        Assert.assertEquals((double)d, (double)(dArray[0] + dArray[1]), (double)1.0E-10);
        Assert.assertEquals((double)d, (double)d2, (double)1.0E-10);
    }

    @Test
    public void testCompoundCreators() {
        double d = 0.5;
        CompoundDoubleDataset compoundDoubleDataset = CompoundDoubleDataset.createFromObject(d);
        Assert.assertEquals((long)0L, (long)compoundDoubleDataset.getRank());
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset.getSize());
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset.getElementsPerItem());
        Assert.assertEquals((double)d, (double)compoundDoubleDataset.getElementDoubleAbs(0), (double)1.0E-14);
        double[] dArray = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        CompoundDoubleDataset compoundDoubleDataset2 = CompoundDoubleDataset.createFromObject(dArray);
        int n = compoundDoubleDataset2.getElementsPerItem();
        Assert.assertEquals((long)6L, (long)n);
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset2.getRank());
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset2.getSize());
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset2.getShape()[0]);
        IndexIterator indexIterator = compoundDoubleDataset2.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            int n3 = 0;
            while (n3 < n) {
                Assert.assertEquals((double)n2, (double)compoundDoubleDataset2.getElementDoubleAbs(indexIterator.index + n3), (double)(1.0E-15 * (double)n2));
                ++n3;
                ++n2;
            }
        }
        double[][] dArrayArray = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        CompoundDoubleDataset compoundDoubleDataset3 = CompoundDoubleDataset.createFromObject(dArrayArray);
        n = compoundDoubleDataset3.getElementsPerItem();
        Assert.assertEquals((long)3L, (long)n);
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset3.getRank());
        Assert.assertEquals((long)2L, (long)compoundDoubleDataset3.getSize());
        Assert.assertEquals((long)2L, (long)compoundDoubleDataset3.getShape()[0]);
        indexIterator = compoundDoubleDataset3.getIterator();
        int n4 = 0;
        while (indexIterator.hasNext()) {
            int n5 = 0;
            while (n5 < n) {
                Assert.assertEquals((double)n4, (double)compoundDoubleDataset3.getElementDoubleAbs(indexIterator.index + n5), (double)(1.0E-15 * (double)n4));
                ++n5;
                ++n4;
            }
        }
        double[][] dArrayArray2 = new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}};
        CompoundDoubleDataset compoundDoubleDataset4 = CompoundDoubleDataset.createFromObject(dArrayArray2);
        n = compoundDoubleDataset4.getElementsPerItem();
        Assert.assertEquals((long)4L, (long)n);
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset4.getRank());
        Assert.assertEquals((long)2L, (long)compoundDoubleDataset4.getSize());
        Assert.assertEquals((long)2L, (long)compoundDoubleDataset4.getShape()[0]);
        indexIterator = compoundDoubleDataset4.getIterator();
        int n6 = 0;
        while (indexIterator.hasNext()) {
            int n7 = 0;
            while (n7 < n) {
                if (n6 < 7) {
                    Assert.assertEquals((double)n6, (double)compoundDoubleDataset4.getElementDoubleAbs(indexIterator.index + n7), (double)(1.0E-15 * (double)n6));
                } else {
                    Assert.assertEquals((double)0.0, (double)compoundDoubleDataset4.getElementDoubleAbs(indexIterator.index + n7), (double)1.0E-15);
                }
                ++n7;
                ++n6;
            }
        }
        double[][] dArrayArray3 = new double[][]{{0.0, 1.0, 2.0}, {4.0, 5.0, 6.0, 7.0}};
        CompoundDoubleDataset compoundDoubleDataset5 = CompoundDoubleDataset.createFromObject(dArrayArray3);
        n = compoundDoubleDataset5.getElementsPerItem();
        Assert.assertEquals((long)4L, (long)n);
        Assert.assertEquals((long)1L, (long)compoundDoubleDataset5.getRank());
        Assert.assertEquals((long)2L, (long)compoundDoubleDataset5.getSize());
        Assert.assertEquals((long)2L, (long)compoundDoubleDataset5.getShape()[0]);
        indexIterator = compoundDoubleDataset5.getIterator();
        int n8 = 0;
        while (indexIterator.hasNext()) {
            int n9 = 0;
            while (n9 < n) {
                if (n8 != 3) {
                    Assert.assertEquals((double)n8, (double)compoundDoubleDataset5.getElementDoubleAbs(indexIterator.index + n9), (double)(1.0E-15 * (double)n8));
                } else {
                    Assert.assertEquals((double)0.0, (double)compoundDoubleDataset5.getElementDoubleAbs(indexIterator.index + n9), (double)1.0E-15);
                }
                ++n9;
                ++n8;
            }
        }
    }

    @Test
    public void test1DErrors() {
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[5];
        int n = 0;
        while (n < 5) {
            abstractDatasetArray[n] = AbstractDataset.arange(100.0, 3);
            ++n;
        }
        CompoundIntegerDataset compoundIntegerDataset = new CompoundIntegerDataset(abstractDatasetArray);
        compoundIntegerDataset.setError(5);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(0)[0], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(0)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(0)[4], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(50)[0], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(50)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(50)[4], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(99)[0], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(99)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(99)[4], (double)0.001);
        AbstractCompoundDataset abstractCompoundDataset = compoundIntegerDataset.getError();
        try {
            AbstractDataset.checkCompatibility(compoundIntegerDataset, abstractCompoundDataset);
        }
        catch (Exception exception) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(0).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(2).getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(2).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(2).getDouble(99), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(4).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset.getElements(4).getDouble(99), (double)0.001);
        compoundIntegerDataset.setError(Maths.multiply((AbstractDataset)abstractCompoundDataset, 2));
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(0)[0], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(0)[2], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(0)[4], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(50)[0], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(50)[2], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(50)[4], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(99)[0], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(99)[2], (double)0.001);
        Assert.assertEquals((double)10.0, (double)compoundIntegerDataset.getErrorArray(99)[4], (double)0.001);
        AbstractCompoundDataset abstractCompoundDataset2 = compoundIntegerDataset.getError();
        try {
            AbstractDataset.checkCompatibility(compoundIntegerDataset, abstractCompoundDataset2);
        }
        catch (Exception exception) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(0).getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(2).getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(2).getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(2).getDouble(99), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(4).getDouble(50), (double)0.001);
        Assert.assertEquals((double)10.0, (double)abstractCompoundDataset2.getElements(4).getDouble(99), (double)0.001);
        compoundIntegerDataset.setErrorArray(new Double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        Assert.assertEquals((double)1.0, (double)compoundIntegerDataset.getErrorArray(0)[0], (double)0.001);
        Assert.assertEquals((double)3.0, (double)compoundIntegerDataset.getErrorArray(0)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(0)[4], (double)0.001);
        Assert.assertEquals((double)1.0, (double)compoundIntegerDataset.getErrorArray(50)[0], (double)0.001);
        Assert.assertEquals((double)3.0, (double)compoundIntegerDataset.getErrorArray(50)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(50)[4], (double)0.001);
        Assert.assertEquals((double)1.0, (double)compoundIntegerDataset.getErrorArray(99)[0], (double)0.001);
        Assert.assertEquals((double)3.0, (double)compoundIntegerDataset.getErrorArray(99)[2], (double)0.001);
        Assert.assertEquals((double)5.0, (double)compoundIntegerDataset.getErrorArray(99)[4], (double)0.001);
        AbstractCompoundDataset abstractCompoundDataset3 = compoundIntegerDataset.getError();
        try {
            AbstractDataset.checkCompatibility(compoundIntegerDataset, abstractCompoundDataset2);
        }
        catch (Exception exception) {
            Assert.fail((String)"Error shape is not the same as input datasets");
        }
        Assert.assertEquals((double)1.0, (double)abstractCompoundDataset3.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)2.0, (double)abstractCompoundDataset3.getElements(1).getDouble(50), (double)0.001);
        Assert.assertEquals((double)1.0, (double)abstractCompoundDataset3.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)2.0, (double)abstractCompoundDataset3.getElements(1).getDouble(0), (double)0.001);
        Assert.assertEquals((double)3.0, (double)abstractCompoundDataset3.getElements(2).getDouble(50), (double)0.001);
        Assert.assertEquals((double)4.0, (double)abstractCompoundDataset3.getElements(3).getDouble(99), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset3.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)4.0, (double)abstractCompoundDataset3.getElements(3).getDouble(50), (double)0.001);
        Assert.assertEquals((double)5.0, (double)abstractCompoundDataset3.getElements(4).getDouble(99), (double)0.001);
    }

    @Test
    public void testInternalErrors() {
        AbstractDataset[] abstractDatasetArray = new AbstractDataset[5];
        int n = 0;
        while (n < 5) {
            abstractDatasetArray[n] = AbstractDataset.arange(100.0, 3);
            ++n;
        }
        CompoundIntegerDataset compoundIntegerDataset = new CompoundIntegerDataset(abstractDatasetArray);
        compoundIntegerDataset.setErrorArray(new Double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        Assert.assertEquals((double)1.0, (double)AbstractCompoundDataset.toDoubleArray(compoundIntegerDataset.errorArray, 5)[0], (double)0.001);
        Assert.assertEquals((double)4.0, (double)AbstractCompoundDataset.toDoubleArray(compoundIntegerDataset.errorArray, 5)[1], (double)0.001);
        Assert.assertEquals((double)9.0, (double)AbstractCompoundDataset.toDoubleArray(compoundIntegerDataset.errorArray, 5)[2], (double)0.001);
        Assert.assertEquals((double)16.0, (double)AbstractCompoundDataset.toDoubleArray(compoundIntegerDataset.errorArray, 5)[3], (double)0.001);
        Assert.assertEquals((double)25.0, (double)AbstractCompoundDataset.toDoubleArray(compoundIntegerDataset.errorArray, 5)[4], (double)0.001);
        AbstractCompoundDataset abstractCompoundDataset = compoundIntegerDataset.getError();
        compoundIntegerDataset.setErrorCompoundData(abstractCompoundDataset);
        Assert.assertEquals((double)1.0, (double)compoundIntegerDataset.errorCompoundData.getElements(0).getDouble(0), (double)0.001);
        Assert.assertEquals((double)4.0, (double)compoundIntegerDataset.errorCompoundData.getElements(1).getDouble(0), (double)0.001);
        Assert.assertEquals((double)9.0, (double)compoundIntegerDataset.errorCompoundData.getElements(2).getDouble(0), (double)0.001);
        Assert.assertEquals((double)16.0, (double)compoundIntegerDataset.errorCompoundData.getElements(3).getDouble(0), (double)0.001);
        Assert.assertEquals((double)25.0, (double)compoundIntegerDataset.errorCompoundData.getElements(4).getDouble(0), (double)0.001);
        Assert.assertEquals((double)1.0, (double)compoundIntegerDataset.errorCompoundData.getElements(0).getDouble(99), (double)0.001);
        Assert.assertEquals((double)4.0, (double)compoundIntegerDataset.errorCompoundData.getElements(1).getDouble(99), (double)0.001);
        Assert.assertEquals((double)9.0, (double)compoundIntegerDataset.errorCompoundData.getElements(2).getDouble(99), (double)0.001);
        Assert.assertEquals((double)16.0, (double)compoundIntegerDataset.errorCompoundData.getElements(3).getDouble(99), (double)0.001);
        Assert.assertEquals((double)25.0, (double)compoundIntegerDataset.errorCompoundData.getElements(4).getDouble(99), (double)0.001);
    }
}

